/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.doctype;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.doctype.KewDocumentTypeBaseTest;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;

public class KewDocumentTypeJpaTest
extends KewDocumentTypeBaseTest {
    public static final String TEST_DOC_ID = "1234";
    private DataObjectService dataObjectService;

    @Before
    public void setup() {
        this.dataObjectService = KRADServiceLocator.getDataObjectService();
    }

    @Test
    public void testDocumentTypeFindByDocumentId() throws Exception {
        DocumentType documentType = this.setupDocumentType(true);
        String documentTypeId = documentType.getDocumentTypeId();
        this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned(documentTypeId);
        documentType = KEWServiceLocator.getDocumentTypeService().findByDocumentId(TEST_DOC_ID);
        Assert.assertTrue((String)"DocumentType fetched by document id", (documentType != null && StringUtils.equals((String)documentType.getDocumentTypeId(), (String)documentTypeId) ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeVersionAndSave() throws Exception {
        DocumentType parent = this.setupDocumentType(false);
        parent.setName("MyParentDocType");
        parent = KEWServiceLocator.getDocumentTypeService().versionAndSave(parent);
        Assert.assertNotNull((Object)parent.getDocumentTypeId());
        Assert.assertEquals((Object)0, (Object)parent.getVersion());
        DocumentType documentType = this.setupDocumentType(false);
        documentType.setDocTypeParentId(parent.getDocumentTypeId());
        documentType = KEWServiceLocator.getDocumentTypeService().versionAndSave(documentType);
        Assert.assertNotNull((Object)documentType);
        Assert.assertEquals((Object)0, (Object)documentType.getVersion());
        DocumentType modified = this.setupDocumentType(false);
        modified.setLabel("a custom label");
        modified = KEWServiceLocator.getDocumentTypeService().versionAndSave(modified);
        Assert.assertNotNull((Object)modified.getDocumentTypeId());
        Assert.assertEquals((Object)modified.getPreviousVersionId(), (Object)documentType.getDocumentTypeId());
        Assert.assertEquals((Object)1, (Object)modified.getVersion());
        Assert.assertTrue((boolean)modified.isCurrent());
        Assert.assertNull((Object)modified.getParentId());
        DocumentType newParent = KEWServiceLocator.getDocumentTypeService().findByName(parent.getName());
        Assert.assertEquals((long)0L, (long)newParent.getChildrenDocTypes().size());
        Assert.assertEquals((Object)parent.getDocumentTypeId(), (Object)newParent.getDocumentTypeId());
        DocumentType oldVersion = KEWServiceLocator.getDocumentTypeService().findById(modified.getPreviousVersionId());
        Assert.assertEquals((Object)0, (Object)oldVersion.getVersion());
        Assert.assertFalse((boolean)oldVersion.isCurrent());
    }

    @Test
    public void testDocumentTypeFindAllCurrentRootDocuments() throws Exception {
        this.setupDocumentType(true);
        List rootDocumentType = KEWServiceLocator.getDocumentTypeService().findAllCurrentRootDocuments();
        Assert.assertTrue((String)"Found all root documents", (rootDocumentType != null && rootDocumentType.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeFindAllCurrent() throws Exception {
        this.setupDocumentType(true);
        List currentDocTypes = KEWServiceLocator.getDocumentTypeService().findAllCurrent();
        Assert.assertTrue((String)"Found all current documents", (currentDocTypes != null && currentDocTypes.size() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeFindPreviousInstances() throws Exception {
        this.testDocumentTypeVersionAndSave();
        List previousInstances = KEWServiceLocator.getDocumentTypeService().findPreviousInstances("gooddoctype");
        Assert.assertTrue((String)"Previous instances found correctly", (previousInstances != null && previousInstances.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeFindByName() throws Exception {
        DocumentType documentType = this.setupDocumentType(true);
        String documentTypeName = documentType.getName();
        documentType = KEWServiceLocator.getDocumentTypeService().findByName(documentTypeName);
        Assert.assertTrue((String)"DocumentType fetched by document id", (documentType != null && StringUtils.equals((String)documentType.getName(), (String)documentTypeName) ? 1 : 0) != 0);
        String nameCaseInsensitive = "gooDdocType";
        documentType = KEWServiceLocator.getDocumentTypeService().findByNameCaseInsensitive(nameCaseInsensitive);
        Assert.assertTrue((String)"DocumentType fetched by document id", (documentType != null && StringUtils.equals((String)documentType.getName(), (String)documentTypeName) ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentTypeServiceFind() throws Exception {
        DocumentType parentDocType = this.setupDocumentType(true);
        DocumentType childDocType = this.setupDocumentType(false);
        childDocType.setDocTypeParentId(parentDocType.getDocumentTypeId());
        childDocType.setName("CoolNewDocType");
        childDocType = (DocumentType)KRADServiceLocator.getDataObjectService().save((Object)childDocType, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertTrue((String)"Child doc type now has a parent doc type", (childDocType != null && StringUtils.isNotBlank((String)childDocType.getDocTypeParentId()) ? 1 : 0) != 0);
        List documentTypes = (List)KEWServiceLocator.getDocumentTypeService().find(childDocType, parentDocType.getName(), true);
        Assert.assertTrue((String)"Fetched correct number of documentTypes", (documentTypes != null && documentTypes.size() == 1 ? 1 : 0) != 0);
    }

    @Override
    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Override
    protected DocumentType fetchDocumentType(DocumentType dt) {
        return (DocumentType)this.dataObjectService.find(DocumentType.class, (Object)dt.getDocumentTypeId());
    }
}

