/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.DynamicNode;
import org.kuali.rice.kew.engine.node.DynamicResult;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class DynamicRoutingTest
extends KEWTestCase {
    private static final String SEQ_DOC_TYPE_NAME = "DynSeqDocType";
    private static final String INIT = "Initial";
    private static final String FIRST = "First";
    private static final String DYNAMIC_SEQ = "DynSeq";
    private static final String SUB_REQUESTS = "SubRequests";
    private static final String LAST = "Last";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testDynamicParallelRoute() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)SEQ_DOC_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertTrue((String)"Document should be initiated", (boolean)document.isInitiated());
        Assert.assertEquals((String)"Should be no action requests.", (long)0L, (long)document.getRootActionRequests().size());
        List nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        Assert.assertEquals((String)"Wrong active node.", (Object)INIT, (Object)((RouteNodeInstance)nodeInstances.iterator().next()).getRouteNode().getRouteNodeName());
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        this.verifyRoutingPath(document.getDocumentId());
    }

    private void verifyRoutingPath(String documentId) {
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        List initial = document.getInitialRouteNodeInstances();
        Assert.assertEquals((long)1L, (long)initial.size());
        RouteNodeInstance init = (RouteNodeInstance)initial.get(0);
        Assert.assertEquals((Object)INIT, (Object)init.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)0L, (long)init.getPreviousNodeInstances().size());
        List next = init.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance first = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)FIRST, (Object)first.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)first.getPreviousNodeInstances().size());
        next = first.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance pmckownNode = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)SUB_REQUESTS, (Object)pmckownNode.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)pmckownNode.getPreviousNodeInstances().size());
        this.assertInSubProcess(pmckownNode);
        next = pmckownNode.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance temayNode = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)SUB_REQUESTS, (Object)temayNode.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)temayNode.getPreviousNodeInstances().size());
        this.assertInSubProcess(temayNode);
        next = temayNode.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance jhopfNode = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)SUB_REQUESTS, (Object)jhopfNode.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)jhopfNode.getPreviousNodeInstances().size());
        this.assertInSubProcess(jhopfNode);
        next = jhopfNode.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance last = (RouteNodeInstance)next.get(0);
        Assert.assertNull((Object)last.getProcess());
        Assert.assertEquals((Object)LAST, (Object)last.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)last.getPreviousNodeInstances().size());
        Assert.assertEquals((long)0L, (long)last.getNextNodeInstances().size());
    }

    private void assertInSubProcess(RouteNodeInstance nodeInstance) {
        RouteNodeInstance subProcess = nodeInstance.getProcess();
        Assert.assertNotNull((Object)subProcess);
        Assert.assertEquals((Object)DYNAMIC_SEQ, (Object)subProcess.getRouteNode().getRouteNodeName());
    }

    public static class MockSequentialDynamicNode
    implements DynamicNode {
        public DynamicResult transitioningInto(RouteContext context, RouteNodeInstance process, RouteHelper helper) throws Exception {
            RouteNodeInstance routeNodeInstance = context.getNodeInstance();
            RouteNode dynamicRequestNode = helper.getNodeFactory().getRouteNode(context, DynamicRoutingTest.SUB_REQUESTS);
            RouteNodeInstance dynamicRequestNodeInstance1 = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), dynamicRequestNode);
            dynamicRequestNodeInstance1.addNodeState(new NodeState("role", "pmckown"));
            RouteNodeInstance dynamicRequestNodeInstance2 = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), dynamicRequestNode);
            dynamicRequestNodeInstance2.addNodeState(new NodeState("role", "temay"));
            RouteNodeInstance dynamicRequestNodeInstance3 = helper.getNodeFactory().createRouteNodeInstance(context.getDocument().getDocumentId(), dynamicRequestNode);
            dynamicRequestNodeInstance3.addNodeState(new NodeState("role", "jhopf"));
            dynamicRequestNodeInstance1.addNextNodeInstance(dynamicRequestNodeInstance2);
            dynamicRequestNodeInstance2.addNextNodeInstance(dynamicRequestNodeInstance3);
            routeNodeInstance.addNodeState(new NodeState("beenHere", "val"));
            return new DynamicResult(true, dynamicRequestNodeInstance1);
        }

        public DynamicResult transitioningOutOf(RouteContext context, RouteHelper helper) throws Exception {
            return new DynamicResult(true, null);
        }
    }
}

