/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.RoutePath;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.test.KEWTestCase;

public class EmptyProcessTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_NAME = "EmptyProcessDocType";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testEmptyProcess() throws Exception {
        PostProcessor.clear();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.route("test");
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((boolean)document.isFinal());
        Assert.assertEquals((long)3L, (long)PostProcessor.statusChanges.size());
        DocumentRouteStatusChange iToR = (DocumentRouteStatusChange)PostProcessor.statusChanges.get(0);
        DocumentRouteStatusChange rToP = (DocumentRouteStatusChange)PostProcessor.statusChanges.get(1);
        DocumentRouteStatusChange pToF = (DocumentRouteStatusChange)PostProcessor.statusChanges.get(2);
        Assert.assertEquals((Object)DocumentStatus.INITIATED.getCode(), (Object)iToR.getOldRouteStatus());
        Assert.assertEquals((Object)DocumentStatus.ENROUTE.getCode(), (Object)iToR.getNewRouteStatus());
        Assert.assertEquals((Object)DocumentStatus.ENROUTE.getCode(), (Object)rToP.getOldRouteStatus());
        Assert.assertEquals((Object)DocumentStatus.PROCESSED.getCode(), (Object)rToP.getNewRouteStatus());
        Assert.assertEquals((Object)DocumentStatus.PROCESSED.getCode(), (Object)pToF.getOldRouteStatus());
        Assert.assertEquals((Object)DocumentStatus.FINAL.getCode(), (Object)pToF.getNewRouteStatus());
    }

    @Test
    public void testGetRoutePathForDocumentTypeName() throws Exception {
        RoutePath routePath = KewApiServiceLocator.getDocumentTypeService().getRoutePathForDocumentTypeName(DOCUMENT_TYPE_NAME);
        Assert.assertNotNull((Object)routePath);
        ProcessDefinition processDefinition = routePath.getPrimaryProcess();
        Assert.assertNotNull((Object)processDefinition);
        Assert.assertNull((String)"The initial route node *should* be null since this is an empty process", (Object)processDefinition.getInitialRouteNode());
    }

    public static class PostProcessor
    extends DefaultPostProcessor {
        private static List<DocumentRouteStatusChange> statusChanges = new ArrayList<DocumentRouteStatusChange>();

        public static void clear() {
            statusChanges.clear();
        }

        public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
            statusChanges.add(statusChangeEvent);
            return super.doRouteStatusChange(statusChangeEvent);
        }
    }
}

