/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.test.KEWTestCase;

public class PostProcessorSpawnedDocumentTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_THAT_SPAWNS = "SpawnNewDocumentType";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("PostProcessorSpawnedDocConfig.xml");
    }

    @Test
    public void testSpawnDocument() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("jitrue"), (String)DOCUMENT_TYPE_THAT_SPAWNS);
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        document.route("Route");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        Assert.assertEquals((String)"Document should be enroute.", (Object)"R", (Object)document.getStatus().getCode());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("Test approve by bmcgough");
        String originalDocumentId = document.getDocumentId();
        Long originalDocumentIdLong = Long.parseLong(originalDocumentId.trim());
        Long spawnedDocumentIdLong = originalDocumentIdLong + 1L;
        String spawnedDocumentId = spawnedDocumentIdLong.toString();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)spawnedDocumentId);
        Assert.assertEquals((String)"Document should be final.", (Object)"F", (Object)document.getStatus().getCode());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)originalDocumentId);
        Assert.assertEquals((String)"Document should be final.", (Object)"F", (Object)document.getStatus().getCode());
    }
}

