/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine;

import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class SequentialRoutingTest
extends KEWTestCase {
    private static final String DOCUMENT_TYPE_NAME = "SeqDocType";
    private static final String ADHOC_NODE = "AdHoc";
    private static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
    private static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
    private static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("EngineConfig.xml");
    }

    @Test
    public void testSequentialRoute() throws Exception {
        ActionRequest requestVO;
        int i;
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)DOCUMENT_TYPE_NAME);
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        DocumentRouteHeaderValue drhv = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Set nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertEquals((String)"Wrong node name.", (Object)ADHOC_NODE, nodeNames.iterator().next());
        document.route("Routing sequentially.");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertEquals((String)"Wrong node name.", (Object)WORKFLOW_DOCUMENT_NODE, nodeNames.iterator().next());
        List requests = document.getRootActionRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        ActionRequest request = (ActionRequest)requests.get(0);
        Assert.assertEquals((Object)this.getPrincipalIdForName("bmcgough"), (Object)request.getPrincipalId());
        Assert.assertEquals((Object)ActionRequestType.APPROVE, (Object)request.getActionRequested());
        TestUtilities.assertAtNode(document, WORKFLOW_DOCUMENT_NODE);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("Test approve by bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        requests = document.getRootActionRequests();
        Assert.assertEquals((long)3L, (long)requests.size());
        boolean toTemay = false;
        boolean toJhopf = false;
        for (i = 0; i < requests.size(); ++i) {
            requestVO = (ActionRequest)requests.get(i);
            if (requestVO.getPrincipalId().equals(this.getPrincipalIdForName("temay"))) {
                toTemay = true;
                Assert.assertEquals((Object)ActionRequestType.ACKNOWLEDGE, (Object)requestVO.getActionRequested());
                Assert.assertEquals((Object)ACKNOWLEDGE_1_NODE, (Object)requestVO.getNodeName());
                Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)requestVO.getStatus());
                continue;
            }
            if (!requestVO.getPrincipalId().equals(this.getPrincipalIdForName("jhopf"))) continue;
            toJhopf = true;
            Assert.assertEquals((Object)ActionRequestType.ACKNOWLEDGE, (Object)requestVO.getActionRequested());
            Assert.assertEquals((Object)ACKNOWLEDGE_2_NODE, (Object)requestVO.getNodeName());
            Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)requestVO.getStatus());
        }
        Assert.assertTrue((String)"Should be an acknowledge to temay", (boolean)toTemay);
        Assert.assertTrue((String)"Should be an acknowledge to jhopf", (boolean)toJhopf);
        document.acknowledge("Temay taking acknowledge");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        requests = document.getRootActionRequests();
        toTemay = false;
        toJhopf = false;
        for (i = 0; i < requests.size(); ++i) {
            requestVO = (ActionRequest)requests.get(i);
            if (requestVO.getPrincipalId().equals(this.getPrincipalIdForName("temay"))) {
                toTemay = true;
                Assert.assertEquals((Object)ActionRequestType.ACKNOWLEDGE, (Object)requestVO.getActionRequested());
                Assert.assertEquals((Object)ActionRequestStatus.DONE, (Object)requestVO.getStatus());
                continue;
            }
            if (!requestVO.getPrincipalId().equals(this.getPrincipalIdForName("jhopf"))) continue;
            toJhopf = true;
            Assert.assertEquals((Object)ActionRequestType.ACKNOWLEDGE, (Object)requestVO.getActionRequested());
            Assert.assertEquals((Object)ACKNOWLEDGE_2_NODE, (Object)requestVO.getNodeName());
            Assert.assertEquals((Object)ActionRequestStatus.ACTIVATED, (Object)requestVO.getStatus());
        }
        Assert.assertTrue((String)"Should be a DONE acknowledge to temay", (boolean)toTemay);
        Assert.assertTrue((String)"Should be an acknowledge to jhopf", (boolean)toJhopf);
        document.acknowledge("Jhopf taking acknowledge");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
        this.verifyRoutingPath(document.getDocumentId());
    }

    private void verifyRoutingPath(String documentId) {
        DocumentRouteHeaderValue document = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        List initial = document.getInitialRouteNodeInstances();
        Assert.assertEquals((long)1L, (long)initial.size());
        RouteNodeInstance adhoc = (RouteNodeInstance)initial.get(0);
        Assert.assertEquals((Object)ADHOC_NODE, (Object)adhoc.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)0L, (long)adhoc.getPreviousNodeInstances().size());
        List next = adhoc.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance wd = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)WORKFLOW_DOCUMENT_NODE, (Object)wd.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)wd.getPreviousNodeInstances().size());
        next = wd.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance ack1 = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)ACKNOWLEDGE_1_NODE, (Object)ack1.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)ack1.getPreviousNodeInstances().size());
        next = ack1.getNextNodeInstances();
        Assert.assertEquals((long)1L, (long)next.size());
        RouteNodeInstance ack2 = (RouteNodeInstance)next.get(0);
        Assert.assertEquals((Object)ACKNOWLEDGE_2_NODE, (Object)ack2.getRouteNode().getRouteNodeName());
        Assert.assertEquals((long)1L, (long)ack2.getPreviousNodeInstances().size());
        next = ack2.getNextNodeInstances();
        Assert.assertEquals((long)0L, (long)next.size());
    }
}

