/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.hierarchyrouting;

import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.hierarchyrouting.HierarchyProvider;
import org.kuali.rice.kew.engine.node.hierarchyrouting.SimpleHierarchyProvider;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HierarchyRoutingNodeTest
extends KEWTestCase {
    private static final String HIERARCHY = "<stop id=\"root\" type=\"user\" recipient=\"dewey\"><stop id=\"child1\" type=\"user\" recipient=\"user3\"><stop id=\"child1-1\" type=\"user\" recipient=\"user2\"/><stop id=\"child1-2\" type=\"user\" recipient=\"user1\"/></stop><stop id=\"child2\" type=\"user\" recipient=\"quickstart\"><stop id=\"child2-1\" type=\"user\" recipient=\"temay\"/><stop id=\"child2-2\" type=\"user\" recipient=\"jhopf\"/></stop></stop>";
    private static final String HIERARCHY_UPDATED = "<stop id=\"root\" type=\"user\" recipient=\"dewey\"><stop id=\"child1\" type=\"user\" recipient=\"user3\"><stop id=\"child1-1\" type=\"user\" recipient=\"user2\"/><stop id=\"child1-2\" type=\"user\" recipient=\"user1\"/><stop id=\"child1-3\" type=\"user\" recipient=\"delyea\"/></stop><stop id=\"child2\" type=\"user\" recipient=\"quickstart\"><stop id=\"child2-1\" type=\"user\" recipient=\"temay\"/><stop id=\"child2-2\" type=\"user\" recipient=\"jhopf\"/><stop id=\"child2-3\" type=\"user\" recipient=\"pzhang\"/></stop><stop id=\"child3\" type=\"user\" recipient=\"shenl\"/></stop>";

    protected void assertStop(HierarchyProvider provider, String name, String parentName, String[] childNames) {
        HierarchyProvider.Stop stop = provider.getStopByIdentifier(name);
        Assert.assertNotNull((Object)stop);
        if (parentName == null) {
            Assert.assertNull((Object)provider.getParent(stop));
        } else {
            HierarchyProvider.Stop parent = provider.getStopByIdentifier(parentName);
            Assert.assertNotNull((Object)parent);
            Assert.assertEquals((Object)parent, (Object)((SimpleHierarchyProvider.SimpleStop)stop).parent);
        }
        Assert.assertEquals((long)childNames.length, (long)((SimpleHierarchyProvider.SimpleStop)stop).children.size());
        List<SimpleHierarchyProvider.SimpleStop> children = ((SimpleHierarchyProvider.SimpleStop)stop).children;
        for (String childName : childNames) {
            HierarchyProvider.Stop child = provider.getStopByIdentifier(childName);
            Assert.assertTrue((boolean)children.contains(child));
        }
    }

    @Test
    public void testParseHierarchy() throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(HIERARCHY)));
        SimpleHierarchyProvider provider = new SimpleHierarchyProvider();
        provider.init(doc.getDocumentElement());
        this.assertStop(provider, "root", null, new String[]{"child1", "child2"});
        this.assertStop(provider, "child1", "root", new String[]{"child1-1", "child1-2"});
        this.assertStop(provider, "child1-1", "child1", new String[0]);
        this.assertStop(provider, "child1-2", "child1", new String[0]);
        this.assertStop(provider, "child2", "root", new String[]{"child2-1", "child2-2"});
        this.assertStop(provider, "child2-1", "child2", new String[0]);
        this.assertStop(provider, "child2-2", "child2", new String[0]);
        List<HierarchyProvider.Stop> leaves = provider.getLeafStops(null);
        Assert.assertEquals((long)4L, (long)leaves.size());
        Assert.assertTrue((boolean)leaves.contains(provider.getStopByIdentifier("child1-1")));
        Assert.assertTrue((boolean)leaves.contains(provider.getStopByIdentifier("child1-2")));
        Assert.assertTrue((boolean)leaves.contains(provider.getStopByIdentifier("child2-1")));
        Assert.assertTrue((boolean)leaves.contains(provider.getStopByIdentifier("child2-2")));
    }

    @Test
    public void testHierarchyRoutingNode() throws WorkflowException {
        this.loadXmlFile("HierarchyRoutingNodeConfig.xml");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)"HierarchyDocType");
        doc.setApplicationContent(HIERARCHY);
        doc.route("initial route");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        doc.approve("approving as user2");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.approve("approving as jhopf");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"jhopf", "user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        doc.approve("approving as user1");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)doc.getDocumentId());
        doc.approve("approving as temay");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "quickstart"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"temay", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        doc.approve("approving as user3");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"quickstart"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)doc.getDocumentId());
        doc.approve("approving as quickstart");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"dewey"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "user1", "jhopf", "user2", "quickstart"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("dewey"), (String)doc.getDocumentId());
        doc.approve("approving as dewey");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"dewey", "user3", "temay", "user1", "jhopf", "user2", "quickstart"}, false);
        Assert.assertTrue((boolean)doc.isFinal());
    }

    @Test
    public void testHierarchyRoutingNodeUnevenApproval() throws WorkflowException {
        this.loadXmlFile("HierarchyRoutingNodeConfig.xml");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)"HierarchyDocType");
        doc.setApplicationContent(HIERARCHY);
        doc.route("initial route");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        doc.approve("approving as user2");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.approve("approving as jhopf");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"jhopf", "user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        doc.approve("approving as user1");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        doc.approve("approving as user3");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)doc.getDocumentId());
        doc.approve("approving as temay");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"quickstart"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)doc.getDocumentId());
        doc.approve("approving as quickstart");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"dewey"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "user1", "jhopf", "user2", "quickstart"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("dewey"), (String)doc.getDocumentId());
        doc.approve("approving as dewey");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"dewey", "user3", "temay", "user1", "jhopf", "user2", "quickstart"}, false);
        Assert.assertTrue((boolean)doc.isFinal());
    }

    @Test
    public void testHierarchyRoutingNodeUnevenApprovalExtraStops() throws WorkflowException {
        this.loadXmlFile("HierarchyRoutingNodeConfig.xml");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)"HierarchyDocType");
        doc.setApplicationContent(HIERARCHY);
        doc.route("initial route");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        doc.approve("approving as user2");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.approve("approving as jhopf");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"jhopf", "user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        doc.setApplicationContent(HIERARCHY_UPDATED);
        doc.approve("approving as user1");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "delyea", "pzhang", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        doc.approve("approving as user3");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"temay", "delyea", "pzhang", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)doc.getDocumentId());
        doc.approve("approving as temay");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"delyea", "pzhang", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay", "user1", "jhopf", "user2", "dewey", "quickstart"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("delyea"), (String)doc.getDocumentId());
        doc.approve("approving as delyea");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "pzhang", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"delyea", "temay", "user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        doc.approve("approving as user3");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"pzhang", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"delyea", "temay", "user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pzhang"), (String)doc.getDocumentId());
        doc.approve("approving as pzhang");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"quickstart", "shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"pzhang", "delyea", "temay", "user1", "jhopf", "user2", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("quickstart"), (String)doc.getDocumentId());
        doc.approve("approving as quickstart");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"shenl"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"pzhang", "delyea", "temay", "user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("shenl"), (String)doc.getDocumentId());
        doc.approve("approving as shenl");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"dewey"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"pzhang", "delyea", "temay", "user1", "jhopf", "user2", "quickstart", "shenl"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("dewey"), (String)doc.getDocumentId());
        doc.approve("approving as dewey");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"shenl", "dewey", "pzhang", "delyea", "user3", "temay", "user1", "jhopf", "user2", "quickstart"}, false);
        Assert.assertTrue((boolean)doc.isFinal());
    }

    @Test
    public void testHierarchyRoutingNodeUnevenApprovalDisapprove() throws WorkflowException {
        this.loadXmlFile("HierarchyRoutingNodeConfig.xml");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("arh14"), (String)"HierarchyDocType");
        doc.setApplicationContent(HIERARCHY);
        doc.route("initial route");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        doc.approve("approving as user2");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay", "jhopf"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.approve("approving as jhopf");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"jhopf", "user2", "user3", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        doc.approve("approving as user1");
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user3", "temay"}, true);
        TestUtilities.assertApprovals(doc.getDocumentId(), new String[]{"user1", "jhopf", "user2", "quickstart", "dewey"}, false);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user3"), (String)doc.getDocumentId());
        doc.disapprove("disapproving as user3");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("arh14"), (String)doc.getDocumentId());
        Assert.assertTrue((boolean)doc.isDisapproved());
        TestUtilities.logActionRequests(doc.getDocumentId());
        int numActionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(doc.getDocumentId()).size();
        Assert.assertEquals((String)"Incorrect number of action requests", (long)4L, (long)numActionRequests);
        int numActionItems = KEWServiceLocator.getActionListService().findByDocumentId(doc.getDocumentId()).size();
        Assert.assertEquals((String)"Incorrect number of action items.", (long)4L, (long)numActionItems);
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user2"), (String)doc.getDocumentId());
        doc.acknowledge("acknowledging disapproval as user2");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)doc.getDocumentId());
        doc.acknowledge("acknowledging disapproval as jhopf");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("user1"), (String)doc.getDocumentId());
        doc.acknowledge("acknowledging disapproval as user1");
        doc = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("arh14"), (String)doc.getDocumentId());
        doc.acknowledge("acknowledging disapproval as arh14");
        Assert.assertTrue((boolean)doc.isDisapproved());
        numActionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(doc.getDocumentId()).size();
        Assert.assertEquals((String)"Incorrect number of action requests", (long)0L, (long)numActionRequests);
        numActionItems = KEWServiceLocator.getActionListService().findByDocumentId(doc.getDocumentId()).size();
        Assert.assertEquals((String)"Incorrect number of action items.", (long)0L, (long)numActionItems);
    }
}

