/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node.hierarchyrouting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeConfigParam;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.hierarchyrouting.HierarchyProvider;
import org.kuali.rice.kew.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleHierarchyProvider
implements HierarchyProvider {
    private static final Logger LOG = LogManager.getLogger(SimpleHierarchyProvider.class);
    private SimpleStop root;
    private Map<String, SimpleStop> stops = new HashMap<String, SimpleStop>();

    public void init(RouteNodeInstance nodeInstance, RouteContext context) {
        this.init(context.getDocumentContent().getDocument().getDocumentElement());
    }

    public void init(Element element) {
        Element rootStop = this.findRootStop(element);
        this.root = this.parseStops(rootStop, null);
    }

    protected Element findRootStop(Element e) {
        if ("stop".equals(e.getNodeName())) {
            return e;
        }
        NodeList nl = e.getElementsByTagName("stop");
        if (nl == null || nl.getLength() == 0) {
            throw new RuntimeException("No stops found");
        }
        return (Element)nl.item(0);
    }

    protected SimpleStop parseStops(Element e, SimpleStop parent) {
        LOG.debug("parsing element: " + e + " parent: " + parent);
        SimpleStop stop = this.parseStop(e);
        LOG.debug("parsed stop: " + stop);
        stop.parent = parent;
        if (parent != null) {
            parent.children.add(stop);
        }
        this.stops.put(e.getAttribute("id"), stop);
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element)) continue;
            this.parseStops((Element)n, stop);
        }
        return stop;
    }

    protected SimpleStop parseStop(Element e) {
        SimpleStop ss = new SimpleStop();
        String recipient = e.getAttribute("recipient");
        String type = e.getAttribute("type");
        String id = e.getAttribute("id");
        if (id == null) {
            throw new RuntimeException("malformed document content, missing id attribute: " + e);
        }
        ss.id = id;
        ss.recipient = recipient;
        if (!StringUtils.isEmpty((String)type)) {
            SimpleStop.RecipientType rtype;
            ss.type = rtype = SimpleStop.RecipientType.valueOf(type.toUpperCase());
        }
        return ss;
    }

    public List<HierarchyProvider.Stop> getLeafStops(RouteContext context) {
        ArrayList<HierarchyProvider.Stop> leafStops = new ArrayList<HierarchyProvider.Stop>();
        for (SimpleStop stop : this.stops.values()) {
            if (stop.children.size() != 0) continue;
            leafStops.add(stop);
        }
        return leafStops;
    }

    public HierarchyProvider.Stop getStopByIdentifier(String stopId) {
        return this.stops.get(stopId);
    }

    public String getStopIdentifier(HierarchyProvider.Stop stop) {
        return ((SimpleStop)stop).id;
    }

    public boolean hasStop(RouteNodeInstance nodeInstance) {
        return nodeInstance.getNodeState("id") != null;
    }

    public void setStop(RouteNodeInstance requestNodeInstance, HierarchyProvider.Stop stop) {
        SimpleStop ss = (SimpleStop)stop;
        requestNodeInstance.addNodeState(new NodeState("id", this.getStopIdentifier(stop)));
        if (ss.recipient != null) {
            requestNodeInstance.addNodeState(new NodeState("recipient", ((SimpleStop)stop).recipient));
        }
        if (ss.type != null) {
            requestNodeInstance.addNodeState(new NodeState("type", ((SimpleStop)stop).type.name().toLowerCase()));
        }
    }

    public boolean equals(HierarchyProvider.Stop a, HierarchyProvider.Stop b) {
        return ObjectUtils.equals((Object)a, (Object)b);
    }

    public HierarchyProvider.Stop getParent(HierarchyProvider.Stop stop) {
        return ((SimpleStop)stop).parent;
    }

    public boolean isRoot(HierarchyProvider.Stop stop) {
        return this.equals(stop, this.root);
    }

    public HierarchyProvider.Stop getStop(RouteNodeInstance nodeInstance) {
        NodeState state = nodeInstance.getNodeState("id");
        if (state == null) {
            throw new RuntimeException();
        }
        LOG.warn("id Node state on nodeinstance " + nodeInstance + ": " + state);
        return this.stops.get(state.getValue());
    }

    public void configureRequestNode(RouteNodeInstance hierarchyNodeInstance, RouteNode node) {
        Map hierarchyCfgMap;
        Map cfgMap = Utilities.getKeyValueCollectionAsMap((List)node.getConfigParams());
        if (!cfgMap.containsKey("ruleSelector")) {
            hierarchyCfgMap = Utilities.getKeyValueCollectionAsMap((List)hierarchyNodeInstance.getRouteNode().getConfigParams());
            node.getConfigParams().add(new RouteNodeConfigParam(node, "ruleSelector", (String)hierarchyCfgMap.get("ruleSelector")));
        }
        if (!cfgMap.containsKey("ruleName")) {
            hierarchyCfgMap = Utilities.getKeyValueCollectionAsMap((List)hierarchyNodeInstance.getRouteNode().getConfigParams());
            node.getConfigParams().add(new RouteNodeConfigParam(node, "ruleName", (String)hierarchyCfgMap.get("ruleName")));
        }
    }

    static class SimpleStop
    implements HierarchyProvider.Stop {
        public SimpleStop parent;
        public List<SimpleStop> children = new ArrayList<SimpleStop>();
        public RecipientType type;
        public String recipient;
        public String id;

        SimpleStop() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("recipient", (Object)this.recipient).append("type", (Object)this.type).append("parent", this.parent == null ? null : this.parent.id).append("children", (Object)StringUtils.join((Collection)CollectionUtils.collect(this.children, (Transformer)new Transformer(){

                public Object transform(Object o) {
                    return ((SimpleStop)o).id;
                }
            }), (char)',')).toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleStop)) {
                return false;
            }
            return this.id.equals(((SimpleStop)o).id);
        }

        public int hashCode() {
            return ObjectUtils.hashCode((Object)this.id);
        }

        private static enum RecipientType {
            USER,
            WORKGROUP;

        }
    }
}

