/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.document;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.docsearch.SearchableAttributeDateTimeValue;
import org.kuali.rice.kew.docsearch.SearchableAttributeStringValue;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.documentlink.DocumentLink;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.BranchState;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValueContent;
import org.kuali.rice.kew.routeheader.DocumentStatusTransition;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.test.TestHarnessServiceLocator;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.JdbcTemplate;

public class KewDocumentDataJpaTest
extends KEWTestCase {
    public static final String TEST_DOC_ID = "1234";
    public static final String SEARCHABLE_ATTR_ID = "1000";
    public static final String SEARCHABLE_ATTR_KEY = "testAttribute";
    public static final String SEARCHABLE_ATTR_VAL = "testing";
    public static final Timestamp SEARCHABLE_ATTR_VAL_DT = new Timestamp(System.currentTimeMillis());
    public static final String DOC_CNT = "<xml>some content</xml>";
    public static final String NOTE_TXT = "noteText";

    @Test
    public void testDocumentContentFetchAndSave() throws Exception {
        DocumentRouteHeaderValueContent dc = this.setupDocumentValueContent();
        Assert.assertTrue((String)"DocumentRouteHeaderContent persisted", (dc != null && StringUtils.equals((String)TEST_DOC_ID, (String)dc.getDocumentId()) && StringUtils.equals((String)dc.getDocumentContent(), (String)DOC_CNT) ? 1 : 0) != 0);
        dc = (DocumentRouteHeaderValueContent)KRADServiceLocator.getDataObjectService().find(DocumentRouteHeaderValueContent.class, (Object)TEST_DOC_ID);
        Assert.assertTrue((String)"DocumentRouteHeaderContent refetched", (dc != null && StringUtils.equals((String)TEST_DOC_ID, (String)dc.getDocumentId()) && StringUtils.equals((String)dc.getDocumentContent(), (String)DOC_CNT) ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentRouteHeaderValueFindByDocumentId() throws Exception {
        DocumentRouteHeaderValue savedVal = this.setupDocumentRouteHeaderValue();
        DocumentRouteHeaderValue fetchedVal = KEWServiceLocator.getRouteHeaderService().getRouteHeader(savedVal.getDocumentId(), true);
        Assert.assertTrue((String)"getRouteHeader fetched correctly", (fetchedVal != null && StringUtils.equals((String)fetchedVal.getDocumentId(), (String)savedVal.getDocumentId()) ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentRouteHeaderValueGetRouteHeaders() throws Exception {
        DocumentRouteHeaderValue savedRouteHeader = this.setupDocumentRouteHeaderValue();
        this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        ArrayList<String> documentIds = new ArrayList<String>();
        documentIds.add(TEST_DOC_ID);
        documentIds.add(savedRouteHeader.getDocumentId());
        Collection routeHeaders = KEWServiceLocator.getRouteHeaderService().getRouteHeaders(documentIds, true);
        Assert.assertTrue((String)"getRouteHeaders fetched", (routeHeaders != null && routeHeaders.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentRouteHeaderValueLockRouteHeader() throws Exception {
        DocumentRouteHeaderValue dv = this.setupDocumentRouteHeaderValue();
        KEWServiceLocator.getRouteHeaderService().lockRouteHeader(dv.getDocumentId());
        dv = KEWServiceLocator.getRouteHeaderService().getRouteHeader(dv.getDocumentId());
        dv.setAppDocStatus("X");
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(dv);
    }

    @Test
    public void testDocumentRouteHeaderValueSaveRouteHeader() throws Exception {
        DocumentRouteHeaderValue dv = this.setupDocumentRouteHeaderValue();
        dv.setAppDocStatus("X");
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(dv);
        Assert.assertTrue((String)"saveRouteHeader saved correctly", (boolean)StringUtils.equals((String)dv.getAppDocStatus(), (String)"X"));
    }

    @Test(expected=OptimisticLockingFailureException.class)
    public void testDocumentRouteHeaderValueSaveRouteHeaderThrowsOptimisticException() throws Exception {
        DocumentRouteHeaderValue dv = this.setupDocumentRouteHeaderValue();
        dv.setVersionNumber(null);
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(dv);
        Assert.fail();
    }

    @Test
    public void testDocumentRouteHeaderValueDelete() throws Exception {
        DocumentRouteHeaderValue dv = this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        KEWServiceLocator.getRouteHeaderService().deleteRouteHeader(dv);
        dv = KEWServiceLocator.getRouteHeaderService().getRouteHeader(dv.getDocumentId());
        Assert.assertTrue((String)"Route Header deleted", (dv == null ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentRouteHeaderValueGetNextDocumentId() throws Exception {
        String val = KEWServiceLocator.getRouteHeaderService().getNextDocumentId();
        Assert.assertTrue((String)"Next value found", (boolean)StringUtils.isNotEmpty((String)val));
    }

    @Test
    public void testDocumentRouteHeaderValueClearRouteHeaderSearchValues() throws Exception {
        this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        this.setupSearchAttributeStringValue();
        KEWServiceLocator.getRouteHeaderService().clearRouteHeaderSearchValues(TEST_DOC_ID);
    }

    @Test
    public void testDocumentRouteHeaderValueHasSearchableAttributeValue() throws Exception {
        this.setupSearchAttributeStringValue();
        this.setupSearchAttributeDateTimeValue();
        boolean hasSAValue = KEWServiceLocator.getRouteHeaderService().hasSearchableAttributeValue(TEST_DOC_ID, SEARCHABLE_ATTR_KEY, SEARCHABLE_ATTR_VAL);
        Assert.assertTrue((String)"hasSearchableAttributeValue found", (hasSAValue ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentStatusTransition() throws Exception {
        DocumentRouteHeaderValue documentRouteHeaderValue = this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        DocumentStatusTransition documentStatusTransition = this.setupDocumentStatusTransition();
        documentRouteHeaderValue.getAppDocStatusHistory().add(documentStatusTransition);
        documentStatusTransition.setOldAppDocStatus("R");
        Assert.assertTrue((String)"Document Status Transition saved and persisted", (documentStatusTransition != null && StringUtils.isNotEmpty((String)documentStatusTransition.getStatusTransitionId()) ? 1 : 0) != 0);
        DocumentStatusTransition fetchedVal = (DocumentStatusTransition)KRADServiceLocator.getDataObjectService().find(DocumentStatusTransition.class, (Object)documentStatusTransition.getStatusTransitionId());
        Assert.assertTrue((String)"DocumentStatusTransition fetched after save", (fetchedVal != null && StringUtils.equals((String)fetchedVal.getDocumentId(), (String)fetchedVal.getDocumentId()) ? 1 : 0) != 0);
        KRADServiceLocator.getDataObjectService().save((Object)documentRouteHeaderValue, new PersistenceOption[0]);
        DocumentRouteHeaderValue newHeaderVal = (DocumentRouteHeaderValue)KRADServiceLocator.getDataObjectService().find(DocumentRouteHeaderValue.class, (Object)documentRouteHeaderValue.getDocumentId());
        Assert.assertTrue((String)"On fetch app doc history updated", (newHeaderVal != null && StringUtils.equals((String)((DocumentStatusTransition)newHeaderVal.getAppDocStatusHistory().get(0)).getOldAppDocStatus(), (String)"R") ? 1 : 0) != 0);
    }

    @Test
    public void testBranchState() throws Exception {
        Branch branch = this.setupRouteBranch();
        Assert.assertTrue((String)"BranchState persisted", ((branch = this.setupRouteBranchState(branch)) != null && branch.getBranchState() != null && StringUtils.isNotBlank((String)((BranchState)branch.getBranchState().get(0)).getBranchStateId()) ? 1 : 0) != 0);
        branch = (Branch)KradDataServiceLocator.getDataObjectService().find(Branch.class, (Object)branch.getBranchId());
        Assert.assertTrue((String)"BranchState fetched", (branch != null && branch.getBranchState().get(0) != null ? 1 : 0) != 0);
    }

    @Test
    public void testRouteHeaderInitJoinTable() throws Exception {
        DocumentRouteHeaderValue dv = this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance rni = this.setupRouteNodeInstance(rn);
        this.setupInitialRouteNodeInstancesJoinTable(rni.getRouteNodeInstanceId());
        dv = (DocumentRouteHeaderValue)KradDataServiceLocator.getDataObjectService().find(DocumentRouteHeaderValue.class, (Object)TEST_DOC_ID);
        dv.getInitialRouteNodeInstances().add(rni);
        Assert.assertTrue((String)"DocumentRouteHeaderValue fetched correctly with joined instance", (dv != null && dv.getInitialRouteNodeInstances() != null && dv.getInitialRouteNodeInstances().get(0) != null && StringUtils.equals((String)((RouteNodeInstance)dv.getInitialRouteNodeInstances().get(0)).getRouteNodeInstanceId(), (String)rni.getRouteNodeInstanceId()) ? 1 : 0) != 0);
    }

    @Test
    public void testBranch() throws Exception {
        Branch b = this.setupRouteBranch();
        Assert.assertTrue((String)"branch persisted correctly", (b != null && StringUtils.isNotBlank((String)b.getBranchId()) && b.getLockVerNbr() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNodeStates() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance savedVal = this.setupRouteNodeInstance(rn);
        NodeState ns = this.setupNodeState(savedVal);
        savedVal.getState().add(ns);
        KRADServiceLocator.getDataObjectService().save((Object)savedVal, new PersistenceOption[0]);
        Assert.assertTrue((String)"RouteNodeInstance saved and persisted", (savedVal != null && StringUtils.isNotEmpty((String)savedVal.getRouteNodeInstanceId()) ? 1 : 0) != 0);
        savedVal = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().find(RouteNodeInstance.class, (Object)savedVal.getRouteNodeInstanceId());
        Assert.assertTrue((String)"NodeStates fetched correctly", (savedVal.getState() != null && savedVal.getState().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeInstance() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance savedVal = this.setupRouteNodeInstance(rn);
        Assert.assertTrue((String)"DocumentRouteHeaderValue saved and persisted", (savedVal != null && StringUtils.isNotEmpty((String)savedVal.getRouteNodeInstanceId()) ? 1 : 0) != 0);
        RouteNodeInstance fetchedValue = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().find(RouteNodeInstance.class, (Object)savedVal.getRouteNodeInstanceId());
        Assert.assertTrue((String)"DocumentRouteHeaderValue fetched after save", (fetchedValue != null && StringUtils.equals((String)savedVal.getDocumentId(), (String)fetchedValue.getDocumentId()) ? 1 : 0) != 0);
    }

    @Test
    public void testNote() throws Exception {
        Note note = this.setupNote();
        Assert.assertTrue((String)"Note persisted correctly", (note != null && StringUtils.isNotBlank((String)note.getNoteId()) ? 1 : 0) != 0);
        note.setNoteText("ModifiedText");
        KRADServiceLocator.getDataObjectService().save((Object)note, new PersistenceOption[0]);
        note = (Note)KRADServiceLocator.getDataObjectService().find(Note.class, (Object)note.getNoteId());
        Assert.assertTrue((String)"Note persisted correctly", (note != null && StringUtils.equals((String)note.getNoteText(), (String)"ModifiedText") ? 1 : 0) != 0);
    }

    @Test
    public void testNoteService() throws Exception {
        Note note = this.setupNote();
        Assert.assertTrue((String)"Note persisted correctly", (note != null && StringUtils.isNotBlank((String)note.getNoteId()) ? 1 : 0) != 0);
        List notes = KEWServiceLocator.getNoteService().getNotesByDocumentId(TEST_DOC_ID);
        Assert.assertTrue((String)"getNotesByDocumentId fetched correctly", (notes != null && notes.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAttachment() throws Exception {
        Note note = this.setupNote();
        Attachment attachment = this.setupAttachment(note);
        note.getAttachments().add(attachment);
        Assert.assertTrue((String)"Attachment persisted correctly", (attachment != null && StringUtils.isNotBlank((String)attachment.getAttachmentId()) ? 1 : 0) != 0);
        note = KEWServiceLocator.getNoteService().getNoteByNoteId(note.getNoteId());
        Assert.assertTrue((String)"Attachment fetched on note fetch", (note != null && note.getAttachments() != null && note.getAttachments().size() == 1 && StringUtils.equals((String)((Attachment)note.getAttachments().get(0)).getAttachmentId(), (String)attachment.getAttachmentId()) ? 1 : 0) != 0);
    }

    @Test
    public void testDocumentLink() throws Exception {
        DocumentLink documentLink = this.setupDocumentLink(TEST_DOC_ID, "9999");
        Assert.assertTrue((String)"documentlink persisted correctly", (documentLink != null && StringUtils.isNotBlank((String)documentLink.getDocLinkId()) ? 1 : 0) != 0);
        KEWServiceLocator.getDocumentLinkService().deleteDocumentLink(documentLink);
        documentLink = (DocumentLink)KRADServiceLocator.getDataObjectService().find(DocumentLink.class, (Object)documentLink.getDocLinkId());
        Assert.assertTrue((String)"documentlink was deleted", (documentLink == null ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceDeleteByRouteNodeInstance() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        String routeNodeInstanceId = routeNodeInstance.getRouteNodeInstanceId();
        KEWServiceLocator.getRouteNodeService().deleteByRouteNodeInstance(routeNodeInstance);
        routeNodeInstance = (RouteNodeInstance)KradDataServiceLocator.getDataObjectService().find(RouteNodeInstance.class, (Object)routeNodeInstanceId);
        Assert.assertTrue((String)"RouteNodeInstanceDeleted successfully", (routeNodeInstance == null ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceGetActiveNodeInstances() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        List routeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeInstances != null && routeNodeInstances.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceGetCurrentRouteNodeNames() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        List routeNodeNames = KEWServiceLocator.getRouteNodeService().getCurrentRouteNodeNames(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeNames != null && routeNodeNames.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceGetActiveRouteNodeNames() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        List routeNodeNames = KEWServiceLocator.getRouteNodeService().getActiveRouteNodeNames(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeNames != null && routeNodeNames.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceGetTerminalNodeInstances() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setActive(false);
        routeNodeInstance.setComplete(true);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        List routeNodeList = KEWServiceLocator.getRouteNodeService().getTerminalNodeInstances(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeList != null && routeNodeList.size() == 1 ? 1 : 0) != 0);
        List routeNodeNames = KEWServiceLocator.getRouteNodeService().getTerminalRouteNodeNames(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeNames != null && routeNodeNames.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceGetInitialNodeInstances() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        Assert.assertTrue((String)"Route node instance persisted with route node", (routeNodeInstance != null && StringUtils.isNotBlank((String)routeNodeInstance.getRouteNodeId()) ? 1 : 0) != 0);
        DocumentRouteHeaderValue drv = this.setupDocumentRouteHeaderValueWithRouteHeaderAssigned();
        drv.getInitialRouteNodeInstances().add(routeNodeInstance);
        KRADServiceLocator.getDataObjectService().save((Object)drv, new PersistenceOption[0]);
        List routeNodeInstances = KEWServiceLocator.getRouteNodeService().getInitialNodeInstances(routeNodeInstance.getDocumentId());
        Assert.assertTrue((String)"Route node instances found", (routeNodeInstances != null && routeNodeInstances.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceFindNodeState() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        RouteNodeInstance routeNodeInstance = this.setupRouteNodeInstance(rn);
        routeNodeInstance.setRouteNode(rn);
        routeNodeInstance = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[0]);
        NodeState nodeState = this.setupNodeState(routeNodeInstance);
        Assert.assertTrue((String)"Node state is persisted", (nodeState != null && StringUtils.isNotBlank((String)nodeState.getNodeStateId()) ? 1 : 0) != 0);
        String nodeStateId = nodeState.getNodeStateId();
        nodeState = KEWServiceLocator.getRouteNodeService().findNodeState(Long.valueOf(Long.parseLong(routeNodeInstance.getRouteNodeInstanceId())), nodeState.getKey());
        Assert.assertTrue((String)"Node state is found", (nodeState != null && StringUtils.equals((String)nodeStateId, (String)nodeState.getNodeStateId()) ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceFindRouteNodeByName() throws Exception {
        DocumentType documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        String routeNodeId = rn.getRouteNodeId();
        rn = KEWServiceLocator.getRouteNodeService().findRouteNodeByName(rn.getDocumentTypeId(), rn.getRouteNodeName());
        Assert.assertTrue((String)"Route node fetched correctly", (rn != null && StringUtils.equals((String)routeNodeId, (String)rn.getRouteNodeId()) ? 1 : 0) != 0);
    }

    @Test
    public void testRouteNodeServiceSaveRouteNodeInstance() throws Exception {
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("gooddoctype");
        if (documentType != null) {
            KRADServiceLocator.getDataObjectService().delete((Object)documentType);
        }
        documentType = this.setupDocumentType();
        RouteNode rn = this.setupRouteNode(documentType);
        Assert.assertNotNull((Object)rn.getRouteNodeId());
        RouteNodeInstance rni = new RouteNodeInstance();
        rni.setDocumentId(TEST_DOC_ID);
        rni.setRouteNode(rn);
        rni = (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)rni, new PersistenceOption[0]);
        Assert.assertNotNull((Object)rni.getRouteNodeId());
        Assert.assertEquals((Object)rn.getName(), (Object)rni.getName());
    }

    private DocumentLink setupDocumentLink(String desDocumentId, String orgDocumentId) {
        DocumentLink documentLink = new DocumentLink();
        documentLink.setDestDocId(desDocumentId);
        documentLink.setOrgnDocId(orgDocumentId);
        KRADServiceLocator.getDataObjectService().save((Object)documentLink, new PersistenceOption[0]);
        documentLink = new DocumentLink();
        documentLink.setOrgnDocId(desDocumentId);
        documentLink.setDestDocId(orgDocumentId);
        return (DocumentLink)KRADServiceLocator.getDataObjectService().save((Object)documentLink, new PersistenceOption[0]);
    }

    private NodeState setupNodeState(RouteNodeInstance routeNodeInstance) {
        NodeState nodeState = new NodeState();
        nodeState.setKey("TST");
        nodeState.setValue("VAL");
        nodeState.setNodeInstance(routeNodeInstance);
        return (NodeState)KRADServiceLocator.getDataObjectService().save((Object)nodeState, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private Note setupNote() {
        Note note = new Note();
        note.setNoteText(NOTE_TXT);
        note.setNoteAuthorWorkflowId("1");
        note.setNoteCreateDate(new Timestamp(System.currentTimeMillis()));
        note.setDocumentId(TEST_DOC_ID);
        return (Note)KradDataServiceLocator.getDataObjectService().save((Object)note, new PersistenceOption[0]);
    }

    private Attachment setupAttachment(Note note) {
        Attachment attachment = new Attachment();
        attachment.setFileLoc("/testfile");
        attachment.setMimeType("test");
        attachment.setFileName("test.txt");
        attachment.setNote(note);
        return (Attachment)KRADServiceLocator.getDataObjectService().save((Object)attachment, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private Branch setupRouteBranchState(Branch branch) {
        BranchState bs = new BranchState();
        bs.setKey("KEY");
        bs.setValue("VAL");
        bs.setBranch(branch);
        branch.getBranchState().add(bs);
        return (Branch)KradDataServiceLocator.getDataObjectService().save((Object)branch, new PersistenceOption[0]);
    }

    private Branch setupRouteBranch() {
        Branch branch = new Branch();
        branch.setName("PRIMARY");
        return (Branch)KRADServiceLocator.getDataObjectService().save((Object)branch, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private void setupInitialRouteNodeInstancesJoinTable(String routeNodeInstanceId) {
        new JdbcTemplate(TestHarnessServiceLocator.getDataSource()).execute("insert into KREW_INIT_RTE_NODE_INSTN_T values('1234','" + routeNodeInstanceId + "')");
    }

    private DocumentRouteHeaderValueContent setupDocumentValueContent() {
        DocumentRouteHeaderValueContent dc = new DocumentRouteHeaderValueContent();
        dc.setDocumentId(TEST_DOC_ID);
        dc.setDocumentContent(DOC_CNT);
        return (DocumentRouteHeaderValueContent)KRADServiceLocator.getDataObjectService().save((Object)dc, new PersistenceOption[0]);
    }

    private SearchableAttributeStringValue setupSearchAttributeStringValue() {
        SearchableAttributeStringValue searchableAttributeValue = new SearchableAttributeStringValue();
        searchableAttributeValue.setDocumentId(TEST_DOC_ID);
        searchableAttributeValue.setSearchableAttributeValueId(SEARCHABLE_ATTR_ID);
        searchableAttributeValue.setSearchableAttributeKey(SEARCHABLE_ATTR_KEY);
        searchableAttributeValue.setSearchableAttributeValue(SEARCHABLE_ATTR_VAL);
        return (SearchableAttributeStringValue)KRADServiceLocator.getDataObjectService().save((Object)searchableAttributeValue, new PersistenceOption[0]);
    }

    private SearchableAttributeDateTimeValue setupSearchAttributeDateTimeValue() {
        SearchableAttributeDateTimeValue searchableAttributeDateTimeValue = new SearchableAttributeDateTimeValue();
        searchableAttributeDateTimeValue.setDocumentId(TEST_DOC_ID);
        searchableAttributeDateTimeValue.setSearchableAttributeValueId(SEARCHABLE_ATTR_ID);
        searchableAttributeDateTimeValue.setSearchableAttributeKey(SEARCHABLE_ATTR_KEY);
        searchableAttributeDateTimeValue.setSearchableAttributeValue(SEARCHABLE_ATTR_VAL_DT);
        return (SearchableAttributeDateTimeValue)KRADServiceLocator.getDataObjectService().save((Object)searchableAttributeDateTimeValue, new PersistenceOption[0]);
    }

    private DocumentRouteHeaderValue setupDocumentRouteHeaderValue() {
        DocumentRouteHeaderValue routeHeader = new DocumentRouteHeaderValue();
        routeHeader.setAppDocId("Test");
        routeHeader.setApprovedDate(null);
        routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        routeHeader.setDocContent("test");
        routeHeader.setDocRouteLevel(Integer.valueOf(1));
        routeHeader.setDocRouteStatus("R");
        routeHeader.setDocTitle("Test");
        routeHeader.setDocumentTypeId("1");
        routeHeader.setDocVersion(Integer.valueOf(1));
        routeHeader.setRouteStatusDate(new Timestamp(new Date().getTime()));
        routeHeader.setDateModified(new Timestamp(new Date().getTime()));
        routeHeader.setInitiatorWorkflowId("someone");
        return (DocumentRouteHeaderValue)KRADServiceLocator.getDataObjectService().save((Object)routeHeader, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private DocumentRouteHeaderValue setupDocumentRouteHeaderValueWithRouteHeaderAssigned() {
        DocumentRouteHeaderValue routeHeader = new DocumentRouteHeaderValue();
        routeHeader.setDocumentId(TEST_DOC_ID);
        routeHeader.setAppDocId("Test");
        routeHeader.setApprovedDate(null);
        routeHeader.setCreateDate(new Timestamp(new Date().getTime()));
        routeHeader.setDocContent("test");
        routeHeader.setDocRouteLevel(Integer.valueOf(1));
        routeHeader.setDocRouteStatus("R");
        routeHeader.setDocTitle("Test");
        routeHeader.setDocumentTypeId("1");
        routeHeader.setDocVersion(Integer.valueOf(1));
        routeHeader.setRouteStatusDate(new Timestamp(new Date().getTime()));
        routeHeader.setDateModified(new Timestamp(new Date().getTime()));
        routeHeader.setInitiatorWorkflowId("someone");
        return (DocumentRouteHeaderValue)KRADServiceLocator.getDataObjectService().save((Object)routeHeader, new PersistenceOption[0]);
    }

    private DocumentStatusTransition setupDocumentStatusTransition() {
        DocumentStatusTransition documentStatusTransition = new DocumentStatusTransition();
        documentStatusTransition.setDocumentId(TEST_DOC_ID);
        documentStatusTransition.setNewAppDocStatus("F");
        documentStatusTransition.setOldAppDocStatus("A");
        documentStatusTransition.setStatusTransitionDate(new Timestamp(System.currentTimeMillis()));
        return (DocumentStatusTransition)KRADServiceLocator.getDataObjectService().save((Object)documentStatusTransition, new PersistenceOption[0]);
    }

    private RouteNodeInstance setupRouteNodeInstance(RouteNode routeNode) {
        RouteNodeInstance routeNodeInstance = new RouteNodeInstance();
        routeNodeInstance.setActive(true);
        routeNodeInstance.setComplete(true);
        routeNodeInstance.setDocumentId(TEST_DOC_ID);
        routeNodeInstance.setInitial(true);
        routeNodeInstance.setRouteNode(routeNode);
        return (RouteNodeInstance)KRADServiceLocator.getDataObjectService().save((Object)routeNodeInstance, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private RouteNode setupRouteNode(DocumentType documentType) {
        RouteNode routeNode = new RouteNode();
        routeNode.setDocumentType(documentType);
        routeNode.setRouteNodeName("PreRoute");
        routeNode.setRouteMethodName("org.kuali.rice.kew.engine.node.InitialNode");
        routeNode.setRouteMethodCode("C");
        routeNode.setActivationType("P");
        return (RouteNode)KRADServiceLocator.getDataObjectService().save((Object)routeNode, new PersistenceOption[]{PersistenceOption.FLUSH});
    }

    private DocumentType setupDocumentType() {
        DocumentType documentType = new DocumentType();
        documentType.setActionsUrl("/test");
        documentType.setActive(true);
        documentType.setActualApplicationId("tst");
        documentType.setActualNotificationFromAddress("blah@iu.edu");
        documentType.setApplyRetroactively(Boolean.valueOf(true));
        documentType.setAuthorizer("TestAuthorizer");
        documentType.setBlanketApprovePolicy("GoodPolicy");
        documentType.setBlanketApproveWorkgroupId("TestGroup");
        documentType.setCurrentInd(Boolean.valueOf(true));
        documentType.setDescription("testing descr");
        documentType.setCustomEmailStylesheet("blah@iu.edu");
        documentType.setDocumentId(TEST_DOC_ID);
        documentType.setLabel("doc type stuff");
        documentType.setName("gooddoctype");
        documentType.setReturnUrl("returnUrl");
        documentType.setPostProcessorName("PostProcessMe");
        documentType.setDocTypeParentId(null);
        return (DocumentType)KRADServiceLocator.getDataObjectService().save((Object)documentType, new PersistenceOption[0]);
    }
}

