/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.note;

import java.util.List;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.note.Note;
import org.kuali.rice.kew.api.note.NoteService;
import org.kuali.rice.kew.test.KEWTestCase;

public class NoteServiceTest
extends KEWTestCase {
    @Test
    public void testIllegalNoteOperations() throws Exception {
        NoteService noteService = KewApiServiceLocator.getNoteService();
        try {
            noteService.createNote(null);
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Note.Builder testNote = Note.Builder.create((String)"1234", (String)"ewestfal");
        testNote.setId("4321");
        try {
            noteService.createNote(testNote.build());
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            noteService.updateNote(null);
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        testNote = Note.Builder.create((String)"1234", (String)"ewestfal");
        try {
            noteService.updateNote(testNote.build());
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        testNote.setId("4321");
        try {
            noteService.updateNote(testNote.build());
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        testNote.setVersionNumber(new Long(1L));
        try {
            noteService.updateNote(testNote.build());
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        testNote.setCreateDate(new DateTime());
        try {
            noteService.updateNote(testNote.build());
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            noteService.deleteNote("1234");
            Assert.fail((String)"RiceIllegalArgumentException should have been thrown");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNotesClient() throws Exception {
        NoteService noteService = KewApiServiceLocator.getNoteService();
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"TestDocumentType");
        Assert.assertTrue((boolean)noteService.getNotes(doc.getDocumentId()).isEmpty());
        Note.Builder testNote = Note.Builder.create((String)doc.getDocumentId(), (String)"andlee");
        testNote.setText("first added note");
        Note createdNote = noteService.createNote(testNote.build());
        Assert.assertNotNull((Object)createdNote);
        Assert.assertNotNull((Object)createdNote.getId());
        Assert.assertNotNull((Object)createdNote.getVersionNumber());
        Assert.assertEquals((Object)doc.getDocumentId(), (Object)createdNote.getDocumentId());
        Assert.assertEquals((Object)"andlee", (Object)createdNote.getAuthorPrincipalId());
        Assert.assertEquals((Object)"first added note", (Object)createdNote.getText());
        testNote = Note.Builder.create((String)doc.getDocumentId(), (String)"rou");
        testNote.setText("second added note");
        Note createdNote2 = noteService.createNote(testNote.build());
        List notesList = noteService.getNotes(doc.getDocumentId());
        Assert.assertEquals((String)"Two notes are added.", (long)2L, (long)notesList.size());
        Assert.assertEquals((String)"Note List size changed", (long)2L, (long)notesList.size());
        for (Note note : notesList) {
            Assert.assertNotNull((String)"Note saved", (Object)note.getId());
            if (note.getId().equals(createdNote.getId())) {
                Assert.assertEquals((String)"text altered during save", (Object)"first added note", (Object)note.getText());
                Assert.assertEquals((String)"note user associated with saved note", (Object)"andlee", (Object)note.getAuthorPrincipalId());
            }
            if (!note.getId().equals(createdNote2.getId())) continue;
            Assert.assertEquals((String)"text altered during save", (Object)"second added note", (Object)note.getText());
            Assert.assertEquals((String)"note user associated with saved note", (Object)"rou", (Object)note.getAuthorPrincipalId());
        }
        notesList = noteService.getNotes(doc.getDocumentId());
        Note note1 = null;
        Note note2 = null;
        for (Note note : notesList) {
            if (note.getId().equals(createdNote.getId())) {
                note1 = note;
                continue;
            }
            if (note.getId().equals(createdNote2.getId())) {
                note2 = note;
                continue;
            }
            Assert.fail((String)("encountered unexpected note!: " + note.getId()));
        }
        noteService.deleteNote(note1.getId());
        Note.Builder note2Builder = Note.Builder.create(note2);
        note2Builder.setText("Update second note text");
        noteService.updateNote(note2Builder.build());
        notesList = noteService.getNotes(doc.getDocumentId());
        Assert.assertEquals((String)"Note List size changed", (long)1L, (long)notesList.size());
        Note remainingNote = (Note)notesList.get(0);
        Assert.assertNotNull((String)"Note saved", (Object)remainingNote.getId());
        Assert.assertEquals((String)"text altered during save", (Object)"Update second note text", (Object)remainingNote.getText());
        Assert.assertEquals((String)"note user associated with saved note", (Object)"rou", (Object)remainingNote.getAuthorPrincipalId());
    }
}

