/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail.service.impl;

import mocks.MockEmailNotificationService;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.mail.ImmediateEmailReminderQueue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class ImmediateEmailReminderQueueImplTest
extends KEWTestCase {
    private ImmediateEmailReminderQueue immediateEmailReminderQueue;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.immediateEmailReminderQueue = KewApiServiceLocator.getImmediateEmailReminderQueue();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void test() {
        ActionItem actionItem = ActionItem.Builder.create((String)"124", (String)"A", (String)"123", (DateTime)new DateTime(), (String)"Test", (String)"http://www.test.com", (String)"Test", (String)"125", (String)"user1").build();
        this.immediateEmailReminderQueue.sendReminder(actionItem, Boolean.FALSE);
        Assert.assertEquals((String)"user1 should have 1 email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("user1", "124", "A"));
        Assert.assertEquals((String)"user2 should have no emails", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("user2", "124", "A"));
        this.getMockEmailService().resetReminderCounts();
        this.immediateEmailReminderQueue.sendReminder(actionItem, Boolean.TRUE);
        Assert.assertEquals((String)"user1 should have no emails", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("user1", "124", "A"));
        this.getMockEmailService().resetReminderCounts();
        this.immediateEmailReminderQueue.sendReminder(actionItem, null);
        Assert.assertEquals((String)"user1 should have 1 email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("user1", "124", "A"));
        this.getMockEmailService().resetReminderCounts();
        actionItem = ActionItem.Builder.create((String)"124", (String)"K", (String)"123", (DateTime)new DateTime(), (String)"Test", (String)"http://www.test.com", (String)"Test", (String)"125", (String)"user1").build();
        this.immediateEmailReminderQueue.sendReminder(actionItem, Boolean.TRUE);
        Assert.assertEquals((String)"user1 should have 1 emails", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("user1", "124", "K"));
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }
}

