/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notification;

import mocks.MockEmailNotificationService;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesContract;
import org.kuali.rice.kew.api.preferences.PreferencesService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class NotificationServiceTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("NotificationConfig.xml");
    }

    @Test
    public void testNoDuplicateEmails() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"NotificationTest");
        document.route("");
        Assert.assertEquals((String)"rkirkend should only have one email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"ewestfal should only have one email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jhopf should only have one email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("jhopf", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"bmcgough should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("bmcgough", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jitrue should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("jitrue", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"user1 should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("user1", document.getDocumentId(), "A"));
    }

    @Test
    public void testEmailPreferences() throws Exception {
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String jitruePrincipalId = this.getPrincipalIdForName("jitrue");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String jhopfPrincipalId = this.getPrincipalIdForName("jhopf");
        String bmcgoughPrincipalId = this.getPrincipalIdForName("bmcgough");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        this.assertDefaultNotificationPreferences(ewestfalPrincipalId);
        this.assertDefaultNotificationPreferences(jitruePrincipalId);
        this.assertDefaultNotificationPreferences(rkirkendPrincipalId);
        this.assertDefaultNotificationPreferences(jhopfPrincipalId);
        this.assertDefaultNotificationPreferences(bmcgoughPrincipalId);
        Preferences prefs = this.getPreferencesService().getPreferences(ewestfalPrincipalId);
        Preferences.Builder preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setNotifySecondaryDelegation("yes");
        preferencesBuilder.setEmailNotification("no");
        this.getPreferencesService().savePreferences(ewestfalPrincipalId, preferencesBuilder.build());
        prefs = this.getPreferencesService().getPreferences(jitruePrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setNotifySecondaryDelegation("yes");
        this.getPreferencesService().savePreferences(jitruePrincipalId, preferencesBuilder.build());
        prefs = this.getPreferencesService().getPreferences(rkirkendPrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setNotifyPrimaryDelegation("no");
        this.getPreferencesService().savePreferences(rkirkendPrincipalId, preferencesBuilder.build());
        prefs = this.getPreferencesService().getPreferences(bmcgoughPrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setEmailNotification("daily");
        this.getPreferencesService().savePreferences(bmcgoughPrincipalId, preferencesBuilder.build());
        prefs = this.getPreferencesService().getPreferences(jhopfPrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setEmailNotification("no");
        this.getPreferencesService().savePreferences(jhopfPrincipalId, preferencesBuilder.build());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"NotificationTest");
        document.route("");
        Assert.assertEquals((String)"ewestfal should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jitrue should have one email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("jitrue", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"rkirkend should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jhopf should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("jhopf", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"bmcgough should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("bmcgough", document.getDocumentId(), "A"));
    }

    @Test
    public void testIndDocTypeEmailPreferences() throws Exception {
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String jitruePrincipalId = this.getPrincipalIdForName("jitrue");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        String jhopfPrincipalId = this.getPrincipalIdForName("jhopf");
        String bmcgoughPrincipalId = this.getPrincipalIdForName("bmcgough");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        Preferences prefs = this.getPreferencesService().getPreferences(ewestfalPrincipalId);
        Preferences.Builder preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        prefs = this.getPreferencesService().getPreferences(ewestfalPrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setEmailNotification("weekly");
        preferencesBuilder.setDocumentTypeNotificationPreference("NotificationTest", "immediate");
        this.getPreferencesService().savePreferences(ewestfalPrincipalId, preferencesBuilder.build());
        prefs = this.getPreferencesService().getPreferences(jhopfPrincipalId);
        preferencesBuilder = Preferences.Builder.create((PreferencesContract)prefs);
        preferencesBuilder.setEmailNotification("no");
        preferencesBuilder.setDocumentTypeNotificationPreference("NotificationTest", "daily");
        this.getPreferencesService().savePreferences(jhopfPrincipalId, preferencesBuilder.build());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"NotificationTest");
        document.route("");
        Assert.assertEquals((String)"ewestfal should have one emails.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"rkirkend should only have one email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jhopf should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("jhopf", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"jitrue should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("jitrue", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"bmcgough should have no emails.", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("bmcgough", document.getDocumentId(), "A"));
    }

    @Test
    public void testDocumentTypeNotificationFromAddress() throws Exception {
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("NotificationTest");
        Assert.assertNull((String)"Wrong notification from address, should be null.", (Object)documentType.getNotificationFromAddress());
        Assert.assertNull((String)"Wrong actual notification from address, should be null.", (Object)documentType.getActualNotificationFromAddress());
        documentType = KEWServiceLocator.getDocumentTypeService().findByName("NotificationFromAddressParent");
        Assert.assertEquals((String)"Wrong notification from address.", (Object)"fakey@mcfakey.com", (Object)documentType.getNotificationFromAddress());
        documentType = KEWServiceLocator.getDocumentTypeService().findByName("NotificationFromAddressChild");
        Assert.assertEquals((String)"Wrong notification from address.", (Object)"fakey@mcchild.com", (Object)documentType.getNotificationFromAddress());
        documentType = KEWServiceLocator.getDocumentTypeService().findByName("NotificationFromAddressChildInherited");
        Assert.assertEquals((String)"Wrong notification from address.", (Object)"fakey@mcfakey.com", (Object)documentType.getNotificationFromAddress());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)user1PrincipalId, (String)"NotificationFromAddressChild");
        document.adHocToPrincipal(ActionRequestType.APPROVE, "Initial", "", this.getPrincipalIdForName("ewestfal"), "", true);
        document.route("");
        Assert.assertEquals((String)"ewestfal should have an email.", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A"));
    }

    private void assertDefaultNotificationPreferences(String principalId) throws Exception {
        Preferences prefs = this.getPreferencesService().getPreferences(principalId);
        Assert.assertEquals((Object)"immediate", (Object)prefs.getEmailNotification());
        Assert.assertEquals((Object)"yes", (Object)prefs.getNotifyPrimaryDelegation());
        Assert.assertEquals((Object)"no", (Object)prefs.getNotifySecondaryDelegation());
    }

    private PreferencesService getPreferencesService() {
        return KewApiServiceLocator.getPreferencesService();
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }
}

