/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.role.XPathQualifierResolver;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.routeheader.StandardDocumentContent;
import org.kuali.rice.test.BaseRiceTestCase;

public class XPathQualifierResolverTest
extends BaseRiceTestCase {
    private static final String SIMPLE_CONFIG_1 = "<resolverConfig><baseXPathExpression>/xmlData/accountNumbers</baseXPathExpression><attributes name=\"accountNumber\"><xPathExpression>./accountNumber</xPathExpression></attributes></resolverConfig>";
    private static final String SIMPLE_DOC_XML_1 = "<xmlData><accountNumbers><accountNumber>12345</accountNumber><accountNumber>54321</accountNumber><accountNumber>102030</accountNumber><accountNumber>302010</accountNumber></accountNumbers></xmlData>";
    private static final String SIMPLE_CONFIG_2 = "<resolverConfig><attributes name=\"accountNumber\"><xPathExpression>//accountNumber</xPathExpression></attributes></resolverConfig>";
    private static final String COMPOUND_CONFIG_1 = "<resolverConfig><baseXPathExpression>/xmlData/chartOrg</baseXPathExpression><attributes name=\"chart\"><xPathExpression>./chart</xPathExpression></attributes><attributes name=\"org\"><xPathExpression>./org</xPathExpression></attributes></resolverConfig>";
    private static final String COMPOUND_CONFIG_2 = "<resolverConfig><attributes name=\"chart\"><xPathExpression>//chart</xPathExpression></attributes><attributes name=\"org\"><xPathExpression>//org</xPathExpression></attributes></resolverConfig>";
    private static final String COMPOUND_DOC_XML_1 = "<xmlData><chartOrg><chart>BL</chart><org>BUS</org></chartOrg><chartOrg><chart>IN</chart><org>MED</org></chartOrg></xmlData>";
    private static final String COMPOUND_DOC_XML_2 = "<xmlData><chartOrg><chart>BL</chart><org>BUS</org><chart>IN</chart><org>MED</org></chartOrg></xmlData>";
    private static final String COMPOUND_DOC_XML_3 = "<xmlData><chartOrg><chart>BL</chart><org>BUS</org></chartOrg></xmlData>";

    @Test
    public void testResolve_simpleMap() throws Exception {
        HashSet<String> configStrings = new HashSet<String>();
        configStrings.add(SIMPLE_CONFIG_1);
        configStrings.add(StringUtils.replace((String)SIMPLE_CONFIG_1, (String)"attributes", (String)"qualifier"));
        for (String currentTestConfig : configStrings) {
            XPathQualifierResolver resolver = new XPathQualifierResolver();
            ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
            extensionDefinition.setConfiguration(Collections.singletonMap("xmlConfigData", currentTestConfig));
            resolver.setExtensionDefinition(extensionDefinition.build());
            RouteContext context = new RouteContext();
            StandardDocumentContent docContent = new StandardDocumentContent(SIMPLE_DOC_XML_1);
            context.setDocumentContent((DocumentContent)docContent);
            List maps = resolver.resolve(context);
            this.verifyAccountmaps(maps);
        }
    }

    @Test
    public void testResolve_simpleMap_noBaseXPath() throws Exception {
        HashSet<String> configStrings = new HashSet<String>();
        configStrings.add(SIMPLE_CONFIG_2);
        configStrings.add(StringUtils.replace((String)SIMPLE_CONFIG_2, (String)"attributes", (String)"qualifier"));
        for (String currentTestConfig : configStrings) {
            XPathQualifierResolver resolver = new XPathQualifierResolver();
            ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
            extensionDefinition.setConfiguration(Collections.singletonMap("xmlConfigData", currentTestConfig));
            resolver.setExtensionDefinition(extensionDefinition.build());
            RouteContext context = new RouteContext();
            StandardDocumentContent docContent = new StandardDocumentContent(SIMPLE_DOC_XML_1);
            context.setDocumentContent((DocumentContent)docContent);
            List maps = resolver.resolve(context);
            this.verifyAccountmaps(maps);
        }
    }

    private void verifyAccountmaps(List<Map<String, String>> maps) {
        Assert.assertEquals((String)"Incorrect number of attribute sets.", (long)4L, (long)maps.size());
        String acctNumKey = "accountNumber";
        Map<String, String> map1 = maps.get(0);
        Assert.assertEquals((long)1L, (long)map1.size());
        Assert.assertEquals((Object)"12345", (Object)map1.get(acctNumKey));
        Map<String, String> map2 = maps.get(1);
        Assert.assertEquals((long)1L, (long)map2.size());
        Assert.assertEquals((Object)"54321", (Object)map2.get(acctNumKey));
        Map<String, String> map3 = maps.get(2);
        Assert.assertEquals((long)1L, (long)map3.size());
        Assert.assertEquals((Object)"102030", (Object)map3.get(acctNumKey));
        Map<String, String> map4 = maps.get(3);
        Assert.assertEquals((long)1L, (long)map4.size());
        Assert.assertEquals((Object)"302010", (Object)map4.get(acctNumKey));
    }

    @Test
    public void testResolve_compoundMap1() throws Exception {
        HashSet<String> configStrings = new HashSet<String>();
        configStrings.add(COMPOUND_CONFIG_1);
        configStrings.add(StringUtils.replace((String)COMPOUND_CONFIG_1, (String)"attributes", (String)"qualifier"));
        for (String currentTestConfig : configStrings) {
            XPathQualifierResolver resolver = new XPathQualifierResolver();
            ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
            extensionDefinition.setConfiguration(Collections.singletonMap("xmlConfigData", currentTestConfig));
            resolver.setExtensionDefinition(extensionDefinition.build());
            RouteContext context = new RouteContext();
            StandardDocumentContent docContent = new StandardDocumentContent(COMPOUND_DOC_XML_1);
            context.setDocumentContent((DocumentContent)docContent);
            List maps = resolver.resolve(context);
            Assert.assertEquals((String)"Incorrect number of attribute sets", (long)2L, (long)maps.size());
            String chartKey = "chart";
            String orgKey = "org";
            Map map1 = (Map)maps.get(0);
            Assert.assertEquals((long)2L, (long)map1.size());
            Assert.assertEquals((Object)"BL", map1.get(chartKey));
            Assert.assertEquals((Object)"BUS", map1.get(orgKey));
            Map map2 = (Map)maps.get(1);
            Assert.assertEquals((long)2L, (long)map2.size());
            Assert.assertEquals((Object)"IN", map2.get(chartKey));
            Assert.assertEquals((Object)"MED", map2.get(orgKey));
        }
    }

    @Test
    public void testResolve_compoundMap() throws Exception {
        HashSet<String> configStrings = new HashSet<String>();
        configStrings.add(COMPOUND_CONFIG_1);
        configStrings.add(StringUtils.replace((String)COMPOUND_CONFIG_1, (String)"attributes", (String)"qualifier"));
        for (String currentTestConfig : configStrings) {
            XPathQualifierResolver resolver = new XPathQualifierResolver();
            ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
            extensionDefinition.setConfiguration(Collections.singletonMap("xmlConfigData", currentTestConfig));
            resolver.setExtensionDefinition(extensionDefinition.build());
            RouteContext context = new RouteContext();
            StandardDocumentContent docContent = new StandardDocumentContent(COMPOUND_DOC_XML_2);
            context.setDocumentContent((DocumentContent)docContent);
            try {
                resolver.resolve(context);
                Assert.fail((String)"Invalid XML was encountered, resolver should have thrown an exception");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            context = new RouteContext();
            docContent = new StandardDocumentContent(COMPOUND_DOC_XML_3);
            context.setDocumentContent((DocumentContent)docContent);
            List maps = resolver.resolve(context);
            Assert.assertEquals((long)1L, (long)maps.size());
            Assert.assertEquals((Object)"BL", ((Map)maps.get(0)).get("chart"));
            Assert.assertEquals((Object)"BUS", ((Map)maps.get(0)).get("org"));
        }
    }

    @Test
    public void testResolve_compoundMap_noBaseXPath() throws Exception {
        HashSet<String> configStrings = new HashSet<String>();
        configStrings.add(COMPOUND_CONFIG_2);
        configStrings.add(StringUtils.replace((String)COMPOUND_CONFIG_2, (String)"attributes", (String)"qualifier"));
        for (String currentTestConfig : configStrings) {
            XPathQualifierResolver resolver = new XPathQualifierResolver();
            ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
            extensionDefinition.setConfiguration(Collections.singletonMap("xmlConfigData", currentTestConfig));
            resolver.setExtensionDefinition(extensionDefinition.build());
            RouteContext context = new RouteContext();
            StandardDocumentContent docContent = new StandardDocumentContent(COMPOUND_DOC_XML_2);
            context.setDocumentContent((DocumentContent)docContent);
            try {
                resolver.resolve(context);
                Assert.fail((String)"Invalid XML was encountered, resolver should have thrown an exception");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            context = new RouteContext();
            docContent = new StandardDocumentContent(COMPOUND_DOC_XML_3);
            context.setDocumentContent((DocumentContent)docContent);
            List maps = resolver.resolve(context);
            Assert.assertEquals((long)1L, (long)maps.size());
            Assert.assertEquals((Object)"BL", ((Map)maps.get(0)).get("chart"));
            Assert.assertEquals((Object)"BUS", ((Map)maps.get(0)).get("org"));
        }
    }
}

