/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.role.service.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.role.service.impl.ActionRequestDerivedRoleTypeServiceImpl;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class ActionRequestDerivedRoleTypeServiceImplTest
extends KEWTestCase {
    private static final String APPROVE_REQUEST_RECIPIENT_ROLE_NAME = "Approve Request Recipient";
    private static final String NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME = "Non-Ad Hoc Approve Request Recipient";
    private static final String ACKNOWLEDGE_REQUEST_RECIPIENT_ROLE_NAME = "Acknowledge Request Recipient";
    private static final String FYI_REQUEST_RECIPIENT_ROLE_NAME = "FYI Request Recipient";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionRequestDerivedRoleTypeServiceImplTest.xml");
    }

    @Test
    public void testHasApplicationRole() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"ActionRequestDerivedRoleTypeServiceImplTest");
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", this.getPrincipalIdForName("rkirkend"), "", true);
        document.route("");
        ActionRequestDerivedRoleTypeServiceImpl roleTypeService = new ActionRequestDerivedRoleTypeServiceImpl();
        Map<String, String> qualifications = Collections.singletonMap("documentNumber", "" + document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have role.", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("rkirkend"), null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        Assert.assertFalse((String)"rkirkend should not have role for non-adhoc (since this was an adhoc request)", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("rkirkend"), null, null, NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        document = TestUtilities.switchByPrincipalName("bmcgough", document);
        document.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "", this.getPrincipalIdForName("bmcgough"), "", true);
        Assert.assertTrue((String)"bmcgough should have ack", (boolean)document.isAcknowledgeRequested());
        Assert.assertFalse((String)"bmcgough should not have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("bmcgough"), null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        Assert.assertTrue((String)"bmcgough should have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("bmcgough"), null, null, ACKNOWLEDGE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        Assert.assertFalse((String)"bmcgough should not have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("bmcgough"), null, null, FYI_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        document = TestUtilities.switchByPrincipalName("rkirkend", document);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        document = TestUtilities.switchByPrincipalName("jhopf", document);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"jhopf should have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("jhopf"), null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        Assert.assertTrue((String)"jhopf should have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("jhopf"), null, null, NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        document.adHocToPrincipal(ActionRequestType.FYI, "", this.getPrincipalIdForName("pmckown"), "", true);
        document = TestUtilities.switchByPrincipalName("pmckown", document);
        Assert.assertTrue((boolean)document.isFYIRequested());
        Assert.assertTrue((String)"pmckown should have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("pmckown"), null, null, FYI_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"ActionRequestDerivedRoleTypeServiceImplTest");
        document.saveDocument("");
        Assert.assertTrue((boolean)document.isSaved());
        Assert.assertTrue((boolean)document.isCompletionRequested());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertFalse((String)"ewestfal should not have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("ewestfal"), null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        Assert.assertFalse((String)"ewestfal should not have role", (boolean)roleTypeService.hasDerivedRole(this.getPrincipalIdForName("ewestfal"), null, null, NON_AD_HOC_APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
    }

    @Test
    public void testDynamicRoleCacheability() {
        RoleService roleService = KimApiServiceLocator.getRoleService();
        Role r = roleService.getRoleByNamespaceCodeAndName("KR-WKFLW", APPROVE_REQUEST_RECIPIENT_ROLE_NAME);
        Assert.assertTrue((boolean)roleService.isDynamicRoleMembership(r.getId()));
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"ActionRequestDerivedRoleTypeServiceImplTest");
        String rkirkend = this.getPrincipalIdForName("rkirkend");
        document.adHocToPrincipal(ActionRequestType.APPROVE, "ad-hoc-ing will result in request to member of derive role", rkirkend, "approve this ad-hoc'd doc responsibility", true);
        document.route("");
        ActionRequestDerivedRoleTypeServiceImpl roleTypeService = new ActionRequestDerivedRoleTypeServiceImpl();
        Map<String, String> qualifications = Collections.singletonMap("documentNumber", document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have role.", (boolean)roleTypeService.hasDerivedRole(rkirkend, null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        boolean firstResult = roleService.principalHasRole(rkirkend, Arrays.asList(r.getId()), qualifications);
        Assert.assertTrue((boolean)firstResult);
        document = WorkflowDocumentFactory.loadDocument((String)rkirkend, (String)document.getDocumentId());
        document.approve("approved ad-hoc request. rkirkend is no longer a derived approver!");
        Assert.assertFalse((String)"rkirkend should have NO LONGER have derived approver role.", (boolean)roleTypeService.hasDerivedRole(rkirkend, null, null, APPROVE_REQUEST_RECIPIENT_ROLE_NAME, qualifications));
        boolean afterApprove = roleService.principalHasRole(rkirkend, Arrays.asList(r.getId()), qualifications);
        Assert.assertFalse((boolean)afterApprove);
    }
}

