/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routemodule;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routemodule.TestDelegation;
import org.kuali.rice.kew.routemodule.TestDocContent;
import org.kuali.rice.kew.routemodule.TestRecipient;
import org.kuali.rice.kew.routemodule.TestResponsibility;
import org.kuali.rice.kew.routemodule.TestRouteLevel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TestRouteModuleXMLHelper {
    public static String toXML(TestDocContent docContent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<docContent>");
        for (TestRouteLevel routeLevel : docContent.getRouteLevels()) {
            buffer.append("<routeLevel priority=\"").append(routeLevel.getPriority()).append("\">");
            for (TestResponsibility responsibility : routeLevel.getResponsibilities()) {
                buffer.append("<responsibility actionRequested=\"").append(responsibility.getActionRequested()).append("\" priority=\"").append(responsibility.getPriority()).append("\">");
                TestRecipient recipient = responsibility.getRecipient();
                buffer.append("<recipient type=\"").append(recipient.getType()).append("\" id=\"").append(recipient.getId()).append("\"/>");
                if (!responsibility.getDelegations().isEmpty()) {
                    buffer.append("<delegations>");
                }
                for (TestDelegation delegation : responsibility.getDelegations()) {
                    buffer.append("<delegation type=\"").append(delegation.getType().getCode()).append("\">");
                    TestResponsibility delResp = delegation.getResponsibility();
                    buffer.append("<delegateResponsibility>");
                    TestRecipient delRecipient = delResp.getRecipient();
                    buffer.append("<recipient type=\"").append(delRecipient.getType()).append("\" id=\"").append(delRecipient.getId()).append("\"/>");
                    buffer.append("</delegateResponsibility>");
                    buffer.append("</delegation>");
                }
                if (!responsibility.getDelegations().isEmpty()) {
                    buffer.append("</delegations>");
                }
                buffer.append("</responsibility>");
            }
            buffer.append("</routeLevel>");
        }
        buffer.append("</docContent>");
        return buffer.toString();
    }

    public static TestRouteLevel parseCurrentRouteLevel(DocumentRouteHeaderValue routeHeader) throws ResourceUnavailableException, WorkflowException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new BufferedInputStream(new ByteArrayInputStream(routeHeader.getDocContent().getBytes())));
            NodeList nodes = document.getElementsByTagName("routeLevel");
            Node routeLevelNode = null;
            Integer priority = null;
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node node = nodes.item(index);
                NamedNodeMap nodeMap = node.getAttributes();
                Node priorityNode = nodeMap.getNamedItem("priority");
                try {
                    priority = Integer.valueOf(priorityNode.getNodeValue());
                }
                catch (NumberFormatException e) {
                    throw new WorkflowException("Invalid route level priority '" + priorityNode.getNodeValue() + "'", (Throwable)e);
                }
                if (priorityNode == null || !routeHeader.getDocRouteLevel().equals(priority)) continue;
                routeLevelNode = node;
                break;
            }
            if (routeLevelNode == null) {
                return null;
            }
            TestRouteLevel routeLevel = new TestRouteLevel();
            routeLevel.setPriority(priority);
            ArrayList<Node> responsibilityNodes = new ArrayList<Node>();
            NodeList rlNodes = routeLevelNode.getChildNodes();
            for (int index = 0; index < rlNodes.getLength(); ++index) {
                Node node = rlNodes.item(index);
                if (!node.getNodeName().equals("responsibility")) continue;
                responsibilityNodes.add(node);
            }
            routeLevel.setResponsibilities(TestRouteModuleXMLHelper.parseResponsibilities(responsibilityNodes));
            return routeLevel;
        }
        catch (ParserConfigurationException e) {
            throw new ResourceUnavailableException("Could not configure DOM parser for route level " + routeHeader.getDocRouteLevel(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceUnavailableException("Could not parse XML doc content for route level " + routeHeader.getDocRouteLevel(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new ResourceUnavailableException("Could not parse XML doc content for route level " + routeHeader.getDocRouteLevel(), (Throwable)e);
        }
    }

    private static List parseResponsibilities(List responsibilityNodes) throws WorkflowException {
        ArrayList<TestResponsibility> responsibilities = new ArrayList<TestResponsibility>();
        for (Node node : responsibilityNodes) {
            responsibilities.add(TestRouteModuleXMLHelper.parseResponsibility(node));
        }
        return responsibilities;
    }

    private static TestResponsibility parseResponsibility(Node responsibilityNode) throws WorkflowException {
        TestResponsibility responsibility = new TestResponsibility();
        NamedNodeMap attributes = responsibilityNode.getAttributes();
        Node actionRequestedNode = attributes.getNamedItem("actionRequested");
        Node priorityNode = attributes.getNamedItem("priority");
        responsibility.setActionRequested(actionRequestedNode.getNodeValue());
        try {
            responsibility.setPriority(Integer.parseInt(priorityNode.getNodeValue()));
        }
        catch (NumberFormatException e) {
            throw new WorkflowException("Invalid responsibility priority '" + priorityNode.getNodeValue() + "'", (Throwable)e);
        }
        NodeList childNodes = responsibilityNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeName().equals("recipient")) {
                responsibility.setRecipient(TestRouteModuleXMLHelper.parseRecipient(node));
                continue;
            }
            if (!node.getNodeName().equals("delegations")) continue;
            responsibility.setDelegations(TestRouteModuleXMLHelper.parseDelegations(node));
        }
        return responsibility;
    }

    private static TestRecipient parseRecipient(Node recipientNode) {
        TestRecipient recipient = new TestRecipient();
        NamedNodeMap attributes = recipientNode.getAttributes();
        recipient.setType(attributes.getNamedItem("type").getNodeValue());
        recipient.setId(attributes.getNamedItem("id").getNodeValue());
        return recipient;
    }

    private static List parseDelegations(Node delegationsNode) {
        ArrayList<TestDelegation> delegations = new ArrayList<TestDelegation>();
        NodeList childNodes = delegationsNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (!node.getNodeName().equals("delegation")) continue;
            delegations.add(TestRouteModuleXMLHelper.parseDelegation(node));
        }
        return delegations;
    }

    private static TestDelegation parseDelegation(Node delegationNode) {
        TestDelegation delegation = new TestDelegation();
        NamedNodeMap attributes = delegationNode.getAttributes();
        delegation.setType(DelegationType.fromCode((String)attributes.getNamedItem("type").getNodeValue()));
        NodeList childNodes = delegationNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (!node.getNodeName().equals("delegateResponsibility")) continue;
            delegation.setResponsibility(TestRouteModuleXMLHelper.parseDelegateResponsibility(node));
        }
        return delegation;
    }

    private static TestResponsibility parseDelegateResponsibility(Node delegateResponsibilityNode) {
        TestResponsibility responsibility = new TestResponsibility();
        NodeList childNodes = delegateResponsibilityNode.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (!node.getNodeName().equals("recipient")) continue;
            responsibility.setRecipient(TestRouteModuleXMLHelper.parseRecipient(node));
        }
        return responsibility;
    }
}

