/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.identity.PrincipalName;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.rule.UnqualifiedRoleAttribute;
import org.kuali.rice.kew.workgroup.GroupNameId;

public class MockRole
extends UnqualifiedRoleAttribute {
    private static final RoleName ROLE = new RoleName(MockRole.class.getName(), "List of authentication ids", "List of authentication ids");
    private static final List<RoleName> ROLES;

    public MockRole() {
        super(ROLES);
    }

    protected boolean isValidRoleName(String roleName) {
        return true;
    }

    protected ResolvedQualifiedRole resolveRole(RouteContext routeContext, String roleName) {
        String[] ids = roleName.split("[,\\s+]");
        ResolvedQualifiedRole rqr = new ResolvedQualifiedRole();
        for (String id : ids) {
            PrincipalName recipientId;
            String type = "user";
            String[] components = id.split(":", 2);
            if (components.length > 1 && !StringUtils.isEmpty((String)components[0])) {
                type = components[0].trim();
            }
            if ("user".equals(type)) {
                recipientId = new PrincipalName(id);
            } else if ("group".equals(type)) {
                recipientId = new GroupNameId(id);
            } else {
                throw new RuntimeException("Unknown role recipient type: '" + type + "'. Must be 'user' or 'group'.");
            }
            rqr.getRecipients().add(recipientId);
        }
        rqr.setQualifiedRoleLabel("Recipients from parsing mock role: " + roleName);
        rqr.setAnnotation("Recipients from parsing mock role: " + roleName);
        return rqr;
    }

    static {
        ArrayList<RoleName> roles = new ArrayList<RoleName>(1);
        roles.add(ROLE);
        ROLES = Collections.unmodifiableList(roles);
    }
}

