/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.kew.api.identity.Id;
import org.kuali.rice.kew.api.identity.PrincipalId;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;
import org.kuali.rice.kew.rule.RoleAttribute;
import org.kuali.rice.kew.rule.WorkflowAttributeXmlValidator;
import org.kuali.rice.kew.rule.WorkflowRuleAttribute;

public class TestRuleAttribute
implements WorkflowRuleAttribute,
RoleAttribute,
WorkflowAttributeXmlValidator {
    private static final long serialVersionUID = -220808609566348066L;
    public static boolean VALID_CLIENT_ROUTING_DATA_CALLED = false;
    private static Map<String, Map<String, List<String>>> roles = new HashMap<String, Map<String, List<String>>>();
    private boolean required;

    public boolean isMatch(DocumentContent documentContent, List ruleExtensions) {
        return true;
    }

    public List getRoleNames() {
        ArrayList<RoleName> roleNames = new ArrayList<RoleName>();
        for (String roleName : roles.keySet()) {
            roleNames.add(new RoleName(this.getClass().getName(), roleName, roleName));
        }
        return roleNames;
    }

    public List getRuleRows() {
        return new ArrayList();
    }

    public List getRoutingDataRows() {
        return new ArrayList();
    }

    public String getDocContent() {
        return "<testRuleAttributeContent/>";
    }

    public List getRuleExtensionValues() {
        return new ArrayList();
    }

    public List validateRoutingData(Map paramMap) {
        return new ArrayList();
    }

    public String getAttributeLabel() {
        return "";
    }

    public List<RemotableAttributeError> validateRuleData(Map paramMap) {
        return new ArrayList<RemotableAttributeError>();
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<String> getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        ArrayList<String> qualifiedRoleNames = new ArrayList<String>();
        Map<String, List<String>> qualifiedRoles = roles.get(roleName);
        if (qualifiedRoles == null) {
            throw new IllegalArgumentException("TestRuleAttribute does not support the given role " + roleName);
        }
        qualifiedRoleNames.addAll(qualifiedRoles.keySet());
        return qualifiedRoleNames;
    }

    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRole) {
        List<String> recipients;
        ResolvedQualifiedRole resolved = new ResolvedQualifiedRole();
        Map<String, List<String>> qualifiedRoles = roles.get(roleName);
        if (qualifiedRoles != null) {
            recipients = qualifiedRoles.get(qualifiedRole);
            if (recipients == null) {
                throw new IllegalArgumentException("TestRuleAttribute does not support the qualified role " + qualifiedRole);
            }
        } else {
            throw new IllegalArgumentException("TestRuleAttribute does not support the given role " + roleName);
        }
        resolved.setQualifiedRoleLabel(qualifiedRole);
        resolved.setRecipients(TestRuleAttribute.convertPrincipalIdList(recipients));
        return resolved;
    }

    private static List<Id> convertPrincipalIdList(List<String> principalIds) {
        ArrayList<Id> idList = new ArrayList<Id>();
        for (String principalId : principalIds) {
            idList.add((Id)new PrincipalId(principalId));
        }
        return idList;
    }

    public static void addRole(String roleName) {
        roles.put(roleName, new HashMap());
    }

    public static void removeRole(String roleName) {
        roles.remove(roleName);
    }

    public static Map<String, List<String>> getRole(String roleName) {
        return roles.get(roleName);
    }

    public static void addQualifiedRole(String roleName, String qualifiedRoleName) {
        TestRuleAttribute.getRole(roleName).put(qualifiedRoleName, new ArrayList());
    }

    public static void removeQualifiedRole(String roleName, String qualifiedRoleName) {
        TestRuleAttribute.getRole(roleName).remove(qualifiedRoleName);
    }

    public static void setRecipientPrincipalIds(String roleName, String qualifiedRoleName, List<String> principalIds) {
        Map<String, List<String>> qualifiedRoles = TestRuleAttribute.getRole(roleName);
        if (qualifiedRoles == null) {
            TestRuleAttribute.addRole(roleName);
        }
        if (qualifiedRoles == null) {
            TestRuleAttribute.addRole(roleName);
            TestRuleAttribute.addQualifiedRole(roleName, qualifiedRoleName);
            qualifiedRoles = TestRuleAttribute.getRole(roleName);
        }
        qualifiedRoles.put(qualifiedRoleName, principalIds);
    }

    public static List<String> getRecipientPrincipalIds(String roleName, String qualifiedRoleName) {
        Map<String, List<String>> qualifiedRoles = TestRuleAttribute.getRole(roleName);
        return qualifiedRoles.get(qualifiedRoleName);
    }

    public List<RemotableAttributeError> validateClientRoutingData() {
        return new ArrayList<RemotableAttributeError>();
    }
}

