/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kew.test.KEWTestCase;
import org.xml.sax.InputSource;

public class UniversityIdRoleAttributeTest
extends KEWTestCase {
    private static final String UNIVERSITY_ID_PROP = "universityId";

    @Test
    public void testUniversityIdAttribute() throws Exception {
        this.loadXmlFile("UniversityIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)"2001", (String)"UniversityIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder universityIdDef1 = WorkflowAttributeDefinition.Builder.create((String)"UniversityIdRoleAttribute");
        PropertyDefinition universityIdProp1 = PropertyDefinition.create((String)UNIVERSITY_ID_PROP, (String)"2002");
        universityIdDef1.addPropertyDefinition(universityIdProp1);
        WorkflowAttributeDefinition.Builder universityIdDef2 = WorkflowAttributeDefinition.Builder.create((String)"UniversityIdRoleAttribute");
        PropertyDefinition universityIdProp2 = PropertyDefinition.create((String)UNIVERSITY_ID_PROP, (String)"2004");
        universityIdDef2.addPropertyDefinition(universityIdProp2);
        document.addAttributeDefinition(universityIdDef1.build());
        document.addAttributeDefinition(universityIdDef2.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)"2002", (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)"2004", (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i approve");
        document = WorkflowDocumentFactory.loadDocument((String)"2002", (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        document.approve("i also approve");
        Assert.assertTrue((String)"Document should be FINAL", (boolean)document.isFinal());
    }

    @Test
    public void testParameterizedUniversityIdAttribute() throws Exception {
        this.loadXmlFile("ParameterizedUniversityIdRoleAttributeTestConfig.xml");
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"UniversityIdRoleAttributeTest");
        WorkflowAttributeDefinition.Builder univIdDef1 = WorkflowAttributeDefinition.Builder.create((String)"UniversityIdRoleAttribute");
        PropertyDefinition univIdProp1 = PropertyDefinition.create((String)UNIVERSITY_ID_PROP, (String)"2002");
        univIdDef1.addPropertyDefinition(univIdProp1);
        document.addAttributeDefinition(univIdDef1.build());
        document.route("Routing!");
        document = WorkflowDocumentFactory.loadDocument((String)"2002", (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be ENROUTE", (boolean)document.isEnroute());
        Assert.assertTrue((String)"rkirkend should have an approve request.", (boolean)document.isApprovalRequested());
        XPath xPath = XPathHelper.newXPath();
        Assert.assertTrue((String)"Should have found the ID.", (boolean)((Boolean)xPath.evaluate("//UniversityIdRoleAttribute/thisIdRocks", new InputSource(new StringReader(document.getDocumentContent().getFullContent())), XPathConstants.BOOLEAN)));
    }
}

