/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public final class TestUtilities {
    private static final Logger LOG = LogManager.getLogger(TestUtilities.class);
    private static final String TEST_TABLE_NAME = "EN_UNITTEST_T";
    private static Thread exceptionThreader;
    private static final String DEFAULT_TEST_PLATFORM = "oracle";
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String TEST_PLATFORM = "test.platform";

    private TestUtilities() {
        throw new UnsupportedOperationException("do not call");
    }

    public static InputStream loadResource(Class packageClass, String resourceName) {
        return packageClass.getResourceAsStream(resourceName);
    }

    public static TransactionTemplate getTransactionTemplate() {
        return (TransactionTemplate)GlobalResourceLoader.getService((String)"transactionTemplate");
    }

    public static void verifyTestEnvironment(DataSource dataSource) {
        if (dataSource == null) {
            Assert.fail((String)"Could not locate the data source.");
        }
        JdbcTemplate template = new JdbcTemplate(dataSource);
        template.execute(new ConnectionCallback(){

            public Object doInConnection(Connection connection) throws SQLException {
                ResultSet resultSet = connection.getMetaData().getTables(null, null, TestUtilities.TEST_TABLE_NAME, null);
                if (!resultSet.next()) {
                    LOG.error("No table named 'EN_UNITTEST_T' was found in the configured database.  You are attempting to run tests against a non-test database!!!");
                    LOG.error("The test environment will not start up properly!!!");
                    Assert.fail((String)"No table named 'EN_UNITTEST_T' was found in the configured database.  You are attempting to run tests against a non-test database!!!");
                }
                return null;
            }
        });
    }

    public static void clearTables(PlatformTransactionManager transactionManager, final DataSource dataSource, final String edenSchemaName, final List<String> dontClear) {
        LOG.info("Clearing tables for schema " + edenSchemaName);
        if (dataSource == null) {
            Assert.fail((String)"Null data source given");
        }
        if (edenSchemaName == null || edenSchemaName.equals("")) {
            Assert.fail((String)"Empty eden schema name given");
        }
        new TransactionTemplate(transactionManager).execute(new TransactionCallback(){

            public Object doInTransaction(TransactionStatus status) {
                TestUtilities.verifyTestEnvironment(dataSource);
                JdbcTemplate template = new JdbcTemplate(dataSource);
                return template.execute(new StatementCallback(){

                    public Object doInStatement(Statement statement) throws SQLException {
                        ArrayList<String> reEnableConstraints = new ArrayList<String>();
                        ResultSet resultSet = statement.getConnection().getMetaData().getTables(null, edenSchemaName, null, new String[]{"TABLE"});
                        while (resultSet.next()) {
                            String tableName = resultSet.getString("TABLE_NAME");
                            if (!tableName.startsWith("EN_") || dontClear.contains(tableName)) continue;
                            ResultSet keyResultSet = statement.getConnection().getMetaData().getExportedKeys(null, edenSchemaName, tableName);
                            while (keyResultSet.next()) {
                                String fkName = keyResultSet.getString("FK_NAME");
                                String fkTableName = keyResultSet.getString("FKTABLE_NAME");
                                statement.addBatch("ALTER TABLE " + fkTableName + " DISABLE CONSTRAINT " + fkName);
                                reEnableConstraints.add("ALTER TABLE " + fkTableName + " ENABLE CONSTRAINT " + fkName);
                            }
                            keyResultSet.close();
                            statement.addBatch("DELETE FROM " + tableName);
                        }
                        for (String constraint : reEnableConstraints) {
                            statement.addBatch(constraint);
                        }
                        statement.executeBatch();
                        resultSet.close();
                        return null;
                    }
                });
            }
        });
        LOG.info("Tables successfully cleared for schema " + edenSchemaName);
    }

    public static Set<String> createNodeInstanceNameSet(Collection nodeInstances) {
        HashSet<String> nameSet = new HashSet<String>();
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            nameSet.add(nodeInstance.getName());
        }
        return nameSet;
    }

    public static void assertAtNode(String message, WorkflowDocument document, String nodeNameToAssert) {
        Set nodeNames = document.getNodeNames();
        for (String nodeName : nodeNames) {
            if (!nodeNameToAssert.equals(nodeName)) continue;
            return;
        }
        Assert.fail((String)((StringUtils.isEmpty((String)message) ? "" : message + ": ") + "Was [" + StringUtils.join((Collection)nodeNames, (String)", ") + "], Expected " + nodeNameToAssert));
    }

    public static void assertAtNode(WorkflowDocument document, String nodeName) throws WorkflowException {
        TestUtilities.assertAtNode("", document, nodeName);
    }

    public static void assertAtNodeNew(String message, WorkflowDocument document, String nodeName) throws WorkflowException {
        Set nodeNames = document.getNodeNames();
        if (!nodeNames.contains(nodeName)) {
            Assert.fail((String)((StringUtils.isEmpty((String)message) ? "" : message + ": ") + "Was [" + StringUtils.join((Collection)nodeNames, (String)", ") + "], Expected " + nodeName));
        }
    }

    public static void assertAtNodeNew(WorkflowDocument document, String nodeName) throws WorkflowException {
        TestUtilities.assertAtNodeNew("", document, nodeName);
    }

    public static void assertInActionList(String principalId, String documentId) {
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
        Assert.assertNotNull((String)("Given principal id was invalid: " + principalId), (Object)principal);
        Collection actionList = KEWServiceLocator.getActionListService().findByPrincipalId(principalId);
        for (ActionItem actionItem : actionList) {
            if (!actionItem.getDocumentId().equals(documentId)) continue;
            return;
        }
        Assert.fail((String)"Could not locate an action item in the user's action list for the given document id.");
    }

    public static void assertNotInActionList(String principalId, String documentId) {
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(principalId);
        Assert.assertNotNull((String)("Given principal id was invalid: " + principalId), (Object)principal);
        Collection actionList = KEWServiceLocator.getActionListService().findByPrincipalId(principalId);
        for (ActionItem actionItem : actionList) {
            if (!actionItem.getDocumentId().equals(documentId)) continue;
            Assert.fail((String)"Found an action item in the user's acton list for the given document id.");
        }
    }

    public static void assertNumberOfPendingRequests(String documentId, int numberOfPendingRequests) {
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
        Assert.assertEquals((String)("Wrong number of pending requests for document: " + documentId), (long)numberOfPendingRequests, (long)actionRequests.size());
    }

    public static void assertUserHasPendingRequest(String documentId, String principalName) throws WorkflowException {
        String principalId = KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName);
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(documentId);
        boolean foundRequest = false;
        for (ActionRequestValue actionRequest : actionRequests) {
            if (actionRequest.isUserRequest() && actionRequest.getPrincipalId().equals(principalId)) {
                foundRequest = true;
                break;
            }
            if (!actionRequest.isGroupRequest() || !KimApiServiceLocator.getGroupService().isMemberOfGroup(principalId, actionRequest.getGroup().getId())) continue;
            foundRequest = true;
            break;
        }
        Assert.assertTrue((String)("Could not locate pending request for the given user: " + principalId), (boolean)foundRequest);
    }

    public static void assertApprovals(String docId, String[] users, boolean shouldHaveApproval) throws WorkflowException {
        ArrayList<String> failedUsers = new ArrayList<String>();
        IdentityService ims = KimApiServiceLocator.getIdentityService();
        for (String user : users) {
            WorkflowDocument doc = WorkflowDocumentFactory.loadDocument((String)ims.getPrincipalByPrincipalName(user).getPrincipalId(), (String)docId);
            boolean appRqsted = doc.isApprovalRequested();
            if (shouldHaveApproval != appRqsted) {
                failedUsers.add(user);
            }
            LOG.info("User " + user + (appRqsted ? " HAS " : " HAS NO ") + "approval request");
        }
        for (String user : failedUsers) {
            LOG.error("User " + user + (shouldHaveApproval ? " should have " : " should NOT have ") + " approval");
        }
        if (failedUsers.size() > 0) {
            Assert.fail((String)"Outstanding approvals are incorrect");
        }
    }

    public static WorkflowDocument switchByPrincipalName(String principalName, WorkflowDocument document) throws WorkflowException {
        return TestUtilities.switchPrincipalId(KEWServiceLocator.getIdentityHelperService().getIdForPrincipalName(principalName), document);
    }

    public static WorkflowDocument switchPrincipalId(String principalId, WorkflowDocument document) throws WorkflowException {
        return WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
    }

    public static void logActionRequests(String docId) {
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(docId);
        LOG.info("Current action requests:");
        for (ActionRequestValue ar : actionRequests) {
            LOG.info((Object)ar);
        }
    }

    public static JdbcTemplate getJdbcTemplate() {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(KEWServiceLocator.getDataSource());
        jdbcTemplate.afterPropertiesSet();
        return jdbcTemplate;
    }

    public static void waitForExceptionRouting() {
        TestUtilities.waitForExceptionRouting(300000L);
    }

    public static void waitForExceptionRouting(long milliseconds) {
        if (TestUtilities.getExceptionThreader() == null) {
            return;
        }
        try {
            TestUtilities.getExceptionThreader().join(milliseconds);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"This thread was interuppted while waiting for exception routing.");
        }
        if (TestUtilities.getExceptionThreader().isAlive()) {
            Assert.fail((String)("Document was not put into exception routing within the specified amount of time " + milliseconds));
        }
    }

    public static Thread getExceptionThreader() {
        return exceptionThreader;
    }

    public static void setExceptionThreader(Thread exceptionThreader) {
        TestUtilities.exceptionThreader = exceptionThreader;
    }

    public static String getTestPlatform() throws IOException {
        Properties properties;
        Properties properties2;
        File userBuildProperties = new File(SystemUtils.USER_HOME + "/" + BUILD_PROPERTIES);
        if (userBuildProperties.isFile() && (properties2 = TestUtilities.loadProperties(userBuildProperties)).containsKey(TEST_PLATFORM)) {
            return properties2.getProperty(TEST_PLATFORM).toLowerCase();
        }
        File localBuildProperties = new File(BUILD_PROPERTIES);
        if (localBuildProperties.isFile() && (properties = TestUtilities.loadProperties(localBuildProperties)).containsKey(TEST_PLATFORM)) {
            return properties.getProperty(TEST_PLATFORM).toLowerCase();
        }
        return DEFAULT_TEST_PLATFORM.toLowerCase();
    }

    private static Properties loadProperties(File file) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(file);){
            properties.load(fis);
        }
        return properties;
    }

    public static File createTempDir() throws Exception {
        File tmpFile = File.createTempFile("wfUnitTest", "");
        Assert.assertTrue((boolean)tmpFile.delete());
        File tmpDir = new File(new File(SystemUtils.JAVA_IO_TMPDIR), tmpFile.getName());
        Assert.assertTrue((boolean)tmpDir.mkdir());
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    public static File getPluginsDirectory() {
        String directory = ConfigContext.getCurrentContextConfig().getProperty("plugin.dir");
        if (StringUtils.isNotBlank((String)directory)) {
            return new File(directory);
        }
        return new File("./work/unit-test/plugins");
    }

    public static void initializePluginDirectories() throws Exception {
        File pluginDir = TestUtilities.getPluginsDirectory();
        if (pluginDir.exists()) {
            FileUtils.forceDelete((File)pluginDir);
        }
        FileUtils.forceMkdir((File)pluginDir);
        FileUtils.forceDeleteOnExit((File)pluginDir);
    }

    public static void cleanupPluginDirectories() throws Exception {
        FileUtils.deleteDirectory((File)TestUtilities.getPluginsDirectory());
    }

    public static <T extends Throwable> T findExceptionInStack(Throwable topLevelException, Class<T> exceptionClass) {
        for (Throwable t = topLevelException; t != null; t = t.getCause()) {
            if (!exceptionClass.isAssignableFrom(t.getClass())) continue;
            return (T)t;
        }
        return null;
    }
}

