/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.xml.export;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.doctype.ApplicationDocumentStatus;
import org.kuali.rice.kew.doctype.DocumentTypePolicy;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.BranchPrototype;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.export.KewExportDataSet;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.xml.export.XmlExporterTestCase;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class DocumentTypeXmlExporterTest
extends XmlExporterTestCase {
    private static final Logger LOG = LogManager.getLogger(DocumentTypeXmlExporterTest.class);

    @Test
    public void testExportDynamicProcessConfig() throws Exception {
        this.loadXmlFile("DocTypeExportRuleTemplateConfig.xml");
        this.loadXmlFile("DocTypeExportConfig.xml");
        this.assertExport();
    }

    @Test
    public void testExportAppDocStatusTestConfig() throws Exception {
        this.loadXmlFile("org/kuali/rice/kew/routeheader/AppDocStatusTestConfig.xml");
        this.assertExport();
    }

    @Override
    protected void assertExport() throws Exception {
        List documentTypes = KEWServiceLocator.getDocumentTypeService().findAllCurrent();
        for (DocumentType existingDocType : documentTypes) {
            KewExportDataSet dataSet = new KewExportDataSet();
            dataSet.getDocumentTypes().add(existingDocType);
            byte[] xmlBytes = CoreApiServiceLocator.getXmlExporterService().export(dataSet.createExportDataSet());
            Assert.assertTrue((String)"XML should be non empty.", (xmlBytes != null && xmlBytes.length > 0 ? 1 : 0) != 0);
            this.loadXmlStream(new BufferedInputStream(new ByteArrayInputStream(xmlBytes)));
            DocumentType newDocType = KEWServiceLocator.getDocumentTypeService().findByName(existingDocType.getName());
            LOG.info("checking export for " + existingDocType.getName());
            this.assertDocTypeExport(existingDocType, newDocType);
        }
    }

    private void assertDocTypeExport(DocumentType oldDocType, DocumentType newDocType) {
        Assert.assertFalse((String)"Document type ids should be different.", (boolean)oldDocType.getDocumentTypeId().equals(newDocType.getDocumentTypeId()));
        Assert.assertTrue((String)"Version should be one greater.", (newDocType.getVersion() == oldDocType.getVersion() + 1 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Previous version should be old doc type.", (Object)oldDocType.getDocumentTypeId(), (Object)newDocType.getPreviousVersionId());
        Assert.assertEquals((String)"Should have same name", (Object)oldDocType.getName(), (Object)newDocType.getName());
        if (oldDocType.getParentDocType() == null) {
            Assert.assertNull((String)"Should have same parent.", (Object)newDocType.getParentDocType());
        } else {
            Assert.assertEquals((String)"Should have same parent.", (Object)oldDocType.getParentDocType().getName(), (Object)newDocType.getParentDocType().getName());
        }
        Assert.assertEquals((Object)oldDocType.getActive(), (Object)newDocType.getActive());
        Assert.assertEquals((Object)oldDocType.getDescription(), (Object)newDocType.getDescription());
        Assert.assertEquals((Object)oldDocType.getUnresolvedDocHandlerUrl(), (Object)newDocType.getUnresolvedDocHandlerUrl());
        Assert.assertEquals((Object)oldDocType.getUnresolvedHelpDefinitionUrl(), (Object)newDocType.getUnresolvedHelpDefinitionUrl());
        Assert.assertEquals((Object)oldDocType.getUnresolvedDocSearchHelpUrl(), (Object)newDocType.getUnresolvedDocSearchHelpUrl());
        Assert.assertEquals((Object)oldDocType.getLabel(), (Object)newDocType.getLabel());
        Assert.assertEquals((Object)oldDocType.getPostProcessorName(), (Object)newDocType.getPostProcessorName());
        Assert.assertEquals((Object)oldDocType.getAuthorizer(), (Object)newDocType.getAuthorizer());
        Assert.assertEquals((Object)oldDocType.getRoutingVersion(), (Object)newDocType.getRoutingVersion());
        this.assertWorkgroupsEqual(oldDocType.getBlanketApproveWorkgroup(), newDocType.getBlanketApproveWorkgroup());
        Assert.assertEquals((Object)oldDocType.getBlanketApprovePolicy(), (Object)newDocType.getBlanketApprovePolicy());
        Assert.assertEquals((Object)oldDocType.getCurrentInd(), (Object)newDocType.getCurrentInd());
        this.assertWorkgroupsEqual(oldDocType.getSuperUserWorkgroup(), newDocType.getSuperUserWorkgroup());
        this.assertWorkgroupsEqual(oldDocType.getSuperUserWorkgroupNoInheritence(), newDocType.getSuperUserWorkgroupNoInheritence());
        Assert.assertEquals((Object)oldDocType.getActualNotificationFromAddress(), (Object)newDocType.getActualNotificationFromAddress());
        Assert.assertEquals((Object)oldDocType.getActualApplicationId(), (Object)newDocType.getActualApplicationId());
        this.assertRoutePath(oldDocType, newDocType);
        this.assertPolicies(oldDocType, newDocType);
        this.assertValidApplicationStatuses(oldDocType, newDocType);
    }

    private void assertWorkgroupsEqual(Group a, Group b) {
        if (a == null) {
            Assert.assertNull((Object)b);
        } else {
            Assert.assertNotNull((Object)b);
            Assert.assertEquals((Object)a.getId(), (Object)b.getId());
        }
    }

    private void assertRoutePath(DocumentType oldDocType, DocumentType newDocType) {
        for (ProcessDefinitionBo oldProcess : oldDocType.getProcesses()) {
            ProcessDefinitionBo newProcess = newDocType.getNamedProcess(oldProcess.getName());
            this.assertRouteNodes(oldProcess.getInitialRouteNode(), newProcess.getInitialRouteNode(), new HashSet());
        }
    }

    private void assertRouteNodes(RouteNode oldNode, RouteNode newNode, Set processedNodeIds) {
        if (oldNode == null && newNode == null) {
            return;
        }
        if (processedNodeIds.contains(oldNode.getRouteNodeId())) {
            if (!processedNodeIds.contains(newNode.getRouteNodeId())) {
                Assert.fail((String)"If old node is processed, new node should also be processed.");
            }
            return;
        }
        Assert.assertEquals((Object)oldNode.getRouteNodeName(), (Object)newNode.getRouteNodeName());
        Assert.assertEquals((Object)oldNode.getActivationType(), (Object)newNode.getActivationType());
        Assert.assertEquals((Object)oldNode.getExceptionWorkgroupId(), (Object)newNode.getExceptionWorkgroupId());
        Assert.assertEquals((Object)oldNode.getNodeType(), (Object)newNode.getNodeType());
        Assert.assertEquals((Object)oldNode.getRouteMethodCode(), (Object)newNode.getRouteMethodCode());
        Assert.assertEquals((Object)oldNode.getRouteMethodName(), (Object)newNode.getRouteMethodName());
        Assert.assertEquals((Object)oldNode.getDocumentType().getName(), (Object)newNode.getDocumentType().getName());
        Assert.assertEquals((Object)oldNode.getFinalApprovalInd(), (Object)newNode.getFinalApprovalInd());
        Assert.assertEquals((Object)oldNode.getMandatoryRouteInd(), (Object)newNode.getMandatoryRouteInd());
        Assert.assertEquals((Object)oldNode.getNextDocumentStatus(), (Object)newNode.getNextDocumentStatus());
        this.assertBranches(oldNode.getBranch(), newNode.getBranch());
        Assert.assertEquals((long)oldNode.getNextNodes().size(), (long)newNode.getNextNodes().size());
        processedNodeIds.add(oldNode.getRouteNodeId());
        processedNodeIds.add(newNode.getRouteNodeId());
        for (RouteNode nextOldNode : oldNode.getNextNodes()) {
            boolean foundNode = false;
            for (RouteNode nextNewNode : newNode.getNextNodes()) {
                if (!nextNewNode.getRouteNodeName().equals(nextOldNode.getRouteNodeName())) continue;
                foundNode = true;
                this.assertRouteNodes(nextOldNode, nextNewNode, processedNodeIds);
                break;
            }
            Assert.assertTrue((String)("Could not locate new node by name: " + nextOldNode.getRouteNodeName()), (boolean)foundNode);
        }
    }

    private void assertBranches(BranchPrototype oldBranch, BranchPrototype newBranch) {
        if (oldBranch == null) {
            Assert.assertNull((String)"New Branch should also be null.", (Object)newBranch);
        } else {
            Assert.assertEquals((Object)oldBranch.getName(), (Object)newBranch.getName());
        }
    }

    private void assertPolicies(DocumentType oldDocType, DocumentType newDocType) {
        Assert.assertEquals((long)oldDocType.getDocumentTypePolicies().size(), (long)newDocType.getDocumentTypePolicies().size());
        for (DocumentTypePolicy oldPolicy : oldDocType.getDocumentTypePolicies()) {
            boolean foundPolicy = false;
            for (DocumentTypePolicy newPolicy : newDocType.getDocumentTypePolicies()) {
                if (!oldPolicy.getPolicyName().equals(newPolicy.getPolicyName())) continue;
                foundPolicy = true;
                Assert.assertEquals((Object)oldPolicy.getInheritedFlag(), (Object)newPolicy.getInheritedFlag());
                Assert.assertEquals((Object)oldPolicy.getPolicyValue(), (Object)newPolicy.getPolicyValue());
                break;
            }
            Assert.assertTrue((String)("Could not locate policy by name " + oldPolicy.getPolicyName()), (boolean)foundPolicy);
        }
    }

    private void assertValidApplicationStatuses(DocumentType oldDocType, DocumentType newDocType) {
        Assert.assertEquals((long)oldDocType.getValidApplicationStatuses().size(), (long)newDocType.getValidApplicationStatuses().size());
        Assert.assertEquals((long)oldDocType.getApplicationStatusCategories().size(), (long)newDocType.getApplicationStatusCategories().size());
        for (ApplicationDocumentStatus oldApplicationDocumentStatus : oldDocType.getValidApplicationStatuses()) {
            String oldApplicationStatusCat = oldApplicationDocumentStatus.getCategoryName();
            boolean foundStatus = false;
            for (ApplicationDocumentStatus newApplicationDocumentStatus : newDocType.getValidApplicationStatuses()) {
                String newApplicationStatusCat = newApplicationDocumentStatus.getCategoryName();
                if (!oldApplicationDocumentStatus.getStatusName().equals(newApplicationDocumentStatus.getStatusName()) || !StringUtils.equals((CharSequence)oldApplicationStatusCat, (CharSequence)newApplicationStatusCat)) continue;
                foundStatus = true;
                break;
            }
            Assert.assertTrue((String)("Could not locate validApplicationStatus by status name and category" + oldApplicationDocumentStatus.getStatusName()), (boolean)foundStatus);
        }
    }
}

