/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actionrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.rice.kew.api.identity.PrincipalName;
import org.kuali.rice.kew.api.rule.RoleName;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.routeheader.DocumentContent;
import org.kuali.rice.kew.rule.AbstractRoleAttribute;
import org.kuali.rice.kew.rule.ResolvedQualifiedRole;

public class RoleToRoleDelegationRole
extends AbstractRoleAttribute {
    private static final long serialVersionUID = 3881730393316239780L;
    public static final String MAIN_ROLE = "MAIN";
    public static final String PRIMARY_DELEGATE_ROLE = "PRIMARY_DELEGATE";
    public static final String SECONDARY_DELEGATE_ROLE = "SECONDARY_DELEGATE";
    private static final List ROLE_NAMES = new ArrayList();
    public static List MAIN_USERS;
    public static Map PRIMARY_DELEGATES;
    public static Map SECONDARY_DELEGATES;

    public List getRoleNames() {
        return ROLE_NAMES;
    }

    public List getQualifiedRoleNames(String roleName, DocumentContent documentContent) {
        ArrayList names = new ArrayList();
        if (!MAIN_ROLE.equals(roleName)) {
            throw new IllegalArgumentException("Can't get qualified role names for role '" + roleName + "'");
        }
        names = new ArrayList(MAIN_USERS);
        return names;
    }

    public ResolvedQualifiedRole resolveQualifiedRole(RouteContext routeContext, String roleName, String qualifiedRole) {
        List userIds = new ArrayList();
        if (MAIN_ROLE.equals(roleName)) {
            userIds = MAIN_USERS;
        } else if (PRIMARY_DELEGATE_ROLE.equals(roleName)) {
            userIds = new ArrayList((List)PRIMARY_DELEGATES.get(qualifiedRole));
        } else if (SECONDARY_DELEGATE_ROLE.equals(roleName)) {
            userIds = new ArrayList((List)SECONDARY_DELEGATES.get(qualifiedRole));
        } else {
            throw new IllegalArgumentException("Can't resolve qualified role for role '" + roleName + "'");
        }
        ArrayList<PrincipalName> recipients = new ArrayList<PrincipalName>();
        for (String networkId : userIds) {
            recipients.add(new PrincipalName(networkId));
        }
        return new ResolvedQualifiedRole(roleName, recipients);
    }

    static {
        ROLE_NAMES.add(new RoleName(RoleToRoleDelegationRole.class.getName(), MAIN_ROLE, MAIN_ROLE));
        ROLE_NAMES.add(new RoleName(RoleToRoleDelegationRole.class.getName(), PRIMARY_DELEGATE_ROLE, PRIMARY_DELEGATE_ROLE));
        ROLE_NAMES.add(new RoleName(RoleToRoleDelegationRole.class.getName(), SECONDARY_DELEGATE_ROLE, SECONDARY_DELEGATE_ROLE));
        MAIN_USERS = new ArrayList();
        MAIN_USERS.add("ewestfal");
        PRIMARY_DELEGATES = new HashMap();
        ArrayList<String> primDelegates1 = new ArrayList<String>();
        primDelegates1.add("jhopf");
        PRIMARY_DELEGATES.put("ewestfal", primDelegates1);
        PRIMARY_DELEGATES.put("rkirkend", new ArrayList());
        SECONDARY_DELEGATES = new HashMap();
        ArrayList<String> secondaryDelegates1 = new ArrayList<String>();
        secondaryDelegates1.add("jitrue");
        secondaryDelegates1.add("xqi");
        ArrayList<String> secondaryDelegates2 = new ArrayList<String>();
        secondaryDelegates2.add("jhopf");
        secondaryDelegates2.add("bmcgough");
        secondaryDelegates2.add("natjohns");
        SECONDARY_DELEGATES.put("ewestfal", secondaryDelegates1);
        SECONDARY_DELEGATES.put("rkirkend", secondaryDelegates2);
    }
}

