/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mocks.MockEmailNotificationService;
import org.apache.cxf.common.util.StringUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.InvalidActionTakenException;
import org.kuali.rice.kew.api.document.DocumentContentUpdate;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.PropertyDefinition;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.rule.GenericWorkflowAttribute;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class BlanketApproveTest
extends KEWTestCase {
    public static String TEST_USER_EWESTFAL = "ewestfal";
    public static String TEST_USER_USER1 = "user1";
    public static String TEST_USER_USER2 = "user2";
    public static String TEST_USER_TEMAY = "temay";
    public static String TEST_USER_JHOPF = "jhopf";
    public static String TEST_USER_JITRUE = "jitrue";
    public static String TEST_USER_JTHOMAS = "jthomas";
    public static String TEST_USER_BMCGOUGH = "bmcgough";
    public static String TEST_USER_RKIRKEND = "rkirkend";
    public static String TEST_USER_PMCKOWN = "pmckown";
    public static String TEST_USER_XQI = "xqi";

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    @Test
    public void testBlanketApproverNotInBlanketApproverWorkgroup() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_USER1), (String)"BlanketApproveSequentialTest");
        try {
            document.blanketApprove("");
            Assert.fail((String)"InvalidActionTakenException should have been thrown");
        }
        catch (InvalidActionTakenException iate) {
            Assert.assertEquals((String)"Exception on message is incorrent", (Object)"User is not authorized to BlanketApprove document", (Object)iate.getMessage());
        }
    }

    @Test
    public void testBlanketApproverNotInitiator() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_USER1), (String)"BlanketApproveSequentialTest");
        WorkflowDocument newDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        try {
            newDocument.blanketApprove("");
            Assert.fail((String)"Exception should have been thrown when non-initiator user attempts blanket approve on default blanket approve policy document");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testBlanketApproveSequential() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveSequentialTest");
        document.blanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        List nodeInstances = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)0L, (long)nodeInstances.size());
        nodeInstances = this.getRouteNodeService().getTerminalNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)nodeInstances.size());
        RouteNodeInstance ackNodeInstance = (RouteNodeInstance)nodeInstances.iterator().next();
        Assert.assertEquals((String)"At wrong node.", (Object)"Acknowledge2", (Object)ackNodeInstance.getRouteNode().getRouteNodeName());
        Assert.assertTrue((String)"Node should be complete.", (boolean)ackNodeInstance.isComplete());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)5L, (long)actionRequests.size());
        boolean isNotification1 = false;
        boolean isNotification2 = false;
        boolean isNotification3 = false;
        boolean isAck1 = false;
        boolean isAck2 = false;
        for (ActionRequestValue actionRequest : actionRequests) {
            Assert.assertEquals((String)"Should only be acknowledges.", (Object)"K", (Object)actionRequest.getActionRequested());
            RouteNodeInstance nodeInstance = actionRequest.getNodeInstance();
            Assert.assertNotNull((Object)nodeInstance);
            String nodeName = nodeInstance.getRouteNode().getRouteNodeName();
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName(TEST_USER_BMCGOUGH))) {
                isNotification1 = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)nodeName);
                Assert.assertEquals((Object)"0", (Object)actionRequest.getResponsibilityId());
                continue;
            }
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName(TEST_USER_RKIRKEND))) {
                isNotification2 = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)nodeName);
                Assert.assertEquals((Object)"0", (Object)actionRequest.getResponsibilityId());
                continue;
            }
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName(TEST_USER_PMCKOWN))) {
                isNotification3 = true;
                Assert.assertEquals((Object)"WorkflowDocument2", (Object)nodeName);
                Assert.assertEquals((Object)"0", (Object)actionRequest.getResponsibilityId());
                continue;
            }
            if (actionRequest.getPrincipalId().equals(this.getPrincipalIdForName(TEST_USER_TEMAY))) {
                isAck1 = true;
                Assert.assertEquals((Object)"Acknowledge1", (Object)nodeName);
                Assert.assertFalse((boolean)"0".equals(actionRequest.getResponsibilityId()));
                continue;
            }
            if (!actionRequest.getPrincipalId().equals(this.getPrincipalIdForName(TEST_USER_JHOPF))) continue;
            isAck2 = true;
            Assert.assertEquals((Object)"Acknowledge2", (Object)nodeName);
            Assert.assertFalse((boolean)"0".equals(actionRequest.getResponsibilityId()));
        }
        Assert.assertTrue((boolean)isNotification1);
        Assert.assertTrue((boolean)isNotification2);
        Assert.assertTrue((boolean)isNotification3);
        Assert.assertTrue((boolean)isAck1);
        Assert.assertTrue((boolean)isAck2);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_BMCGOUGH), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"bmcgough should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent(TEST_USER_BMCGOUGH, document.getDocumentId(), "A"));
        Assert.assertEquals((String)"bmcgough should not have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent(TEST_USER_BMCGOUGH, document.getDocumentId(), "K"));
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_RKIRKEND), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"rkirkend should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"rkirkend should not have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("rkirkend", document.getDocumentId(), "K"));
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_PMCKOWN), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"pmckown should not have been sent an approve email", (long)0L, (long)this.getMockEmailService().immediateReminderEmailsSent("pmckown", document.getDocumentId(), "A"));
        Assert.assertEquals((String)"pmckown should not have been sent an ack email", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent("pmckown", document.getDocumentId(), "K"));
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_TEMAY), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"rkirkend should have been sent an temay", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent(TEST_USER_TEMAY, document.getDocumentId(), "K"));
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_JHOPF), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        Assert.assertEquals((String)"rkirkend should have been sent an jhopf", (long)1L, (long)this.getMockEmailService().immediateReminderEmailsSent(TEST_USER_JHOPF, document.getDocumentId(), "K"));
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isFinal());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveSequentialTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2"});
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        nodeInstances = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Should be one active node.", (long)1L, (long)nodeInstances.size());
        RouteNodeInstance doc2Instance = (RouteNodeInstance)nodeInstances.iterator().next();
        Assert.assertEquals((String)"At wrong node.", (Object)"WorkflowDocument2", (Object)doc2Instance.getRouteNode().getRouteNodeName());
    }

    @Test
    public void testBlanketApproveSequentialErrors() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveSequentialTest");
        try {
            document.blanketApprove("", new String[]{"TotallyInvalidNode"});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveSequentialTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2"});
        try {
            document.blanketApprove("", new String[]{"WorkflowDocument"});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveSequentialTest");
        document.route("");
        try {
            document.blanketApprove("", new String[]{"WorkflowDocument"});
            Assert.fail((String)"Should have thrown exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_USER1), (String)"BlanketApproveSequentialTest");
        try {
            document.blanketApprove("");
            Assert.fail((String)"Shouldn't be able to blanket approve if not in blanket approve workgroup");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBlanketApproveParallel() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        document.blanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        List nodeInstances = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)0L, (long)nodeInstances.size());
        nodeInstances = this.getRouteNodeService().getTerminalNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of terminal nodes.", (long)1L, (long)nodeInstances.size());
        RouteNodeInstance ackNodeInstance = (RouteNodeInstance)nodeInstances.iterator().next();
        Assert.assertEquals((String)"At wrong node.", (Object)"Acknowledge2", (Object)ackNodeInstance.getRouteNode().getRouteNodeName());
        Assert.assertTrue((String)"Node should be complete.", (boolean)ackNodeInstance.isComplete());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)10L, (long)actionRequests.size());
    }

    @Ignore
    @Test
    public void testChainedBlanketApproval() throws Exception {
        WorkflowDocument childDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"ChainedBlanketApproveTestChild");
        WorkflowAttributeDefinition.Builder childDocAttribute = WorkflowAttributeDefinition.Builder.create((String)"ChildDocumentAttribute");
        PropertyDefinition docIdProperty = PropertyDefinition.create((String)"documentId", (String)childDocument.getDocumentId());
        childDocAttribute.addPropertyDefinition(docIdProperty);
        WorkflowDocument parentDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"ChainedBlanketApproveTestParent");
        String fullContent = parentDocument.getDocumentContent().getFullContent();
        String newContent = "<documentContent><attributeContent><documentId>" + childDocument.getDocumentId() + "</documentId></attributeContent></documentContent>";
        DocumentContentUpdate.Builder documentContentUpdateBuilder = DocumentContentUpdate.Builder.create();
        documentContentUpdateBuilder.setAttributeContent(newContent);
        parentDocument.updateDocumentContent(documentContentUpdateBuilder.build());
        parentDocument.saveDocumentData();
        parentDocument.blanketApprove("");
        parentDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)parentDocument.getDocumentId());
        Assert.assertTrue((String)"Parent Document should be processed.", (boolean)parentDocument.isProcessed());
        childDocument = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)childDocument.getDocumentId());
        Assert.assertTrue((String)"Child Document should be processed.", (boolean)childDocument.isProcessed());
    }

    @Test
    public void testBlanketApproveIntoBranch() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2-B1"});
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)5L, (long)actionRequests.size());
        List activeNodes = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)3L, (long)activeNodes.size());
        boolean isAtWD2B1 = false;
        boolean isAtJoin = false;
        boolean isAtWD3B2 = false;
        boolean isAtWD4B3 = false;
        for (RouteNodeInstance nodeInstance : activeNodes) {
            isAtWD2B1 = isAtWD2B1 || nodeInstance.getName().equals("WorkflowDocument2-B1");
            isAtWD3B2 = isAtWD3B2 || nodeInstance.getName().equals("WorkflowDocument3-B2");
            isAtWD4B3 = isAtWD4B3 || nodeInstance.getName().equals("WorkflowDocument4-B3");
            isAtJoin = isAtJoin || nodeInstance.getName().equals("Join");
        }
        Assert.assertTrue((String)"Should be at blanket approved node.", (boolean)isAtWD2B1);
        Assert.assertTrue((String)"Should be at blanket approved node WD3B2.", (boolean)isAtWD3B2);
        Assert.assertTrue((String)"Should be at blanket approved node WD4B3.", (boolean)isAtWD4B3);
        Assert.assertFalse((String)"Should be at join node.", (boolean)isAtJoin);
        document.blanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)10L, (long)actionRequests.size());
    }

    @Test
    public void testBlanketApproveToMultipleNodes() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2-B1", "WorkflowDocument3-B2"});
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)5L, (long)actionRequests.size());
        List activeNodes = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)3L, (long)activeNodes.size());
        boolean isAtWD2B1 = false;
        boolean isAtWD3B2 = false;
        boolean isAtJoin = false;
        boolean isAtWD4B3 = false;
        for (RouteNodeInstance nodeInstance : activeNodes) {
            isAtWD2B1 = isAtWD2B1 || nodeInstance.getName().equals("WorkflowDocument2-B1");
            isAtWD3B2 = isAtWD3B2 || nodeInstance.getName().equals("WorkflowDocument3-B2");
            isAtWD4B3 = isAtWD4B3 || nodeInstance.getName().equals("WorkflowDocument4-B3");
            isAtJoin = isAtJoin || nodeInstance.getName().equals("Join");
        }
        Assert.assertTrue((String)"Should be at blanket approved node WD2B1.", (boolean)isAtWD2B1);
        Assert.assertTrue((String)"Should be at blanket approved node WD3B2.", (boolean)isAtWD3B2);
        Assert.assertTrue((String)"Should be at blanket approved node WD4B3.  https://jira.kuali.org/browse/KULRICE-8481 - BlanketApproveTest.testBlanketApproveToMultipleNodes fails in CI with Should be at blanket approved node WD4B3.", (boolean)isAtWD4B3);
        Assert.assertFalse((String)"Should not be at join node.", (boolean)isAtJoin);
        document.blanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of pending action requests.", (long)10L, (long)actionRequests.size());
    }

    @Test
    public void testBlanketApproveToJoin() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        document.blanketApprove("", new String[]{"Join"});
        Assert.assertTrue((String)"Document should still be enroute.", (boolean)document.isEnroute());
        List activeNodes = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)1L, (long)activeNodes.size());
        RouteNodeInstance nodeInstance = (RouteNodeInstance)activeNodes.iterator().next();
        Assert.assertEquals((String)"Document at wrong node.", (Object)"WorkflowDocumentFinal", (Object)nodeInstance.getName());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_XQI), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        document.blanketApprove("", new String[]{"Acknowledge1"});
        activeNodes = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)0L, (long)activeNodes.size());
        List terminalNodes = this.getRouteNodeService().getTerminalNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of terminal nodes.", (long)1L, (long)terminalNodes.size());
        nodeInstance = (RouteNodeInstance)terminalNodes.iterator().next();
        Assert.assertEquals((String)"Document at wrong node.", (Object)"Acknowledge2", (Object)nodeInstance.getName());
        Assert.assertTrue((String)"Final node not complete.", (boolean)nodeInstance.isComplete());
    }

    @Test
    public void testBlanketApproveToAcknowledge() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        document.blanketApprove("", new String[]{"Acknowledge1"});
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        List activeNodes = this.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of active nodes.", (long)0L, (long)activeNodes.size());
        List terminalNodes = this.getRouteNodeService().getTerminalNodeInstances(document.getDocumentId());
        Assert.assertEquals((String)"Wrong number of terminal nodes.", (long)1L, (long)terminalNodes.size());
        RouteNodeInstance nodeInstance = (RouteNodeInstance)terminalNodes.iterator().next();
        Assert.assertEquals((String)"Document at wrong node.", (Object)"Acknowledge2", (Object)nodeInstance.getName());
        Assert.assertTrue((String)"Final node not complete.", (boolean)nodeInstance.isComplete());
    }

    @Test
    public void testBlanketApproveToMultipleNodesErrors() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveParallelTest");
        try {
            document.blanketApprove("", new String[]{"WorkflowDocument2-B1", "Acknowledge1"});
            Assert.fail((String)"document should have thrown exception");
        }
        catch (Exception e) {
            TestUtilities.getExceptionThreader().join();
            document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
            Assert.assertTrue((String)"Document should be in exception routing.", (boolean)document.isException());
        }
    }

    @Test
    public void testBlanketApproveNotification() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"NotificationTest");
        document.blanketApprove("");
        ActionRequestService arService = KEWServiceLocator.getActionRequestService();
        List actionRequests = arService.getRootRequests((Collection)arService.findPendingByDoc(document.getDocumentId()));
        Assert.assertEquals((String)"Should be 5 pending acknowledgements and 1 pending fyi", (long)6L, (long)actionRequests.size());
        boolean foundJhopfNotification = false;
        boolean foundRkirkendNotification = false;
        boolean foundJitrueNotification = false;
        boolean foundBmcgoughNotification = false;
        boolean foundXqiAck = false;
        boolean foundJthomasFYI = false;
        for (ActionRequestValue actionRequest : actionRequests) {
            String netId;
            RouteNodeInstance nodeInstance = actionRequest.getNodeInstance();
            String string = netId = actionRequest.getPrincipalId() == null ? null : this.getPrincipalNameForId(actionRequest.getPrincipalId());
            if (TEST_USER_JHOPF.equals(netId)) {
                foundJhopfNotification = true;
                Assert.assertTrue((String)"Action request should be an acknowledge.", (boolean)actionRequest.isAcknowledgeRequest());
                Assert.assertEquals((Object)"NotifyFirst", (Object)nodeInstance.getName());
                continue;
            }
            if ("rkirkend".equals(netId)) {
                foundRkirkendNotification = true;
                Assert.assertTrue((String)"Action request should be an acknowledge.", (boolean)actionRequest.isAcknowledgeRequest());
                Assert.assertEquals((Object)"NotifyLeftBranch", (Object)nodeInstance.getName());
                Assert.assertEquals((String)"Rkirkend should have three delegate acks.", (long)3L, (long)actionRequest.getChildrenRequests().size());
                Assert.assertTrue((String)"Should be primary delegation.", (boolean)actionRequest.isPrimaryDelegator());
                boolean foundTemayDelegate = false;
                boolean foundNonSITWGDelegate = false;
                boolean foundPmckownDelegate = false;
                for (ActionRequestValue childRequest : actionRequest.getChildrenRequests()) {
                    String childId;
                    Assert.assertTrue((String)"Child request should be an acknowledge.", (boolean)actionRequest.isAcknowledgeRequest());
                    String string2 = childId = childRequest.isGroupRequest() ? childRequest.getGroup().getName() : this.getPrincipalNameForId(childRequest.getPrincipalId());
                    if (TEST_USER_TEMAY.equals(childId)) {
                        foundTemayDelegate = true;
                        Assert.assertEquals((String)"Should be primary delegation.", (Object)DelegationType.PRIMARY, (Object)childRequest.getDelegationType());
                        continue;
                    }
                    if ("pmckown".equals(childId)) {
                        foundPmckownDelegate = true;
                        Assert.assertEquals((String)"Should be secondary delegation.", (Object)DelegationType.SECONDARY, (Object)childRequest.getDelegationType());
                        continue;
                    }
                    if (!"NonSIT".equals(childId)) continue;
                    foundNonSITWGDelegate = true;
                    Assert.assertEquals((String)"Should be primary delegation.", (Object)DelegationType.PRIMARY, (Object)childRequest.getDelegationType());
                }
                Assert.assertTrue((String)"Could not locate delegate request for temay.", (boolean)foundTemayDelegate);
                Assert.assertTrue((String)"Could not locate delegate request for NonSIT Group.", (boolean)foundNonSITWGDelegate);
                Assert.assertTrue((String)"Could not locate delegate request for pmckown.", (boolean)foundPmckownDelegate);
                continue;
            }
            if (TEST_USER_BMCGOUGH.equals(netId)) {
                foundBmcgoughNotification = true;
                Assert.assertTrue((String)"Action request should be an acknowledge.", (boolean)actionRequest.isAcknowledgeRequest());
                Assert.assertEquals((Object)"NotifyFinal", (Object)nodeInstance.getName());
                continue;
            }
            if ("xqi".equals(netId)) {
                foundXqiAck = true;
                Assert.assertTrue((String)"Action request should be an acknowledge.", (boolean)actionRequest.isAcknowledgeRequest());
                Assert.assertEquals((Object)"NotifyFinal", (Object)nodeInstance.getName());
                continue;
            }
            if (TEST_USER_JTHOMAS.equals(netId)) {
                foundJthomasFYI = true;
                Assert.assertTrue((String)"Action request should be an FYI.", (boolean)actionRequest.isFYIRequest());
                Assert.assertEquals((Object)"NotifyFinal", (Object)nodeInstance.getName());
                continue;
            }
            if (!actionRequest.isRoleRequest()) continue;
            List topLevelRequests = arService.getTopLevelRequests(actionRequest);
            Assert.assertEquals((long)1L, (long)topLevelRequests.size());
            actionRequest = (ActionRequestValue)topLevelRequests.get(0);
            Assert.assertEquals((String)"Should be to jitrue.", (Object)TEST_USER_JITRUE, (Object)this.getPrincipalNameForId(actionRequest.getPrincipalId()));
            foundJitrueNotification = true;
            List delegateRoleRequests = arService.getDelegateRequests(actionRequest);
            Assert.assertEquals((String)"Should be 1 delegate role requests", (long)1L, (long)delegateRoleRequests.size());
            ActionRequestValue delegateRoleRequest = (ActionRequestValue)delegateRoleRequests.get(0);
            Assert.assertEquals((String)"Should be NotifyDelegate role", (Object)"NotifyDelegate", (Object)delegateRoleRequest.getRoleName());
            Assert.assertEquals((String)"Should be secondary delegation", (Object)DelegationType.SECONDARY, (Object)delegateRoleRequest.getDelegationType());
            List delegateRequests = arService.getTopLevelRequests(delegateRoleRequest);
            Assert.assertEquals((String)"Should be 2 delegate requests", (long)2L, (long)delegateRequests.size());
            boolean foundNatjohnsDelegate = false;
            boolean foundShenlDelegate = false;
            for (ActionRequestValue delegateRequest : delegateRequests) {
                String delNetId = this.getPrincipalNameForId(delegateRequest.getPrincipalId());
                if ("natjohns".equals(delNetId)) {
                    foundNatjohnsDelegate = true;
                    continue;
                }
                if (!"shenl".equals(delNetId)) continue;
                foundShenlDelegate = true;
            }
            Assert.assertTrue((String)"Could not locate natjohns role delegate request.", (boolean)foundNatjohnsDelegate);
            Assert.assertTrue((String)"Could not locate shenl role delegate request.", (boolean)foundShenlDelegate);
        }
        Assert.assertTrue((String)"Could not locate notification for jhopf.", (boolean)foundJhopfNotification);
        Assert.assertTrue((String)"Could not locate notification for rkirkend.", (boolean)foundRkirkendNotification);
        Assert.assertTrue((String)"Could not locate notification for bmcgough.", (boolean)foundBmcgoughNotification);
        Assert.assertTrue((String)"Could not locate acknowledgment for xqi.", (boolean)foundXqiAck);
        Assert.assertTrue((String)"Could not locate FYI for jthomas.", (boolean)foundJthomasFYI);
        Assert.assertTrue((String)"Could not locate notification for jitrue.", (boolean)foundJitrueNotification);
    }

    @Test
    public void testBlanketApprovePastMandatoryNode() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)"BlanketApproveMandatoryNodeTest");
        document.blanketApprove("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
    }

    @Test
    public void testBlanketApproveThroughRoleAndWorkgroup() throws Exception {
        String jitruePrincipalId = this.getPrincipalIdForName(TEST_USER_JITRUE);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(TEST_USER_USER1), (String)"BlanketApproveThroughRoleAndWorkgroupTest");
        document.saveDocument("");
        Assert.assertTrue((boolean)document.isSaved());
        TestUtilities.assertNotInActionList(jitruePrincipalId, document.getDocumentId());
        document.blanketApprove("");
        document = WorkflowDocumentFactory.loadDocument((String)jitruePrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 3 root requests.", (long)3L, (long)actionRequests.size());
        TestUtilities.assertInActionList(jitruePrincipalId, document.getDocumentId());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName(TEST_USER_EWESTFAL), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        document.acknowledge("");
        document = WorkflowDocumentFactory.loadDocument((String)jitruePrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isProcessed());
        Assert.assertTrue((boolean)document.isAcknowledgeRequested());
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 2 root requests.", (long)2L, (long)actionRequests.size());
        TestUtilities.assertInActionList(jitruePrincipalId, document.getDocumentId());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void testBlanketApprovePostProcessorSUApproveAnotherDoc() throws Exception {
        WorkflowDocument document1 = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"NotificationTest");
        Assert.assertEquals((String)"Document should be at start node", (Object)"AdHoc", document1.getNodeNames().iterator().next());
        Assert.assertEquals((String)"Document should be initiated", (Object)DocumentStatus.INITIATED, (Object)document1.getStatus());
        WorkflowDocument document2 = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"BAActionSUApproveAnotherDocPostProcessor");
        Assert.assertEquals((String)"Document should be at start node", (Object)"AdHoc", document2.getNodeNames().iterator().next());
        Assert.assertEquals((String)"Document should be initiated", (Object)DocumentStatus.INITIATED, (Object)document2.getStatus());
        document2 = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document2.getDocumentId());
        document2.superUserBlanketApprove("");
        Assert.assertEquals((String)"Document should be Final", (Object)DocumentStatus.FINAL, (Object)document2.getStatus());
        document1 = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document1.getDocumentId());
        Assert.assertEquals((String)"Document should be Processed", (Object)DocumentStatus.PROCESSED, (Object)document1.getStatus());
    }

    private RouteNodeService getRouteNodeService() {
        return KEWServiceLocator.getRouteNodeService();
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }

    public static class NotifySetup {
        public static final String DOCUMENT_TYPE_NAME = "NotificationTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String NOTIFY_FIRST_NODE = "NotifyFirst";
        public static final String NOTIFY_LEFT_NODE = "NotifyLeftBranch";
        public static final String NOTIFY_RIGHT_NODE = "NotifyRightBranch";
        public static final String NOTIFY_FINAL_NODE = "NotifyFinal";
        public static final String SPLIT_NODE = "Split";
        public static final String JOIN_NODE = "Join";
    }

    public class ChainedApprovalWorkflowAttribute
    extends GenericWorkflowAttribute {
        Map<String, String> propertiesMap = new HashMap<String, String>();

        public Map<String, String> getProperties() {
            return this.propertiesMap;
        }
    }

    public static class ChainedApprovalPostProcessor
    extends DefaultPostProcessor {
        public ProcessDocReport doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) throws Exception {
            if ("P".equals(statusChangeEvent.getNewRouteStatus())) {
                String principalId = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(TEST_USER_EWESTFAL).getPrincipalId();
                WorkflowDocument parentDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)statusChangeEvent.getDocumentId());
                List attributeDefinitions = parentDocument.getAttributeDefinitions();
                String documentContent = parentDocument.getDocumentContent().getFullContent();
                String documentId = StringUtils.split((String)documentContent, (String)"\\<(\\/)?documentId\\>")[1];
                WorkflowDocument childDocument = WorkflowDocumentFactory.loadDocument((String)principalId, (String)documentId);
                childDocument.blanketApprove("");
                for (WorkflowAttributeDefinition attributeDefinition : parentDocument.getAttributeDefinitions()) {
                    if (!"ChildDocumentAttribute".equals(attributeDefinition.getAttributeName())) continue;
                    String childDocumentId = (String)attributeDefinition.getPropertyDefinitionsAsMap().get("documentId");
                    WorkflowDocument childDocumentItem = WorkflowDocumentFactory.loadDocument((String)principalId, (String)childDocumentId);
                    childDocumentItem.blanketApprove("");
                }
            }
            return new ProcessDocReport(true);
        }
    }

    private class ParallelSetup {
        public static final String DOCUMENT_TYPE_NAME = "BlanketApproveParallelTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_B1_NODE = "WorkflowDocument2-B1";
        public static final String WORKFLOW_DOCUMENT_2_B2_NODE = "WorkflowDocument2-B2";
        public static final String WORKFLOW_DOCUMENT_3_B1_NODE = "WorkflowDocument3-B1";
        public static final String WORKFLOW_DOCUMENT_3_B2_NODE = "WorkflowDocument3-B2";
        public static final String WORKFLOW_DOCUMENT_4_B3_NODE = "WorkflowDocument4-B3";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";
        public static final String JOIN_NODE = "Join";
        public static final String SPLIT_NODE = "Split";
        public static final String WORKFLOW_DOCUMENT_FINAL_NODE = "WorkflowDocumentFinal";

        private ParallelSetup() {
        }
    }

    private class ChainedChildSetup {
        public static final String DOCUMENT_TYPE_NAME = "ChainedBlanketApproveTestChild";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private ChainedChildSetup() {
        }
    }

    private class ChainedParentSetup {
        public static final String DOCUMENT_TYPE_NAME = "ChainedBlanketApproveTestParent";
        public static final String CHILD_DOC_ATTRIBUTE = "ChildDocumentAttribute";
        public static final String DOC_ID_PROPERTY = "documentId";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private ChainedParentSetup() {
        }
    }

    private class SequentialSetup {
        public static final String DOCUMENT_TYPE_NAME = "BlanketApproveSequentialTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private SequentialSetup() {
        }
    }
}

