/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteLevelChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.kew.postprocessor.DefaultPostProcessor;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;

public class ReturnToPreviousNodeActionTest
extends KEWTestCase {
    @Test
    public void testReturnToPreviousSequential() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"BlanketApproveSequentialTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertEquals((String)"Should be at WorkflowDocument2.", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"pmckown should have approve.", (boolean)document.isApprovalRequested());
        document.returnToPreviousNode("", "AdHoc");
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        boolean isApproveToEwestfal = false;
        for (ActionRequestValue request : actionRequests) {
            if (!request.getPrincipalId().equals(this.getPrincipalIdForName("ewestfal"))) continue;
            Assert.assertEquals((String)"Should be approve request.", (Object)"A", (Object)request.getActionRequested());
            isApproveToEwestfal = true;
        }
        Assert.assertTrue((boolean)isApproveToEwestfal);
        Assert.assertEquals((String)"Should be 1 requests.", (long)1L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"BlanketApproveSequentialTest");
        document.route("");
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 2 requests.", (long)2L, (long)actionRequests.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        RouteNodeInstance preReturnNodeInstance = (RouteNodeInstance)KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId()).iterator().next();
        document.returnToPreviousNode("", "WorkflowDocument");
        preReturnNodeInstance = KEWServiceLocator.getRouteNodeService().findRouteNodeInstanceById(preReturnNodeInstance.getRouteNodeInstanceId());
        RouteNodeInstance postReturnNodeInstance = (RouteNodeInstance)KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId()).iterator().next();
        Assert.assertFalse((String)"Node instances should be different.", (boolean)preReturnNodeInstance.getRouteNodeInstanceId().equals(postReturnNodeInstance.getRouteNodeInstanceId()));
        Assert.assertEquals((String)"Route nodes should be equal.", (Object)preReturnNodeInstance.getRouteNode().getRouteNodeId(), (Object)postReturnNodeInstance.getRouteNode().getRouteNodeId());
        Assert.assertEquals((String)"Should have 1 next node.", (long)1L, (long)preReturnNodeInstance.getNextNodeInstances().size());
        Assert.assertEquals((String)"Should have 1 previous node.", (long)1L, (long)postReturnNodeInstance.getPreviousNodeInstances().size());
        Assert.assertEquals((String)"Should have 0 next node.", (long)0L, (long)postReturnNodeInstance.getNextNodeInstances().size());
        Assert.assertEquals((String)"pre node's next node should be the post node.", (Object)postReturnNodeInstance.getRouteNodeInstanceId(), (Object)((RouteNodeInstance)preReturnNodeInstance.getNextNodeInstances().iterator().next()).getRouteNodeInstanceId());
        Assert.assertEquals((String)"post node's previous node should be the pre node.", (Object)preReturnNodeInstance.getRouteNodeInstanceId(), (Object)((RouteNodeInstance)postReturnNodeInstance.getPreviousNodeInstances().iterator().next()).getRouteNodeInstanceId());
        actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        Assert.assertEquals((String)"There should be 3 requests.", (long)3L, (long)actionRequests.size());
        boolean isApproveToRkirkend = false;
        boolean isApproveToBmcgough = false;
        boolean isFyiToBmcgough = false;
        for (ActionRequestValue request : actionRequests) {
            String netId = this.getPrincipalNameForId(request.getPrincipalId());
            if (netId.equals("rkirkend")) {
                Assert.assertEquals((String)"Should be approve request.", (Object)"A", (Object)request.getActionRequested());
                isApproveToRkirkend = true;
                continue;
            }
            if (!netId.equals("bmcgough")) continue;
            if (request.getActionRequested().equals("A")) {
                isApproveToBmcgough = true;
                continue;
            }
            if (!request.getActionRequested().equals("F")) continue;
            isFyiToBmcgough = true;
        }
        Assert.assertTrue((boolean)isApproveToRkirkend);
        Assert.assertTrue((boolean)isApproveToBmcgough);
        Assert.assertTrue((boolean)isFyiToBmcgough);
    }

    @Test
    public void testReturnToPreviousApproverSequential() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"ReturnToPreviousWithSplitTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"pmckown should have approve.", (boolean)document.isApprovalRequested());
        KEWServiceLocator.getWorkflowDocumentService().superUserReturnDocumentToPreviousNode(this.getPrincipalIdByName("ewestfal"), document.getDocumentId(), "WorkflowDocument", "pmckown is sending it back to bmcgough", true);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Should be at WorkflowDocument.", (Object)"WorkflowDocument", document.getNodeNames().iterator().next());
        Assert.assertTrue((String)"bmcgough should have approve again.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"rkirkend should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertEquals((String)"Should be at WorkflowDocument2.", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"pmckown should have approve.", (boolean)document.isApprovalRequested());
    }

    @Test
    public void testReturnToPreviousParallel() throws Exception {
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName("BlanketApproveParallelTest");
        docType.setPostProcessorName(ReturnToPreviousPostProcessor.class.getName());
        KEWServiceLocator.getDocumentTypeService().save(docType);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"BlanketApproveParallelTest");
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        this.assertAtNodes(document.getDocumentId(), new String[]{"WorkflowDocument2-B1", "WorkflowDocument3-B2", "WorkflowDocument4-B3"});
        this.assertInBranches(document.getDocumentId(), new String[]{"B1", "B2", "B3"});
        this.assertAllBranchesSameParent(document.getDocumentId(), "PRIMARY");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("jitrue"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("jthomas"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        document.approve("");
        this.assertAtNodes(document.getDocumentId(), new String[]{"WorkflowDocument3-B1", "WorkflowDocument3-B2", "WorkflowDocument4-B3"});
        this.assertInBranches(document.getDocumentId(), new String[]{"B1", "B2", "B3"});
        this.assertAllBranchesSameParent(document.getDocumentId(), "PRIMARY");
        Assert.assertEquals((String)"Post processor should have transitioned 6 times.", (long)6L, (long)ReturnToPreviousPostProcessor.getRouteLevelChanges().size());
        ReturnToPreviousPostProcessor.clearRouteLevelChanges();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertFalse((String)"pmckown should not have an approve request", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("jitrue"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.returnToPreviousNode("", "WorkflowDocument2-B1");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be back to pmckown", (boolean)document.isApprovalRequested());
        Assert.assertEquals((String)"Post processor should have been notified.", (long)1L, (long)ReturnToPreviousPostProcessor.getRouteLevelChanges().size());
        DocumentRouteLevelChange levelChangeEvent = ReturnToPreviousPostProcessor.getRouteLevelChanges().get(0);
        Assert.assertEquals((String)"New node should be WorkflowDocument2-B1", (Object)"WorkflowDocument2-B1", (Object)levelChangeEvent.getNewNodeName());
        Assert.assertEquals((String)"Old node should be WorkflowDocument3-B1", (Object)"WorkflowDocument3-B1", (Object)levelChangeEvent.getOldNodeName());
    }

    private void assertAtNodes(String documentId, String[] nodeNames) {
        List activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(documentId);
        Assert.assertEquals((String)("There should be " + nodeNames.length + " active nodes."), (long)nodeNames.length, (long)activeNodeInstances.size());
        for (int index = 0; index < nodeNames.length; ++index) {
            String nodeName = nodeNames[index];
            boolean foundNode = false;
            for (RouteNodeInstance activeNodeInstance : activeNodeInstances) {
                if (!activeNodeInstance.getName().equals(nodeName)) continue;
                foundNode = true;
                break;
            }
            Assert.assertTrue((String)("Document is not currently at node " + nodeName), (boolean)foundNode);
        }
    }

    private void assertInBranches(String documentId, String[] branchNames) {
        List nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(documentId);
        boolean foundB1 = false;
        boolean foundB2 = false;
        boolean foundB3 = false;
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            if ("B1".equals(nodeInstance.getBranch().getName())) {
                foundB1 = true;
            }
            if ("B2".equals(nodeInstance.getBranch().getName())) {
                foundB2 = true;
            }
            if (!"B3".equals(nodeInstance.getBranch().getName())) continue;
            foundB3 = true;
        }
        Assert.assertTrue((String)"Not in Branch B1.", (boolean)foundB1);
        Assert.assertTrue((String)"Not in Branch B2.", (boolean)foundB2);
        Assert.assertTrue((String)"Not in Branch B3.", (boolean)foundB3);
    }

    private void assertAllBranchesSameParent(String documentId, String parentBranchName) {
        List nodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(documentId);
        for (RouteNodeInstance nodeInstance : nodeInstances) {
            String branchName = nodeInstance.getBranch().getParentBranch() == null ? null : nodeInstance.getBranch().getParentBranch().getName();
            Assert.assertTrue((String)("Parent branch should be '" + parentBranchName + "'."), (boolean)ObjectUtils.equals((Object)parentBranchName, (Object)branchName));
        }
    }

    @Test
    public void testReturnToPreviousFromFinalNode() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"BlanketApproveMandatoryNodeTest");
        document.blanketApprove("", new String[]{"WorkflowDocument2"});
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("Should be at ye old WorkflowDocument2 node.", document, "WorkflowDocument2");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be to pmckown.", (boolean)document.isApprovalRequested());
        List activeNodeInstances = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(document.getDocumentId());
        Assert.assertEquals((long)1L, (long)activeNodeInstances.size());
        RouteNodeInstance nodeInstance = (RouteNodeInstance)activeNodeInstances.get(0);
        Assert.assertTrue((String)"Active node instance should be a final approval node.", (boolean)nodeInstance.getRouteNode().getFinalApprovalInd());
        document.returnToPreviousNode("", "AdHoc");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("We should be at the AdHoc node.", document, "AdHoc");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("ewestfal"), (String)document.getDocumentId());
        document.blanketApprove("", new String[]{"WorkflowDocument2"});
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("Should be at ye old WorkflowDocument2 node.", document, "WorkflowDocument2");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be to pmckown.", (boolean)document.isApprovalRequested());
        document.returnToPreviousNode("", "WorkflowDocument");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("Should be at ye old WorkflowDocument node.", document, "WorkflowDocument");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have an approve.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have an approve.", (boolean)document.isApprovalRequested());
        document.blanketApprove("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
    }

    @Test
    public void testFinalApprovalNodeReturnToPrevious() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdByName("ewestfal"), (String)"BlanketApproveMandatoryNodeTest");
        document.route("");
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("Should be at the WorkflowDocument node.", document, "WorkflowDocument");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have an approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have an approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        TestUtilities.assertAtNodeNew("Document should be at WorkflowDocument2 node.", document, "WorkflowDocument2");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"pmckown should have approve and return to previous actions", (boolean)document.isApprovalRequested());
        document.returnToPreviousNode("", "WorkflowDocument");
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        TestUtilities.assertAtNodeNew("Should be at the old WorkflowDocument node.", document, "WorkflowDocument");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Bmcgough should have an approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Rkirkend should have an approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        TestUtilities.assertAtNodeNew("Document should be at WorkflowDocument2 node.", document, "WorkflowDocument2");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"pmckown should have approve and return to previous actions", (boolean)document.isApprovalRequested());
        document.returnToPreviousNode("", "AdHoc");
        TestUtilities.assertAtNodeNew("Document should be at the AdHoc node", document, "AdHoc");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("ewestfal"), (String)document.getDocumentId());
        document.blanketApprove("", new String[]{"WorkflowDocument2"});
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdByName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"pmckown should have approve.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
    }

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("ActionsConfig.xml");
    }

    public String getPrincipalIdByName(String principalName) {
        return KEWServiceLocator.getIdentityHelperService().getPrincipalByPrincipalName(principalName).getPrincipalId();
    }

    public static class ReturnToPreviousPostProcessor
    extends DefaultPostProcessor {
        private static List<DocumentRouteLevelChange> routeLevelChanges = new ArrayList<DocumentRouteLevelChange>();

        public ProcessDocReport doRouteLevelChange(DocumentRouteLevelChange levelChangeEvent) throws Exception {
            routeLevelChanges.add(levelChangeEvent);
            return new ProcessDocReport(true);
        }

        public static List<DocumentRouteLevelChange> getRouteLevelChanges() {
            return routeLevelChanges;
        }

        public static void clearRouteLevelChanges() {
            routeLevelChanges.clear();
        }
    }

    private class ParallelSetup {
        public static final String DOCUMENT_TYPE_NAME = "BlanketApproveParallelTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_B1_NODE = "WorkflowDocument2-B1";
        public static final String WORKFLOW_DOCUMENT_2_B2_NODE = "WorkflowDocument2-B2";
        public static final String WORKFLOW_DOCUMENT_3_B1_NODE = "WorkflowDocument3-B1";
        public static final String WORKFLOW_DOCUMENT_3_B2_NODE = "WorkflowDocument3-B2";
        public static final String WORKFLOW_DOCUMENT_4_B3_NODE = "WorkflowDocument4-B3";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";
        public static final String JOIN_NODE = "Join";
        public static final String SPLIT_NODE = "Split";

        private ParallelSetup() {
        }
    }

    private class SequentialWithSplitSetup {
        public static final String DOCUMENT_TYPE_NAME = "ReturnToPreviousWithSplitTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";

        private SequentialWithSplitSetup() {
        }
    }

    private class SequentialSetup {
        public static final String DOCUMENT_TYPE_NAME = "BlanketApproveSequentialTest";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private SequentialSetup() {
        }
    }
}

