/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.framework.support.krms;

import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaAttributeBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class KewToRulesEngineIntegrationTest
extends KEWTestCase {
    private static final String SIMPLE_DOCUMENT_TYPE = "RulesEngineIntegration-Simple";
    private static final String PEOPLE_FLOW_ID_ATTRIBUTE = "peopleFlowId";
    private static final String PEOPLE_FLOW_NAME_ATTRIBUTE = "peopleFlowName";
    private static final String EVENT_ATTRIBUTE = "Event";
    private DataObjectService dataObjectService;
    private RuleManagementService ruleManagementService;
    private KrmsAttributeDefinition peopleFlowIdAttributeDefinition;
    private KrmsAttributeDefinition peopleFlowNameAttributeDefinition;
    private KrmsTypeDefinition approvalPeopleFlowActionType;
    private RuleBo ruleBo;

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("KewToRulesEngineIntegrationTest.xml");
        this.dataObjectService = KRADServiceLocator.getDataObjectService();
        Assert.assertNotNull((Object)this.dataObjectService);
        this.ruleManagementService = (RuleManagementService)KrmsRepositoryServiceLocator.getService((String)"ruleManagementService");
        PeopleFlowDefinition peopleFlow = this.createFirstPeopleFlow();
        this.peopleFlowIdAttributeDefinition = this.createPeopleFlowIdAttributeDefinition();
        this.peopleFlowNameAttributeDefinition = this.createPeopleFlowNameAttributeDefinition();
        KrmsAttributeDefinitionBo eventAttributeDefinition = this.createEventAttributeDefinition();
        this.approvalPeopleFlowActionType = this.createApprovalPeopleFlowActionType(this.peopleFlowIdAttributeDefinition);
        this.ruleBo = this.createRule(this.approvalPeopleFlowActionType, this.peopleFlowIdAttributeDefinition, this.peopleFlowNameAttributeDefinition, peopleFlow.getId());
        ContextBo contextBo = this.createContext();
        this.createAgenda(this.ruleBo, contextBo, eventAttributeDefinition);
    }

    private PeopleFlowDefinition createFirstPeopleFlow() {
        String user1 = this.getPrincipalIdForName("user1");
        String user2 = this.getPrincipalIdForName("user2");
        String testWorkgroup = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        PeopleFlowDefinition.Builder peopleFlow = PeopleFlowDefinition.Builder.create((String)"TEST", (String)"PeopleFlow1");
        peopleFlow.addPrincipal(user1).setPriority(1);
        peopleFlow.addPrincipal(user2).setPriority(2);
        peopleFlow.addGroup(testWorkgroup).setPriority(3);
        return KewApiServiceLocator.getPeopleFlowService().createPeopleFlow(peopleFlow.build());
    }

    private KrmsAttributeDefinition createPeopleFlowIdAttributeDefinition() {
        return this.createPeopleFlowAttributeDefinition(PEOPLE_FLOW_ID_ATTRIBUTE, "PeopleFlow ID");
    }

    private KrmsAttributeDefinition createPeopleFlowNameAttributeDefinition() {
        return this.createPeopleFlowAttributeDefinition(PEOPLE_FLOW_NAME_ATTRIBUTE, "PeopleFlow Name");
    }

    private KrmsAttributeDefinition createPeopleFlowAttributeDefinition(String attribute, String label) {
        KrmsAttributeDefinitionService service = (KrmsAttributeDefinitionService)KrmsServiceLocatorInternal.getService((String)"krmsAttributeDefinitionService");
        Assert.assertNotNull((Object)service);
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace("KR-RULE");
        attributeDefinitionBo.setName(attribute);
        attributeDefinitionBo.setLabel(label);
        attributeDefinitionBo.setActive(true);
        attributeDefinitionBo = (KrmsAttributeDefinitionBo)this.dataObjectService.save((Object)attributeDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)attributeDefinitionBo.getId());
        return KrmsAttributeDefinitionBo.to((KrmsAttributeDefinitionBo)attributeDefinitionBo);
    }

    private KrmsTypeDefinition createApprovalPeopleFlowActionType(KrmsAttributeDefinition peopleFlowIdAttributeDefinition) {
        KrmsTypeRepositoryService krmsTypeRepositoryService = KrmsApiServiceLocator.getKrmsTypeRepositoryService();
        KrmsTypeDefinition.Builder typeDefinition = KrmsTypeDefinition.Builder.create((String)"KR-RULE", (String)"approvalPeopleFlowActionType");
        typeDefinition.setServiceName("approvalPeopleFlowActionTypeService");
        KrmsTypeAttribute.Builder attributeDefinition = KrmsTypeAttribute.Builder.create(null, (String)peopleFlowIdAttributeDefinition.getId(), (Integer)1);
        typeDefinition.getAttributes().add(attributeDefinition);
        KrmsTypeDefinition approvalPeopleFlowActionType = krmsTypeRepositoryService.createKrmsType(typeDefinition.build());
        Assert.assertNotNull((Object)approvalPeopleFlowActionType);
        Assert.assertNotNull((Object)approvalPeopleFlowActionType.getId());
        Assert.assertEquals((long)1L, (long)approvalPeopleFlowActionType.getAttributes().size());
        Assert.assertNotNull((Object)((KrmsTypeAttribute)approvalPeopleFlowActionType.getAttributes().get(0)).getId());
        Assert.assertEquals((Object)approvalPeopleFlowActionType.getId(), (Object)((KrmsTypeAttribute)approvalPeopleFlowActionType.getAttributes().get(0)).getTypeId());
        return approvalPeopleFlowActionType;
    }

    private RuleBo createRule(KrmsTypeDefinition actionType, KrmsAttributeDefinition peopleFlowIdAttributeDefinition, KrmsAttributeDefinition peopleFlowNameAttributeDefinition, String peopleFlowId) {
        RuleBo rule = new RuleBo();
        rule.setNamespace("TEST");
        rule.setName("PeopleFlowRule");
        ArrayList<ActionBo> actions = new ArrayList<ActionBo>();
        rule.setActions(actions);
        ActionBo peopleFlowAction = new ActionBo();
        actions.add(peopleFlowAction);
        peopleFlowAction.setNamespace("TEST");
        peopleFlowAction.setName("PeopleFlowApprovalAction");
        peopleFlowAction.setSequenceNumber(Integer.valueOf(1));
        peopleFlowAction.setTypeId(actionType.getId());
        ArrayList<ActionAttributeBo> actionAttributes = new ArrayList<ActionAttributeBo>();
        peopleFlowAction.setAttributeBos(actionAttributes);
        peopleFlowAction.setRule(rule);
        ActionAttributeBo actionAttribute = new ActionAttributeBo();
        actionAttributes.add(actionAttribute);
        actionAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)peopleFlowIdAttributeDefinition));
        actionAttribute.setValue(peopleFlowId);
        actionAttribute.setAction(peopleFlowAction);
        ActionAttributeBo actionNameAttribute = new ActionAttributeBo();
        actionAttributes.add(actionNameAttribute);
        actionNameAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)peopleFlowNameAttributeDefinition));
        actionNameAttribute.setValue(peopleFlowAction.getName() + " Name attr");
        actionNameAttribute.setAction(peopleFlowAction);
        KrmsTypeRepositoryService krmsTypeRepositoryService = KrmsApiServiceLocator.getKrmsTypeRepositoryService();
        KrmsTypeDefinition.Builder typeDefinition = KrmsTypeDefinition.Builder.create((String)"PeopleFlowRule Name", (String)"KR-RULE");
        typeDefinition.setServiceName("defaultRuleTypeService");
        KrmsTypeDefinition defaultRuleType = krmsTypeRepositoryService.createKrmsType(typeDefinition.build());
        Assert.assertNotNull((Object)defaultRuleType);
        Assert.assertNotNull((Object)defaultRuleType.getId());
        rule.setTypeId(defaultRuleType.getId());
        rule = (RuleBo)this.dataObjectService.save((Object)rule, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)rule.getId());
        Assert.assertEquals((long)1L, (long)rule.getActions().size());
        Assert.assertNotNull((Object)((ActionBo)rule.getActions().get(0)).getId());
        Assert.assertEquals((long)2L, (long)((ActionBo)rule.getActions().get(0)).getAttributeBos().size());
        return rule;
    }

    private ContextBo createContext() {
        KrmsTypeRepositoryService krmsTypeRepositoryService = KrmsApiServiceLocator.getKrmsTypeRepositoryService();
        KrmsTypeDefinition.Builder typeDefinition = KrmsTypeDefinition.Builder.create((String)"KR-RULE", (String)"DefaultContextType");
        KrmsTypeDefinition defaultContextType = krmsTypeRepositoryService.createKrmsType(typeDefinition.build());
        ContextBo contextBo = new ContextBo();
        contextBo.setNamespace("KR-RULE");
        contextBo.setName("MyContext");
        contextBo.setTypeId(defaultContextType.getId());
        ContextDefinition contextDefinition = this.ruleManagementService.getContextByNameAndNamespace("MyContext", "KR-RULE");
        if (contextDefinition == null) {
            return ContextBo.from((ContextDefinition)this.ruleManagementService.createContext(ContextBo.to((ContextBo)contextBo)));
        }
        this.ruleManagementService.updateContext(ContextBo.to((ContextBo)contextBo));
        return ContextBo.from((ContextDefinition)this.ruleManagementService.getContextByNameAndNamespace("MyContext", "KR-RULE"));
    }

    private KrmsAttributeDefinitionBo createEventAttributeDefinition() {
        KrmsAttributeDefinitionService service = (KrmsAttributeDefinitionService)KrmsServiceLocatorInternal.getService((String)"krmsAttributeDefinitionService");
        Assert.assertNotNull((Object)service);
        KrmsAttributeDefinitionBo attributeDefinitionBo = new KrmsAttributeDefinitionBo();
        attributeDefinitionBo.setNamespace("KR-RULE");
        attributeDefinitionBo.setName(EVENT_ATTRIBUTE);
        attributeDefinitionBo.setLabel(EVENT_ATTRIBUTE);
        attributeDefinitionBo.setActive(true);
        attributeDefinitionBo = (KrmsAttributeDefinitionBo)this.dataObjectService.save((Object)attributeDefinitionBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        Assert.assertNotNull((Object)attributeDefinitionBo.getId());
        return attributeDefinitionBo;
    }

    private AgendaBo createAgenda(RuleBo ruleBo, ContextBo contextBo, KrmsAttributeDefinitionBo eventAttributeDefinition) {
        AgendaBo agendaBo = new AgendaBo();
        agendaBo.setActive(true);
        agendaBo.setContextId(contextBo.getId());
        agendaBo.setName("MyAgenda");
        agendaBo.setTypeId(null);
        agendaBo = (AgendaBo)this.dataObjectService.save((Object)agendaBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        AgendaItemBo agendaItemBo = new AgendaItemBo();
        agendaItemBo.setRule(ruleBo);
        agendaItemBo.setAgendaId(agendaBo.getId());
        agendaItemBo = (AgendaItemBo)this.dataObjectService.save((Object)agendaItemBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        ArrayList<AgendaItemBo> agendaItems = new ArrayList<AgendaItemBo>();
        agendaItems.add(agendaItemBo);
        agendaBo.setItems(agendaItems);
        agendaBo.setFirstItemId(agendaItemBo.getId());
        agendaBo.setFirstItem(agendaItemBo);
        HashSet<AgendaAttributeBo> agendaAttributes = new HashSet<AgendaAttributeBo>();
        agendaBo.setAttributeBos(agendaAttributes);
        AgendaAttributeBo agendaAttribute = new AgendaAttributeBo();
        agendaAttributes.add(agendaAttribute);
        agendaAttribute.setAttributeDefinition(eventAttributeDefinition);
        agendaAttribute.setValue("workflow");
        agendaAttribute.setAgenda(agendaBo);
        agendaBo = (AgendaBo)this.dataObjectService.save((Object)agendaBo, new PersistenceOption[]{PersistenceOption.FLUSH});
        contextBo.getAgendas().add(agendaBo);
        return agendaBo;
    }

    @Test
    public void testSimpleKrmsPeopleFlowRules() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user3"), (String)SIMPLE_DOCUMENT_TYPE);
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        String user1 = this.getPrincipalIdForName("user1");
        String user2 = this.getPrincipalIdForName("user2");
        String ewestfal = this.getPrincipalIdForName("ewestfal");
        document.switchPrincipal(ewestfal);
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document.switchPrincipal(user2);
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document.switchPrincipal(user1);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        document.switchPrincipal(user2);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        document.switchPrincipal(ewestfal);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    @Test
    public void testMultipleKrmsPeopleFlowRules() throws Exception {
        this.addAnotherPeopleFlow(this.ruleBo);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user3"), (String)SIMPLE_DOCUMENT_TYPE);
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        String user1 = this.getPrincipalIdForName("user1");
        String user2 = this.getPrincipalIdForName("user2");
        String ewestfal = this.getPrincipalIdForName("ewestfal");
        document.switchPrincipal(ewestfal);
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document.switchPrincipal(user2);
        Assert.assertFalse((boolean)document.isApprovalRequested());
        document.switchPrincipal(user1);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((long)3L, (long)document.getRootActionRequests().size());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        document.switchPrincipal(user2);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        document.switchPrincipal(ewestfal);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((boolean)document.isEnroute());
        String testuser1 = this.getPrincipalIdForName("testuser1");
        document.switchPrincipal(testuser1);
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((long)4L, (long)document.getRootActionRequests().size());
        document.approve("");
        Assert.assertTrue((boolean)document.isFinal());
    }

    private void addAnotherPeopleFlow(RuleBo ruleBo) {
        String testuser1 = this.getPrincipalIdForName("testuser1");
        PeopleFlowDefinition.Builder peopleFlowBuilder = PeopleFlowDefinition.Builder.create((String)"TEST", (String)"PeopleFlow2");
        peopleFlowBuilder.addPrincipal(testuser1).setPriority(1);
        PeopleFlowDefinition peopleFlow = KewApiServiceLocator.getPeopleFlowService().createPeopleFlow(peopleFlowBuilder.build());
        ActionBo peopleFlowAction = new ActionBo();
        ruleBo.getActions().add(peopleFlowAction);
        peopleFlowAction.setNamespace("TEST");
        peopleFlowAction.setName("PeopleFlowApprovalAction2");
        peopleFlowAction.setSequenceNumber(Integer.valueOf(2));
        peopleFlowAction.setTypeId(this.approvalPeopleFlowActionType.getId());
        ArrayList<ActionAttributeBo> actionAttributes = new ArrayList<ActionAttributeBo>();
        peopleFlowAction.setAttributeBos(actionAttributes);
        peopleFlowAction.setRule(ruleBo);
        ActionAttributeBo actionAttribute = new ActionAttributeBo();
        actionAttributes.add(actionAttribute);
        actionAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)this.peopleFlowIdAttributeDefinition));
        actionAttribute.setValue(peopleFlow.getId());
        actionAttribute.setAction(peopleFlowAction);
        ActionAttributeBo actionNameAttribute = new ActionAttributeBo();
        actionAttributes.add(actionNameAttribute);
        actionNameAttribute.setAttributeDefinition(KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)this.peopleFlowNameAttributeDefinition));
        actionNameAttribute.setValue(peopleFlowAction.getName() + " Name attr");
        actionNameAttribute.setAction(peopleFlowAction);
        this.dataObjectService.save((Object)ruleBo, new PersistenceOption[]{PersistenceOption.FLUSH});
    }
}

