/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.kuali.rice.core.api.mail.EmailContent;
import org.kuali.rice.kew.actionitem.ActionItem;
import org.kuali.rice.kew.actionlist.ActionListFilter;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.mail.service.EmailContentService;
import org.kuali.rice.kew.rule.RuleTestUtils;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class EmailContentServiceTest
extends KEWTestCase {
    private static final Logger LOG = Logger.getLogger(EmailContentServiceTest.class);

    public void setUp() throws Exception {
        super.setUp();
        this.loadXmlFile("EmailContentServiceTestConfig.xml");
    }

    @Test
    public void testGroup() throws Exception {
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"EmailTestWorkgroupDocType");
        doc.route("");
        ActionListFilter actionListFilter = new ActionListFilter();
        actionListFilter.setDocumentType(doc.getDocumentTypeName());
        Collection actionItems = KEWServiceLocator.getActionListService().getActionList(ewestfalPrincipalId, actionListFilter);
        EmailContentService emailContentService = KEWServiceLocator.getEmailContentService();
        Person person = KimApiServiceLocator.getPersonService().getPerson(ewestfalPrincipalId);
        EmailContent emailContent = emailContentService.generateDailyReminder(person, (Collection)ActionItem.to(new ArrayList(actionItems)));
    }

    @Test
    public void testUserDelegator() throws Exception {
        RuleTestUtils.createDelegationToUser("EmailTestUserDocType", "WorkflowDocumentTemplate", "user1");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"EmailTestUserDocType");
        doc.route("");
        ActionListFilter actionListFilter = new ActionListFilter();
        actionListFilter.setDocumentType(doc.getDocumentTypeName());
        Collection actionItems = KEWServiceLocator.getActionListService().getActionList(user1PrincipalId, actionListFilter);
        EmailContentService emailContentService = KEWServiceLocator.getEmailContentService();
        Person person = KimApiServiceLocator.getPersonService().getPerson(user1PrincipalId);
        EmailContent emailContent = emailContentService.generateDailyReminder(person, (Collection)ActionItem.to(new ArrayList(actionItems)));
    }

    @Test
    public void testGroupDelegator() throws Exception {
        RuleTestUtils.createDelegationToGroup("EmailTestWorkgroupDocType", "WorkflowDocumentTemplate", "EmailTestDelegateWorkgroup");
        String user1PrincipalId = this.getPrincipalIdForName("user1");
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"EmailTestWorkgroupDocType");
        doc.route("");
        ActionListFilter actionListFilter = new ActionListFilter();
        actionListFilter.setDocumentType(doc.getDocumentTypeName());
        Collection actionItems = KEWServiceLocator.getActionListService().getActionList(user1PrincipalId, actionListFilter);
        EmailContentService emailContentService = KEWServiceLocator.getEmailContentService();
        Person person = KimApiServiceLocator.getPersonService().getPerson(user1PrincipalId);
        EmailContent emailContent = emailContentService.generateDailyReminder(person, (Collection)ActionItem.to(new ArrayList(actionItems)));
    }
}

