/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.mail;

import mocks.MockEmailNotificationService;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.preferences.Preferences;
import org.kuali.rice.kew.api.preferences.PreferencesContract;
import org.kuali.rice.kew.mail.EmailReminderLifecycle;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;

public class EmailReminderLifecycleTest
extends KEWTestCase {
    protected final Logger LOG = Logger.getLogger(((Object)((Object)this)).getClass());
    private static final String DEFAULT_EMAIL_CRON_WEEKLY = "0 0 2 ? * 2";
    private static final String DEFAULT_EMAIL_CRON_DAILY = "0 0 1 * * ?";
    private EmailReminderLifecycle emailReminderLifecycle;

    public void tearDown() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("dailyEmail.active", "false");
        ConfigContext.getCurrentContextConfig().putProperty("weeklyEmail.active", "false");
        super.tearDown();
    }

    @Test
    public void testDailyEmails() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("dailyEmail.cronExpression", "0/2 * * * * ?");
        ConfigContext.getCurrentContextConfig().putProperty("dailyEmail.active", "true");
        ConfigContext.getCurrentContextConfig().putProperty("weeklyEmail.active", "false");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        Preferences prefs = KewApiServiceLocator.getPreferencesService().getPreferences(ewestfalPrincipalId);
        Preferences.Builder builder = Preferences.Builder.create((PreferencesContract)prefs);
        builder.setEmailNotification("daily");
        KewApiServiceLocator.getPreferencesService().savePreferences(ewestfalPrincipalId, builder.build());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", ewestfalPrincipalId, "", Boolean.TRUE.booleanValue());
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        int emailsSent = this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A");
        Assert.assertEquals((String)"ewestfal should have no emails.", (long)0L, (long)emailsSent);
        this.emailReminderLifecycle = new EmailReminderLifecycle();
        this.LOG.info((Object)"testDailyEmails(): Starting EmailReminderLifeCycle");
        this.emailReminderLifecycle.start();
        Thread.sleep(10000L);
        Assert.assertTrue((String)"daily reminder should have been called.", (boolean)this.getMockEmailService().wasDailyReminderSent());
        this.LOG.info((Object)"testDailyEmails(): Stopping EmailReminderLifeCycle");
        this.emailReminderLifecycle.stop();
        ConfigContext.getCurrentContextConfig().putProperty("dailyEmail.cronExpression", DEFAULT_EMAIL_CRON_DAILY);
        this.emailReminderLifecycle.start();
        this.emailReminderLifecycle.stop();
    }

    @Test
    public void testWeeklyEmails() throws Exception {
        ConfigContext.getCurrentContextConfig().putProperty("weeklyEmail.cronExpression", "0/2 * * * * ?");
        ConfigContext.getCurrentContextConfig().putProperty("weeklyEmail.active", "true");
        ConfigContext.getCurrentContextConfig().putProperty("dailyEmail.active", "false");
        String ewestfalPrincipalId = this.getPrincipalIdForName("ewestfal");
        String rkirkendPrincipalId = this.getPrincipalIdForName("rkirkend");
        Preferences prefs = KewApiServiceLocator.getPreferencesService().getPreferences(ewestfalPrincipalId);
        Preferences.Builder builder = Preferences.Builder.create((PreferencesContract)prefs);
        builder.setEmailNotification("weekly");
        KewApiServiceLocator.getPreferencesService().savePreferences(ewestfalPrincipalId, builder.build());
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)rkirkendPrincipalId, (String)"TestDocumentType");
        document.adHocToPrincipal(ActionRequestType.APPROVE, "", ewestfalPrincipalId, "", Boolean.TRUE.booleanValue());
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)ewestfalPrincipalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        int emailsSent = this.getMockEmailService().immediateReminderEmailsSent("ewestfal", document.getDocumentId(), "A");
        Assert.assertEquals((String)"ewestfal should have no emails.", (long)0L, (long)emailsSent);
        this.emailReminderLifecycle = new EmailReminderLifecycle();
        this.LOG.info((Object)"testWeeklyEmails(): Starting EmailReminderLifeCycle");
        this.emailReminderLifecycle.start();
        Assert.assertTrue((String)"EmailReminderLifecycle should have been started", (boolean)this.emailReminderLifecycle.isStarted());
        Thread.sleep(10000L);
        Assert.assertTrue((String)"weekly reminder should have been called.", (boolean)this.getMockEmailService().wasWeeklyReminderSent());
        this.LOG.info((Object)"testWeeklyEmails(): Stopping EmailReminderLifeCycle");
        this.emailReminderLifecycle.stop();
        ConfigContext.getCurrentContextConfig().putProperty("weeklyEmail.cronExpression", DEFAULT_EMAIL_CRON_WEEKLY);
        this.emailReminderLifecycle.start();
        this.emailReminderLifecycle.stop();
    }

    private MockEmailNotificationService getMockEmailService() {
        return (MockEmailNotificationService)KEWServiceLocator.getActionListEmailService();
    }
}

