/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes;

import java.io.FileReader;
import java.io.InputStream;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.Note;
import org.kuali.rice.kew.notes.service.NoteService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.springframework.core.io.Resource;

public class NoteServiceTest
extends KEWTestCase {
    @Test
    public void testAttachmentSave() throws Exception {
        int data;
        int c;
        Note note = new Note();
        note.setNoteAuthorWorkflowId("fakeyUser");
        note.setDocumentId("2");
        note.setNoteCreateDate(new Timestamp(new Date().getTime()));
        note.setNoteText("i like notes");
        Attachment attachment = new Attachment();
        attachment.setNote(note);
        attachment.setMimeType("mimeType");
        attachment.setFileName("attachedFile.txt");
        attachment.setAttachedObject(TestUtilities.loadResource(((Object)((Object)this)).getClass(), "attachedFile.txt"));
        note.getAttachments().add(attachment);
        NoteService noteService = KEWServiceLocator.getNoteService();
        note = noteService.saveNote(note);
        KRADServiceLocator.getDataObjectService().flush(Note.class);
        attachment = (Attachment)note.getAttachments().get(0);
        Assert.assertNotNull((String)"Note should have a id", (Object)note.getNoteId());
        Assert.assertNotNull((String)"Note should have a version number", (Object)note.getLockVerNbr());
        Assert.assertNotNull((String)"Attachment should have a id", (Object)attachment.getAttachmentId());
        Assert.assertNotNull((String)"Attachment should have version number", (Object)attachment.getLockVerNbr());
        Assert.assertNotNull((String)"Attachment file loc should reflect file system location", (Object)attachment.getFileLoc());
        FileReader fileReader = new FileReader(noteService.findAttachmentFile(attachment));
        StringWriter stringWriter = new StringWriter();
        while ((c = fileReader.read()) != -1) {
            stringWriter.write(c);
        }
        Assert.assertEquals((String)"Attached file content should equal source file content", (Object)"I'm an attached file", (Object)stringWriter.getBuffer().toString());
        Resource resource = noteService.findAttachmentResource(attachment);
        InputStream inputStream = resource.getInputStream();
        stringWriter = new StringWriter();
        while ((data = inputStream.read()) != -1) {
            stringWriter.write(data);
        }
        Assert.assertEquals((String)"Attached file content should equal source file content", (Object)"I'm an attached file", (Object)stringWriter.getBuffer().toString());
    }
}

