/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.routeheader;

import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.AdHocToPrincipal;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.document.Document;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.impl.document.WorkflowDocumentPrototype;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.DocumentStatusTransition;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.KRADUtils;

public class AppDocStatusTest
extends KEWTestCase {
    @Override
    protected void loadTestData() throws Exception {
        super.loadTestData();
        this.loadXmlFile("AppDocStatusTestConfig.xml");
    }

    @Test
    public void testValidAppDocStatus() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc2");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        document.route("Test Routing.");
        String appDocStatus = document.getDocument().getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Approval in Progress".equalsIgnoreCase(appDocStatus));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        Set nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertTrue((String)"Wrong node name.", (boolean)document.getNodeNames().contains("DestinationApproval"));
        List requests = document.getRootActionRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        ActionRequest request = (ActionRequest)requests.get(0);
        Assert.assertEquals((Object)this.getPrincipalIdForName("bmcgough"), (Object)request.getPrincipalId());
        Assert.assertEquals((Object)ActionRequestType.APPROVE, (Object)request.getActionRequested());
        Assert.assertEquals((Object)"DestinationApproval", (Object)request.getNodeName());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("Test approve by bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        Document rh = document.getDocument();
        appDocStatus = rh.getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Submitted".equalsIgnoreCase(appDocStatus));
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertTrue((String)"Wrong node name.", (boolean)nodeNames.contains("TravelerApproval"));
        document.approve("Test approve by temay");
        document.setApplicationDocumentStatus("Completed");
        document.saveDocumentData();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        rh = document.getDocument();
        appDocStatus = rh.getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Completed".equalsIgnoreCase(appDocStatus));
        List history = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatusTransitionHistory(document.getDocumentId());
        Assert.assertEquals((long)3L, (long)history.size());
        Assert.assertTrue((String)"First History record has incorrect status", (boolean)"Approval In Progress".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(0)).getNewStatus()));
        Assert.assertTrue((String)"Second History record has incorrect old status", (boolean)"Approval In Progress".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(1)).getOldStatus()));
        Assert.assertTrue((String)"Second History record has incorrect new status", (boolean)"Submitted".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(1)).getNewStatus()));
        Assert.assertTrue((String)"Third History record has incorrect old status", (boolean)"Submitted".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(2)).getOldStatus()));
        Assert.assertTrue((String)"Third History record has incorrect new status", (boolean)"Completed".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(2)).getNewStatus()));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
    }

    @Test
    public void testAppDocStatusValuesNotDefined() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc1");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        document.route("Test Routing.");
        Document rh = document.getDocument();
        String appDocStatus = rh.getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Approval in Progress".equalsIgnoreCase(appDocStatus));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        Set nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertTrue((String)"Wrong node name.", (boolean)nodeNames.contains("step1"));
        List requests = document.getRootActionRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        ActionRequest request = (ActionRequest)requests.get(0);
        Assert.assertEquals((Object)this.getPrincipalIdForName("bmcgough"), (Object)request.getPrincipalId());
        Assert.assertEquals((Object)ActionRequestType.APPROVE, (Object)request.getActionRequested());
        Assert.assertEquals((Object)"step1", (Object)request.getNodeName());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("Test approve by bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        rh = document.getDocument();
        appDocStatus = rh.getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Submitted".equalsIgnoreCase(appDocStatus));
        Assert.assertTrue((String)"Document should be enroute", (boolean)document.isEnroute());
        nodeNames = document.getNodeNames();
        Assert.assertEquals((String)"Wrong number of node names.", (long)1L, (long)nodeNames.size());
        Assert.assertTrue((String)"Wrong node name.", (boolean)nodeNames.contains("step2"));
        document.approve("Test approve by temay");
        document.setApplicationDocumentStatus("Some Random Value");
        document.saveDocumentData();
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        rh = document.getDocument();
        appDocStatus = rh.getApplicationDocumentStatus();
        Assert.assertTrue((String)("Application Document Status:" + appDocStatus + " is invalid"), (boolean)"Some Random Value".equalsIgnoreCase(appDocStatus));
        List history = KewApiServiceLocator.getWorkflowDocumentService().getDocumentStatusTransitionHistory(document.getDocumentId());
        Assert.assertEquals((long)3L, (long)history.size());
        Assert.assertTrue((String)"First History record has incorrect status", (boolean)"Approval In Progress".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(0)).getNewStatus()));
        Assert.assertTrue((String)"Second History record has incorrect old status", (boolean)"Approval In Progress".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(1)).getOldStatus()));
        Assert.assertTrue((String)"Second History record has incorrect new status", (boolean)"Submitted".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(1)).getNewStatus()));
        Assert.assertTrue((String)"Third History record has incorrect old status", (boolean)"Submitted".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(2)).getOldStatus()));
        Assert.assertTrue((String)"Third History record has incorrect new status", (boolean)"Some Random Value".equalsIgnoreCase(((org.kuali.rice.kew.api.document.DocumentStatusTransition)history.get(2)).getNewStatus()));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be final.", (boolean)document.isFinal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidAppDocStatusValue() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc2");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        boolean gotException = false;
        try {
            document.setApplicationDocumentStatus("BAD STATUS");
            document.saveDocumentData();
        }
        catch (Throwable t) {
            gotException = true;
            WorkflowRuntimeException ex = new WorkflowRuntimeException();
            Assert.assertEquals((String)"WrongExceptionType", t.getClass(), ex.getClass());
        }
        finally {
            Assert.assertTrue((String)"Expected WorkflowRuntimeException not thrown.", (boolean)gotException);
        }
    }

    @Test
    public void testValidInheritedAppDocStatus() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc3");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestAppDocStatusDoc3");
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType));
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getValidApplicationStatuses()));
        Assert.assertEquals((long)6L, (long)documentType.getValidApplicationStatuses().size());
        this.LOG.info((Object)("valid application status size: " + documentType.getValidApplicationStatuses().size()));
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getApplicationStatusCategories()));
        Assert.assertEquals((long)0L, (long)documentType.getApplicationStatusCategories().size());
    }

    @Test
    public void testValidInheritedAppDocStatusWithCategories() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc5");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestAppDocStatusDoc5");
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType));
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getValidApplicationStatuses()));
        this.LOG.info((Object)("valid application status size: " + documentType.getValidApplicationStatuses().size()));
        Assert.assertEquals((long)6L, (long)documentType.getValidApplicationStatuses().size());
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getApplicationStatusCategories()));
        Assert.assertEquals((long)2L, (long)documentType.getApplicationStatusCategories().size());
    }

    @Test
    public void testInheritedAppDocStatusWithKEWStatus() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"TestAppDocStatusDoc6");
        document.saveDocumentData();
        Assert.assertNotNull((Object)document.getDocumentId());
        Assert.assertTrue((String)"Document should be initiatied", (boolean)document.isInitiated());
        Assert.assertTrue((String)"Invalid route level.", (boolean)document.getNodeNames().contains("Initiated"));
        DocumentType documentType = KEWServiceLocator.getDocumentTypeService().findByName("TestAppDocStatusDoc6");
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType));
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getValidApplicationStatuses()));
        Assert.assertEquals((long)0L, (long)documentType.getValidApplicationStatuses().size());
        this.LOG.info((Object)("valid application status size: " + documentType.getValidApplicationStatuses().size()));
        Assert.assertTrue((boolean)KRADUtils.isNotNull((Object)documentType.getApplicationStatusCategories()));
        Assert.assertEquals((long)0L, (long)documentType.getApplicationStatusCategories().size());
    }

    @Test
    public void testSearching() throws InterruptedException {
        String documentTypeName = "TestAppDocStatusDoc1";
        String initiatorNetworkId = "rkirkend";
        Person initiator = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(initiatorNetworkId);
        String approverNetworkId = "bmcgough";
        Person approver = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(approverNetworkId);
        String travelerNetworkId = "temay";
        Person traveler = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(travelerNetworkId);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)initiator.getPrincipalId(), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        this.assertAppDocStatuses(workflowDocument.getDocumentId(), new String[0]);
        this.assertSearchStatus(documentTypeName, initiator, "Approval in Progress", 0, 0L);
        this.assertSearchStatus(documentTypeName, initiator, "Submitted", 0, 0L);
        workflowDocument.route("routing this document.");
        DocumentRouteHeaderValue drhv = KEWServiceLocator.getRouteHeaderService().getRouteHeader(workflowDocument.getDocumentId());
        this.assertAppDocStatuses(workflowDocument.getDocumentId(), new String[]{"Approval in Progress"});
        this.assertSearchStatus(documentTypeName, initiator, "Approval in Progress", 1, 0L);
        this.assertSearchStatus(documentTypeName, initiator, "Approval in Progress", 1, drhv.getRouteStatusDate().getTime());
        this.assertSearchStatus(documentTypeName, initiator, "Submitted", 0, 0L);
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)approver.getPrincipalId(), (String)workflowDocument.getDocumentId());
        RequestedActions actions = workflowDocument.getRequestedActions();
        Assert.assertTrue((boolean)actions.isApproveRequested());
        workflowDocument.approve("destination approval");
        this.assertAppDocStatuses(workflowDocument.getDocumentId(), new String[]{"Approval in Progress", "Submitted"});
        this.assertSearchStatus(documentTypeName, approver, "Approval in Progress", 0, 0L);
        this.assertSearchStatus(documentTypeName, approver, "Approval in Progress", 1, drhv.getRouteStatusDate().getTime());
        this.assertSearchStatus(documentTypeName, approver, "Submitted", 1, 0L);
        this.assertSearchStatus(documentTypeName, approver, "Submitted", 1, drhv.getDateLastModified().getMillis());
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)traveler.getPrincipalId(), (String)workflowDocument.getDocumentId());
        actions = workflowDocument.getRequestedActions();
        Assert.assertTrue((boolean)actions.isApproveRequested());
        workflowDocument.approve("travel approval");
        this.assertAppDocStatuses(workflowDocument.getDocumentId(), new String[]{"Approval in Progress", "Submitted"});
        this.assertSearchStatus(documentTypeName, traveler, "Approval in Progress", 0, 0L);
        this.assertSearchStatus(documentTypeName, traveler, "Approval in Progress", 1, drhv.getRouteStatusDate().getTime());
        this.assertSearchStatus(documentTypeName, traveler, "Submitted", 1, 0L);
        this.assertSearchStatus(documentTypeName, traveler, "Submitted", 1, drhv.getDateLastModified().getMillis());
    }

    @Test
    public void testAppDocResetAfterAdHoc() throws Exception {
        String documentTypeName = "TestAppDocStatusDoc1";
        String initiatorNetworkId = "rkirkend";
        String approverNetworkId = "bmcgough";
        String travelerNetworkId = "temay";
        Person initiator = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(initiatorNetworkId);
        Person approver = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(approverNetworkId);
        Person traveler = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(travelerNetworkId);
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)initiator.getPrincipalId(), (String)documentTypeName);
        workflowDocument.setTitle("Routing style");
        workflowDocument.route("routing this document.");
        this.assertAppDocStatuses(workflowDocument.getDocumentId(), new String[]{"Approval in Progress"});
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)approver.getPrincipalId(), (String)workflowDocument.getDocumentId());
        Document staleWorkflowDocument = KewApiServiceLocator.getWorkflowDocumentService().getDocument(workflowDocument.getDocumentId());
        Assert.assertEquals((String)("app doc status incorrect before final approval: " + staleWorkflowDocument), (Object)"Approval in Progress", (Object)staleWorkflowDocument.getApplicationDocumentStatus());
        RequestedActions actions = workflowDocument.getRequestedActions();
        Assert.assertTrue((boolean)actions.isApproveRequested());
        workflowDocument.approve("destination approval");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)traveler.getPrincipalId(), (String)workflowDocument.getDocumentId());
        Assert.assertEquals((String)"current app doc status incorrect after 1st approval", (Object)"Submitted", (Object)workflowDocument.getApplicationDocumentStatus());
        actions = workflowDocument.getRequestedActions();
        Assert.assertTrue((boolean)actions.isApproveRequested());
        workflowDocument.approve("travel approval");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)traveler.getPrincipalId(), (String)workflowDocument.getDocumentId());
        Assert.assertEquals((String)"app doc status in 'stale' WorkflowDocument retrieved before approval should still have original status", (Object)"Approval in Progress", (Object)staleWorkflowDocument.getApplicationDocumentStatus());
        Document newWorkflowDocument = KewApiServiceLocator.getWorkflowDocumentService().getDocument(workflowDocument.getDocumentId());
        Assert.assertEquals((String)"current API app doc status incorrect after 2nd approval", (Object)"Submitted", (Object)newWorkflowDocument.getApplicationDocumentStatus());
        WorkflowDocumentPrototype prototype = KEWServiceLocator.getWorkflowDocumentPrototype();
        prototype.init(traveler.getPrincipalId(), staleWorkflowDocument);
        prototype.setTitle(prototype.getTitle());
        prototype.adHocToPrincipal(AdHocToPrincipal.Builder.create((ActionRequestType)ActionRequestType.FYI, null, (String)initiator.getPrincipalId()).build(), "FYI to initiator");
        workflowDocument = WorkflowDocumentFactory.loadDocument((String)traveler.getPrincipalId(), (String)workflowDocument.getDocumentId());
        Assert.assertEquals((String)"current app doc status incorrect after adhoc", (Object)"Submitted", (Object)workflowDocument.getApplicationDocumentStatus());
    }

    protected void assertSearchStatus(String documentTypeName, Person user, String appDocStatus, int expected, long changed) {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setApplicationDocumentStatus(appDocStatus);
        if (changed != 0L) {
            criteria.setDateApplicationDocumentStatusChangedFrom(new DateTime(changed - 200L));
            criteria.setDateApplicationDocumentStatusChangedTo(new DateTime(changed + 200L));
        }
        DocumentSearchResults results = KEWServiceLocator.getDocumentSearchService().lookupDocuments(user.getPrincipalId(), criteria.build());
        Assert.assertEquals((String)("Search results should have " + expected + " documents."), (long)expected, (long)results.getSearchResults().size());
    }

    protected void assertAppDocStatuses(String documentId, String[] appDocStatuses) {
        DocumentRouteHeaderValue drhv = KEWServiceLocator.getRouteHeaderService().getRouteHeader(documentId);
        String curStatus = KewApiConstants.UNKNOWN_STATUS;
        if (appDocStatuses.length > 0) {
            curStatus = appDocStatuses[appDocStatuses.length - 1];
        }
        Assert.assertEquals((Object)curStatus, (Object)drhv.getAppDocStatus());
        List transitions = drhv.getAppDocStatusHistory();
        Assert.assertEquals((long)appDocStatuses.length, (long)transitions.size());
        for (int i = 0; i < appDocStatuses.length; ++i) {
            DocumentStatusTransition trans = (DocumentStatusTransition)transitions.get(i);
            Assert.assertEquals((Object)appDocStatuses[i], (Object)trans.getNewAppDocStatus());
            String prevStatus = null;
            if (i > 0) {
                prevStatus = appDocStatuses[i - 1];
            }
            Assert.assertEquals(prevStatus, (Object)trans.getOldAppDocStatus());
        }
    }
}

