/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.server;

import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.coreservice.api.parameter.Parameter;
import org.kuali.rice.coreservice.api.parameter.ParameterContract;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.KewApiConstants;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionItem;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.RequestedActions;
import org.kuali.rice.kew.api.action.RoutingReportActionToTake;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.api.rule.Rule;
import org.kuali.rice.kew.api.rule.RuleReportCriteria;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleService;
import org.kuali.rice.kew.docsearch.DocumentSearchInternalUtils;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeDateTime;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeFloat;
import org.kuali.rice.kew.docsearch.TestXMLSearchableAttributeLong;
import org.kuali.rice.kew.server.TestSplitNode;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kew.test.KEWTestCase;
import org.kuali.rice.kew.test.TestUtilities;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class WorkflowUtilityTest
extends KEWTestCase {
    private static Logger LOG = Logger.getLogger(WorkflowUtilityTest.class);

    @Override
    protected void loadTestData() throws Exception {
        this.loadXmlFile("WorkflowUtilityConfig.xml");
    }

    @Test
    public void testGetDocumentDetailByAppId() throws WorkflowException {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.setApplicationDocumentId("123456789");
        document.route("");
        WorkflowDocumentService documentService = KewApiServiceLocator.getWorkflowDocumentService();
        DocumentDetail doc = documentService.getDocumentDetailByAppId("SeqDocType", "123456789");
        Assert.assertNotNull((Object)doc);
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.setApplicationDocumentId("123456789");
        document.route("");
        try {
            documentService.getDocumentDetailByAppId("SeqDocType", "123456789");
            Assert.assertTrue((boolean)false);
        }
        catch (RiceIllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            documentService.getDocumentDetailByAppId("notExist", "wrong");
            Assert.assertTrue((boolean)false);
        }
        catch (RiceIllegalStateException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            documentService.getDocumentDetailByAppId("notExist", null);
            Assert.assertTrue((boolean)false);
        }
        catch (RiceIllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            documentService.getDocumentDetailByAppId(null, null);
            Assert.assertTrue((boolean)false);
        }
        catch (RiceIllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testGetActionsRequested() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.route("");
        this.assertActionsRequested("ewestfal", document.getDocumentId(), false);
        this.assertActionsRequested("bmcgough", document.getDocumentId(), true);
        this.assertActionsRequested("rkirkend", document.getDocumentId(), true);
    }

    protected void assertActionsRequested(String principalName, String documentId, boolean shouldHaveRequest) throws Exception {
        RequestedActions attrSet = KewApiServiceLocator.getWorkflowDocumentActionsService().determineRequestedActions(documentId, this.getPrincipalIdForName(principalName));
        Assert.assertNotNull((String)"Actions requested should be populated", (Object)attrSet);
        if (shouldHaveRequest) {
            Assert.assertTrue((String)"Actions requested should be populated with at least one entry", (!attrSet.getRequestedActions().isEmpty() ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"Principal should have no requests", (boolean)attrSet.getRequestedActions().isEmpty());
        }
    }

    @Test
    public void testIsUserInRouteLog() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("temay"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("temay"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.saveDocument("");
        Assert.assertTrue((boolean)document.isSaved());
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("temay"), false));
        Assert.assertFalse((String)"User should not be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("temay"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
    }

    @Test
    public void testIsUserInRouteLogAfterReturnToPrevious() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertFalse((String)"User should NOT be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        document.returnToPreviousNode("", "AdHoc");
        TestUtilities.assertAtNode(document, "AdHoc");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertFalse((String)"User should NOT be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
        List revokedNodeInstances = KEWServiceLocator.getRouteNodeService().getRevokedNodeInstances(KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId()));
        Assert.assertNotNull((Object)revokedNodeInstances);
        Assert.assertEquals((long)2L, (long)revokedNodeInstances.size());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        TestUtilities.assertAtNode(document, "WorkflowDocument2");
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
        document.returnToPreviousNode("", "WorkflowDocument");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertFalse((String)"User should NOT be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), false));
        Assert.assertTrue((String)"User should be authenticated.", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), true));
    }

    @Test
    public void testIsUserInRouteLogWithSplits() throws Exception {
        this.loadXmlFile("WorkflowUtilitySplitConfig.xml");
        TestSplitNode.setLeftBranch(true);
        TestSplitNode.setRightBranch(true);
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("admin"), (String)"UserInRouteLog_Split");
        document.route("");
        document = TestUtilities.switchByPrincipalName("ewestfal", document);
        Assert.assertTrue((String)"should have approve", (boolean)document.isApprovalRequested());
        TestUtilities.assertAtNode(document, "BeforeSplit");
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("natjohns"), true));
        Assert.assertFalse((String)"should NOT be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("user1"), true));
        TestSplitNode.setRightBranch(false);
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertFalse((String)"should NOT be in route log because right branch is not active", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("natjohns"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLogWithOptionalFlattening(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true, true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLogWithOptionalFlattening(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true, true));
        Assert.assertTrue((String)"should be in route log because we've flattened nodes", (boolean)wdas.isUserInRouteLogWithOptionalFlattening(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true, true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLogWithOptionalFlattening(document.getDocumentId(), this.getPrincipalIdForName("natjohns"), true, true));
        TestSplitNode.setRightBranch(true);
        TestSplitNode.setLeftBranch(false);
        Assert.assertFalse((String)"should NOT be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertFalse((String)"should NOT be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("natjohns"), true));
        TestSplitNode.setLeftBranch(true);
        TestSplitNode.setRightBranch(false);
        document.approve("");
        TestUtilities.assertAtNode(document, "SplitLeft1");
        document = TestUtilities.switchByPrincipalName("rkirkend", document);
        Assert.assertTrue((String)"should have an approve request", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), true));
        Assert.assertFalse((String)"should NOT be in route log because right branch is not active", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("jhopf"), true));
        Assert.assertTrue((String)"should be in route log", (boolean)wdas.isUserInRouteLog(document.getDocumentId(), this.getPrincipalIdForName("natjohns"), true));
    }

    @Test
    public void testDocumentWillHaveApproveOrCompleteRequestAtNode_DocumentId() throws Exception {
        this.runDocumentWillHaveApproveOrCompleteRequestAtNode("SeqDocType", new ReportCriteriaGeneratorUsingDocumentId());
    }

    @Test
    public void testDocumentWillHaveApproveOrCompleteRequestAtNode_XmlContent() throws Exception {
        this.runDocumentWillHaveApproveOrCompleteRequestAtNode("SeqDocType", new ReportCriteriaGeneratorUsingXML());
    }

    @Test
    public void testDocumentWillHaveApproveOrCompleteRequestAtNode_ForceAction_DocumentId() throws Exception {
        this.runDocumentWillHaveApproveOrCompleteRequestAtNode_ForceAction("SimulationTestDocumenType_ForceAction", new ReportCriteriaGeneratorUsingDocumentId());
    }

    @Test
    public void testDocumentWillHaveApproveOrCompleteRequestAtNode_ForceAction_XmlContent() throws Exception {
        this.runDocumentWillHaveApproveOrCompleteRequestAtNode_ForceAction("SimulationTestDocumenType_ForceAction", new ReportCriteriaGeneratorUsingXML());
    }

    private void runDocumentWillHaveApproveOrCompleteRequestAtNode_ForceAction(String documentType, ReportCriteriaGenerator generator) throws Exception {
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)documentType);
        RoutingReportCriteria.Builder builder = RoutingReportCriteria.Builder.createByDocumentId((String)doc.getDocumentId());
        builder.setXmlContent(doc.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument2");
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("bmcgough"));
        Assert.assertTrue((String)"Document should have at least one unfulfilled approve/complete request", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder.setTargetPrincipalIds(Collections.singletonList(this.getPrincipalIdForName("bmcgough")));
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)doc.getDocumentId());
        builder.setXmlContent(doc.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument4");
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("bmcgough"));
        ArrayList<RoutingReportActionToTake.Builder> actionsToTake = new ArrayList<RoutingReportActionToTake.Builder>();
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("rkirkend"), (String)"WorkflowDocument3"));
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("jitrue"), (String)"WorkflowDocument4"));
        builder.setActionsToTake(actionsToTake);
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)doc.getDocumentId());
        builder.setXmlContent(doc.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument4");
        actionsToTake = new ArrayList();
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("rkirkend"), (String)"WorkflowDocument3"));
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("jitrue"), (String)"WorkflowDocument4"));
        builder.setActionsToTake(actionsToTake);
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)documentType);
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("rkirkend"));
        builder.setTargetNodeName("WorkflowDocument");
        Assert.assertFalse((String)"Document should not have any approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("rkirkend"));
        builder.setTargetNodeName("WorkflowDocument2");
        Assert.assertFalse((String)"Document should not have any approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("rkirkend"));
        builder.setTargetPrincipalIds(Collections.singletonList(this.getPrincipalIdForName("rkirkend")));
        Assert.assertFalse((String)"Document should not have any approve/complete requests for user rkirkend", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        document.route("");
        Assert.assertEquals((String)"Document should be enroute", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
        Assert.assertEquals((String)"Document route node is incorrect", (Object)"WorkflowDocument3", document.getNodeNames().iterator().next());
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument4");
        Assert.assertTrue((String)"At least one unfulfilled approve/complete request should have been generated", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetPrincipalIds(Collections.singletonList(this.getPrincipalIdForName("rkirkend")));
        Assert.assertTrue((String)"At least one unfulfilled approve/complete request should have been generated for rkirkend", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument4");
        Assert.assertTrue((String)"At least one unfulfilled approve/complete request should have been generated", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertEquals((String)"Document should be enroute", (Object)DocumentStatus.ENROUTE, (Object)document.getStatus());
        Assert.assertEquals((String)"Document route node is incorrect", (Object)"WorkflowDocument4", document.getNodeNames().iterator().next());
    }

    private void runDocumentWillHaveApproveOrCompleteRequestAtNode(String documentType, ReportCriteriaGenerator generator) throws Exception {
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)documentType);
        RoutingReportCriteria.Builder builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument2");
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("bmcgough"));
        Assert.assertTrue((String)"Document should have one unfulfilled approve/complete request", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder.setTargetPrincipalIds(Collections.singletonList(this.getPrincipalIdForName("bmcgough")));
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument2");
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("bmcgough"));
        ArrayList<RoutingReportActionToTake.Builder> actionsToTake = new ArrayList<RoutingReportActionToTake.Builder>();
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("pmckown"), (String)"WorkflowDocument2"));
        builder.setActionsToTake(actionsToTake);
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument2");
        actionsToTake = new ArrayList();
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("bmcgough"), (String)"WorkflowDocument"));
        actionsToTake.add(RoutingReportActionToTake.Builder.create((String)"A", (String)this.getPrincipalIdForName("rkirkend"), (String)"WorkflowDocument"));
        builder.setActionsToTake(actionsToTake);
        builder.setRoutingPrincipalId(this.getPrincipalIdForName("pmckown"));
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)documentType);
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("WorkflowDocument2");
        Assert.assertTrue((String)"Document should have one unfulfilled approve/complete request", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((boolean)document.isProcessed());
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("Acknowledge1");
        Assert.assertFalse((String)"Document should not have any unfulfilled approve/complete requests when in processed status", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("A", "C"), false));
        builder = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId());
        builder.setXmlContent(document.getDocumentContent().getApplicationContent());
        builder.setTargetNodeName("Acknowledge1");
        Assert.assertTrue((String)"Document should have one unfulfilled Ack request when in final status", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("K"), false));
        if (generator.isCriteriaRouteHeaderBased()) {
            Assert.assertFalse((String)"Document should have no unfulfilled Ack request generated when in final status", (boolean)wdas.documentWillHaveAtLeastOneActionRequest(builder.build(), Arrays.asList("K"), true));
        }
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        document.acknowledge("");
        Assert.assertTrue((boolean)document.isProcessed());
    }

    @Test
    public void testIsLastApprover() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        document.saveDocumentData();
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertFalse((String)"Should not be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "AdHoc"));
        String groupId = this.getGroupIdForName("KR-WKFLW", "TestWorkgroup");
        document.adHocToGroup(ActionRequestType.APPROVE, "AdHoc", "", groupId, "", false);
        Assert.assertTrue((String)"Should be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "AdHoc"));
        document.adHocToPrincipal(ActionRequestType.APPROVE, "AdHoc", "", this.getPrincipalIdForName("jitrue"), "", false);
        Assert.assertTrue((String)"Should be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("jitrue"), "AdHoc"));
        Assert.assertFalse((String)"Should not be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "AdHoc"));
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jitrue"), (String)document.getDocumentId());
        Assert.assertEquals((String)"Document should be at adhoc node.", (Object)"AdHoc", document.getNodeNames().iterator().next());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        Assert.assertFalse((String)"Should not be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), "WorkflowDocument"));
        Assert.assertFalse((String)"Should not be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), "WorkflowDocument"));
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Approve should be requested.", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"Should be last approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), "WorkflowDocument"));
        document.approve("");
    }

    @Test
    public void testIsLastApproverActivation() throws Exception {
        ActionRequestValue actionRequest2;
        Parameter lastApproverActivateParameter = CoreFrameworkServiceLocator.getParameterService().getParameter("KR-WKFLW", "Feature", "IS_LAST_APPROVER_ACTIVATE_FIRST_IND");
        Assert.assertNotNull((String)"last approver parameter should exist.", (Object)lastApproverActivateParameter);
        Assert.assertTrue((String)"initial parameter value should be null or empty.", (boolean)StringUtils.isBlank((String)lastApproverActivateParameter.getValue()));
        String originalParameterValue = lastApproverActivateParameter.getValue();
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqLastApproverDocType");
        document.route("");
        Assert.assertEquals((String)"We should be at the WorkflowDocument node.", (Object)"WorkflowDocument", document.getNodeNames().iterator().next());
        Assert.assertFalse((String)"ewestfal should have not have approve because it's initiated", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertFalse((String)"rkirkend should not have approve because it's initiated", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"bmcgough should have approve", (boolean)document.isApprovalRequested());
        List actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be 3 pending requests.", (long)3L, (long)actionRequests.size());
        boolean foundBmcgoughRequest = false;
        boolean foundRkirkendRequest = false;
        boolean foundEwestfalRequest = false;
        for (ActionRequestValue actionRequest2 : actionRequests) {
            String netId = this.getPrincipalNameForId(actionRequest2.getPrincipalId());
            if ("bmcgough".equals(netId)) {
                Assert.assertTrue((String)"Request to bmcgough should be activated.", (boolean)actionRequest2.isActive());
                foundBmcgoughRequest = true;
                continue;
            }
            if ("rkirkend".equals(netId)) {
                Assert.assertTrue((String)"Request to rkirkend should be initialized.", (boolean)actionRequest2.isInitialized());
                foundRkirkendRequest = true;
                continue;
            }
            if (!"ewestfal".equals(netId)) continue;
            Assert.assertTrue((String)"Request to ewestfal should be initialized.", (boolean)actionRequest2.isInitialized());
            Assert.assertTrue((String)"Request to ewestfal should be forceAction.", (boolean)actionRequest2.getForceAction());
            foundEwestfalRequest = true;
        }
        Assert.assertTrue((String)"Did not find request to bmcgough.", (boolean)foundBmcgoughRequest);
        Assert.assertTrue((String)"Did not find request to rkirkend.", (boolean)foundRkirkendRequest);
        Assert.assertTrue((String)"Did not find request to ewestfal.", (boolean)foundEwestfalRequest);
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertFalse((String)"Bmcgough should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), "WorkflowDocument"));
        Assert.assertFalse((String)"Rkirkend should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), "WorkflowDocument"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertFalse((String)"Rkirkend should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), "WorkflowDocument"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be 1 pending requests.", (long)1L, (long)actionRequests.size());
        actionRequest2 = (ActionRequestValue)actionRequests.get(0);
        Assert.assertTrue((String)"Should be activated.", (boolean)actionRequest2.isActive());
        Assert.assertTrue((String)"Ewestfal should be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"ewestfal should have approve request", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertEquals((String)"Should be at the WorkflowDocument2 Node.", (Object)"WorkflowDocument2", document.getNodeNames().iterator().next());
        Assert.assertFalse((String)"Pmckown should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), "WorkflowDocument2"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument2"));
        actionRequests = KEWServiceLocator.getActionRequestService().findPendingByDoc(document.getDocumentId());
        Assert.assertEquals((String)"Should be 2 action requests.", (long)2L, (long)actionRequests.size());
        String parameterValue = "Y";
        Parameter.Builder b = Parameter.Builder.create((ParameterContract)lastApproverActivateParameter);
        b.setValue(parameterValue);
        CoreFrameworkServiceLocator.getParameterService().updateParameter(b.build());
        lastApproverActivateParameter = CoreFrameworkServiceLocator.getParameterService().getParameter("KR-WKFLW", "Feature", "IS_LAST_APPROVER_ACTIVATE_FIRST_IND");
        Assert.assertNotNull((String)"Parameter should not be null.", (Object)lastApproverActivateParameter);
        Assert.assertEquals((String)"Parameter should be Y.", (Object)parameterValue, (Object)lastApproverActivateParameter.getValue());
        document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqLastApproverDocType");
        document.route("");
        Assert.assertFalse((String)"Bmcgough should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("bmcgough"), "WorkflowDocument"));
        Assert.assertFalse((String)"Rkirkend should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), "WorkflowDocument"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertFalse((String)"Rkirkend should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("rkirkend"), "WorkflowDocument"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertFalse((String)"Ewestfal should not have permissions to approve", (boolean)document.isApprovalRequested());
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("ewestfal"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Ewestfal should now have permission to approve", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"Ewestfal should now be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument"));
        document.approve("");
        TestUtilities.assertAtNode(document, "WorkflowDocument2");
        List requests = KEWServiceLocator.getActionRequestService().findPendingRootRequestsByDocId(document.getDocumentId());
        Assert.assertEquals((String)"We should have 2 requests here.", (long)2L, (long)requests.size());
        Assert.assertTrue((String)"Pmckown should be the last approver at this node.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("pmckown"), "WorkflowDocument2"));
        Assert.assertFalse((String)"Ewestfal should not be the final approver.", (boolean)wdas.isLastApproverAtNode(document.getDocumentId(), this.getPrincipalIdForName("ewestfal"), "WorkflowDocument2"));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
        Parameter.Builder b2 = Parameter.Builder.create((ParameterContract)lastApproverActivateParameter);
        b2.setValue("");
        CoreFrameworkServiceLocator.getParameterService().updateParameter(b2.build());
    }

    @Test
    public void testIsFinalApprover() throws Exception {
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqDocType");
        this.assertFinalApprover(document);
    }

    @Test
    public void testIsFinalApproverChild() throws Exception {
        WorkflowDocument childDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("ewestfal"), (String)"SeqChildDocType");
        this.assertFinalApprover(childDocument);
    }

    private void assertFinalApprover(WorkflowDocument document) throws Exception {
        document.route("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("bmcgough"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        Assert.assertFalse((String)"Should not be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("bmcgough")));
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("rkirkend"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        Assert.assertFalse((String)"Should not be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("rkirkend")));
        document.approve("");
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Document should be enroute.", (boolean)document.isEnroute());
        Assert.assertTrue((String)"Should have approve request.", (boolean)document.isApprovalRequested());
        Assert.assertTrue((String)"Should be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("pmckown")));
        document.adHocToPrincipal(ActionRequestType.APPROVE, "WorkflowDocument2", "", this.getPrincipalIdForName("temay"), "", true);
        Assert.assertFalse((String)"Should not be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("pmckown")));
        Assert.assertFalse((String)"Should not be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("temay")));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("temay"), (String)document.getDocumentId());
        Assert.assertTrue((String)"SHould have approve request.", (boolean)document.isApprovalRequested());
        document.approve("");
        Assert.assertTrue((String)"Should be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("pmckown")));
        document.adHocToPrincipal(ActionRequestType.ACKNOWLEDGE, "WorkflowDocument2", "", this.getPrincipalIdForName("jhopf"), "", true);
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("jhopf"), (String)document.getDocumentId());
        Assert.assertTrue((String)"Should have acknowledge request.", (boolean)document.isAcknowledgeRequested());
        Assert.assertTrue((String)"Should be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("pmckown")));
        Assert.assertFalse((String)"Should not be final approver.", (boolean)wdas.isFinalApprover(document.getDocumentId(), this.getPrincipalIdForName("jhopf")));
        document = WorkflowDocumentFactory.loadDocument((String)this.getPrincipalIdForName("pmckown"), (String)document.getDocumentId());
        document.approve("");
        Assert.assertTrue((String)"Document should be processed.", (boolean)document.isProcessed());
    }

    @Test
    public void testGetPrincipalIdsInRouteLog() throws Exception {
        HashSet<String> NonSITMembers = new HashSet<String>(Arrays.asList(this.getPrincipalIdForName("user1"), this.getPrincipalIdForName("user2"), this.getPrincipalIdForName("user3"), this.getPrincipalIdForName("dewey")));
        HashSet<String> WorkflowAdminMembers = new HashSet<String>(Arrays.asList(this.getPrincipalIdForName("ewestfal"), this.getPrincipalIdForName("rkirkend"), this.getPrincipalIdForName("jhopf"), this.getPrincipalIdForName("bmcgough"), this.getPrincipalIdForName("shenl"), this.getPrincipalIdForName("quickstart")));
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("rkirkend"), (String)"UserAndGroupTestDocType");
        document.route("");
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        List principalIds = wdas.getPrincipalIdsInRouteLog(document.getDocumentId(), false);
        Assert.assertTrue((boolean)principalIds.contains(this.getPrincipalIdForName("ewestfal")));
        Assert.assertTrue((boolean)principalIds.containsAll(NonSITMembers));
        Assert.assertFalse((boolean)principalIds.contains(this.getPrincipalIdForName("jitrue")));
        Assert.assertFalse((boolean)principalIds.containsAll(WorkflowAdminMembers));
        principalIds = wdas.getPrincipalIdsInRouteLog(document.getDocumentId(), true);
        Assert.assertTrue((boolean)principalIds.contains(this.getPrincipalIdForName("ewestfal")));
        Assert.assertTrue((boolean)principalIds.containsAll(NonSITMembers));
        Assert.assertTrue((boolean)principalIds.contains(this.getPrincipalIdForName("jitrue")));
        Assert.assertTrue((boolean)principalIds.containsAll(WorkflowAdminMembers));
    }

    @Test
    public void testRoutingReportOnDocumentType() throws Exception {
        RoutingReportCriteria.Builder criteria = RoutingReportCriteria.Builder.createByDocumentTypeName((String)"SeqDocType");
        criteria.setRuleTemplateNames(Collections.singletonList("WorkflowDocumentTemplate"));
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        DocumentDetail documentDetail = wdas.executeSimulation(criteria.build());
        Assert.assertNotNull((Object)documentDetail);
        Assert.assertEquals((String)"Should have been 2 requests generated.", (long)2L, (long)documentDetail.getActionRequests().size());
        criteria.setRuleTemplateNames(Arrays.asList("WorkflowDocumentTemplate", "WorkflowDocument2Template"));
        documentDetail = wdas.executeSimulation(criteria.build());
        Assert.assertEquals((String)"Should have been 3 requests generated.", (long)3L, (long)documentDetail.getActionRequests().size());
        boolean foundRkirkend = false;
        boolean foundBmcgough = false;
        boolean foundPmckown = false;
        for (ActionRequest actionRequest : documentDetail.getActionRequests()) {
            String netId = this.getPrincipalNameForId(actionRequest.getPrincipalId());
            if (netId.equals("rkirkend")) {
                foundRkirkend = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)actionRequest.getNodeName());
                continue;
            }
            if (netId.equals("bmcgough")) {
                foundBmcgough = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)actionRequest.getNodeName());
                continue;
            }
            if (!netId.equals("pmckown")) continue;
            foundPmckown = true;
            Assert.assertEquals((Object)"WorkflowDocument2", (Object)actionRequest.getNodeName());
        }
        Assert.assertTrue((String)"Did not find request for rkirkend", (boolean)foundRkirkend);
        Assert.assertTrue((String)"Did not find request for bmcgough", (boolean)foundBmcgough);
        Assert.assertTrue((String)"Did not find request for pmckown", (boolean)foundPmckown);
    }

    @Test
    public void testRoutingReportOnDocumentId() throws Exception {
        WorkflowDocument doc = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName("user1"), (String)"SeqDocType");
        WorkflowDocumentActionsService wdas = KewApiServiceLocator.getWorkflowDocumentActionsService();
        RoutingReportCriteria.Builder criteria = RoutingReportCriteria.Builder.createByDocumentId((String)doc.getDocumentId());
        criteria.setRuleTemplateNames(Collections.singletonList("WorkflowDocumentTemplate"));
        DocumentDetail documentDetail = wdas.executeSimulation(criteria.build());
        Assert.assertNotNull((Object)documentDetail);
        Assert.assertEquals((String)"Document id returned should be the same as the one passed in", (Object)doc.getDocumentId(), (Object)documentDetail.getDocument().getDocumentId());
        Assert.assertEquals((String)"Wrong number of action requests generated", (long)2L, (long)documentDetail.getActionRequests().size());
        criteria.setRuleTemplateNames(Arrays.asList("WorkflowDocumentTemplate", "WorkflowDocument2Template"));
        documentDetail = wdas.executeSimulation(criteria.build());
        Assert.assertEquals((String)"Should have been 3 requests generated.", (long)3L, (long)documentDetail.getActionRequests().size());
        boolean foundRkirkend = false;
        boolean foundBmcgough = false;
        boolean foundPmckown = false;
        for (ActionRequest actionRequest : documentDetail.getActionRequests()) {
            String netId = this.getPrincipalNameForId(actionRequest.getPrincipalId());
            if (netId.equals("rkirkend")) {
                foundRkirkend = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)actionRequest.getNodeName());
                continue;
            }
            if (netId.equals("bmcgough")) {
                foundBmcgough = true;
                Assert.assertEquals((Object)"WorkflowDocument", (Object)actionRequest.getNodeName());
                continue;
            }
            if (!netId.equals("pmckown")) continue;
            foundPmckown = true;
            Assert.assertEquals((Object)"WorkflowDocument2", (Object)actionRequest.getNodeName());
        }
        Assert.assertTrue((String)"Did not find request for rkirkend", (boolean)foundRkirkend);
        Assert.assertTrue((String)"Did not find request for bmcgough", (boolean)foundBmcgough);
        Assert.assertTrue((String)"Did not find request for pmckown", (boolean)foundPmckown);
    }

    protected void verifyEmptyArray(String qualifier, Object[] array) {
        Assert.assertNotNull((String)"Array should not be empty", (Object)array);
        Assert.assertEquals((String)("Number of " + qualifier + "s Returned Should be 0"), (long)0L, (long)array.length);
    }

    private void verifyEmptyCollection(String qualifier, Collection collection) {
        Assert.assertNotNull((String)"Array should not be empty", (Object)collection);
        Assert.assertEquals((String)("Number of " + qualifier + "s Returned Should be 0"), (long)0L, (long)collection.size());
    }

    @Test
    public void testRuleReportGeneralFunction() throws Exception {
        this.ruleExceptionTest(null, "Sending in null RuleReportCriteriaDTO should throw Exception");
        RuleReportCriteria.Builder ruleReportCriteria = RuleReportCriteria.Builder.create();
        this.ruleExceptionTest(ruleReportCriteria.build(), "Sending in empty RuleReportCriteriaDTO should throw Exception");
        ruleReportCriteria.setResponsiblePrincipalId("hobo_man");
        this.ruleExceptionTest(ruleReportCriteria.build(), "Sending in an invalid principle ID should throw Exception");
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setResponsibleGroupId("-1234567");
        this.ruleExceptionTest(ruleReportCriteria.build(), "Sending in an invalid Workgroup ID should throw Exception");
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setRuleExtensions(Collections.singletonMap("key", "value"));
        this.ruleExceptionTest(ruleReportCriteria.build(), "Sending in one or more RuleExtentionVO objects with no Rule Template Name should throw Exception");
        RuleService wdas = KewApiServiceLocator.getRuleService();
        List rules = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setConsiderGroupMembership(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of Rules Returned Should be 3", (long)3L, (long)rules.size());
        rules = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setActionRequestCodes(Collections.singletonList("K"));
        ruleReportCriteria.setConsiderGroupMembership(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("temay"));
        rules = wdas.ruleReport(ruleReportCriteria.build());
        this.verifyEmptyCollection("Rule", rules);
        rules = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setActionRequestCodes(Collections.singletonList("K"));
        ruleReportCriteria.setConsiderGroupMembership(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of Rules Returned Should be 1", (long)1L, (long)rules.size());
        Rule ruleVO = (Rule)rules.get(0);
        Assert.assertEquals((String)"Rule Document Type is not RuleTestDocType", (Object)"RuleTestDocType", (Object)ruleVO.getDocTypeName());
        Assert.assertEquals((String)"Rule Template Named returned is not WorkflowDocument2Template", (Object)"WorkflowDocument2Template", (Object)ruleVO.getRuleTemplateName());
        Assert.assertEquals((String)"Rule did not have force action set to false", (Object)Boolean.FALSE, (Object)ruleVO.isForceAction());
        Assert.assertEquals((String)"Number of Rule Responsibilities returned is incorrect", (long)2L, (long)ruleVO.getRuleResponsibilities().size());
        for (Object responsibility : ruleVO.getRuleResponsibilities()) {
            String responsibilityPrincipalName = this.getPrincipalNameForId(responsibility.getPrincipalId());
            if ("temay".equals(responsibilityPrincipalName)) {
                Assert.assertEquals((String)"Rule user is not correct", (Object)"temay", (Object)responsibilityPrincipalName);
                Assert.assertEquals((String)"Rule priority is incorrect", (Object)1, (Object)responsibility.getPriority());
                Assert.assertEquals((String)"Rule should be Ack Request", (Object)"A", (Object)responsibility.getActionRequestedCd());
                continue;
            }
            if ("ewestfal".equals(responsibilityPrincipalName)) {
                Assert.assertEquals((String)"Rule user is not correct", (Object)"ewestfal", (Object)responsibilityPrincipalName);
                Assert.assertEquals((String)"Rule priority is incorrect", (Object)2, (Object)responsibility.getPriority());
                Assert.assertEquals((String)"Rule should be Ack Request", (Object)"K", (Object)responsibility.getActionRequestedCd());
                continue;
            }
            Assert.fail((String)"Network ID of user for this responsibility is neither temay or ewestfal");
        }
        rules = null;
        ruleVO = null;
        RuleResponsibility responsibilityVO = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setConsiderGroupMembership(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("temay"));
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of Rules returned is not correct", (long)2L, (long)rules.size());
        for (Rule rule : rules) {
            if ("WorkflowDocumentTemplate".equals(rule.getRuleTemplateName())) {
                Assert.assertEquals((String)"Rule Document Type is not RuleTestDocType", (Object)"RuleTestDocType", (Object)rule.getDocTypeName());
                Assert.assertEquals((String)"Rule Template Named returned is not WorkflowDocumentTemplate", (Object)"WorkflowDocumentTemplate", (Object)rule.getRuleTemplateName());
                Assert.assertEquals((String)"Rule did not have force action set to true", (Object)Boolean.TRUE, (Object)rule.isForceAction());
                Assert.assertEquals((String)"Number of Rule Responsibilities Returned Should be 1", (long)1L, (long)rule.getRuleResponsibilities().size());
                responsibilityVO = (RuleResponsibility)rule.getRuleResponsibilities().get(0);
                Assert.assertEquals((String)"Rule user is incorrect", (Object)"temay", (Object)this.getPrincipalNameForId(responsibilityVO.getPrincipalId()));
                Assert.assertEquals((String)"Rule priority is incorrect", (Object)3, (Object)responsibilityVO.getPriority());
                Assert.assertEquals((String)"Rule action request is incorrect", (Object)"A", (Object)responsibilityVO.getActionRequestedCd());
                continue;
            }
            if ("WorkflowDocument2Template".equals(rule.getRuleTemplateName())) {
                Assert.assertEquals((String)"Rule Document Type is not RuleTestDocType", (Object)"RuleTestDocType", (Object)rule.getDocTypeName());
                Assert.assertEquals((String)"Rule Template Named returned is not WorkflowDocument2Template", (Object)"WorkflowDocument2Template", (Object)rule.getRuleTemplateName());
                Assert.assertEquals((String)"Rule did not have force action set to false", (Object)Boolean.FALSE, (Object)rule.isForceAction());
                Assert.assertEquals((String)"Number of Rule Responsibilities returned is incorrect", (long)2L, (long)rule.getRuleResponsibilities().size());
                for (RuleResponsibility responsibility : rule.getRuleResponsibilities()) {
                    String responsibilityPrincipalName = this.getPrincipalNameForId(responsibility.getPrincipalId());
                    if ("temay".equals(responsibilityPrincipalName)) {
                        Assert.assertEquals((String)"Rule user is not correct", (Object)"temay", (Object)responsibilityPrincipalName);
                        Assert.assertEquals((String)"Rule priority is incorrect", (Object)1, (Object)responsibility.getPriority());
                        Assert.assertEquals((String)"Rule should be Ack Request", (Object)"A", (Object)responsibility.getActionRequestedCd());
                        continue;
                    }
                    if ("ewestfal".equals(responsibilityPrincipalName)) {
                        Assert.assertEquals((String)"Rule user is not correct", (Object)"ewestfal", (Object)responsibilityPrincipalName);
                        Assert.assertEquals((String)"Rule priority is incorrect", (Object)2, (Object)responsibility.getPriority());
                        Assert.assertEquals((String)"Rule should be Ack Request", (Object)"K", (Object)responsibility.getActionRequestedCd());
                        continue;
                    }
                    Assert.fail((String)"Network ID of user for this responsibility is neither temay or ewestfal");
                }
                continue;
            }
            Assert.fail((String)"Rule Template of returned rule is not of type WorkflowDocumentTemplate nor WorkflowDocument2Template");
        }
        rules = null;
        ruleVO = null;
        responsibilityVO = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setResponsibleGroupId("3003");
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of Rules Returned Should be 1", (long)1L, (long)rules.size());
        ruleVO = (Rule)rules.get(0);
        Assert.assertEquals((String)"Rule Document Type is not RuleTestDocType", (Object)"RuleTestDocType", (Object)ruleVO.getDocTypeName());
        Assert.assertEquals((String)"Rule Template Named returned is not WorkflowDocument3Template", (Object)"WorkflowDocument3Template", (Object)ruleVO.getRuleTemplateName());
        Assert.assertEquals((String)"Rule did not have force action set to true", (Object)Boolean.TRUE, (Object)ruleVO.isForceAction());
        Assert.assertEquals((String)"Number of Rule Responsibilities Returned Should be 1", (long)1L, (long)ruleVO.getRuleResponsibilities().size());
        responsibilityVO = (RuleResponsibility)ruleVO.getRuleResponsibilities().get(0);
        Group ruleTestGroup = KimApiServiceLocator.getGroupService().getGroup(responsibilityVO.getGroupId());
        Assert.assertEquals((String)"Rule workgroup id is incorrect", (Object)"3003", (Object)ruleTestGroup.getId());
        Assert.assertEquals((String)"Rule priority is incorrect", (Object)1, (Object)responsibilityVO.getPriority());
        Assert.assertEquals((String)"Rule action request is incorrect", (Object)"F", (Object)responsibilityVO.getActionRequestedCd());
        rules = null;
        ruleVO = null;
        responsibilityVO = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("RuleTestDocType");
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("user1"));
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of Rules Returned Should be 1", (long)1L, (long)rules.size());
        ruleVO = (Rule)rules.get(0);
        Assert.assertEquals((String)"Rule Document Type is not RuleTestDocType", (Object)"RuleTestDocType", (Object)ruleVO.getDocTypeName());
        Assert.assertNotSame((String)"Rule Template Named returned is not WorkflowDocument3Template", (Object)"WorkflowDocument3Template", (Object)ruleVO.getRuleTemplateName());
        Assert.assertEquals((String)"Rule did not have force action set to true", (Object)Boolean.TRUE, (Object)ruleVO.isForceAction());
        Assert.assertEquals((String)"Number of Rule Responsibilities Returned Should be 1", (long)1L, (long)ruleVO.getRuleResponsibilities().size());
        responsibilityVO = (RuleResponsibility)ruleVO.getRuleResponsibilities().get(0);
        Assert.assertEquals((String)"Rule workgroup id is incorrect", (Object)"3003", (Object)ruleTestGroup.getId());
        Assert.assertEquals((String)"Rule priority is incorrect", (Object)1, (Object)responsibilityVO.getPriority());
        Assert.assertEquals((String)"Rule action request is incorrect", (Object)"F", (Object)responsibilityVO.getActionRequestedCd());
    }

    @Test
    public void testRuleReportOrgReviewTest() throws Exception {
        this.loadXmlFile("WorkflowUtilityRuleReportConfig.xml");
        RuleService wdas = KewApiServiceLocator.getRuleService();
        RuleReportCriteria.Builder ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("user1"));
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        List rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)2L, (long)rules.size());
        ruleReportCriteria = null;
        rules = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("user1"));
        ruleReportCriteria.setConsiderGroupMembership(Boolean.FALSE.booleanValue());
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)1L, (long)rules.size());
        ruleReportCriteria = null;
        rules = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        Map<String, String> ruleExtensions = new HashMap<String, String>();
        ruleExtensions.put("chartCode", "BA");
        ruleExtensions.put("orgCode", "FMOP");
        ruleReportCriteria.setRuleExtensions(ruleExtensions);
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)2L, (long)rules.size());
        ruleReportCriteria = null;
        rules = null;
        ruleExtensions = new HashMap();
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("ewestfal"));
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)1L, (long)rules.size());
        Rule ruleVO = (Rule)rules.get(0);
        Assert.assertEquals((String)"Rule Document Type is not OrgReviewTestDocType", (Object)"OrgReviewTestDocType", (Object)ruleVO.getDocTypeName());
        Assert.assertEquals((String)"Rule Template Named returned is not OrgReviewTemplate", (Object)"OrgReviewTemplate", (Object)ruleVO.getRuleTemplateName());
        Assert.assertEquals((String)"Rule did not have force action set to true", (Object)Boolean.TRUE, (Object)ruleVO.isForceAction());
        Assert.assertEquals((String)"Number of Rule Responsibilities Returned Should be 1", (long)1L, (long)ruleVO.getRuleResponsibilities().size());
        RuleResponsibility responsibilityVO = (RuleResponsibility)ruleVO.getRuleResponsibilities().get(0);
        Group ruleTestGroup2 = KimApiServiceLocator.getGroupService().getGroup(responsibilityVO.getGroupId());
        Assert.assertEquals((String)"Rule workgroup name is incorrect", (Object)"Org_Review_Group_2", (Object)ruleTestGroup2.getName());
        Assert.assertEquals((String)"Rule priority is incorrect", (Object)4, (Object)responsibilityVO.getPriority());
        Assert.assertEquals((String)"Rule action request is incorrect", (Object)"F", (Object)responsibilityVO.getActionRequestedCd());
        ruleExtensions = ruleVO.getRuleExtensionMap();
        Assert.assertEquals((String)"Number of Rule Extensions Returned Should be 2", (long)2L, (long)ruleExtensions.size());
        for (Map.Entry entry : ruleExtensions.entrySet()) {
            if ("chartCode".equals(entry.getKey())) {
                Assert.assertEquals((String)"Rule Extension for key 'chartCode' is incorrect", (Object)"UA", entry.getValue());
                continue;
            }
            if ("orgCode".equals(entry.getKey())) {
                Assert.assertEquals((String)"Rule Extension for key 'orgCode' is incorrect", (Object)"VPIT", entry.getValue());
                continue;
            }
            Assert.fail((String)"Rule Extension has attribute key that is neither 'chartCode' nor 'orgCode'");
        }
        ruleReportCriteria = null;
        rules = null;
        ruleVO = null;
        responsibilityVO = null;
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        ruleReportCriteria.setResponsiblePrincipalId(this.getPrincipalIdForName("user1"));
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)2L, (long)rules.size());
        ruleReportCriteria = null;
        rules = null;
        ruleVO = null;
        responsibilityVO = null;
        ruleExtensions = new HashMap();
        ruleReportCriteria = RuleReportCriteria.Builder.create();
        ruleReportCriteria.setDocumentTypeName("OrgReviewTestDocType");
        ruleReportCriteria.setRuleTemplateName("OrgReviewTemplate");
        ruleExtensions.put("chartCode", "UA");
        ruleExtensions.put("orgCode", "FMOP");
        ruleReportCriteria.setRuleExtensions(ruleExtensions);
        ruleReportCriteria.setIncludeDelegations(Boolean.FALSE.booleanValue());
        rules = wdas.ruleReport(ruleReportCriteria.build());
        Assert.assertEquals((String)"Number of rules returned is incorrect", (long)1L, (long)rules.size());
        ruleVO = (Rule)rules.get(0);
        Assert.assertEquals((String)"Rule Document Type is not OrgReviewTestDocType", (Object)"OrgReviewTestDocType", (Object)ruleVO.getDocTypeName());
        Assert.assertEquals((String)"Rule Template Named returned is not OrgReviewTemplate", (Object)"OrgReviewTemplate", (Object)ruleVO.getRuleTemplateName());
        Assert.assertEquals((String)"Rule did not have force action set to true", (Object)Boolean.TRUE, (Object)ruleVO.isForceAction());
        Assert.assertEquals((String)"Number of Rule Responsibilities Returned Should be 1", (long)1L, (long)ruleVO.getRuleResponsibilities().size());
        responsibilityVO = (RuleResponsibility)ruleVO.getRuleResponsibilities().get(0);
        ruleTestGroup2 = KimApiServiceLocator.getGroupService().getGroup(responsibilityVO.getGroupId());
        Assert.assertEquals((String)"Rule workgroup name is incorrect", (Object)"Org_Review_Group", (Object)ruleTestGroup2.getName());
        Assert.assertEquals((String)"Rule priority is incorrect", (Object)1, (Object)responsibilityVO.getPriority());
        Assert.assertEquals((String)"Rule action request is incorrect", (Object)"A", (Object)responsibilityVO.getActionRequestedCd());
    }

    @Test
    public void testGetUserActionItemCount() throws Exception {
        String principalId = this.getPrincipalIdForName("ewestfal");
        ActionListService als = KewApiServiceLocator.getActionListService();
        Assert.assertEquals((String)("Count (test start) is incorrect for user " + principalId), (Object)0, (Object)als.getUserActionItemCount(principalId));
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)principalId, (String)"SeqDocType");
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)0, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("rkirkend");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        document.returnToPreviousNode("", "AdHoc");
        TestUtilities.assertAtNode(document, "AdHoc");
        principalId = this.getPrincipalIdForName("ewestfal");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        Assert.assertTrue((boolean)document.isFYIRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("rkirkend");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)0, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("ewestfal");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        document.approve("");
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        principalId = this.getPrincipalIdForName("ewestfal");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertFalse((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)0, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("bmcgough");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
        principalId = this.getPrincipalIdForName("rkirkend");
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        Assert.assertEquals((String)("Count is incorrect for user " + principalId), (Object)1, (Object)als.getUserActionItemCount(principalId));
    }

    @Test
    public void testGetActionItems() throws Exception {
        String initiatorNetworkId = "ewestfal";
        String user1NetworkId = "bmcgough";
        String user2NetworkId = "rkirkend";
        String initiatorPrincipalId = this.getPrincipalIdForName(initiatorNetworkId);
        String user1PrincipalId = this.getPrincipalIdForName(user1NetworkId);
        String user2PrincipalId = this.getPrincipalIdForName(user2NetworkId);
        String principalId = this.getPrincipalIdForName(initiatorNetworkId);
        String docTitle = "this is the doc title";
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)principalId, (String)"SeqDocType");
        document.setTitle(docTitle);
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        ActionListService als = KewApiServiceLocator.getActionListService();
        List actionItems = als.getAllActionItems(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item should be Approve request", (Object)"A", (Object)actionItem.getActionRequestCd());
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)("User should be one of '" + user1NetworkId + "' or '" + user2NetworkId + "'"), (user1PrincipalId.equals(actionItem.getPrincipalId()) || user2PrincipalId.equals(actionItem.getPrincipalId()) ? 1 : 0) != 0);
        }
        principalId = this.getPrincipalIdForName(user2NetworkId);
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        document.returnToPreviousNode("", "AdHoc");
        TestUtilities.assertAtNode(document, "AdHoc");
        actionItems = als.getAllActionItems(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)"Action Items should be Approve or FYI requests only", ("A".equals(actionItem.getActionRequestCd()) || "F".equals(actionItem.getActionRequestCd()) ? 1 : 0) != 0);
            if ("A".equals(actionItem.getActionRequestCd())) {
                Assert.assertTrue((String)("User should be '" + initiatorNetworkId + "'"), (boolean)initiatorPrincipalId.equals(actionItem.getPrincipalId()));
                continue;
            }
            if (!"F".equals(actionItem.getActionRequestCd())) continue;
            Assert.assertTrue((String)("User should be  '" + user1NetworkId + "'"), (boolean)user1PrincipalId.equals(actionItem.getPrincipalId()));
        }
        principalId = this.getPrincipalIdForName(initiatorNetworkId);
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        actionItems = als.getAllActionItems(document.getDocumentId());
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item should be Approve request", (Object)"A", (Object)actionItem.getActionRequestCd());
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)("User should be one of '" + user1NetworkId + "' or '" + user2NetworkId + "'"), (user1PrincipalId.equals(actionItem.getPrincipalId()) || user2PrincipalId.equals(actionItem.getPrincipalId()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetActionItems_ActionRequestCodes() throws Exception {
        String initiatorNetworkId = "ewestfal";
        String user1NetworkId = "bmcgough";
        String user2NetworkId = "rkirkend";
        String initiatorPrincipalId = this.getPrincipalIdForName(initiatorNetworkId);
        String user1PrincipalId = this.getPrincipalIdForName(user1NetworkId);
        String user2PrincipalId = this.getPrincipalIdForName(user2NetworkId);
        String principalId = this.getPrincipalIdForName(initiatorNetworkId);
        String docTitle = "this is the doc title";
        WorkflowDocument document = WorkflowDocumentFactory.createDocument((String)principalId, (String)"SeqDocType");
        document.setTitle(docTitle);
        document.route("");
        Assert.assertTrue((boolean)document.isEnroute());
        ActionListService als = KewApiServiceLocator.getActionListService();
        List actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("C"));
        this.verifyEmptyCollection("Action Item", actionItems);
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("A"));
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item should be Approve request", (Object)"A", (Object)actionItem.getActionRequestCd());
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)("User should be one of '" + user1NetworkId + "' or '" + user2NetworkId + "'"), (user1PrincipalId.equals(actionItem.getPrincipalId()) || user2PrincipalId.equals(actionItem.getPrincipalId()) ? 1 : 0) != 0);
        }
        principalId = this.getPrincipalIdForName(user2NetworkId);
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        document.returnToPreviousNode("", "AdHoc");
        TestUtilities.assertAtNode(document, "AdHoc");
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("C"));
        this.verifyEmptyCollection("Action Item", actionItems);
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("A"));
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)1L, (long)actionItems.size());
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("F"));
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)1L, (long)actionItems.size());
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("F", "A"));
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)"Action Items should be Approve or FYI requests only", ("A".equals(actionItem.getActionRequestCd()) || "F".equals(actionItem.getActionRequestCd()) ? 1 : 0) != 0);
            if ("A".equals(actionItem.getActionRequestCd())) {
                Assert.assertTrue((String)("User should be '" + initiatorNetworkId + "'"), (boolean)initiatorPrincipalId.equals(actionItem.getPrincipalId()));
                continue;
            }
            if ("F".equals(actionItem.getActionRequestCd())) {
                Assert.assertTrue((String)("User should be  '" + user1NetworkId + "'"), (boolean)user1PrincipalId.equals(actionItem.getPrincipalId()));
                continue;
            }
            Assert.fail((String)("Should not have found action request with requested action '" + (String)KewApiConstants.ACTION_REQUEST_CD.get(actionItem.getActionRequestCd()) + "'"));
        }
        principalId = this.getPrincipalIdForName(initiatorNetworkId);
        document = WorkflowDocumentFactory.loadDocument((String)principalId, (String)document.getDocumentId());
        Assert.assertTrue((boolean)document.isApprovalRequested());
        document.approve("");
        TestUtilities.assertAtNode(document, "WorkflowDocument");
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("C"));
        this.verifyEmptyCollection("Action Item", actionItems);
        actionItems = als.getActionItems(document.getDocumentId(), Arrays.asList("A"));
        Assert.assertEquals((String)"Incorrect number of action items returned", (long)2L, (long)actionItems.size());
        for (ActionItem actionItem : actionItems) {
            Assert.assertEquals((String)"Action Item should be Approve request", (Object)"A", (Object)actionItem.getActionRequestCd());
            Assert.assertEquals((String)"Action Item has incorrect doc title", (Object)docTitle, (Object)actionItem.getDocTitle());
            Assert.assertTrue((String)("User should be one of '" + user1NetworkId + "' or '" + user2NetworkId + "'"), (user1PrincipalId.equals(actionItem.getPrincipalId()) || user2PrincipalId.equals(actionItem.getPrincipalId()) ? 1 : 0) != 0);
        }
    }

    private void setupPerformDocumentSearchTests(String documentTypeName, String expectedRouteNodeName, String docTitle) throws WorkflowException {
        String userNetworkId = "ewestfal";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Respect my Authoritah");
        workflowDocument.route("routing this document.");
        if (StringUtils.isNotBlank((String)expectedRouteNodeName)) {
            Assert.assertEquals((String)"Document is not at expected routeNodeName", (Object)expectedRouteNodeName, workflowDocument.getNodeNames().iterator().next());
        }
        userNetworkId = "rkirkend";
        workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle(docTitle);
        workflowDocument.route("routing this document.");
        if (StringUtils.isNotBlank((String)expectedRouteNodeName)) {
            Assert.assertEquals((String)"Document is not at expected routeNodeName", (Object)expectedRouteNodeName, workflowDocument.getNodeNames().iterator().next());
        }
    }

    @Test
    public void testPerformDocumentSearch_WithUser_CustomThreshold() throws Exception {
        this.runTestPerformDocumentSearch_CustomThreshold(this.getPrincipalIdForName("user2"));
    }

    @Test
    public void testPerformDocumentSearch_NoUser_CustomThreshold() throws Exception {
        this.runTestPerformDocumentSearch_CustomThreshold(null);
    }

    private void runTestPerformDocumentSearch_CustomThreshold(String principalId) throws Exception {
        String documentTypeName = "SeqDocType";
        String docTitle = "Routing Style";
        this.setupPerformDocumentSearchTests(documentTypeName, null, docTitle);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have two documents.", (long)2L, (long)results.getSearchResults().size());
        int threshold = 1;
        criteria.setMaxResults(Integer.valueOf(1));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertTrue((String)("Search results should signify search went over the given threshold: " + threshold), (boolean)results.isOverThreshold());
        Assert.assertEquals((String)"Search results should have one document.", (long)threshold, (long)results.getSearchResults().size());
    }

    @Test
    public void testPerformDocumentSearch_WithUser_BasicCriteria() throws Exception {
        this.runTestPerformDocumentSearch_BasicCriteria(this.getPrincipalIdForName("user2"));
    }

    @Test
    public void testPerformDocumentSearch_NoUser_BasicCriteria() throws Exception {
        this.runTestPerformDocumentSearch_BasicCriteria(null);
    }

    private void runTestPerformDocumentSearch_BasicCriteria(String principalId) throws Exception {
        String documentTypeName = "SeqDocType";
        String docTitle = "Routing Style";
        this.setupPerformDocumentSearchTests(documentTypeName, null, docTitle);
        String userNetworkId = "delyea";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Get Outta Dodge");
        workflowDocument.route("routing this document.");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setTitle(docTitle);
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setInitiatorPrincipalName("rkirkend");
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have one document.", (long)1L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setInitiatorPrincipalName("user1");
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have three documents.", (long)3L, (long)results.getSearchResults().size());
        boolean foundValidDocId = false;
        for (DocumentSearchResult result : results.getSearchResults()) {
            if (!result.getDocument().getDocumentId().equals(workflowDocument.getDocumentId())) continue;
            foundValidDocId = true;
            break;
        }
        Assert.assertTrue((String)"Should have found document search result with specified document id", (boolean)foundValidDocId);
    }

    @Test
    public void testPerformDocumentSearch_WithUser_RouteNodeSearch() throws Exception {
        this.runTestPerformDocumentSearch_RouteNodeSearch(this.getPrincipalIdForName("user2"));
    }

    @Test
    public void testPerformDocumentSearch_NoUser_RouteNodeSearch() throws Exception {
        this.runTestPerformDocumentSearch_RouteNodeSearch(null);
    }

    private void runTestPerformDocumentSearch_RouteNodeSearch(String principalId) throws Exception {
        String documentTypeName = "SeqDocType";
        this.setupPerformDocumentSearchTests(documentTypeName, "WorkflowDocument", "Doc Title");
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setRouteNodeName("AdHoc");
        try {
            KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.fail((String)"Exception should have been thrown when specifying a route node name but no document type name");
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setRouteNodeName("This is an invalid route node name!!!");
        try {
            DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.assertTrue((String)"No results should have been returned for route node name that does not exist on the specified documentType.", (boolean)results.getSearchResults().isEmpty());
        }
        catch (Exception e) {
            Assert.fail((String)"Exception should not have been thrown when specifying a route node name that does not exist on the specified document type name");
        }
        this.runPerformDocumentSearch_RouteNodeSearch(principalId, "AdHoc", documentTypeName, 0, 0, 2);
        this.runPerformDocumentSearch_RouteNodeSearch(principalId, "WorkflowDocument", documentTypeName, 0, 2, 0);
        this.runPerformDocumentSearch_RouteNodeSearch(principalId, "WorkflowDocument2", documentTypeName, 2, 0, 0);
    }

    @Test
    public void testPerformDocumentSearch_RouteNodeSpecial() throws RemoteException, WorkflowException {
        String documentTypeName = "DocumentWithSpecialRouteNodes";
        this.setupPerformDocumentSearchTests(documentTypeName, "Level1", "Doc Title");
        this.runPerformDocumentSearch_RouteNodeSearch(null, "Level5", documentTypeName, 0, 0, 2);
        this.runPerformDocumentSearch_RouteNodeSearch(null, "Level1", documentTypeName, 0, 2, 0);
        this.runPerformDocumentSearch_RouteNodeSearch(null, "Level3", documentTypeName, 2, 0, 0);
    }

    private void runPerformDocumentSearch_RouteNodeSearch(String principalId, String routeNodeName, String documentTypeName, int countBeforeNode, int countAtNode, int countAfterNode) throws RemoteException, WorkflowException {
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.setRouteNodeName(routeNodeName);
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Wrong number of search results when checking docs at default node logic.", (long)countAtNode, (long)results.getSearchResults().size());
        criteria.setRouteNodeLookupLogic(RouteNodeLookupLogic.EXACTLY);
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Wrong number of search results when checking docs at exact node.", (long)countAtNode, (long)results.getSearchResults().size());
        criteria.setRouteNodeLookupLogic(RouteNodeLookupLogic.BEFORE);
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Wrong number of search results when checking docs before node.", (long)countBeforeNode, (long)results.getSearchResults().size());
        criteria.setRouteNodeLookupLogic(RouteNodeLookupLogic.AFTER);
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Wrong number of search results when checking docs after node.", (long)countAfterNode, (long)results.getSearchResults().size());
    }

    @Test
    public void testPerformDocumentSearch_WithUser_SearchAttributes() throws Exception {
        this.runTestPerformDocumentSearch_SearchAttributes(this.getPrincipalIdForName("user2"));
    }

    @Test
    public void testPerformDocumentSearch_NoUser_SearchAttributes() throws Exception {
        this.runTestPerformDocumentSearch_SearchAttributes(null);
    }

    private void runTestPerformDocumentSearch_SearchAttributes(String principalId) throws Exception {
        String documentTypeName = "SeqDocType";
        String docTitle = "Routing Style";
        this.setupPerformDocumentSearchTests(documentTypeName, null, docTitle);
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("givenname", Collections.singletonList("jack"));
        DocumentSearchResults results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have two documents.", (long)2L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("givenname", Collections.singletonList("fred"));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("fakeproperty", Collections.singletonList("doesntexist"));
        try {
            results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testLongKey", Collections.singletonList(TestXMLSearchableAttributeLong.SEARCH_STORAGE_VALUE.toString()));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have two documents.", (long)2L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testLongKey", Collections.singletonList("1111111"));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("fakeymcfakefake", Collections.singletonList("99999999"));
        try {
            results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testFloatKey", Collections.singletonList(TestXMLSearchableAttributeFloat.SEARCH_STORAGE_VALUE.toString()));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have two documents.", (long)2L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testFloatKey", Collections.singletonList("215.3548"));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("fakeylostington", Collections.singletonList("9999.9999"));
        try {
            results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testDateTimeKey", Collections.singletonList(DocumentSearchInternalUtils.getDisplayValueWithDateOnly((Timestamp)new Timestamp(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS))));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should have two documents.", (long)2L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("testDateTimeKey", Collections.singletonList("07/06/1979"));
        results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
        Assert.assertEquals((String)"Search results should be empty.", (long)0L, (long)results.getSearchResults().size());
        criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(documentTypeName);
        criteria.getDocumentAttributeValues().put("lastingsfakerson", Collections.singletonList("07/06/2007"));
        try {
            results = KewApiServiceLocator.getWorkflowDocumentService().documentSearch(principalId, criteria.build());
            Assert.fail((String)"Search results should be throwing a validation exception for use of non-existant searchable attribute");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetSearchableAttributeDateTimeValuesByKey() throws Exception {
        String documentTypeName = "SeqDocType";
        String userNetworkId = "ewestfal";
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        workflowDocument.setTitle("Respect my Authoritah");
        workflowDocument.route("routing this document.");
        userNetworkId = "rkirkend";
        WorkflowDocument workflowDocument2 = WorkflowDocumentFactory.createDocument((String)this.getPrincipalIdForName(userNetworkId), (String)documentTypeName);
        workflowDocument2.setTitle("Routing Style");
        workflowDocument2.route("routing this document.");
        WorkflowDocumentService wds = KewApiServiceLocator.getWorkflowDocumentService();
        List dateTimes = wds.getSearchableAttributeDateTimeValuesByKey(workflowDocument.getDocumentId(), "testDateTimeKey");
        Assert.assertNotNull((String)"dateTimes should not be null", (Object)dateTimes);
        Assert.assertTrue((String)"dateTimes should not be empty", (!dateTimes.isEmpty() ? 1 : 0) != 0);
        this.verifyTimestampToSecond(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS, ((DateTime)dateTimes.get(0)).getMillis());
        dateTimes = wds.getSearchableAttributeDateTimeValuesByKey(workflowDocument2.getDocumentId(), "testDateTimeKey");
        Assert.assertNotNull((String)"dateTimes should not be null", (Object)dateTimes);
        Assert.assertTrue((String)"dateTimes should not be empty", (!dateTimes.isEmpty() ? 1 : 0) != 0);
        this.verifyTimestampToSecond(TestXMLSearchableAttributeDateTime.SEARCH_STORAGE_VALUE_IN_MILLS, ((DateTime)dateTimes.get(0)).getMillis());
    }

    protected void verifyTimestampToSecond(Long originalTimeInMillis, Long testTimeInMillis) throws Exception {
        Calendar testDate = Calendar.getInstance();
        testDate.setTimeInMillis(originalTimeInMillis);
        testDate.set(14, 0);
        Calendar attributeDate = Calendar.getInstance();
        attributeDate.setTimeInMillis(testTimeInMillis);
        attributeDate.set(14, 0);
        Assert.assertEquals((String)"The month value for the searchable attribute is wrong", (long)testDate.get(2), (long)attributeDate.get(2));
        Assert.assertEquals((String)"The date value for the searchable attribute is wrong", (long)testDate.get(5), (long)attributeDate.get(5));
        Assert.assertEquals((String)"The year value for the searchable attribute is wrong", (long)testDate.get(1), (long)attributeDate.get(1));
        Assert.assertEquals((String)"The hour value for the searchable attribute is wrong", (long)testDate.get(10), (long)attributeDate.get(10));
        Assert.assertEquals((String)"The minute value for the searchable attribute is wrong", (long)testDate.get(12), (long)attributeDate.get(12));
        Assert.assertEquals((String)"The second value for the searchable attribute is wrong", (long)testDate.get(13), (long)attributeDate.get(13));
    }

    private void ruleExceptionTest(RuleReportCriteria ruleReportCriteria, String message) {
        try {
            KewApiServiceLocator.getRuleService().ruleReport(ruleReportCriteria);
            Assert.fail((String)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RouteLogTestSetup {
        public static final String DOCUMENT_TYPE_NAME = "UserAndGroupTestDocType";
        public static final String RULE_TEST_TEMPLATE_1 = "WorkflowDocumentTemplate";
        public static final String RULE_TEST_TEMPLATE_2 = "WorkflowDocument2Template";
        public static final String RULE_TEST_GROUP_ID = "3003";

        private RouteLogTestSetup() {
        }
    }

    private class SeqSetup {
        public static final String DOCUMENT_TYPE_NAME = "SeqDocType";
        public static final String LAST_APPROVER_DOCUMENT_TYPE_NAME = "SeqLastApproverDocType";
        public static final String CHILD_DOCUMENT_TYPE_NAME = "SeqChildDocType";
        public static final String ADHOC_NODE = "AdHoc";
        public static final String WORKFLOW_DOCUMENT_NODE = "WorkflowDocument";
        public static final String WORKFLOW_DOCUMENT_2_NODE = "WorkflowDocument2";
        public static final String ACKNOWLEDGE_1_NODE = "Acknowledge1";
        public static final String ACKNOWLEDGE_2_NODE = "Acknowledge2";

        private SeqSetup() {
        }
    }

    private class RuleTestOrgReviewSetup {
        public static final String DOCUMENT_TYPE_NAME = "OrgReviewTestDocType";
        public static final String RULE_TEST_TEMPLATE = "OrgReviewTemplate";
        public static final String RULE_TEST_WORKGROUP = "Org_Review_Group";
        public static final String RULE_TEST_WORKGROUP2 = "Org_Review_Group_2";
        public static final String RULE_TEST_CHART_CODE_NAME = "chartCode";
        public static final String RULE_TEST_ORG_CODE_NAME = "orgCode";

        private RuleTestOrgReviewSetup() {
        }
    }

    private class RuleTestGeneralSetup {
        public static final String DOCUMENT_TYPE_NAME = "RuleTestDocType";
        public static final String RULE_TEST_TEMPLATE_1 = "WorkflowDocumentTemplate";
        public static final String RULE_TEST_TEMPLATE_2 = "WorkflowDocument2Template";
        public static final String RULE_TEST_TEMPLATE_3 = "WorkflowDocument3Template";
        public static final String RULE_TEST_GROUP_ID = "3003";

        private RuleTestGeneralSetup() {
        }
    }

    private class ReportCriteriaGeneratorUsingDocumentId
    implements ReportCriteriaGenerator {
        private ReportCriteriaGeneratorUsingDocumentId() {
        }

        @Override
        public RoutingReportCriteria buildCriteria(WorkflowDocument workflowDoc) throws Exception {
            RoutingReportCriteria.Builder criteria = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
            return criteria.build();
        }

        @Override
        public boolean isCriteriaRouteHeaderBased() {
            return true;
        }
    }

    private class ReportCriteriaGeneratorUsingXML
    implements ReportCriteriaGenerator {
        private ReportCriteriaGeneratorUsingXML() {
        }

        @Override
        public RoutingReportCriteria buildCriteria(WorkflowDocument workflowDoc) throws Exception {
            RoutingReportCriteria.Builder criteria = RoutingReportCriteria.Builder.createByDocumentTypeName((String)workflowDoc.getDocumentTypeName());
            criteria.setXmlContent(workflowDoc.getDocumentContent().getApplicationContent());
            return criteria.build();
        }

        @Override
        public boolean isCriteriaRouteHeaderBased() {
            return false;
        }
    }

    public static interface ReportCriteriaGenerator {
        public RoutingReportCriteria buildCriteria(WorkflowDocument var1) throws Exception;

        public boolean isCriteriaRouteHeaderBased();
    }
}

