/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.identity.PersonServiceImpl;
import org.kuali.rice.kim.impl.identity.external.EntityExternalIdentifierBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.kim.test.bo.BOContainingPerson;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.AutoPopulatingList;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PersonServiceImplTest
extends KIMTestCase {
    private PersonServiceImpl personService;

    public void setUp() throws Exception {
        super.setUp();
        this.personService = (PersonServiceImpl)GlobalResourceLoader.getService((QName)new QName("personService"));
    }

    @Test
    public void testGetPersonByExternalIdentifier() {
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal("p1");
        SequenceAccessorService sas = KRADServiceLocator.getSequenceAccessorService();
        Long externalIdentifierId = sas.getNextAvailableSequenceNumber("KRIM_ENTITY_EXT_ID_ID_S", EntityExternalIdentifierBo.class);
        EntityExternalIdentifierBo externalIdentifier = new EntityExternalIdentifierBo();
        externalIdentifier.setId("externalIdentifierId");
        externalIdentifier.setEntityId(principal.getEntityId());
        externalIdentifier.setExternalId("000-00-0000");
        externalIdentifier.setExternalIdentifierTypeCode("SSN");
        KRADServiceLocator.getBusinessObjectService().save((PersistableBusinessObject)externalIdentifier);
        List people = this.personService.getPersonByExternalIdentifier("SSN", "000-00-0000");
        Assert.assertNotNull((String)"result object must not be null", (Object)people);
        Assert.assertEquals((String)"exactly one record should be returned", (long)1L, (long)people.size());
        Assert.assertEquals((String)"the returned principal is not correct", (Object)"p1", (Object)((Person)people.get(0)).getPrincipalId());
    }

    @Test
    public void testGetPerson() {
        Person p = this.personService.getPerson("KULUSER");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"class must match implementation class defined on service", (Object)this.personService.getPersonImplementationClass(), p.getClass());
        Assert.assertEquals((String)"person name does not match", (Object)"KULUSER", (Object)p.getFirstNameUnmasked());
        Assert.assertEquals((String)"principal name does not match", (Object)"kuluser", (Object)p.getPrincipalName());
        Assert.assertEquals((String)"KULUSER should have no address record", (Object)"", (Object)p.getAddressLine1Unmasked());
        Assert.assertEquals((String)"KULUSER should have no campus code", (Object)"", (Object)p.getCampusCode());
        Assert.assertEquals((String)"KULUSER should have no email address", (Object)"", (Object)p.getEmailAddressUnmasked());
        Assert.assertNotNull((String)"entity ID should be set", (Object)p.getEntityId());
        Assert.assertNotNull((String)"principal ID should be set", (Object)p.getPrincipalId());
        Person p1Person = this.personService.getPerson("p1");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"employee ID does not match", (Object)"p1emplId", (Object)p1Person.getEmployeeId());
    }

    @Test
    public void testGetPersonInactive() {
        Person p = this.personService.getPerson("inactiveuserid");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"principal ID does not match", (Object)"inactiveusernm", (Object)p.getPrincipalName());
    }

    @Test
    public void testGetPersonByPrincipalName() {
        Person p = this.personService.getPersonByPrincipalName("kuluser");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"person name does not match", (Object)"KULUSER", (Object)p.getFirstName());
        Assert.assertEquals((String)"principal id does not match", (Object)"KULUSER", (Object)p.getPrincipalId());
    }

    @Test
    public void testGetPersonByPrincipalNameInactive() {
        Person p = this.personService.getPersonByPrincipalName("inactiveusernm");
        Assert.assertEquals((String)"principal ID does not match", (Object)"inactiveuserid", (Object)p.getPrincipalId());
    }

    @Test
    public void testGetPersonByEmployeeIdNoInfo() {
        Person p = this.personService.getPersonByEmployeeId("");
        Assert.assertNull((String)"person object will be null", (Object)p);
    }

    @Test
    public void testGetPersonByEmployeeIdNotFound() {
        Person p = this.personService.getPersonByEmployeeId("NotFound");
        Assert.assertNull((String)"person object will be null", (Object)p);
    }

    @Test
    public void testGetPersonByEmployeeIdActive() {
        Person p = this.personService.getPersonByEmployeeId("0000001138");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"person name does not match", (Object)"activeUserFirst", (Object)p.getFirstName());
        Assert.assertEquals((String)"principal id does not match", (Object)"activeuserid", (Object)p.getPrincipalId());
    }

    @Test
    public void testGetPersonByEmployeeIdInactiveUser() {
        Person p = this.personService.getPersonByEmployeeId("0000001139");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"person name does not match", (Object)"InactiveUserFirst", (Object)p.getFirstName());
        Assert.assertEquals((String)"principal id does not match", (Object)"inactiveuserid", (Object)p.getPrincipalId());
    }

    @Test
    public void testGetPersonByEmployeeIdInactiveEmp() {
        Person p = this.personService.getPersonByEmployeeId("0000001140");
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"person name does not match", (Object)"InactiveEmplFirst", (Object)p.getFirstName());
        Assert.assertEquals((String)"principal id does not match", (Object)"inactiveempid", (Object)p.getPrincipalId());
    }

    @Test
    public void testConvertPersonPropertiesToEntityProperties() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("firstName", "System User");
        Map entityCriteria = this.personService.convertPersonPropertiesToEntityProperties(criteria);
        Assert.assertEquals((String)"number of criteria is not correct", (long)5L, (long)entityCriteria.size());
        Assert.assertNotNull((String)"criteria must filter for active entity types", entityCriteria.get("entityTypeContactInfos.active"));
        Assert.assertNotNull((String)"criteria must filter on entity type code", entityCriteria.get("entityTypeContactInfos.entityTypeCode"));
        Assert.assertNotNull((String)"criteria must filter for first name", entityCriteria.get("names.firstName"));
        Assert.assertNotNull((String)"criteria must filter for active names", entityCriteria.get("names.active"));
        Assert.assertNotNull((String)"criteria must filter for the default name", entityCriteria.get("names.defaultValue"));
    }

    @Test
    public void testFindPeople() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("firstName", "KULUSER");
        List people = this.personService.findPeople(criteria);
        Assert.assertNotNull((String)"result must not be null", (Object)people);
        Assert.assertEquals((String)"wrong number of people returned", (long)1L, (long)people.size());
        Person p = (Person)people.get(0);
        Assert.assertEquals((String)"name must match criteria", (Object)"KULUSER", (Object)p.getFirstName());
        Assert.assertEquals((String)"principal name must be kuluser", (Object)"kuluser", (Object)p.getPrincipalName());
    }

    @Test
    public void testFindPeopleInactive() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principals.active", "N");
        List people = this.personService.findPeople(criteria);
        Assert.assertNotNull((String)"result must not be null", (Object)people);
        Assert.assertEquals((String)"wrong number of people returned", (long)1L, (long)people.size());
    }

    @Test
    public void testFindPeopleBothInactiveAndActive() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("firstName", "InactiveUserFirst");
        List people = this.personService.findPeople(criteria);
        Assert.assertNotNull((String)"result must not be null", (Object)people);
        Assert.assertEquals((String)"wrong number of people returned", (long)1L, (long)people.size());
    }

    @Test
    public void testFindPeopleByWildcard() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("principalName", "!quick*");
        List people = this.personService.findPeople(criteria);
        Assert.assertNotNull((String)"result must not be null", (Object)people);
        Assert.assertEquals((String)"wrong number of people returned", (long)53L, (long)people.size());
        for (Person p : people) {
            if (!p.getPrincipalName().startsWith("quick")) continue;
            Assert.fail((String)"Invalid wildcard search results");
        }
    }

    @Test
    public void testResolvePrincipalNamesToPrincipalIds() throws Exception {
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().addConfigFileLocation("KR-KIM", "classpath:org/kuali/rice/kim/bo/datadictionary/test/SampleBO.xml");
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().parseDataDictionaryConfigurationFiles(false);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("anAttribute", "aValue");
        criteria.put("anotherAttribute", "anotherValue");
        criteria.put("personAttribute.principalName", "kuluser");
        System.out.println("Before: " + criteria);
        Map newCritiera = this.personService.resolvePrincipalNamesToPrincipalIds((BusinessObject)new SampleBO(), criteria);
        Assert.assertNotNull((String)"returned map must not be null", (Object)newCritiera);
        System.out.println("After:  " + newCritiera);
        Assert.assertTrue((String)"new criteria must have a personPrincipalId entry", (boolean)newCritiera.containsKey("personPrincipalId"));
        Assert.assertEquals((String)"resulting principal ID is not that expected", (Object)"KULUSER", newCritiera.get("personPrincipalId"));
        Assert.assertFalse((String)"new criteria must not contain the original PrincipalName entry", (boolean)newCritiera.containsKey("personAttribute.principalName"));
        criteria.put("personPrincipalId", "NOT KULUSER");
        System.out.println("Before: " + criteria);
        newCritiera = this.personService.resolvePrincipalNamesToPrincipalIds((BusinessObject)new SampleBO(), criteria);
        Assert.assertNotNull((String)"returned map must not be null", (Object)newCritiera);
        System.out.println("After:  " + newCritiera);
        Assert.assertTrue((String)"new criteria must have a personPrincipalId entry", (boolean)newCritiera.containsKey("personPrincipalId"));
        Assert.assertEquals((String)"resulting principal ID should have been changed", (Object)"KULUSER", newCritiera.get("personPrincipalId"));
    }

    @Test
    public void testResolvePrincipalNamesToPrincipalIds_Nested() throws Exception {
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().addConfigFileLocation("", "classpath:org/kuali/rice/kim/bo/datadictionary/test/SampleBO.xml");
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().parseDataDictionaryConfigurationFiles(false);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("add.childBos.childsPersonAttribute.principalName", "kuluser");
        System.out.println("Before: " + criteria);
        Map newCritiera = this.personService.resolvePrincipalNamesToPrincipalIds((BusinessObject)new SampleBO(), criteria);
        Assert.assertNotNull((String)"returned map must not be null", (Object)newCritiera);
        System.out.println("After:  " + newCritiera);
        Assert.assertTrue((String)"new criteria must have a childsPersonPrincipalId entry", (boolean)newCritiera.containsKey("add.childBos.childsPersonPrincipalId"));
        Assert.assertFalse((String)"new criteria must not contain the original PrincipalName entry", (boolean)newCritiera.containsKey("add.childBos.childsPersonAttribute.principalName"));
    }

    @Test
    public void testUpdateWhenNecessary() {
        SampleBO bo = new SampleBO();
        bo.setPersonPrincipalId("KULUSER");
        Person p = bo.getPersonAttribute();
        Assert.assertNotNull((String)"person object must not be null", (Object)p);
        Assert.assertEquals((String)"principal IDs do not match", (Object)bo.getPersonPrincipalId(), (Object)p.getPrincipalId());
        Assert.assertSame((String)"second retrieval must return same object since ID not changed", (Object)p, (Object)bo.getPersonAttribute());
    }

    @Test
    public void testLookupWithPersonJoin() throws Exception {
        InputStream is = new DefaultResourceLoader().getResource("classpath:org/kuali/rice/kim/test/OJB-repository-kimunittests.xml").getInputStream();
        MetadataManager mm = MetadataManager.getInstance();
        DescriptorRepository dr = mm.readDescriptorRepository(is);
        mm.mergeDescriptorRepository(dr);
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().addConfigFileLocation("KR-KIM", "classpath:org/kuali/rice/kim/bo/datadictionary/test/BOContainingPerson.xml");
        KRADServiceLocatorWeb.getDataDictionaryService().getDataDictionary().parseDataDictionaryConfigurationFiles(false);
        BusinessObjectService bos = KRADServiceLocator.getBusinessObjectService();
        bos.delete(new ArrayList(bos.findAll(BOContainingPerson.class)));
        BOContainingPerson bo = new BOContainingPerson();
        bo.setBoPrimaryKey("ONE");
        bo.setPrincipalId("p1");
        bos.save((PersistableBusinessObject)bo);
        bo = new BOContainingPerson();
        bo.setBoPrimaryKey("TWO");
        bo.setPrincipalId("p2");
        bos.save((PersistableBusinessObject)bo);
        Lookupable l = KNSServiceLocator.getKualiLookupable();
        l.setBusinessObjectClass(BOContainingPerson.class);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("person.principalName", "principal1");
        List results = l.getSearchResultsUnbounded(criteria);
        System.out.println(results);
        Assert.assertNotNull((String)"results may not be null", (Object)results);
        Assert.assertEquals((String)"number of results is incorrect", (long)1L, (long)results.size());
        bo = (BOContainingPerson)((Object)results.iterator().next());
        Assert.assertEquals((String)"principalId does not match", (Object)"p1", (Object)bo.getPrincipalId());
    }

    public static class SampleChildBOWithPerson
    implements BusinessObject {
        private String childsAttribute;
        private String childsPersonPrincipalId;
        private Person childsPersonAttribute;

        public String getChildsAttribute() {
            return this.childsAttribute;
        }

        public void setChildsAttribute(String childsAttribute) {
            this.childsAttribute = childsAttribute;
        }

        public String getChildsPersonPrincipalId() {
            return this.childsPersonPrincipalId;
        }

        public void setChildsPersonPrincipalId(String childsPersonPrincipalId) {
            this.childsPersonPrincipalId = childsPersonPrincipalId;
        }

        public Person getChildsPersonAttribute() {
            this.childsPersonAttribute = KimApiServiceLocator.getPersonService().updatePersonIfNecessary(this.childsPersonPrincipalId, this.childsPersonAttribute);
            return this.childsPersonAttribute;
        }

        public void setChildsPersonAttribute(Person childsPersonAttribute) {
            this.childsPersonAttribute = childsPersonAttribute;
        }

        public void refresh() {
        }
    }

    public static class SampleBO
    implements BusinessObject {
        private String anAttribute;
        private String anotherAttribute;
        private String personPrincipalId;
        private Person personAttribute;
        private List<SampleChildBOWithPerson> childBos = new AutoPopulatingList(SampleChildBOWithPerson.class);

        public String getAnAttribute() {
            return this.anAttribute;
        }

        public void setAnAttribute(String anAttribute) {
            this.anAttribute = anAttribute;
        }

        public String getAnotherAttribute() {
            return this.anotherAttribute;
        }

        public void setAnotherAttribute(String anotherAttribute) {
            this.anotherAttribute = anotherAttribute;
        }

        public String getPersonPrincipalId() {
            return this.personPrincipalId;
        }

        public void setPersonPrincipalId(String personPrincipalId) {
            this.personPrincipalId = personPrincipalId;
        }

        public Person getPersonAttribute() {
            this.personAttribute = KimApiServiceLocator.getPersonService().updatePersonIfNecessary(this.personPrincipalId, this.personAttribute);
            return this.personAttribute;
        }

        public void setPersonAttribute(Person personAttribute) {
            this.personAttribute = personAttribute;
        }

        public void refresh() {
        }

        public List<SampleChildBOWithPerson> getChildBos() {
            return this.childBos;
        }

        public void setChildBos(List<SampleChildBOWithPerson> childBos) {
            this.childBos = childBos;
        }
    }
}

