/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class RoleServiceTest
extends KIMTestCase {
    private RoleService roleService;

    public void setUp() throws Exception {
        super.setUp();
        this.setRoleService(KimApiServiceLocator.getRoleService());
    }

    @Test
    public void testPrincipaHasRoleOfDirectAssignment() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r1");
        Assert.assertTrue((String)"p1 has direct role r1", (boolean)this.getRoleService().principalHasRole("p1", roleIds, Collections.emptyMap()));
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("Attribute 2", "CHEM");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.getRoleService().principalHasRole("p1", roleIds, qualification));
        qualification.clear();
        qualification.put("Attribute 3", "PHYS");
        Assert.assertTrue((String)"p1 has direct role r1 with rp2 attr data", (boolean)this.getRoleService().principalHasRole("p1", roleIds, (Map)Maps.newHashMap(qualification)));
    }

    @Test
    public void testPrincipalHasRoleOfHigherLevel() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p1 has assigned in higher level role r1", (boolean)this.getRoleService().principalHasRole("p1", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testPrincipalHasRoleContainsGroupAssigned() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r2");
        Assert.assertTrue((String)"p2 is assigned to g1 and g1 assigned to r2", (boolean)this.getRoleService().principalHasRole("p2", roleIds, Collections.emptyMap()));
    }

    @Test
    public void testGetPrincipalsFromCircularRoles() {
        ArrayList<String> roleIds = new ArrayList<String>();
        roleIds.add("r101");
        Collection rolePrincipalIds = this.getRoleService().getRoleMemberPrincipalIds("ADDL_ROLES_TESTS", "Role A", Collections.emptyMap());
        Assert.assertNotNull((Object)rolePrincipalIds);
        Assert.assertEquals((String)"RoleTwo should have 6 principal ids", (long)5L, (long)rolePrincipalIds.size());
    }

    public RoleService getRoleService() {
        return this.roleService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

