/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.service;

import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.api.type.KimType;
import org.kuali.rice.kim.framework.services.KimFrameworkServiceLocator;
import org.kuali.rice.kim.framework.type.KimTypeService;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.kns.kim.type.DataDictionaryTypeServiceBase;

public class KIMServiceLocatorInternalTest
extends KIMTestCase {
    @Test
    public void testGetKimTypeService_KimType() {
        try {
            KimTypeService typeService1 = KimFrameworkServiceLocator.getKimTypeService((KimType)null);
            Assert.assertTrue((String)"should have thrown exception and never got here", (boolean)false);
        }
        catch (IllegalArgumentException typeService1) {
            // empty catch block
        }
        KimType.Builder nullKimType = KimType.Builder.create();
        nullKimType.setServiceName(null);
        KimTypeService typeService2 = KimFrameworkServiceLocator.getKimTypeService((KimType)nullKimType.build());
        Assert.assertNotNull((String)"type service shoudl have been found", (Object)typeService2);
        Assert.assertEquals((String)"should be the default kim type", DataDictionaryTypeServiceBase.class, typeService2.getClass());
        KimType.Builder emptyKimType = KimType.Builder.create();
        nullKimType.setServiceName("");
        KimTypeService typeService3 = KimFrameworkServiceLocator.getKimTypeService((KimType)emptyKimType.build());
        Assert.assertNotNull((String)"type service should have been found", (Object)typeService3);
        Assert.assertEquals((String)"should be the default kim type", DataDictionaryTypeServiceBase.class, typeService3.getClass());
        KimType permissionKimType = KimApiServiceLocator.getKimTypeInfoService().findKimTypeByNameAndNamespace("KR-IDM", "Permission");
        Assert.assertNotNull((String)"The KR-IDM:Permission KimType should exist.", (Object)permissionKimType);
        KimTypeService typeService4 = KimFrameworkServiceLocator.getKimTypeService((KimType)permissionKimType);
        Assert.assertNotNull((String)"type service should have been found", (Object)typeService4);
    }

    @Test
    public void testGetKimTypeService_QName() {
        try {
            KimFrameworkServiceLocator.getKimTypeService((QName)null);
            Assert.fail((String)"getKimTypeService with a null QName should have thrown an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        KimTypeService typeService1 = KimFrameworkServiceLocator.getKimTypeService((QName)new QName("badNamespace", "badServiceName"));
        Assert.assertNull((String)"A null KimTypeService should have been returned.", (Object)typeService1);
        KimTypeService typeService2 = KimFrameworkServiceLocator.getKimTypeService((QName)new QName("kimGroupService"));
        Assert.assertNull((String)"A null KimTypeService should have been returned.", (Object)typeService2);
        QName permissionServiceName = new QName("permissionPermissionTypeService");
        KimTypeService typeService3 = KimFrameworkServiceLocator.getKimTypeService((QName)permissionServiceName);
        Assert.assertNotNull((String)"permission type service should have been found", (Object)typeService3);
    }
}

