/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.entity.EntityDefault;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.impl.identity.EntityDefaultInfoCacheBo;
import org.kuali.rice.kim.impl.identity.IdentityArchiveService;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class IdentityArchiveServiceTest
extends KIMTestCase {
    public static final String KIM_IDENTITY_ARCHIVE_SERVICE = "kimIdentityArchiveService";
    private IdentityArchiveService identityArchiveService;

    public static IdentityArchiveService getIdentityArchiveService() {
        return (IdentityArchiveService)GlobalResourceLoader.getService((String)KIM_IDENTITY_ARCHIVE_SERVICE);
    }

    public void setUp() throws Exception {
        super.setUp();
        KradDataServiceLocator.getDataObjectService().deleteAll(EntityDefaultInfoCacheBo.class);
        if (null == this.identityArchiveService) {
            this.identityArchiveService = IdentityArchiveServiceTest.getIdentityArchiveService();
        }
    }

    @Test
    public void testArchiveFlushesWhenQueueIsFull() throws Exception {
        int maxWriteQueueSize = Integer.valueOf(ConfigContext.getCurrentContextConfig().getProperty("kim.identityArchiveServiceImpl.maxWriteQueueSize"));
        this.identityArchiveService.flushToArchive();
        this.log.info((Object)"Sleeping, waiting for the flush!");
        for (int j = 2; j >= 0; --j) {
            Thread.sleep(1000L);
            this.log.info((Object)String.valueOf(j));
        }
        this.log.info((Object)"Done sleeping!");
        ArrayList<EntityDefault> added = new ArrayList<EntityDefault>();
        for (int i = 1; i <= maxWriteQueueSize; ++i) {
            MinimalKEDIBuilder builder = new MinimalKEDIBuilder("bogusUser" + i);
            builder.setEntityId("bogusUser" + i);
            EntityDefault bogusUserInfo = builder.build();
            EntityDefault retrieved = this.identityArchiveService.getEntityDefaultFromArchiveByPrincipalId(builder.getPrincipalId());
            Assert.assertNull((Object)retrieved);
            retrieved = this.identityArchiveService.getEntityDefaultFromArchiveByPrincipalName(builder.getPrincipalName());
            Assert.assertNull((Object)retrieved);
            retrieved = this.identityArchiveService.getEntityDefaultFromArchive(builder.getEntityId());
            Assert.assertNull((Object)retrieved);
            this.identityArchiveService.saveEntityDefaultToArchive(bogusUserInfo);
            added.add(bogusUserInfo);
        }
        this.log.info((Object)"Sleeping, hoping for a flush to occur!");
        for (int j = 10; j >= 0; --j) {
            Thread.sleep(1000L);
            this.log.info((Object)String.valueOf(j));
        }
        this.log.info((Object)"Done sleeping!");
        for (EntityDefault kedi : added) {
            EntityDefault retrieved = this.identityArchiveService.getEntityDefaultFromArchiveByPrincipalId(((Principal)kedi.getPrincipals().get(0)).getPrincipalId());
            Assert.assertNotNull((String)("no value retrieved for principalId: " + ((Principal)kedi.getPrincipals().get(0)).getPrincipalId()), (Object)retrieved);
            Assert.assertTrue((boolean)((Principal)kedi.getPrincipals().get(0)).getPrincipalId().equals(((Principal)retrieved.getPrincipals().get(0)).getPrincipalId()));
            retrieved = this.identityArchiveService.getEntityDefaultFromArchiveByPrincipalName(((Principal)kedi.getPrincipals().get(0)).getPrincipalName());
            Assert.assertTrue((boolean)((Principal)kedi.getPrincipals().get(0)).getPrincipalId().equals(((Principal)retrieved.getPrincipals().get(0)).getPrincipalId()));
            retrieved = this.identityArchiveService.getEntityDefaultFromArchive(kedi.getEntityId());
            Assert.assertTrue((boolean)((Principal)kedi.getPrincipals().get(0)).getPrincipalId().equals(((Principal)retrieved.getPrincipals().get(0)).getPrincipalId()));
        }
    }

    private static class MinimalKEDIBuilder {
        private String entityId = UUID.randomUUID().toString();
        private String principalId;
        private String principalName;
        private Boolean active;

        public MinimalKEDIBuilder(String name) {
            this.principalId = this.principalName = name;
        }

        public EntityDefault build() {
            if (this.entityId == null) {
                this.entityId = UUID.randomUUID().toString();
            }
            if (this.principalId == null) {
                this.principalId = UUID.randomUUID().toString();
            }
            if (this.principalName == null) {
                this.principalName = this.principalId;
            }
            if (this.active == null) {
                this.active = true;
            }
            Principal.Builder principal = Principal.Builder.create((String)this.principalName);
            principal.setActive(this.active.booleanValue());
            principal.setEntityId(this.entityId);
            principal.setPrincipalId(this.principalId);
            EntityDefault.Builder kedi = EntityDefault.Builder.create();
            kedi.setPrincipals(Collections.singletonList(principal));
            kedi.setEntityId(this.entityId);
            return kedi.build();
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getPrincipalId() {
            return this.principalId;
        }

        public void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public String getPrincipalName() {
            return this.principalName;
        }

        public void setPrincipalName(String principalName) {
            this.principalName = principalName;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean active) {
            this.active = active;
        }
    }
}

