/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.test.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.kim.api.common.assignee.Assignee;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.impl.permission.PermissionBo;
import org.kuali.rice.kim.impl.permission.PermissionTemplateBo;
import org.kuali.rice.kim.test.KIMTestCase;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.NONE)
public class PermissionServiceTest
extends KIMTestCase {
    private PermissionService permissionService;

    public void setUp() throws Exception {
        super.setUp();
        this.setPermissionService(KimApiServiceLocator.getPermissionService());
    }

    @Test
    public void testHasPermission() {
        Assert.assertTrue((boolean)this.getPermissionService().hasPermission("entity123pId", "KR-NS", "perm1"));
        Assert.assertTrue((boolean)this.getPermissionService().hasPermission("entity123pId", "KR-NS", "perm2"));
        Assert.assertFalse((boolean)this.getPermissionService().hasPermission("entity124pId", "KR-NS", "perm2"));
    }

    @Test
    public void testIsAuthorized() {
        Assert.assertTrue((boolean)this.getPermissionService().isAuthorized("entity123pId", "KR-NS", "perm1", new HashMap()));
        Assert.assertTrue((boolean)this.getPermissionService().isAuthorized("entity123pId", "KR-NS", "perm2", new HashMap()));
        Assert.assertFalse((boolean)this.getPermissionService().isAuthorized("entity124pId", "KR-NS", "perm2", new HashMap()));
    }

    @Test
    public void testHasPermissionByTemplateName() {
        Assert.assertTrue((boolean)this.getPermissionService().hasPermissionByTemplate("entity123pId", "KUALI", "Default", new HashMap()));
    }

    @Test
    @Ignore
    public void testIsAuthorizedByTemplateName() {
    }

    @Test
    public void testGetPermissionAssignees() {
        List assignees = this.getPermissionService().getPermissionAssignees("KUALI", "Log In Kuali Portal", Collections.emptyMap());
        Assert.assertNotNull((Object)assignees);
        Assert.assertEquals((long)1L, (long)assignees.size());
        Assignee permInfo = (Assignee)assignees.get(0);
        Assert.assertEquals((Object)"entity123pId", (Object)permInfo.getPrincipalId());
        assignees = this.getPermissionService().getPermissionAssignees("KUALI", "Not A Valid Permission Name", Collections.emptyMap());
        Assert.assertTrue((null == assignees || assignees.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testGetPermissionAssigneesForTemplateName() {
    }

    @Test
    @Ignore
    public void testIsPermissionDefined() {
    }

    @Test
    @Ignore
    public void testIsPermissionDefinedForTemplateName() {
    }

    @Test
    @Ignore
    public void testGetAuthorizedPermissions() {
    }

    @Test
    @Ignore
    public void testGetAuthorizedPermissionsByTemplateName() {
    }

    @Test
    public void testGetPermission() {
        PermissionBo permissionBo = PermissionBo.from((Permission)this.getPermissionService().getPermission("p1"));
        Assert.assertNotNull((Object)permissionBo);
        Assert.assertEquals((Object)"perm1", (Object)permissionBo.getName());
        Assert.assertEquals((Object)"KR-NS", (Object)permissionBo.getNamespaceCode());
        Assert.assertEquals((long)0L, (long)permissionBo.getDetails().size());
        Assert.assertTrue((boolean)permissionBo.isActive());
        PermissionTemplateBo templateBo = permissionBo.getTemplate();
        Assert.assertNotNull((Object)templateBo);
        Assert.assertTrue((boolean)templateBo.isActive());
        Assert.assertEquals((Object)"1", (Object)templateBo.getKimTypeId());
        Assert.assertEquals((Object)"Default", (Object)templateBo.getName());
        Assert.assertEquals((Object)"KUALI", (Object)templateBo.getNamespaceCode());
        permissionBo = PermissionBo.from((Permission)this.getPermissionService().getPermission("p0"));
        Assert.assertNull((Object)permissionBo);
    }

    @Test
    @Ignore
    public void testGetPermissionsByTemplateName() {
    }

    @Test
    @Ignore
    public void testGetPermissionsByName() {
    }

    @Test
    @Ignore
    public void testLookupPermissions() {
    }

    @Test
    @Ignore
    public void testGetRoleIdsForPermission() {
    }

    @Test
    @Ignore
    public void testGetRoleIdsForPermissions() {
    }

    @Test
    @Ignore
    public void testGetPermissionDetailLabel() {
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

