/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashSet;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.extension.ExtensionDefinition;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.kns.workflow.attribute.KualiXmlAttribute;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Deprecated
public class KualiXMLAttributeImplTest
extends KRADTestCase {
    private static Log LOG = LogFactory.getLog(KualiXMLAttributeImplTest.class);
    private static final String RULE_ATTRIBUTE_CONFIG_NODE_NAME = "routingConfig";
    private static final String SEARCH_ATTRIBUTE_CONFIG_NODE_NAME = "searchingConfig";
    XPath myXPath = XPathHelper.newXPath();
    String ruleAttributeXml = "";
    String searchAttributeXml = "";

    public void setUp() throws Exception {
        super.setUp();
        InputStream ruleInputStream = null;
        InputStream searchInputStream = null;
        try {
            ruleInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("RuleAttributes.xml");
            Assert.assertNotNull((Object)ruleInputStream);
            this.ruleAttributeXml = IOUtils.toString((InputStream)ruleInputStream);
            searchInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("SearchAttributes.xml");
            Assert.assertNotNull((Object)searchInputStream);
            this.searchAttributeXml = IOUtils.toString((InputStream)searchInputStream);
        }
        finally {
            if (ruleInputStream != null) {
                ruleInputStream.close();
            }
            if (searchInputStream != null) {
                searchInputStream.close();
            }
        }
    }

    @Test
    public void testConfirmLabels() {
        boolean failed = false;
        failed |= this.confirmLabels("Label Not Found", this.ruleAttributeXml, RULE_ATTRIBUTE_CONFIG_NODE_NAME);
        Assert.assertFalse((String)"At least one label was incorrect", (boolean)(failed |= this.confirmLabels("Label Not Found", this.searchAttributeXml, SEARCH_ATTRIBUTE_CONFIG_NODE_NAME)));
    }

    private Node configureRuleAttribute(Node xmlNode, KualiXmlAttribute myAttribute) throws TransformerException {
        ExtensionDefinition.Builder extensionDefinition = ExtensionDefinition.Builder.create((String)"fakeName", (String)"fakeType", (String)"fakeResourceDescriptor");
        StringWriter xmlBuffer = new StringWriter();
        DOMSource source = new DOMSource(xmlNode);
        StreamResult result = new StreamResult(xmlBuffer);
        TransformerFactory.newInstance().newTransformer().transform(source, result);
        extensionDefinition.getConfiguration().put("xmlConfigData", new String(xmlBuffer.getBuffer()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"This is the XML that was added to the attribute");
            LOG.debug((Object)new String(xmlBuffer.getBuffer()));
            StringWriter xmlBuffer2 = new StringWriter();
            DOMSource source2 = new DOMSource(xmlNode);
            StreamResult result2 = new StreamResult(xmlBuffer2);
            TransformerFactory.newInstance().newTransformer().transform(source2, result2);
            LOG.debug((Object)"This is the XML that was returned from the ruleAttribute");
            LOG.debug((Object)new String(xmlBuffer2.getBuffer()));
        }
        return myAttribute.getConfigXML(extensionDefinition.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean confirmLabels(String testString, String attributeXml, String configNodeName) {
        boolean testFailed = false;
        String theTitle = "";
        String theName = "";
        String attributeName = "";
        try {
            NodeList tempList = (NodeList)this.myXPath.evaluate("//ruleAttribute", new InputSource(new StringReader(attributeXml)), XPathConstants.NODESET);
            for (int i = 0; i < tempList.getLength(); ++i) {
                Node originalNode = tempList.item(i);
                HashSet<String> ruleAttributeFieldDefNames = new HashSet<String>();
                HashSet<String> ruleAttributeFieldDefTitles = new HashSet<String>();
                attributeName = (String)this.myXPath.evaluate("./name", originalNode, XPathConstants.STRING);
                Node classNameNode = (Node)this.myXPath.evaluate("./className", originalNode, XPathConstants.NODE);
                if (classNameNode != null && classNameNode.getFirstChild() != null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Checking attribute with name '" + attributeName + "'"));
                    }
                    KualiXmlAttribute myAttribute = (KualiXmlAttribute)GlobalResourceLoader.getObject((ObjectDefinition)new ObjectDefinition(classNameNode.getFirstChild().getNodeValue()));
                    Node xmlNode = this.configureRuleAttribute(originalNode, myAttribute);
                    NamedNodeMap fieldDefAttributes = null;
                    String potentialFailMessage = "";
                    try {
                        NodeList xmlNodeList = (NodeList)this.myXPath.evaluate("//fieldDef", xmlNode, XPathConstants.NODESET);
                        for (int j = 0; j < xmlNodeList.getLength(); ++j) {
                            Node fieldDefXmlNode = xmlNodeList.item(j);
                            fieldDefAttributes = fieldDefXmlNode.getAttributes();
                            theTitle = fieldDefAttributes.getNamedItem("title").getNodeValue();
                            theName = fieldDefAttributes.getNamedItem("name").getNodeValue();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)attributeName);
                                LOG.debug((Object)("name=" + theName + "   title=" + theTitle));
                            }
                            if (ruleAttributeFieldDefNames.contains(theName)) {
                                potentialFailMessage = "Each fieldDef name on a single attribute must be unique and the fieldDef name '" + theName + "' already exists on the attribute '" + attributeName + "'";
                                Assert.fail((String)potentialFailMessage);
                            } else {
                                ruleAttributeFieldDefNames.add(theName);
                            }
                            if (testString.equals("Label Not Found")) {
                                potentialFailMessage = "Each fieldDef title should be a valid value and currently the title for attribute '" + attributeName + "' is '" + theTitle + "'";
                                Assert.assertFalse((String)potentialFailMessage, (boolean)theTitle.equals(testString));
                                if (ruleAttributeFieldDefTitles.contains(theTitle)) {
                                    potentialFailMessage = "Each fieldDef title on a single attribute must be unique and the fieldDef title '" + theTitle + "' already exists on the attribute '" + attributeName + "'";
                                    Assert.fail((String)potentialFailMessage);
                                    continue;
                                }
                                ruleAttributeFieldDefTitles.add(theTitle);
                                continue;
                            }
                            potentialFailMessage = "For attribute '" + attributeName + "' the title should have been '" + testString + "' but was actually '" + theTitle + "'";
                            Assert.assertEquals((String)potentialFailMessage, (Object)testString, (Object)theTitle);
                        }
                        continue;
                    }
                    catch (AssertionError afe) {
                        LOG.warn((Object)("Assertion Failed for attribute '" + attributeName + "' with error " + potentialFailMessage), (Throwable)((Object)afe));
                        testFailed = true;
                        continue;
                    }
                    finally {
                        attributeName = "";
                    }
                }
                throw new RuntimeException("Could not find class for attribute named '" + attributeName + "'");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("General Exception thrown for attribute '" + attributeName + "'"), (Throwable)e);
            testFailed = true;
        }
        return testFailed;
    }

    @Test
    public void testLabelSource() {
        DataDictionaryService myDDService = KRADServiceLocatorWeb.getDataDictionaryService();
        String nonsenseString = "BananaRama";
        for (Object tempEntity : myDDService.getDataDictionary().getBusinessObjectEntries().values()) {
            for (AttributeDefinition attribute : ((BusinessObjectEntry)tempEntity).getAttributes()) {
                attribute.setLabel(nonsenseString);
                attribute.setShortLabel(nonsenseString);
            }
        }
        for (Object tempEntity : myDDService.getDataDictionary().getDocumentEntries().values()) {
            for (AttributeDefinition attribute : ((DocumentEntry)tempEntity).getAttributes()) {
                attribute.setLabel(nonsenseString);
                attribute.setShortLabel(nonsenseString);
            }
        }
        boolean failed = false;
        Assert.assertFalse((String)"At least one label was incorrect", (boolean)failed);
        failed |= this.confirmLabels(nonsenseString, this.ruleAttributeXml, RULE_ATTRIBUTE_CONFIG_NODE_NAME);
        Assert.assertFalse((String)"At least one label was incorrect", (boolean)(failed |= this.confirmLabels(nonsenseString, this.searchAttributeXml, SEARCH_ATTRIBUTE_CONFIG_NODE_NAME)));
    }
}

