/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.workflow;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResults;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.docsearch.service.DocumentSearchService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.workflow.attribute.DataDictionarySearchableAttribute;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.datadictionary.exception.UnknownDocumentTypeException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.test.KRADTestCase;
import org.kuali.rice.krad.test.document.AccountWithDDAttributesDocument;
import org.kuali.rice.krad.util.GlobalVariables;

@Deprecated
public class DataDictionarySearchableAttributeTest
extends KRADTestCase {
    private static final String ACCOUNT_WITH_DD_ATTRIBUTES_DOCUMENT_NAME = "AccountWithDDAttributes";

    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
    }

    @Test
    public void testWildcardsAndMultiSelectsOnDDSearchableAttributes() throws Exception {
        DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(ACCOUNT_WITH_DD_ATTRIBUTES_DOCUMENT_NAME);
        String principalName = "quickstart";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName).getPrincipalId();
        docService.routeDocument((Document)DOCUMENT_FIXTURE.NORMAL_DOCUMENT.getDocument(docService), "Routing NORMAL_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.ZERO_NUMBER_DOCUMENT.getDocument(docService), "Routing ZERO_NUMBER_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.FALSE_AWAKE_DOCUMENT.getDocument(docService), "Routing FALSE_AWAKE_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.ODD_NAME_DOCUMENT.getDocument(docService), "Routing ODD_NAME_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.ODD_TIMESTAMP_DOCUMENT.getDocument(docService), "Routing ODD_TIMESTAMP_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.ANOTHER_ODD_NAME_DOCUMENT.getDocument(docService), "Routing ANOTHER_ODD_NAME_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.INVALID_STATE_DOCUMENT.getDocument(docService), "Routing INVALID_STATE_DOCUMENT", null);
        docService.routeDocument((Document)DOCUMENT_FIXTURE.WILDCARD_NAME_DOCUMENT.getDocument(docService), "Routing WILDCARD_NAME_DOCUMENT", null);
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountNumber", new String[]{"!1234567890", "9???9", ">1", "987654321|1234567889", "<100", ">=99999", "<=-42", ">9000|<=1", "<1|>=1234567890", ">1234567889&&<1234567890", ">=88&&<=99999", "0|>10&&<10000", "9000..1000000", "0..100|>1234567889", "1..10000&&>50", "250..50"}, new int[]{7, -1, 6, 2, 3, 4, -1, 6, 2, 0, 3, 3, 2, 4, 2, 0});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountOwner", new String[]{"!John Doe", "!John*", "!John Doe&&!Shane Kloe", "!Jane ???", "!Jane Doe!John Doe", "_", "_|---", "Sh*ne><K!=e", ">Jane Doe", "<Shane Kloe", ">=Johnny", "<=John D'oh", ">John Doe|<---", ">=AAAAAAAAA&&<=Jane Doe", ">---&&!John D'oh", "<Shane Kloe&&!John*", "*oe", "???? Doe", "Jane Doe..John Doe", "AAAAAAAAA..Shane Kloe&&!John Doe", "John D'oh|---..Jane Doe"}, new int[]{7, 6, 6, 7, 6, 1, 2, 8, 5, 6, 3, 4, 3, 2, 6, 4, 3, 2, 3, 5, 4});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountBalance", new String[]{"501.??", "*.54", "!2.22", "10000051.0|771.05", "<0.0", ">501", "<=4.54", ">=-99.99", ">4.54|<=-1", ">=0&&<501.77", "<=0|>=10000051", ">501&&<501.77", "-100|>771.05", "2.22..501", "-100..4.54&&<=0", "2.22|501.77..10000051.0", "Zero", "-$100", "<(501)&&>=($2.22)", "$4.54|<(1)", "($0.00)..$771.05", ">=$(500)", ")501(", "4.54$", "$501..0"}, new int[]{-1, -1, 7, 2, 1, 3, 4, 7, 5, 4, 3, 0, 2, 3, 2, 4, -1, 1, 2, 3, 6, -1, -1, -1, 0});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountOpenDate", new String[]{"!10/15/2009", "Unknown", "10/15/2009|10/21/2009", "10/22/????", "*/*/05", ">10/17/06", "<=12-31-09&&>=10/16/2009", ">101809&&<102012", ">=10/22/2054|<10/16/2009", ">2-29-12|<=10/21/09", "<2009", ">=10/19/2012|04/20/09", ">2/29/09", "2009..2008", "10/15/2009..10/21/2009", "1/1/2009..10/20/2009|10/22/2054", "<=06/32/03", ">2008&&<2011|10/17/06", "<02/26/10500", ">05-07-333", ">=03/26/1001", "<=11-11-9900"}, new int[]{-1, -1, 2, -1, -1, 7, 3, 2, 4, 8, 1, 3, -1, -1, 4, 5, -1, 6, -1, -1, 8, 8});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountStateMultiselect", (Object[])new String[][]{{"FirstState"}, {"SecondState"}, {"ThirdState"}, {"FourthState"}, {"FirstState", "ThirdState"}, {"SecondState", "FourthState"}, {"ThirdState", "SecondState"}, {"FourthState", "FirstState", "SecondState"}, {"SeventhState"}, {"ThirdState", "FirstState", "SecondState", "FourthState"}}, new int[]{2, 1, 2, 2, 4, 3, 3, 5, 1, 7});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountAwake", new String[]{"Y", "N"}, new int[]{6, 2});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountUpdateDateTime", new String[]{"!11/01/2009 00:00:00", "11/02/2015 00:00:00|11/06/2009 12:59:59", "11/??/2009 ??:??:??", ">110609 12:59:59", "<=2009 1:2:3", ">=11/06/09 12:59:59", "<11/8/2008 12:00 PM", "Blank", "11/3/1900 00:00:00|>11-7-09 00:00:01", "02/29/2008 07:00:00..11/04/2009 00:00:00", "11/1/09 00:00:00..11/06/09 12:59:59|11/03/1900 00:00:00", "2009..2008", "2000..2009&&>=110507 12:4:38", "<=11/08/2008 12:00 AM", ">=01-01-1000 00:00:00", ">12/31/999 23:59:59", "<01-01-10000 00:00:00", "<=12/31/9999 23:59:59"}, new int[]{-1, 2, -1, 2, 3, 3, 2, -1, 2, 3, 4, -1, 2, 2, 8, -1, -1, 8});
    }

    private static Timestamp createTimestamp(int year, int month, int day, int hour, int minute, int second) {
        Calendar date = Calendar.getInstance();
        date.set(year, month, day, hour, minute, second);
        return new Timestamp(date.getTimeInMillis());
    }

    private void assertDDSearchableAttributeWildcardsWork(DocumentType docType, String principalId, String fieldName, Object[] searchValues, int[] resultSizes) throws Exception {
        if (!(searchValues instanceof String[]) && !(searchValues instanceof String[][])) {
            throw new IllegalArgumentException("'searchValues' parameter has to be either a String[] or a String[][]");
        }
        DocumentSearchCriteria.Builder criteria = null;
        DocumentSearchResults results = null;
        DocumentSearchService docSearchService = KEWServiceLocator.getDocumentSearchService();
        for (int i = 0; i < resultSizes.length; ++i) {
            block9: {
                criteria = DocumentSearchCriteria.Builder.create();
                criteria.setDocumentTypeName(docType.getName());
                if (searchValues instanceof String[][]) {
                    String[] innerArray = (String[])searchValues[i];
                    for (int j = 0; j < innerArray.length; ++j) {
                        criteria.addDocumentAttributeValue(fieldName, innerArray[j]);
                    }
                } else {
                    criteria.addDocumentAttributeValue(fieldName, searchValues[i].toString());
                }
                try {
                    results = docSearchService.lookupDocuments(principalId, criteria.build());
                    if (resultSizes[i] < 0) {
                        Assert.fail((String)(fieldName + "'s search at loop index " + i + " should have thrown an exception"));
                    }
                    if (resultSizes[i] != results.getSearchResults().size()) {
                        Assert.assertEquals((String)(fieldName + "'s search results at loop index " + i + " returned the wrong number of documents."), (long)resultSizes[i], (long)results.getSearchResults().size());
                    }
                }
                catch (Exception ex) {
                    if (resultSizes[i] < 0) break block9;
                    this.LOG.error((Object)"exception", (Throwable)ex);
                    Assert.fail((String)(fieldName + "'s search at loop index " + i + " for search value '" + searchValues[i] + "' should not have thrown an exception"));
                }
            }
            GlobalVariables.clear();
        }
    }

    @Test
    public void testValidateUserSearchInputsNoCast() throws Exception {
        DataDictionarySearchableAttribute searchableAttribute = new DataDictionarySearchableAttribute();
        DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
        try {
            AccountWithDDAttributesDocument document = DOCUMENT_FIXTURE.NORMAL_DOCUMENT.getDocument(documentService);
            documentService.saveDocument((Document)document);
            String string = document.getDocumentNumber();
        }
        catch (UnknownDocumentTypeException udte) {
            Assert.fail((String)("CI failure - https://jira.kuali.org/browse/KULRICE-9289 " + udte.getMessage() + ExceptionUtils.getStackTrace((Throwable)udte)));
        }
        RuntimeException caughtException = null;
        List foundErrors = new ArrayList();
        DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        criteria.setDocumentTypeName(ACCOUNT_WITH_DD_ATTRIBUTES_DOCUMENT_NAME);
        HashMap<String, List<String>> simpleParamMap = new HashMap<String, List<String>>();
        simpleParamMap.put("accountState", Collections.singletonList("FirstState"));
        criteria.setDocumentAttributeValues(simpleParamMap);
        try {
            foundErrors = searchableAttribute.validateDocumentAttributeCriteria(null, criteria.build());
        }
        catch (RuntimeException re) {
            caughtException = re;
        }
        Assert.assertNull((String)("Found Exception " + caughtException), (Object)caughtException);
        Assert.assertTrue((String)("There were errors: " + foundErrors), (foundErrors == null || foundErrors.isEmpty() ? 1 : 0) != 0);
        caughtException = null;
        foundErrors = new ArrayList();
        HashMap listParamMap = new HashMap();
        ArrayList<String> paramValues = new ArrayList<String>();
        paramValues.add("FirstState");
        paramValues.add("SecondState");
        listParamMap.put("accountState", paramValues);
        criteria.setDocumentAttributeValues(listParamMap);
        try {
            foundErrors = searchableAttribute.validateDocumentAttributeCriteria(null, criteria.build());
        }
        catch (RuntimeException re) {
            caughtException = re;
        }
        Assert.assertNull((String)("Found Exception " + caughtException), (Object)caughtException);
        Assert.assertTrue((String)("There were errors: " + foundErrors), (foundErrors == null || foundErrors.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testErrorMessageResolution() throws Exception {
        final DataDictionarySearchableAttribute searchableAttribute = new DataDictionarySearchableAttribute();
        final DocumentSearchCriteria.Builder criteria = DocumentSearchCriteria.Builder.create();
        List errors = (List)GlobalVariables.doInNewGlobalVariables((Callable)new Callable<List<RemotableAttributeError>>(){

            @Override
            public List<RemotableAttributeError> call() {
                GlobalVariables.getMessageMap().putError("fake.property", "error.custom", new String[]{"the error message"});
                return searchableAttribute.validateDocumentAttributeCriteria(null, criteria.build());
            }
        });
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)"the error message", (Object)((RemotableAttributeError)errors.get(0)).getMessage());
    }

    @Test
    public void testMultiSelectIntegration() throws Exception {
        DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
        DocumentType docType = KEWServiceLocator.getDocumentTypeService().findByName(ACCOUNT_WITH_DD_ATTRIBUTES_DOCUMENT_NAME);
        String principalName = "quickstart";
        String principalId = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName).getPrincipalId();
        docService.routeDocument((Document)DOCUMENT_FIXTURE.NORMAL_DOCUMENT.getDocument(docService), "Routing NORMAL_DOCUMENT", null);
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountStateMultiselect", (Object[])new String[][]{{"FirstState"}, {"SecondState"}, {"ThirdState"}, {"FourthState"}, {"FirstState", "SecondState"}, {"FirstState", "ThirdState"}, {"FirstState", "FourthState"}, {"SecondState", "ThirdState"}, {"SecondState", "FourthState"}, {"ThirdState", "FourthState"}, {"FirstState", "SecondState", "ThirdState"}, {"FirstState", "ThirdState", "FourthState"}, {"SecondState", "ThirdState", "FourthState"}, {"FirstState", "SecondState", "ThirdState", "FourthState"}}, new int[]{0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountOpenDate", (Object[])new String[][]{{"10/15/2009"}, {"10/15/2009", "10/17/2009"}, {"10/14/2009", "10/16/2009"}}, new int[]{1, 1, 0});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountBalance", (Object[])new String[][]{{"501.77"}, {"501.77", "63.54"}, {"501.78", "501.74"}, {"502.00"}, {"0.00"}}, new int[]{1, 1, 0, 0, 0});
        this.assertDDSearchableAttributeWildcardsWork(docType, principalId, "accountNumber", (Object[])new String[][]{{"1234567890"}, {"1234567890", "9876543210"}, {"9876543210", "77774"}, {"88881"}, {"0"}}, new int[]{1, 1, 0, 0, 0});
    }

    static /* synthetic */ Timestamp access$000(int x0, int x1, int x2, int x3, int x4, int x5) {
        return DataDictionarySearchableAttributeTest.createTimestamp(x0, x1, x2, x3, x4, x5);
    }

    static enum DOCUMENT_FIXTURE {
        NORMAL_DOCUMENT("Testing NORMAL_DOCUMENT", new Integer(1234567890), "John Doe", new KualiDecimal(501.77), DataDictionarySearchableAttributeTest.access$000(2009, 9, 15, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2009, 10, 1, 0, 0, 0), "SecondState", true),
        ZERO_NUMBER_DOCUMENT("Testing ZERO_NUMBER_DOCUMENT", new Integer(0), "Jane Doe", new KualiDecimal(-100), DataDictionarySearchableAttributeTest.access$000(2009, 9, 16, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2015, 10, 2, 0, 0, 0), "FirstState", true),
        FALSE_AWAKE_DOCUMENT("Testing FALSE_AWAKE_DOCUMENT", new Integer(987654321), "John D'oh", new KualiDecimal(0.0), DataDictionarySearchableAttributeTest.access$000(2006, 9, 17, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(1900, 10, 3, 0, 0, 0), "FourthState", false),
        ODD_NAME_DOCUMENT("Testing ODD_NAME_DOCUMENT", new Integer(88), "_", new KualiDecimal(1.0000051E7), DataDictionarySearchableAttributeTest.access$000(2009, 9, 18, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2009, 10, 4, 0, 0, 0), "FourthState", true),
        ODD_TIMESTAMP_DOCUMENT("Testing ODD_TIMESTAMP_DOCUMENT", new Integer(9000), "Shane Kloe", new KualiDecimal(4.54), DataDictionarySearchableAttributeTest.access$000(2012, 9, 19, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2007, 10, 5, 12, 4, 38), "ThirdState", false),
        ANOTHER_ODD_NAME_DOCUMENT("Testing ANOTHER_ODD_NAME_DOCUMENT", new Integer(1234567889), "---", new KualiDecimal(501), DataDictionarySearchableAttributeTest.access$000(2009, 3, 20, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2009, 10, 6, 12, 59, 59), "ThirdState", true),
        INVALID_STATE_DOCUMENT("Testing INVALID_STATE_DOCUMENT", new Integer(99999), "AAAAAAAAA", new KualiDecimal(2.22), DataDictionarySearchableAttributeTest.access$000(2009, 9, 21, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2009, 10, 7, 0, 0, 1), "SeventhState", true),
        WILDCARD_NAME_DOCUMENT("Testing WILDCARD_NAME_DOCUMENT", new Integer(1), "Sh*ne><K!=e?", new KualiDecimal(771.05), DataDictionarySearchableAttributeTest.access$000(2054, 9, 22, 0, 0, 0), DataDictionarySearchableAttributeTest.access$000(2008, 10, 8, 12, 0, 0), "FirstState", true);

        private String accountDocumentDescription;
        private Integer accountNumber;
        private String accountOwner;
        private KualiDecimal accountBalance;
        private Timestamp accountOpenDate;
        private Timestamp accountUpdateDateTime;
        private String accountState;
        private boolean accountAwake;

        private DOCUMENT_FIXTURE(String accountDocumentDescription, Integer accountNumber, String accountOwner, KualiDecimal accountBalance, Timestamp accountOpenDate, Timestamp accountUpdateDateTime, String accountState, boolean accountAwake) {
            this.accountDocumentDescription = accountDocumentDescription;
            this.accountNumber = accountNumber;
            this.accountOwner = accountOwner;
            this.accountBalance = accountBalance;
            this.accountOpenDate = accountOpenDate;
            this.accountUpdateDateTime = accountUpdateDateTime;
            this.accountState = accountState;
            this.accountAwake = accountAwake;
        }

        public AccountWithDDAttributesDocument getDocument(DocumentService docService) throws WorkflowException {
            AccountWithDDAttributesDocument acctDoc = (AccountWithDDAttributesDocument)docService.getNewDocument(DataDictionarySearchableAttributeTest.ACCOUNT_WITH_DD_ATTRIBUTES_DOCUMENT_NAME);
            acctDoc.getDocumentHeader().setDocumentDescription(this.accountDocumentDescription);
            acctDoc.setAccountNumber(this.accountNumber);
            acctDoc.setAccountOwner(this.accountOwner);
            acctDoc.setAccountBalance(this.accountBalance);
            acctDoc.setAccountOpenDate(this.accountOpenDate);
            acctDoc.setAccountUpdateDateTime(this.accountUpdateDateTime);
            acctDoc.setAccountState(this.accountState);
            acctDoc.setAccountAwake(this.accountAwake);
            return acctDoc;
        }
    }
}

