/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Collections;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermParameterDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.ContextBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.impl.repository.TermBoServiceImpl;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class TermRelatedBoTest
extends AbstractBoTest {
    private TermBoService termBoService;
    private ContextBoService contextRepository;
    private KrmsTypeRepositoryService krmsTypeRepository;

    @Before
    public void setup() {
        this.termBoService = new TermBoServiceImpl();
        ((TermBoServiceImpl)this.termBoService).setBusinessObjectService(this.getBoService());
        this.contextRepository = new ContextBoServiceImpl();
        ((ContextBoServiceImpl)this.contextRepository).setBusinessObjectService(this.getBoService());
        this.krmsTypeRepository = new KrmsTypeBoServiceImpl();
        ((KrmsTypeBoServiceImpl)this.krmsTypeRepository).setBusinessObjectService(this.getBoService());
    }

    @Test
    public void creationTest() {
        KrmsTypeDefinition krmsContextTypeDefinition = KrmsTypeDefinition.Builder.create((String)"KrmsTestContextType", (String)"KRMS").build();
        krmsContextTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsContextTypeDefinition);
        ContextDefinition.Builder contextBuilder = ContextDefinition.Builder.create((String)"KRMS", (String)"testContext");
        contextBuilder.setTypeId(krmsContextTypeDefinition.getId());
        ContextDefinition contextDefinition = contextBuilder.build();
        contextDefinition = this.contextRepository.createContext(contextDefinition);
        TermSpecificationDefinition outputTermSpec = TermSpecificationDefinition.Builder.create(null, (String)"outputTermSpec", (String)contextDefinition.getId(), (String)"java.lang.String").build();
        outputTermSpec = this.termBoService.createTermSpecification(outputTermSpec);
        TermSpecificationDefinition prereqTermSpec = TermSpecificationDefinition.Builder.create(null, (String)"prereqTermSpec", (String)contextDefinition.getId(), (String)"java.lang.String").build();
        prereqTermSpec = this.termBoService.createTermSpecification(prereqTermSpec);
        KrmsTypeDefinition krmsTermResolverTypeDefinition = KrmsTypeDefinition.Builder.create((String)"KrmsTestResolverType", (String)"KRMS").build();
        krmsTermResolverTypeDefinition = this.krmsTypeRepository.createKrmsType(krmsTermResolverTypeDefinition);
        TermResolverDefinition termResolverDef = TermResolverDefinition.Builder.create(null, (String)"KRMS", (String)"testResolver", (String)krmsTermResolverTypeDefinition.getId(), (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)outputTermSpec), Collections.singleton(TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)prereqTermSpec)), null, Collections.singleton("testParamName")).build();
        termResolverDef = this.termBoService.createTermResolver(termResolverDef);
        TermParameterDefinition.Builder termParamBuilder = TermParameterDefinition.Builder.create(null, null, (String)"testParamName", (String)"testParamValue");
        TermDefinition termDefinition = TermDefinition.Builder.create(null, (TermSpecificationDefinition.Builder)TermSpecificationDefinition.Builder.create((TermSpecificationDefinitionContract)outputTermSpec), Collections.singletonList(termParamBuilder)).build();
        this.termBoService.createTerm(termDefinition);
    }
}

