/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.type.ActionTypeService;

public class TestActionTypeService
implements ActionTypeService {
    private static final Set<String> actionsFired = new HashSet<String>();

    public static void resetActionsFired() {
        actionsFired.clear();
    }

    public static boolean actionFired(String name) {
        return actionsFired.contains(name);
    }

    public Action loadAction(ActionDefinition actionDefinition) {
        return new TestAction(actionDefinition.getName());
    }

    public List<RemotableAttributeField> getAttributeFields(String id) {
        return Collections.emptyList();
    }

    public List<RemotableAttributeError> validateAttributes(String id, Map<String, String> attributes) throws RiceIllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public List<RemotableAttributeError> validateAttributesAgainstExisting(String id, Map<String, String> newAttributes, Map<String, String> oldAttributes) throws RiceIllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    private class TestAction
    implements Action {
        private final String name;

        private TestAction(String name) {
            this.name = name;
        }

        public void execute(ExecutionEnvironment environment) {
            actionsFired.add(this.name);
        }

        public void executeSimulation(ExecutionEnvironment environment) {
            throw new UnsupportedOperationException();
        }
    }
}

