/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.TermBoService;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class TermBoServiceTest
extends AbstractBoTest {
    TermBoService termBoService = null;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.termBoService = KrmsRepositoryServiceLocator.getTermBoService();
    }

    @Test
    public void testGetTermSpecificationById_nullOrBlank() {
        for (String id : Arrays.asList(null, "", " ")) {
            try {
                this.termBoService.getTermSpecificationById(id);
                Assert.fail((String)("getTermSpecificationById should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid id=" + id + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetTermSpecificationById_invalid() {
        TermSpecificationDefinition termSpecificationDefinition = this.termBoService.getTermSpecificationById("1");
        Assert.assertNull((String)"getTermSpecificationById should have returned null with no error", (Object)termSpecificationDefinition);
    }

    @Test
    public void testGetTermSpecificationById_valid() {
        TermSpecificationDefinition.Builder termSpecBuilder = TermSpecificationDefinition.Builder.create(null, (String)"1", (String)"testTermSpec", (String)"java.lang.String");
        TermSpecificationDefinition termSpecificationDefinition = this.termBoService.createTermSpecification(termSpecBuilder.build());
        TermSpecificationDefinition fetchedTermSpec = this.termBoService.getTermSpecificationById(termSpecificationDefinition.getId());
        Assert.assertNotNull((String)"getTermSpecificationById should not have returned null", (Object)fetchedTermSpec);
    }

    @Test
    public void testPersistTermSpecificationContextIds() {
        ContextDefinition context1 = this.createContextDefinition("KR-SAP", "TermBoServiceTest-Context1", Collections.emptyMap());
        ContextDefinition context2 = this.createContextDefinition("KR-SAP", "TermBoServiceTest-Context2", Collections.emptyMap());
        this.termBoService = (TermBoService)GlobalResourceLoader.getService((String)"termBoService");
        TermSpecificationDefinition.Builder termSpecBuilder = TermSpecificationDefinition.Builder.create(null, (String)"1", (String)"testTermSpec", (String)"java.lang.String");
        termSpecBuilder.getContextIds().add(context1.getId());
        termSpecBuilder.getContextIds().add(context2.getId());
        TermSpecificationDefinition termSpecificationDefinition = this.termBoService.createTermSpecification(termSpecBuilder.build());
        Assert.assertNotNull((Object)termSpecificationDefinition);
        Assert.assertTrue((termSpecificationDefinition.getContextIds().size() == 2 ? 1 : 0) != 0);
        for (String contextId : Arrays.asList(context1.getId(), context2.getId())) {
            Assert.assertTrue((boolean)termSpecificationDefinition.getContextIds().contains(contextId));
        }
        TermSpecificationDefinition fetchedTermSpec = this.termBoService.getTermSpecificationById(termSpecificationDefinition.getId());
        for (String contextId : Arrays.asList(context1.getId(), context2.getId())) {
            Assert.assertTrue((String)"https://jira.kuali.org/browse/KULRICE-9850 ", (boolean)fetchedTermSpec.getContextIds().contains(contextId));
        }
    }
}

