/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Iterator;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.MockDataFieldMaxValueIncrementer;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.test.KRMSTestCase;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class AgendaBoTest
extends KRMSTestCase {
    public static final String TEST_PREFIX = "AgendaBoTest";

    @Test
    public void testCopy() {
        AgendaBo.agendaIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        AgendaItemBo.agendaItemIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        RuleBo.ruleIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        RuleBo.actionAttributeIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        RuleBo.actionIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        RuleBo.ruleAttributeIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        PropositionBo.propositionIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        PropositionBo.propositionParameterIdIncrementer.setDataFieldMaxValueIncrementer((DataFieldMaxValueIncrementer)new MockDataFieldMaxValueIncrementer());
        ContextBo contextBo = ContextBo.from((ContextDefinition)ContextDefinition.Builder.create((String)"AgendaBoTestContextName", (String)"AgendaBoTestNamespace").build());
        contextBo.setId("AgendaBoTestContextId");
        AgendaBo agendaBo = new AgendaBo();
        agendaBo.setId("AgendaBoTestAgendaId00");
        agendaBo.setName("AgendaBoTestAgendaName");
        agendaBo.setContext(contextBo);
        RuleBo ruleBo00 = this.newTestRuleBo("00");
        RuleBo ruleBo01 = this.newTestRuleBo("01");
        RuleBo ruleBo02 = this.newTestRuleBo("02");
        RuleBo ruleBo03 = this.newTestRuleBo("03");
        RuleBo ruleBo04 = this.newTestRuleBo("04");
        RuleBo ruleBo05 = this.newTestRuleBo("05");
        RuleBo ruleBo06 = this.newTestRuleBo("06");
        LinkedList<AgendaItemBo> agendaItemBos = new LinkedList<AgendaItemBo>();
        AgendaItemBo agendaItemBo00 = this.newTestAgendaItemBo("00", ruleBo00, agendaBo.getId());
        agendaItemBos.add(agendaItemBo00);
        AgendaItemBo agendaItemBo01 = this.newTestAgendaItemBo("01", ruleBo01, agendaBo.getId());
        agendaItemBos.add(agendaItemBo01);
        AgendaItemBo agendaItemBo02 = this.newTestAgendaItemBo("02", ruleBo02, agendaBo.getId());
        agendaItemBos.add(agendaItemBo02);
        AgendaItemBo agendaItemBo03 = this.newTestAgendaItemBo("03", ruleBo03, agendaBo.getId());
        agendaItemBos.add(agendaItemBo03);
        AgendaItemBo agendaItemBo04 = this.newTestAgendaItemBo("04", ruleBo04, agendaBo.getId());
        agendaItemBos.add(agendaItemBo04);
        AgendaItemBo agendaItemBo05 = this.newTestAgendaItemBo("05", ruleBo05, agendaBo.getId());
        agendaItemBos.add(agendaItemBo05);
        AgendaItemBo agendaItemBo06 = this.newTestAgendaItemBo("06", ruleBo06, agendaBo.getId());
        agendaItemBos.add(agendaItemBo06);
        agendaItemBo00.setWhenTrue(agendaItemBo01);
        agendaItemBo00.setWhenFalse(agendaItemBo04);
        agendaItemBo00.setAlways(agendaItemBo05);
        agendaItemBo01.setAlways(agendaItemBo02);
        agendaItemBo02.setWhenFalse(agendaItemBo06);
        agendaItemBo02.setAlways(agendaItemBo03);
        agendaBo.setFirstItemId(agendaItemBo00.getId());
        agendaBo.setFirstItem(agendaItemBo00);
        agendaBo.setItems(agendaItemBos);
        AgendaBo copiedAgenda = agendaBo.copyAgenda("NewAgendaCopy", "dts123");
        Assert.assertFalse((agendaItemBo00.getAgendaId() == null ? 1 : 0) != 0);
        Assert.assertTrue((String)("agendaBo.getItems().size() of " + agendaBo.getItems().size() + " is not equal to copiedAgenda.getItems().size() of " + copiedAgenda.getItems().size()), (agendaBo.getItems().size() == copiedAgenda.getItems().size() ? 1 : 0) != 0);
        boolean[] ids = new boolean[]{false, false, false, false, false, false, false};
        Assert.assertTrue((String)("agendaBo.getItems().size() of " + agendaBo.getItems().size() + " does not match ids.length" + ids.length), (agendaBo.getItems().size() == ids.length ? 1 : 0) != 0);
        Iterator copiedItems = copiedAgenda.getItems().iterator();
        int index = 0;
        while (copiedItems.hasNext()) {
            try {
                index = Integer.parseInt(((AgendaItemBo)copiedItems.next()).getId());
                ids[index] = true;
            }
            catch (IndexOutOfBoundsException e) {
                Assert.fail((String)("copied agenda item id " + index + " is higher than " + ids.length));
            }
        }
        for (int i = 0; i < ids.length; ++i) {
            Assert.assertTrue((String)("agenda item id verification of " + i + " is false"), (boolean)ids[i]);
        }
        copiedItems = copiedAgenda.getItems().iterator();
        long lastVersion = -1L;
        long version = -1L;
        while (copiedItems.hasNext()) {
            AgendaItemBo agendaItemBo = (AgendaItemBo)copiedItems.next();
            if (agendaItemBo.getVersionNumber() == null) continue;
            version = agendaItemBo.getVersionNumber();
            if (lastVersion == -1L) {
                lastVersion = version;
                continue;
            }
            Assert.assertTrue((lastVersion == version ? 1 : 0) != 0);
            lastVersion = version;
        }
    }

    private RuleBo newTestRuleBo(String testId) {
        String ruleId = "AgendaBoTestRuleId" + testId;
        PropositionDefinition.Builder prop = PropositionDefinition.Builder.create((String)("AgendaBoTestPropositionId" + testId), (String)PropositionType.SIMPLE.getCode(), (String)ruleId, null, null);
        RuleDefinition.Builder builder = RuleDefinition.Builder.create((String)ruleId, (String)(ruleId + "Name"), (String)"AgendaBoTestNamespace", null, (String)prop.getId());
        builder.setProposition(prop);
        return RuleBo.from((RuleDefinition)builder.build());
    }

    private AgendaItemDefinition.Builder newTestAgendaItem(String testId, RuleBo ruleBo, String agendaId) {
        return AgendaItemDefinition.Builder.create((String)("AgendaBoTestAgendaItemId" + testId), (String)agendaId);
    }

    private AgendaItemBo newTestAgendaItemBo(String testId, RuleBo ruleBo, String agendaId) {
        return AgendaItemBo.from((AgendaItemDefinition)this.newTestAgendaItem(testId, ruleBo, agendaId).build());
    }
}

