/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeEntryDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementAgendaItemDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMAIDT";
    }

    @Test
    public void testCreateAgendaItem() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        String ruleId = this.buildTestRuleDefinition(t0.namespaceName, t0.object0).getId();
        String agendaId = this.createTestAgenda(t0.object0).getId();
        AgendaItemDefinition agendaItemDefinition = this.buildTestAgendaItemDefinition(t0.agendaItem_Id, agendaId, ruleId);
        AgendaDefinition agendaDefinition = this.ruleManagementService.getAgenda(agendaId);
        AgendaDefinition.Builder agendaDefinitionBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        agendaDefinitionBuilder.setFirstItemId(agendaItemDefinition.getId());
        this.ruleManagementService.updateAgenda(agendaDefinitionBuilder.build());
        agendaItemDefinition = this.ruleManagementService.getAgendaItem(agendaItemDefinition.getId());
        agendaDefinition = this.ruleManagementService.getAgenda(agendaId);
        Assert.assertEquals((String)"Expected Context not found", (Object)t0.contextId, (Object)agendaDefinition.getContextId());
        Assert.assertEquals((String)"Expected AgendaId not found", (Object)t0.agenda_Id, (Object)agendaDefinition.getId());
        Assert.assertEquals((String)"Expected AgendaItemId not found", (Object)t0.agendaItem_0_Id, (Object)agendaDefinition.getFirstItemId());
        Assert.assertEquals((String)"Expected Rule of AgendaItem not found", (Object)t0.rule_0_Id, (Object)this.ruleManagementService.getAgendaItem(agendaDefinition.getFirstItemId()).getRule().getId());
    }

    @Test
    public void testCreateComplexAgendaItem() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        this.buildComplexAgenda(t1);
        List agendaItems = this.ruleManagementService.getAgendaItemsByContext(t1.contextId);
        Assert.assertEquals((String)"Invalid number of agendaItems created", (long)8L, (long)agendaItems.size());
    }

    @Test
    public void testGetAgendaItem() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        this.buildComplexAgenda(t2);
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t2.agendaItem_0_Id);
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_0_Id, (Object)agendaItem.getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agenda_Id, (Object)agendaItem.getAgendaId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_3_Id, (Object)agendaItem.getAlwaysId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_3_Id, (Object)agendaItem.getAlways().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.rule_0_Id, (Object)agendaItem.getRuleId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_1_Id, (Object)agendaItem.getWhenTrue().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_1_Id, (Object)agendaItem.getWhenTrueId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_2_Id, (Object)agendaItem.getWhenFalse().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t2.agendaItem_2_Id, (Object)agendaItem.getWhenFalseId());
        RuleDefinition ruleDefinition = agendaItem.getRule();
        Assert.assertEquals((String)"Invalid RuleId found for agendaItem", (Object)t2.rule_0_Id, (Object)ruleDefinition.getId());
        Assert.assertEquals((String)"Invalid RuleId found for agendaItem", (Object)t2.rule_0_Name, (Object)ruleDefinition.getName());
        Assert.assertEquals((String)"Invalid RuleId found for agendaItem", (Object)t2.proposition_0_Descr, (Object)ruleDefinition.getProposition().getDescription());
        Assert.assertEquals((String)"Invalid RuleId found for agendaItem", (Object)"S", (Object)ruleDefinition.getProposition().getPropositionTypeCode());
        List agendaItems = this.ruleManagementService.getAgendaItemsByContext(t2.contextId);
        Assert.assertEquals((String)"Invalid number of agendaItems created", (long)8L, (long)agendaItems.size());
        AgendaItemDefinition junkAgendaItem = this.ruleManagementService.getAgendaItem("junk");
        Assert.assertNull((String)"AgendaItem is not null", (Object)junkAgendaItem);
    }

    @Test
    public void testGetAgendaItemsByType() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        this.createComplexAgenda(t3.namespaceName, t3.namespaceType, t3);
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        this.createComplexAgenda(t4.namespaceName, t3.namespaceType, t4);
        Assert.assertEquals((String)"Incorrect number of agendaItems found", (long)16L, (long)this.ruleManagementService.getAgendaItemsByType(t3.namespaceType).size());
    }

    @Test
    public void testGetAgendaItemsByContext() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        this.buildComplexAgenda(t5);
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        this.buildComplexAgenda(t6);
        Assert.assertEquals((String)"Incorrect number of agendaItems returned", (long)8L, (long)this.ruleManagementService.getAgendaItemsByContext(t5.contextId).size());
        Assert.assertEquals((String)"No agendaItems should have been returned", (long)0L, (long)this.ruleManagementService.getAgendaItemsByContext("junk").size());
    }

    @Test
    public void testGetAgendaItemsByTypeAndContext() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        this.createComplexAgenda(t7.namespaceName, t7.namespaceType, t7);
        RuleManagementBaseTestObjectNames t8 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t8");
        this.createComplexAgenda(t8.namespaceName, t7.namespaceType, t8);
        Assert.assertEquals((String)"Incorrect number of agendaItems returned", (long)8L, (long)this.ruleManagementService.getAgendaItemsByTypeAndContext(t7.namespaceType, t8.contextId).size());
        Assert.assertEquals((String)"Incorrect number of agendaItems returned", (long)8L, (long)this.ruleManagementService.getAgendaItemsByTypeAndContext(t7.namespaceType, t7.contextId).size());
        Assert.assertEquals((String)"Incorrect number of agendaItems returned", (long)0L, (long)this.ruleManagementService.getAgendaItemsByTypeAndContext("badType", t7.contextId).size());
        Assert.assertEquals((String)"Incorrect number of agendaItems returned", (long)0L, (long)this.ruleManagementService.getAgendaItemsByTypeAndContext(t7.namespaceType, "badContext").size());
        try {
            this.ruleManagementService.getAgendaItemsByTypeAndContext(null, t7.contextId);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: type ID is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getAgendaItemsByTypeAndContext("    ", t7.contextId);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: type ID is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getAgendaItemsByTypeAndContext(t7.namespaceType, null);
            Assert.fail((String)"Should have thrown RiceIllegalArgumentException: context ID is null or blank");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteAgendaItem() {
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        AgendaDefinition.Builder agendaBuilder4900 = this.buildComplexAgenda(t9);
        List agendaItems = this.ruleManagementService.getAgendaItemsByContext(t9.contextId);
        Assert.assertEquals((String)"Invalid number of agendaItems created", (long)8L, (long)agendaItems.size());
        this.ruleManagementService.deleteAgendaItem(t9.agendaItem_0_Id);
        agendaItems = this.ruleManagementService.getAgendaItemsByContext(t9.contextId);
        Assert.assertEquals((String)"Invalid number of agendaItems created", (long)7L, (long)agendaItems.size());
        AgendaItemDefinition junkAgendaItem = this.ruleManagementService.getAgendaItem("junk");
        Assert.assertNull((String)"AgendaItem is not null", (Object)junkAgendaItem);
    }

    @Test
    @Ignore(value="TODO: figure out how to re-enable")
    public void testUpdateAgendaItem() {
        RuleManagementBaseTestObjectNames t10 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t10");
        this.buildComplexAgenda(t10);
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_0_Id);
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_0_Id, (Object)agendaItem.getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agenda_Id, (Object)agendaItem.getAgendaId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_3_Id, (Object)agendaItem.getAlwaysId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_3_Id, (Object)agendaItem.getAlways().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.rule_0_Id, (Object)agendaItem.getRuleId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenTrue().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenTrueId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenFalse().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenFalseId());
        AgendaItemDefinition.Builder agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
        agendaItemBuilder.setWhenFalse(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.getAgendaItem(t10.agendaItem_1_Id)));
        agendaItemBuilder.setWhenFalseId(t10.agendaItem_1_Id);
        agendaItemBuilder.setWhenTrue(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)this.ruleManagementService.getAgendaItem(t10.agendaItem_2_Id)));
        agendaItemBuilder.setWhenTrueId(t10.agendaItem_2_Id);
        agendaItemBuilder.setAlways(null);
        agendaItemBuilder.setAlwaysId(null);
        this.ruleManagementService.updateAgendaItem(agendaItemBuilder.build());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_0_Id);
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_0_Id, (Object)agendaItem.getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agenda_Id, (Object)agendaItem.getAgendaId());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlwaysId());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlways());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.rule_0_Id, (Object)agendaItem.getRuleId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenTrue().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenTrueId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenFalse().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenFalseId());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_1_Id);
        agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
        agendaItemBuilder.setWhenFalseId(null);
        agendaItemBuilder.setWhenTrueId(null);
        agendaItemBuilder.setAlwaysId(null);
        this.ruleManagementService.updateAgendaItem(agendaItemBuilder.build());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_0_Id);
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlwaysId());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlways());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenTrue().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_2_Id, (Object)agendaItem.getWhenTrueId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenFalse().getId());
        Assert.assertEquals((String)"Invalid AgendaItem value", (Object)t10.agendaItem_1_Id, (Object)agendaItem.getWhenFalseId());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_0_Id);
        agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
        agendaItemBuilder.setWhenFalse(null);
        agendaItemBuilder.setWhenTrue(null);
        agendaItemBuilder.setAlways(null);
        this.ruleManagementService.updateAgendaItem(agendaItemBuilder.build());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_0_Id);
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlwaysId());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getAlways());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getWhenTrue());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getWhenTrueId());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getWhenFalse());
        Assert.assertEquals((String)"Invalid AgendaItem value", null, (Object)agendaItem.getWhenFalseId());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_7_Id);
        agendaItemBuilder = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItem);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(t10.actionAttribute_Key, t10.actionAttribute1_Value);
        for (ActionDefinition.Builder actionBuilder : agendaItemBuilder.getRule().getActions()) {
            actionBuilder.setAttributes(attributes);
        }
        this.ruleManagementService.updateAgendaItem(agendaItemBuilder.build());
        agendaItem = this.ruleManagementService.getAgendaItem(t10.agendaItem_7_Id);
        Assert.assertNotNull((String)"Invalid AgendaItem Rule", (Object)agendaItem.getRule());
        Assert.assertNotNull((String)"Invalid AgendaItem Rule Actions", (Object)agendaItem.getRule().getActions());
        Assert.assertEquals((String)"Invalid AgendaItem Rule Actions count", (long)1L, (long)agendaItem.getRule().getActions().size());
        for (ActionDefinition action : agendaItem.getRule().getActions()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("actionId", action.getId());
            List actionAttributes = BusinessObjectServiceMigrationUtils.findMatching((DataObjectService)this.dataObjectService, ActionAttributeBo.class, map);
            Assert.assertEquals((String)"Invalid AgendaItem Rule Actions attribute count", (long)1L, (long)actionAttributes.size());
            for (ActionAttributeBo actionAttribute : actionAttributes) {
                String expectedAttribute = t10.actionAttribute1_Value;
                String actualAttribute = actionAttribute.getValue();
                Assert.assertEquals((String)"Invalid AgendaItem Rule Actions attribute", (Object)expectedAttribute, (Object)actualAttribute);
            }
        }
    }

    @Test
    public void testAgendaItemCacheEvict() {
        RuleManagementBaseTestObjectNames t11 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t11");
        this.verifyEmptyAgendaItem(t11);
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t11.namespaceName, t11.object0);
        AgendaDefinition agendaDefinition = this.createTestAgenda(t11.object0);
        AgendaItemDefinition agendaItemDefinition = this.buildTestAgendaItemDefinition(t11.agendaItem_Id, agendaDefinition.getId(), ruleDefinition.getId());
        agendaDefinition = this.ruleManagementService.getAgenda(agendaDefinition.getId());
        AgendaDefinition.Builder agendaDefinitionBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDefinition);
        agendaDefinitionBuilder.setFirstItemId(agendaItemDefinition.getId());
        this.ruleManagementService.updateAgenda(agendaDefinitionBuilder.build());
        this.verifyFullAgendaItem(t11);
    }

    private void verifyEmptyAgendaItem(RuleManagementBaseTestObjectNames t) {
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertNull((String)"AgendaItem is not null", (Object)agendaItem);
        AgendaDefinition agenda = this.ruleManagementService.getAgenda(t.agenda_Id);
        Assert.assertFalse((String)"AgendaItem in Agenda found", (agenda != null ? 1 : 0) != 0);
        boolean foundAgendaItem = false;
        ContextDefinition context = this.ruleManagementService.getContext(t.contextId);
        if (context != null) {
            for (AgendaDefinition contextAgenda : context.getAgendas()) {
                if (!StringUtils.equals((String)t.agendaItem_Id, (String)contextAgenda.getFirstItemId())) continue;
                foundAgendaItem = true;
                break;
            }
        }
        Assert.assertFalse((String)"AgendaItem in Context found", (boolean)foundAgendaItem);
        AgendaTreeDefinition agendaTree = this.ruleManagementService.getAgendaTree(t.agenda_Id);
        Assert.assertFalse((String)"AgendaItem in AgendaTree found", (agendaTree != null ? 1 : 0) != 0);
    }

    private void verifyFullAgendaItem(RuleManagementBaseTestObjectNames t) {
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertNotNull((String)"AgendaItem is null", (Object)agendaItem);
        AgendaDefinition agenda = this.ruleManagementService.getAgenda(t.agenda_Id);
        Assert.assertTrue((String)"AgendaItem in Agenda not found", (agenda != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"AgendaItem in Agenda not found", (boolean)StringUtils.equals((String)t.agendaItem_Id, (String)agenda.getFirstItemId()));
        boolean foundAgendaItem = false;
        ContextDefinition context = this.ruleManagementService.getContext(t.contextId);
        if (context != null) {
            for (AgendaDefinition contextAgenda : context.getAgendas()) {
                if (!StringUtils.equals((String)t.agendaItem_Id, (String)contextAgenda.getFirstItemId())) continue;
                foundAgendaItem = true;
                break;
            }
        }
        Assert.assertTrue((String)"AgendaItem in Context not found", (boolean)foundAgendaItem);
        foundAgendaItem = false;
        AgendaTreeDefinition agendaTree = this.ruleManagementService.getAgendaTree(t.agenda_Id);
        if (agendaTree != null) {
            for (AgendaTreeEntryDefinitionContract agendaTreeEntry : agendaTree.getEntries()) {
                if (!StringUtils.equals((String)t.agendaItem_Id, (String)agendaTreeEntry.getAgendaItemId())) continue;
                foundAgendaItem = true;
                break;
            }
        }
        Assert.assertTrue((String)"AgendaItem in AgendaTree not found", (boolean)foundAgendaItem);
    }
}

