/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;
import org.springframework.dao.DataAccessException;

public class RuleManagementNaturalLanguageTemplateTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMLTT";
    }

    @Test
    public void testCreateNaturalLanguageTemplate() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        Assert.assertNull((Object)this.ruleManagementService.getNaturalLanguageTemplate("en-reqActive"));
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t0.namespaceName, "en", "reqActive", "Must not be inActive", true);
        template = this.ruleManagementService.getNaturalLanguageTemplate("en-reqActive");
        Assert.assertNotNull((Object)this.ruleManagementService.getNaturalLanguageTemplate("en-reqActive"));
        Assert.assertEquals((String)"Unexpected language code found", (Object)"en", (Object)template.getLanguageCode());
        Assert.assertEquals((String)"Unexpected template found", (Object)"Must not be inActive", (Object)template.getTemplate());
        Assert.assertEquals((String)"Unexpected TypeId value", (Object)this.krmsTypeRepository.getTypeByName(t0.namespaceName, "reqActive").getId(), (Object)template.getTypeId());
        Assert.assertEquals((String)"Unexpected Active value", (Object)true, (Object)template.isActive());
        try {
            NaturalLanguageTemplate.Builder.create(null, (String)template.getNaturalLanguageUsageId(), (String)"Ky objekt nuk duhet t\u00eb jet\u00eb joaktive", (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"  ", (String)template.getNaturalLanguageUsageId(), (String)"Objektu hau ezin da ez-aktiboak", (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"it", null, (String)"Questo oggetto non deve essere inattivo", (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"ja", (String)"  ", (String)"\u3053\u306e\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u975e\u30a2\u30af\u30c6\u30a3\u30d6\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093", (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"az", (String)template.getNaturalLanguageUsageId(), null, (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: template is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"bg", (String)template.getNaturalLanguageUsageId(), (String)"   ", (String)template.getTypeId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: template is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"hr", (String)template.getNaturalLanguageUsageId(), (String)"Ovaj objekt ne smije biti neaktivna", null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: typeId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            NaturalLanguageTemplate.Builder.create((String)"cs", (String)template.getNaturalLanguageUsageId(), (String)"Tento objekt nesm\u00ed b\u00fdt neaktivn\u00ed", (String)"  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: typeId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NaturalLanguageTemplate.Builder naturalLanguageTemplateBuilder = NaturalLanguageTemplate.Builder.create((String)"da", (String)template.getNaturalLanguageUsageId(), (String)"Dette form\u00e5l m\u00e5 ikke v\u00e6re inaktiv", (String)"badId");
        naturalLanguageTemplateBuilder.setId("da-reqActive");
        try {
            this.ruleManagementService.createNaturalLanguageTemplate(naturalLanguageTemplateBuilder.build());
            Assert.fail((String)"Should have thrown PersistenceException");
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNaturalLanguageTemplate() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t1.namespaceName, "sw", "reqActive", "Detta \u00e4ndam\u00e5l f\u00e5r inte vara inaktiv", true);
        Assert.assertNotNull((Object)this.ruleManagementService.getNaturalLanguageTemplate("sw-reqActive"));
        Assert.assertEquals((String)"Unexpected language code found", (Object)"sw", (Object)template.getLanguageCode());
        try {
            this.ruleManagementService.getNaturalLanguageTemplate(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageTemplateId was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getNaturalLanguageTemplate("  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageTemplateId was blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.ruleManagementService.getNaturalLanguageTemplate("badId"));
    }

    @Test
    public void testUpdateNaturalLanguageTemplate() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t2.namespaceName, "pl", "reqActive", "Isthay Objectway ustmay otnay ebay inActiveway", true);
        NaturalLanguageTemplate.Builder naturalLanguageTemplateBuilder = NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)this.ruleManagementService.getNaturalLanguageTemplate("pl-reqActive"));
        naturalLanguageTemplateBuilder.setTemplate("Ten obiekt nie moze byc nieaktywne");
        naturalLanguageTemplateBuilder.setActive(true);
        this.ruleManagementService.updateNaturalLanguageTemplate(naturalLanguageTemplateBuilder.build());
        Assert.assertEquals((String)"Unexpected template value found", (Object)"Ten obiekt nie moze byc nieaktywne", (Object)this.ruleManagementService.getNaturalLanguageTemplate("pl-reqActive").getTemplate());
        Assert.assertEquals((String)"Unexpected isActive value found", (Object)true, (Object)this.ruleManagementService.getNaturalLanguageTemplate("pl-reqActive").isActive());
    }

    @Test
    public void testDeleteNaturalLanguageTemplate() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t3.namespaceName, "pt", "reqActive", "Este objeto nao deve ser inativo", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("pt-reqActive"));
        this.ruleManagementService.deleteNaturalLanguageTemplate("pt-reqActive");
        Assert.assertNull((String)"Should not have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("pt-reqActive"));
        try {
            this.ruleManagementService.deleteNaturalLanguageTemplate(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageTemplateId was null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteNaturalLanguageTemplate("    ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageTemplateId was blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.deleteNaturalLanguageTemplate("badValue");
            Assert.fail((String)"Should have thrown IllegalStateException: the NaturalLanguageTemplate to delete does not exists: badValue");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFindNaturalLanguageTemplatesByLanguageCode() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t4.namespaceName, "ro", "reqActive", "Acest obiect nu trebuie sa fie inactiv", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("ro-reqActive"));
        List nlTemplates = this.ruleManagementService.findNaturalLanguageTemplatesByLanguageCode("ro");
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)1L, (long)nlTemplates.size());
        Assert.assertEquals((String)"Unexpected template id returned", (Object)"ro-reqActive", (Object)((NaturalLanguageTemplate)nlTemplates.get(0)).getId());
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByLanguageCode(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByLanguageCode("  ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)0L, (long)this.ruleManagementService.findNaturalLanguageTemplatesByLanguageCode("badValue").size());
    }

    @Test
    public void testFindNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t5.namespaceName, "sk", "reqActive", "Tento objekt nesmie byt neakt\u00edvne", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("sk-reqActive"));
        template = this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(template.getLanguageCode(), template.getTypeId(), template.getNaturalLanguageUsageId());
        Assert.assertEquals((String)"Unexpected template id returned", (Object)"sk-reqActive", (Object)template.getId());
        Assert.assertEquals((String)"Unexpected language code found", (Object)"sk", (Object)template.getLanguageCode());
        Assert.assertEquals((String)"Unexpected template found", (Object)"Tento objekt nesmie byt neakt\u00edvne", (Object)template.getTemplate());
        Assert.assertEquals((String)"Unexpected TypeId value", (Object)this.krmsTypeRepository.getTypeByName(t5.namespaceName, "reqActive").getId(), (Object)template.getTypeId());
        Assert.assertEquals((String)"Unexpected Active value", (Object)true, (Object)template.isActive());
        try {
            this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(null, template.getTypeId(), template.getNaturalLanguageUsageId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(template.getLanguageCode(), null, template.getNaturalLanguageUsageId());
        this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId(template.getLanguageCode(), template.getTypeId(), null);
        try {
            this.ruleManagementService.findNaturalLanguageTemplateByLanguageCodeTypeIdAndNluId("  ", template.getTypeId(), template.getNaturalLanguageUsageId());
            Assert.fail((String)"Should have thrown IllegalArgumentException: languageCode is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFindNaturalLanguageTemplatesByNaturalLanguageUsage() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t6.namespaceName, "sl", "reqActive-SL", "Ta predmet ne sme biti neaktiven", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("sl-reqActive-SL"));
        List templates = this.ruleManagementService.findNaturalLanguageTemplatesByNaturalLanguageUsage(template.getNaturalLanguageUsageId());
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)1L, (long)templates.size());
        template = (NaturalLanguageTemplate)templates.get(0);
        Assert.assertEquals((String)"Unexpected template id returned", (Object)"sl-reqActive-SL", (Object)template.getId());
        Assert.assertEquals((String)"Unexpected language code found", (Object)"sl", (Object)template.getLanguageCode());
        Assert.assertEquals((String)"Unexpected template found", (Object)"Ta predmet ne sme biti neaktiven", (Object)template.getTemplate());
        Assert.assertEquals((String)"Unexpected TypeId value", (Object)this.krmsTypeRepository.getTypeByName(t6.namespaceName, "reqActive-SL").getId(), (Object)template.getTypeId());
        Assert.assertEquals((String)"Unexpected Active value", (Object)true, (Object)template.isActive());
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByNaturalLanguageUsage(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByNaturalLanguageUsage("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: naturalLanguageUsageId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)0L, (long)this.ruleManagementService.findNaturalLanguageTemplatesByNaturalLanguageUsage("badValue").size());
    }

    @Test
    public void testFindNaturalLanguageTemplatesByType() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t7.namespaceName, "es", "reqActive-ES", "Este objeto no debe estar inactivo", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("es-reqActive-ES"));
        List templates = this.ruleManagementService.findNaturalLanguageTemplatesByType(template.getTypeId());
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)1L, (long)templates.size());
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByType(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: typeId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByType("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: typeId is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)0L, (long)this.ruleManagementService.findNaturalLanguageTemplatesByType("badValue").size());
    }

    @Test
    public void testFindNaturalLanguageTemplatesByTemplate() {
        RuleManagementBaseTestObjectNames t8 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t8");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t8.namespaceName, "sv", "reqActive", "Detta \u00e4ndamal far inte vara inaktiv", true);
        Assert.assertNotNull((String)"Should have found NaturalLanguageTemplate", (Object)this.ruleManagementService.getNaturalLanguageTemplate("sv-reqActive"));
        List templates = this.ruleManagementService.findNaturalLanguageTemplatesByTemplate("Detta \u00e4ndamal far inte vara inaktiv");
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)1L, (long)templates.size());
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByTemplate(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException: template is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.findNaturalLanguageTemplatesByTemplate("   ");
            Assert.fail((String)"Should have thrown IllegalArgumentException: template is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"Unexpected number of templates returned ", (long)0L, (long)this.ruleManagementService.findNaturalLanguageTemplatesByTemplate("badValue").size());
    }

    @Test
    public void testCreateNaturalLanguageTemplateWithGeneratedId() {
        RuleManagementBaseTestObjectNames t9 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t9");
        NaturalLanguageTemplate template = this.createTestNaturalLanguageTemplate(t9.namespaceName, "XX", "reqActive-XX", "Template name", false);
        Assert.assertNotNull((Object)this.ruleManagementService.getNaturalLanguageTemplate(template.getId()));
        Assert.assertEquals((String)"Unexpected number of attributes created ", (long)2L, (long)template.getAttributes().size());
    }
}

