/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinitionContract;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.KrmsTypeBo;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImplGenTest;
import org.kuali.rice.krms.test.AbstractBoTest;

public final class KrmsTypeIntegrationGenTest
extends AbstractBoTest {
    KrmsTypeBoServiceImpl krmsTypeBoServiceImpl;
    KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    KrmsTypeDefinition krmsType;

    @Before
    public void setup() {
        this.krmsTypeBoServiceImpl = new KrmsTypeBoServiceImpl();
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.krmsTypeBoServiceImpl.setDataObjectService(this.getDataObjectService());
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeById_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getTypeById_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getTypeByName_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getTypeByName_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllTypesByNamespace_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_findAllTypesByNamespace_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllAgendaTypesByContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_findAllAgendaTypesByContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAgendaTypeByAgendaTypeIdAndContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getAgendaTypeByAgendaTypeIdAndContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllRuleTypesByContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_findAllRuleTypesByContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getRuleTypeByRuleTypeIdAndContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getRuleTypeByRuleTypeIdAndContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_findAllActionTypesByContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_findAllActionTypesByContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getActionTypeByActionTypeIdAndContextId_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getActionTypeByActionTypeIdAndContextId_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionById_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getAttributeDefinitionById_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getAttributeDefinitionByName_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_getAttributeDefinitionByName_null_fail();
    }

    @Test
    public void test_createKrmsType() {
        KrmsTypeBoServiceImplGenTest test = KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl);
        test.test_createKrmsType();
        this.krmsType = test.getKrmsTypeDefinition();
        assert (this.krmsType != null);
        assert (this.krmsType.getId() != null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createKrmsType_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_createKrmsType_null_fail();
    }

    @Test
    public void test_updateKrmsType() {
        KrmsTypeBoServiceImplGenTest test = KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl);
        test.test_createKrmsType();
        KrmsTypeDefinition def = test.getKrmsTypeDefinition();
        String id = def.getId();
        assert (!"UpdateTest".equals(def.getName()));
        KrmsTypeBo bo = this.krmsTypeBoServiceImpl.from(def);
        bo.setName("UpdateTest");
        this.krmsTypeBoServiceImpl.updateKrmsType(KrmsTypeDefinition.Builder.create((KrmsTypeDefinitionContract)bo).build());
        KrmsTypeDefinition def2 = this.krmsTypeBoServiceImpl.getTypeById(id);
        assert ("UpdateTest".equals(def2.getName()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateKrmsType_null_fail() {
        KrmsTypeBoServiceImplGenTest.create((KrmsTypeBoServiceImpl)this.krmsTypeBoServiceImpl).test_updateKrmsType_null_fail();
    }

    public KrmsTypeDefinition getKrmsType() {
        return this.krmsType;
    }
}

