/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplate;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplateContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageTemplaterContract;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.KrmsTypeBoServiceImpl;
import org.kuali.rice.krms.impl.repository.KrmsTypeIntegrationGenTest;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBo;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageTemplateBoServiceImplGenTest;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageBoServiceImpl;
import org.kuali.rice.krms.impl.repository.NaturalLanguageUsageIntegrationGenTest;
import org.kuali.rice.krms.test.AbstractBoTest;
import org.kuali.rice.test.BaselineTestCase;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.ROLLBACK_CLEAR_DB)
public final class NaturalLanguageTemplateIntegrationGenTest
extends AbstractBoTest {
    NaturalLanguageTemplateBoServiceImpl naturalLanguageTemplateBoServiceImpl;
    NaturalLanguageTemplate naturalLanguageTemplate;
    KrmsAttributeDefinitionService krmsAttributeDefinitionService;
    KrmsTypeBoServiceImpl krmsTypeBoServiceImpl;
    NaturalLanguageUsageBoServiceImpl naturalLanguageUsageBoServiceImpl;

    NaturalLanguageTemplate getNaturalLanguageTemplate() {
        return this.naturalLanguageTemplate;
    }

    @Before
    public void setup() {
        this.naturalLanguageTemplateBoServiceImpl = new NaturalLanguageTemplateBoServiceImpl();
        this.naturalLanguageTemplateBoServiceImpl.setNaturalLanguageTemplater(NaturalLanguageTemplateIntegrationGenTest.newStringReplaceTemplater());
        this.krmsAttributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        this.naturalLanguageTemplateBoServiceImpl.setAttributeDefinitionService(this.krmsAttributeDefinitionService);
        this.naturalLanguageTemplateBoServiceImpl.setDataObjectService(this.getDataObjectService());
        this.krmsTypeBoServiceImpl = new KrmsTypeBoServiceImpl();
        this.krmsTypeBoServiceImpl.setDataObjectService(this.getDataObjectService());
        this.naturalLanguageUsageBoServiceImpl = new NaturalLanguageUsageBoServiceImpl();
        this.naturalLanguageUsageBoServiceImpl.setDataObjectService(this.getDataObjectService());
    }

    public static NaturalLanguageTemplaterContract newStringReplaceTemplater() {
        return new NaturalLanguageTemplaterContract(){

            public String translate(NaturalLanguageTemplate naturalLanguageTemplate, Map<String, Object> variables) {
                String template = naturalLanguageTemplate.getTemplate();
                Map attributes = naturalLanguageTemplate.getAttributes();
                for (String key : attributes.keySet()) {
                    template.replace(key, (CharSequence)attributes.get(key));
                }
                return template;
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByAttributes_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_getNaturalLanguageTemplatesByAttributes_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByLanguageCode_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_getNaturalLanguageTemplatesByLanguageCode_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByNaturalLanguageUsage_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_getNaturalLanguageTemplatesByNaturalLanguageUsage_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByType_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_getNaturalLanguageTemplatesByType_null_fail();
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_getNaturalLanguageTemplatesByTemplate_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_getNaturalLanguageTemplatesByTemplate_null_fail();
    }

    @Test
    public void test_from_null_yields_null() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_from_null_yields_null();
    }

    @Test
    public void test_to() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_to();
    }

    @Test
    public void test_from() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_from();
    }

    public void test_createNaturalLanguageTemplate() {
        KrmsTypeIntegrationGenTest krmsTypeTest = new KrmsTypeIntegrationGenTest();
        krmsTypeTest.setup();
        krmsTypeTest.test_createKrmsType();
        KrmsTypeDefinition krmsType = krmsTypeTest.getKrmsType();
        NaturalLanguageUsageIntegrationGenTest naturalLanguageUsageTest = new NaturalLanguageUsageIntegrationGenTest();
        naturalLanguageUsageTest.setup();
        naturalLanguageUsageTest.test_createNaturalLanguageUsage();
        NaturalLanguageUsage naturalLanguageUsage = naturalLanguageUsageTest.getNaturalLanguageUsage();
        NaturalLanguageTemplateBoServiceImplGenTest test = NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService);
        test.createNaturalLanguageTemplate(naturalLanguageUsage, krmsType);
        this.naturalLanguageTemplate = test.getNaturalLanguageTemplate();
        assert (this.naturalLanguageTemplate != null);
        assert (this.naturalLanguageTemplate.getId() != null);
        assert (this.naturalLanguageTemplate.getAttributes() != null && !this.naturalLanguageTemplate.getAttributes().isEmpty());
    }

    @Test
    public void test_createNaturalLanguageTemplate_fail_existing() {
        this.test_createNaturalLanguageTemplate();
        try {
            this.test_createNaturalLanguageTemplate();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            return;
        }
        assert (false);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_createNaturalLanguageTemplate_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_createNaturalLanguageTemplate_null_fail();
    }

    public void test_getNaturalLanguageTemplate() {
        this.test_createNaturalLanguageTemplate();
        NaturalLanguageTemplate def = this.getNaturalLanguageTemplate();
        NaturalLanguageTemplate def2 = this.naturalLanguageTemplateBoServiceImpl.getNaturalLanguageTemplate(def.getId());
        assert (def2 != null);
        assert (def2.equals((Object)def));
    }

    public void test_updateNaturalLanguageTemplate() {
        this.test_createNaturalLanguageTemplate();
        NaturalLanguageTemplate def = this.getNaturalLanguageTemplate();
        String id = def.getId();
        assert (!"UpdateTest".equals(def.getTemplate()));
        NaturalLanguageTemplateBo bo = this.naturalLanguageTemplateBoServiceImpl.from(def);
        bo.setTemplate("UpdateTest");
        this.naturalLanguageTemplateBoServiceImpl.updateNaturalLanguageTemplate(NaturalLanguageTemplate.Builder.create((NaturalLanguageTemplateContract)bo).build());
        NaturalLanguageTemplate def2 = this.naturalLanguageTemplateBoServiceImpl.getNaturalLanguageTemplate(id);
        assert ("UpdateTest".equals(def2.getTemplate()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_updateNaturalLanguageTemplate_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_updateNaturalLanguageTemplate_null_fail();
    }

    public void test_deleteNaturalLanguageTemplate() {
        this.test_createNaturalLanguageTemplate();
        NaturalLanguageTemplate def = this.getNaturalLanguageTemplate();
        String id = def.getId();
        this.naturalLanguageTemplateBoServiceImpl.deleteNaturalLanguageTemplate(id);
        NaturalLanguageTemplate def2 = this.naturalLanguageTemplateBoServiceImpl.getNaturalLanguageTemplate(id);
        assert (def2 == null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void test_deleteNaturalLanguageTemplate_null_fail() {
        NaturalLanguageTemplateBoServiceImplGenTest.create((NaturalLanguageTemplateBoServiceImpl)this.naturalLanguageTemplateBoServiceImpl, (KrmsAttributeDefinitionService)this.krmsAttributeDefinitionService).test_deleteNaturalLanguageTemplate_null_fail();
    }
}

