/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.test.AbstractAgendaBoTest;
import org.kuali.rice.test.BaselineTestCase;
import org.springframework.util.CollectionUtils;

@BaselineTestCase.BaselineMode(value=BaselineTestCase.Mode.CLEAR_DB)
public class AgendaBoServiceTest
extends AbstractAgendaBoTest {
    private static final String NULL = new String("null");

    private static <A> A nullConvertingGet(List<A> list, int index) {
        A result = list.get(index);
        if (result == NULL) {
            result = null;
        }
        return result;
    }

    @Test
    public void testGetByContextId() {
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByContextId("#$^$ BogusContextId !@#$")));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByContext("#$^$ BogusContextId !@#$")));
        for (String contextName : Arrays.asList("Context1", "Context2", "Context3")) {
            String namespace = this.getNamespaceByContextName(contextName);
            if (StringUtils.isBlank((String)namespace)) {
                throw new RiceRuntimeException("namespace is " + namespace + " for context with name " + contextName);
            }
            String contextId = this.getContextRepository().getContextByNameAndNamespace(contextName, namespace).getId();
            List agendas = this.getAgendaBoService().getAgendasByContextId(contextId);
            List agendaItems = this.getAgendaBoService().getAgendaItemsByContext(contextId);
            Assert.assertEquals((String)("agenda count doesn't match our tally for context " + contextName), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, Collections.singletonMap("contextId", contextId)));
            int totalAgendaItems = 0;
            HashSet<String> agendaIds = new HashSet<String>();
            for (AgendaDefinition agenda : agendas) {
                Assert.assertEquals((String)("agenda w/ ID " + agenda.getId() + " has a context ID that doesn't match"), (Object)agenda.getContextId(), (Object)contextId);
                totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                agendaIds.add(agenda.getId());
            }
            for (AgendaItemDefinition agendaItem : agendaItems) {
                Assert.assertTrue((String)("agenda item is not part of any agendas in " + contextName), (boolean)agendaIds.contains(agendaItem.getAgendaId()));
            }
            Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
        }
    }

    @Test
    public void testGetAgendasByContextId_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendasByContextId(contextId);
                Assert.fail((String)("getAgendasByContextId should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetAgendaItemsByContextId_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendaItemsByContext(contextId);
                Assert.fail((String)("getAgendaItemsByContext should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetByType() {
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByType("#$^$ BogusTypeId !@#$")));
        Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByType("#$^$ BogusTypeId !@#$")));
        List<KrmsTypeDefinition> agendaTypes = this.getAgendaTypesForContexts(Arrays.asList("Context1", "Context2", "Context3"));
        Assert.assertTrue((String)"We must have some types to test with or we prove nothing", (agendaTypes.size() > 0 ? 1 : 0) != 0);
        for (KrmsTypeDefinition agendaType : agendaTypes) {
            String typeName = agendaType.getName();
            String typeNamespace = agendaType.getNamespace();
            KrmsTypeDefinition type = this.getKrmsTypeRepository().getTypeByName(typeNamespace, typeName);
            List agendas = this.getAgendaBoService().getAgendasByType(type.getId());
            List agendaItems = this.getAgendaBoService().getAgendaItemsByType(type.getId());
            Assert.assertEquals((String)("agenda count doesn't match our tally for type " + typeNamespace + ":" + typeName), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, Collections.singletonMap("typeId", type.getId())));
            int totalAgendaItems = 0;
            HashSet<String> agendaIds = new HashSet<String>();
            for (AgendaDefinition agenda : agendas) {
                Assert.assertEquals((String)("agenda w/ ID " + agenda.getTypeId() + " has a type ID that doesn't match"), (Object)agenda.getTypeId(), (Object)type.getId());
                totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                agendaIds.add(agenda.getId());
            }
            for (AgendaItemDefinition agendaItem : agendaItems) {
                Assert.assertTrue((String)("agenda item is not part of any agendas in type " + typeNamespace + ":" + typeName), (boolean)agendaIds.contains(agendaItem.getAgendaId()));
            }
            Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
        }
    }

    private List<KrmsTypeDefinition> getAgendaTypesForContexts(List<String> contextNames) {
        ArrayList<KrmsTypeDefinition> results = new ArrayList<KrmsTypeDefinition>();
        for (String contextName : contextNames) {
            String namespace = this.getNamespaceByContextName(contextName);
            if (StringUtils.isBlank((String)namespace)) {
                throw new RiceRuntimeException("namespace is " + namespace + " for context with name " + contextName);
            }
            String contextId = this.getContextRepository().getContextByNameAndNamespace(contextName, namespace).getId();
            List agendas = this.getAgendaBoService().getAgendasByContextId(contextId);
            if (CollectionUtils.isEmpty((Collection)agendas)) continue;
            for (AgendaDefinition agenda : agendas) {
                KrmsTypeDefinition type;
                if (agenda.getTypeId() == null || results.contains(type = this.getKrmsTypeRepository().getTypeById(agenda.getTypeId()))) continue;
                results.add(type);
            }
        }
        return results;
    }

    @Test
    public void testGetAgendasByType_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendasByType(contextId);
                Assert.fail((String)("getAgendasByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetAgendaItemsByType_nullOrBlank() {
        for (String contextId : Arrays.asList(null, "", " ")) {
            try {
                this.getAgendaBoService().getAgendaItemsByType(contextId);
                Assert.fail((String)("getAgendaItemsByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid contextId=" + contextId + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testGetByTypeAndContext() {
        boolean testedSomeTypes = false;
        for (String contextName : Arrays.asList("Context1", "Context2", "Context3")) {
            List<KrmsTypeDefinition> agendaTypes = this.getAgendaTypesForContexts(Collections.singletonList(contextName));
            String namespace = this.getNamespaceByContextName(contextName);
            if (StringUtils.isBlank((String)namespace)) {
                throw new RiceRuntimeException("namespace is " + namespace + " for context with name " + contextName);
            }
            ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace(contextName, namespace);
            for (KrmsTypeDefinition agendaType : agendaTypes) {
                testedSomeTypes = true;
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByTypeAndContext("#$^$ BogusTypeId !@#$", context.getId())));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByTypeAndContext("#$^$ BogusTypeId !@#$", context.getId())));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendasByTypeAndContext(agendaType.getId(), "#$^$ BogusContextId !@#$")));
                Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.getAgendaBoService().getAgendaItemsByTypeAndContext(agendaType.getId(), "#$^$ BogusContextId !@#$")));
                List agendas = this.getAgendaBoService().getAgendasByTypeAndContext(agendaType.getId(), context.getId());
                List agendaItems = this.getAgendaBoService().getAgendaItemsByTypeAndContext(agendaType.getId(), context.getId());
                HashMap<String, String> agendaCountCrit = new HashMap<String, String>();
                agendaCountCrit.put("typeId", agendaType.getId());
                agendaCountCrit.put("contextId", context.getId());
                Assert.assertEquals((String)("agenda count doesn't match our tally for type " + agendaType.getNamespace() + ":" + agendaType.getName()), (long)agendas.size(), (long)this.getBoService().countMatching(AgendaBo.class, agendaCountCrit));
                int totalAgendaItems = 0;
                HashSet<String> agendaIds = new HashSet<String>();
                for (AgendaDefinition agenda : agendas) {
                    Assert.assertEquals((String)("agenda w/ ID " + agenda.getTypeId() + " has a type ID that doesn't match"), (Object)agenda.getTypeId(), (Object)agendaType.getId());
                    totalAgendaItems += this.getBoService().countMatching(AgendaItemBo.class, Collections.singletonMap("agendaId", agenda.getId()));
                    agendaIds.add(agenda.getId());
                }
                for (AgendaItemDefinition agendaItem : agendaItems) {
                    String assertionString = "agenda item is not part of any agendas in type " + agendaType.getNamespace() + ":" + agendaType.getName() + " and context " + context.getNamespace() + ":" + context.getName();
                    Assert.assertTrue((String)assertionString, (boolean)agendaIds.contains(agendaItem.getAgendaId()));
                }
                Assert.assertEquals((String)"number of agenda items doesn't match our tally", (long)agendaItems.size(), (long)totalAgendaItems);
            }
            Assert.assertTrue((String)"We have to test some types or we prove nothing", (boolean)testedSomeTypes);
        }
    }

    @Test
    public void testGetAgendaItemsByTypeAndContext_nullOrBlank() {
        HashSet<String> emptyValues = new HashSet<String>();
        emptyValues.addAll(Arrays.asList(NULL, "", " "));
        Sets.SetView oneNonBlank = Sets.union(emptyValues, Collections.singleton("fakeId"));
        Sets.SetView testIds = Sets.union((Set)Sets.cartesianProduct((Set[])new Set[]{emptyValues, oneNonBlank}), (Set)Sets.cartesianProduct((Set[])new Set[]{oneNonBlank, emptyValues}));
        for (List ids : testIds) {
            try {
                this.getAgendaBoService().getAgendaItemsByTypeAndContext((String)AgendaBoServiceTest.nullConvertingGet(ids, 0), (String)AgendaBoServiceTest.nullConvertingGet(ids, 1));
                Assert.fail((String)("getAgendaItemsByType should have thrown " + RiceIllegalArgumentException.class.getSimpleName() + " for invalid combo of contextId=" + ids + "."));
            }
            catch (RiceIllegalArgumentException riceIllegalArgumentException) {}
        }
    }

    @Test
    public void testUpdateAgendaItem() {
        ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace("Context1", "KRMS_TEST_1");
        Assert.assertNotNull((String)"context Context1 not found", (Object)context);
        AgendaDefinition agenda = this.getAgendaBoService().getAgendaByNameAndContextId("TestAgenda1", context.getId());
        Assert.assertNotNull((String)"agenda TestAgenda1 not found", (Object)agenda);
        AgendaItemDefinition agendaItem = this.getAgendaBoService().getAgendaItemById(agenda.getFirstItemId());
        Assert.assertNotNull((String)("agenda item " + agenda.getFirstItemId() + " not found"), (Object)agendaItem);
        KrmsAttributeDefinition attributeDefinition = this.getKrmsAttributeDefinitionService().createAttributeDefinition(KrmsAttributeDefinition.Builder.create(null, (String)"Attribute1", (String)"KRMS_TEST_1").build());
        KrmsAttributeDefinitionBo attributeDefinitionBo = KrmsAttributeDefinitionBo.from((KrmsAttributeDefinition)attributeDefinition);
        AgendaItemBo agendaItemBo = AgendaItemBo.from((AgendaItemDefinition)agendaItem);
        Assert.assertNotNull((String)"agenda item null", (Object)agendaItemBo);
        List agendaItemActionBos = agendaItemBo.getRule().getActions();
        Assert.assertEquals((String)"incorrect number of agenda item rule actions found", (long)1L, (long)agendaItemActionBos.size());
        ActionBo agendaItemActionBo = (ActionBo)agendaItemActionBos.get(0);
        Assert.assertTrue((String)"agenda item rule action attributes found", (boolean)agendaItemActionBo.getAttributes().isEmpty());
        Assert.assertTrue((String)"agenda item rule action attributes found", (boolean)agendaItemActionBo.getAttributeBos().isEmpty());
        AgendaItemBo alwaysBo = agendaItemBo.getAlways();
        Assert.assertNotNull((String)"always agenda item null", (Object)alwaysBo);
        List alwaysActionBos = alwaysBo.getRule().getActions();
        Assert.assertEquals((String)"incorrect number of always agenda item rule actions found", (long)1L, (long)alwaysActionBos.size());
        ActionBo alwaysActionBo = (ActionBo)alwaysActionBos.get(0);
        Assert.assertTrue((String)"always agenda item rule action attributes found", (boolean)alwaysActionBo.getAttributes().isEmpty());
        Assert.assertTrue((String)"always agenda item rule action attributes found", (boolean)alwaysActionBo.getAttributeBos().isEmpty());
        ActionAttributeBo agendaItemActionAttributeBo = new ActionAttributeBo();
        agendaItemActionAttributeBo.setAction(agendaItemActionBo);
        agendaItemActionAttributeBo.setAttributeDefinition(attributeDefinitionBo);
        agendaItemActionAttributeBo.setValue("testAgendaItem");
        agendaItemActionBo.setAttributeBos(Arrays.asList(agendaItemActionAttributeBo));
        ActionAttributeBo whenAlwaysActionAttributeBo = new ActionAttributeBo();
        whenAlwaysActionAttributeBo.setAction(alwaysActionBo);
        whenAlwaysActionAttributeBo.setAttributeDefinition(attributeDefinitionBo);
        whenAlwaysActionAttributeBo.setValue("testAlwaysAgendaItem");
        alwaysActionBo.setAttributeBos(Arrays.asList(whenAlwaysActionAttributeBo));
        AgendaItemDefinition updatedAgendaItem = this.getAgendaBoService().updateAgendaItem(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemBo).build());
        AgendaItemBo updatedAgendaItemBo = AgendaItemBo.from((AgendaItemDefinition)updatedAgendaItem);
        Assert.assertNotNull((String)"updated agenda item null", (Object)updatedAgendaItemBo);
        List updatedAgendaItemActionBos = updatedAgendaItemBo.getRule().getActions();
        Assert.assertEquals((String)"incorrect number of updated agenda item rule actions found", (long)1L, (long)updatedAgendaItemActionBos.size());
        ActionBo updatedAgendaItemActionBo = (ActionBo)updatedAgendaItemActionBos.get(0);
        Assert.assertEquals((String)"incorrect number of updated agenda item rule action attributes found", (long)1L, (long)updatedAgendaItemActionBo.getAttributes().size());
        Assert.assertEquals((String)"incorrect number of updated agenda item rule action attributes found", (long)1L, (long)updatedAgendaItemActionBo.getAttributeBos().size());
        AgendaItemBo updatedAlwaysBo = updatedAgendaItemBo.getAlways();
        Assert.assertNotNull((String)"updated always agenda item null", (Object)updatedAlwaysBo);
        List updatedAlwaysActionBos = updatedAlwaysBo.getRule().getActions();
        Assert.assertEquals((String)"incorrect number of updated always agenda item rule actions found", (long)1L, (long)updatedAlwaysActionBos.size());
        ActionBo updatedAlwaysActionBo = (ActionBo)updatedAlwaysActionBos.get(0);
        Assert.assertEquals((String)"incorrect number of updated always agenda item rule action attributes found", (long)1L, (long)updatedAlwaysActionBo.getAttributes().size());
        Assert.assertEquals((String)"incorrect number of updated always agenda item rule action attributes found", (long)1L, (long)updatedAlwaysActionBo.getAttributeBos().size());
        KrmsAttributeDefinition orgAttribute = this.getKrmsAttributeDefinitionService().getAttributeDefinitionById(attributeDefinition.getId());
        Assert.assertEquals((String)"incorrect number of updated attributes found for the agenda", (long)1L, (long)this.getAgendaBoService().getAgendaByAgendaId(updatedAgendaItem.getAgendaId()).getAttributes().size());
        Assert.assertNotNull((String)"Attribute definition orphaned on AgendaItem update", (Object)orgAttribute);
    }

    @Test
    public void testOrphanActions() {
        AgendaDefinitionDataWrapper agendaWrapper = new AgendaDefinitionDataWrapper();
        List actionDefinitionList = agendaWrapper.firstItemRule.getActions();
        ActionDefinition orgAction = (ActionDefinition)actionDefinitionList.get(0);
        RuleDefinition.Builder rule1Builder = RuleDefinition.Builder.create((RuleDefinitionContract)agendaWrapper.firstItemRule);
        ArrayList<ActionDefinition.Builder> newActionList = new ArrayList<ActionDefinition.Builder>();
        ActionDefinition.Builder actionDefBuilder1 = ActionDefinition.Builder.create(null, (String)(agendaWrapper.firstItemRule.getName() + "::UpdatedAction"), (String)"KRMS_TEST_1", (String)this.createKrmsActionTypeDefinition("KRMS_TEST_1").getId(), (String)agendaWrapper.firstItemRule.getId(), (Integer)1);
        newActionList.add(actionDefBuilder1);
        rule1Builder.setActions(newActionList);
        RuleDefinition updatedFirstRule = rule1Builder.build();
        this.ruleBoService.updateRule(updatedFirstRule);
        ActionDefinition shouldBeDeletedAction = this.actionBoService.getActionByActionId(orgAction.getId());
        Assert.assertNull((String)"Original Action should have been removed", (Object)shouldBeDeletedAction);
    }

    @Test
    public void testOrphanPropositions() {
        AgendaDefinitionDataWrapper agendaWrapper = new AgendaDefinitionDataWrapper();
        List actionDefinitionList = agendaWrapper.firstItemRule.getActions();
        ActionDefinition orgAction = (ActionDefinition)actionDefinitionList.get(0);
        RuleDefinition.Builder rule1Builder = RuleDefinition.Builder.create((RuleDefinitionContract)agendaWrapper.firstItemRule);
        PropositionDefinition.Builder parentProposition = PropositionDefinition.Builder.create(null, (String)PropositionType.COMPOUND.getCode(), (String)agendaWrapper.firstItemRule.getId(), null, null);
        parentProposition.setCompoundComponents(new ArrayList());
        agendaWrapper.firstItemRule = this.ruleBoService.getRuleByRuleId(agendaWrapper.firstItemRule.getId());
        RuleDefinition.Builder rule2Builder = RuleDefinition.Builder.create((RuleDefinitionContract)agendaWrapper.firstItemRule);
        AbstractAgendaBoTest.PropositionParametersBuilder params1 = new AbstractAgendaBoTest.PropositionParametersBuilder();
        params1.add(this.createTermDefinition("campusCodeTermSpec", String.class, agendaWrapper.context).getId(), PropositionParameterType.TERM);
        params1.add("DC", PropositionParameterType.CONSTANT);
        params1.add("=", PropositionParameterType.OPERATOR);
        AbstractAgendaBoTest.PropositionParametersBuilder params2 = new AbstractAgendaBoTest.PropositionParametersBuilder();
        params2.add(this.createTermDefinition("campusCodeTermSpec", String.class, agendaWrapper.context).getId(), PropositionParameterType.TERM);
        params2.add("DD", PropositionParameterType.CONSTANT);
        params2.add("=", PropositionParameterType.OPERATOR);
        StringBuilder propositionNameBuilder = new StringBuilder(agendaWrapper.firstItemRule.getName());
        PropositionDefinition.Builder propositionBuilder = this.createPropositionDefinition(propositionNameBuilder.toString(), params1, agendaWrapper.firstItemRule);
        parentProposition.getCompoundComponents().add(propositionBuilder);
        PropositionDefinition.Builder proposition2Builder = this.createPropositionDefinition(propositionNameBuilder.toString(), params2, agendaWrapper.firstItemRule);
        parentProposition.getCompoundComponents().add(proposition2Builder);
        rule2Builder.setProposition(parentProposition);
        RuleDefinition updatedFirstRule = rule2Builder.build();
        RuleDefinition updatedRuleDef = this.ruleBoService.updateRule(updatedFirstRule);
        PropositionDefinition deletedParentProp = this.propositionBoService.getPropositionById(agendaWrapper.firstItemRule.getProposition().getId());
        PropositionDefinition deletedProp1 = this.propositionBoService.getPropositionById(((PropositionDefinition)agendaWrapper.firstItemRule.getProposition().getCompoundComponents().get(0)).getId());
        PropositionDefinition deletedProp2 = this.propositionBoService.getPropositionById(((PropositionDefinition)agendaWrapper.firstItemRule.getProposition().getCompoundComponents().get(1)).getId());
        Assert.assertNull((String)"Old parent proposition should be removed", (Object)deletedParentProp);
        Assert.assertNull((String)"Old compound proposition should be removed", (Object)deletedProp1);
        Assert.assertNull((String)"Old compound proposition should be removed", (Object)deletedProp2);
    }

    @Test
    public void testDeleteAgenda() {
        ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace("Context2", "KRMS_TEST_2");
        Assert.assertNotNull((String)"context Context2 not found", (Object)context);
        AgendaDefinition agenda = this.getAgendaBoService().getAgendaByNameAndContextId("Agenda2", context.getId());
        Assert.assertNotNull((String)"agenda Agenda2 not found", (Object)agenda);
        AgendaItemDefinition agendaItem = this.getAgendaBoService().getAgendaItemById(agenda.getFirstItemId());
        Assert.assertNotNull((String)("agenda item " + agenda.getFirstItemId() + " not found"), (Object)agendaItem);
        AgendaItemDefinition firstItem = this.getAgendaBoService().getAgendaItemById(agenda.getFirstItemId());
        RuleDefinition firstItemRule = firstItem.getRule();
        List firstActionDefinitions = firstItemRule.getActions();
        AgendaItemDefinition secondItem = firstItem.getAlways();
        RuleDefinition secondItemRule = secondItem.getRule();
        List secondActionDefinitions = secondItemRule.getActions();
        AgendaItemDefinition thirdItem = secondItem.getAlways();
        RuleDefinition thirdItemRule = thirdItem.getRule();
        List thirdActionDefinitions = thirdItemRule.getActions();
        this.getAgendaBoService().deleteAgenda(agenda.getId());
        AgendaDefinition deletedAgenda = this.getAgendaBoService().getAgendaByAgendaId(agenda.getId());
        Assert.assertNull((String)"Agenda should have been deleted", (Object)deletedAgenda);
        AgendaItemDefinition deletedAgendaItem = this.getAgendaBoService().getAgendaItemById(firstItem.getId());
        Assert.assertNull((String)"First Agenda item should have been deleted as part of agenda delete", (Object)deletedAgendaItem);
        AgendaItemDefinition deletedSecondAgendaItem = this.getAgendaBoService().getAgendaItemById(secondItem.getId());
        Assert.assertNull((String)"Second Agenda item should have been deleted as part of agenda delete", (Object)deletedSecondAgendaItem);
        AgendaItemDefinition deletedThirdAgendaItem = this.getAgendaBoService().getAgendaItemById(thirdItem.getId());
        Assert.assertNull((String)"Third Agenda item should have been deleted as part of agenda delete", (Object)deletedThirdAgendaItem);
        RuleDefinition deletedFirstRule = this.getRuleBoService().getRuleByRuleId(firstItemRule.getId());
        Assert.assertNull((String)"First rule should have been deleted as part of agenda delete", (Object)deletedFirstRule);
        RuleDefinition deletedSecondRule = this.getRuleBoService().getRuleByRuleId(secondItemRule.getId());
        Assert.assertNull((String)"Second rule should have been deleted as part of agenda delete", (Object)deletedSecondRule);
        RuleDefinition deletedThirdRule = this.getRuleBoService().getRuleByRuleId(thirdItemRule.getId());
        Assert.assertNull((String)"Third rule should have been deleted as part of agenda delete", (Object)deletedThirdRule);
        ArrayList<ActionDefinition> actionDefinitionList = new ArrayList<ActionDefinition>();
        for (ActionDefinition actionDefinition : firstActionDefinitions) {
            actionDefinitionList.add(actionDefinition);
        }
        for (ActionDefinition actionDefinition : secondActionDefinitions) {
            actionDefinitionList.add(actionDefinition);
        }
        for (ActionDefinition actionDefinition : thirdActionDefinitions) {
            actionDefinitionList.add(actionDefinition);
        }
        for (ActionDefinition actionDef : actionDefinitionList) {
            ActionDefinition deletedActionDef = this.getActionBoService().getActionByActionId(actionDef.getId());
            Assert.assertNull((String)"All action definitions not deleted as part of agenda delete", (Object)deletedActionDef);
        }
    }

    @Test
    public void testDeleteAgenda_WithNoAgendaItems() {
        AgendaDefinition emptyAgendaDefinition = this.createEmptyAgenda("Context1", "testAgenda-deleteEmptyAgenda");
        AgendaBo bo = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)emptyAgendaDefinition.getId());
        this.getAgendaBoService().deleteAgenda(bo.getId());
        AgendaDefinition deletedAgenda = this.getAgendaBoService().getAgendaByAgendaId(bo.getId());
        Assert.assertNull((String)"Agenda should have been deleted", (Object)deletedAgenda);
    }

    private AgendaDefinition createEmptyAgenda(String contextName, String agendaName) {
        String namespace = this.getNamespaceByContextName(contextName);
        if (StringUtils.isBlank((String)namespace)) {
            throw new RiceRuntimeException("namespace is " + namespace + " for context with name " + "Context1");
        }
        ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace("Context1", namespace);
        List agendas = this.getAgendaBoService().getAgendasByContextId(context.getId());
        AgendaDefinition templateAgenda = (AgendaDefinition)agendas.get(0);
        AgendaDefinition.Builder agendaBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)templateAgenda);
        agendaBuilder.setFirstItemId(null);
        agendaBuilder.setId(null);
        agendaBuilder.setVersionNumber(null);
        agendaBuilder.setName("testAgendaCrud-agenda");
        AgendaDefinition newAgenda = this.getAgendaBoService().createAgenda(agendaBuilder.build());
        return newAgenda;
    }

    @Test
    public void testAgendaCrud() {
        AgendaDefinition newAgenda = this.createEmptyAgenda("Context1", "testAgendaCrud-agenda");
        Assert.assertNotNull((Object)newAgenda);
        Assert.assertEquals((Object)newAgenda, (Object)this.getAgendaBoService().getAgendaByAgendaId(newAgenda.getId()));
    }

    @Test
    public void testUpdateAgendaMega() {
        AgendaDefinitionDataWrapper agendaWrapper = new AgendaDefinitionDataWrapper();
        ContextDefinition contextDef = agendaWrapper.context;
        AgendaDefinition agendaDef = agendaWrapper.agenda;
        AgendaItemDefinition agendaItemDefOriginal1 = agendaWrapper.firstItem;
        AgendaItemDefinition agendaItemDefOriginal2 = agendaWrapper.secondItem;
        AgendaItemDefinition agendaItemDefOriginal3 = agendaWrapper.thirdItem;
        AgendaItemDefinition agendaItemDefOriginal4 = agendaWrapper.fourthItem;
        RuleDefinition ruleDef1 = agendaItemDefOriginal1.getRule();
        RuleDefinition ruleDef2 = agendaItemDefOriginal2.getRule();
        RuleDefinition ruleDef3 = agendaItemDefOriginal3.getRule();
        RuleDefinition ruleDef4 = agendaItemDefOriginal4.getRule();
        PropositionDefinition propDef1 = ruleDef1.getProposition();
        PropositionDefinition propDef2 = ruleDef2.getProposition();
        PropositionDefinition propDef3 = ruleDef3.getProposition();
        PropositionDefinition propDef4 = ruleDef4.getProposition();
        List actionDefs1 = ruleDef1.getActions();
        List actionDefs2 = ruleDef2.getActions();
        List actionDefs3 = ruleDef3.getActions();
        List actionDefs4 = ruleDef4.getActions();
        AgendaItemDefinition.Builder agendaItemDefBuilder1 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        agendaItemDefBuilder1.setRuleId(this.createRuleDefinition1(contextDef, "New Agenda", "KRMS_TEST_1").getId());
        agendaItemDefBuilder1.setRule(RuleDefinition.Builder.create((RuleDefinitionContract)this.ruleBoService.getRuleByRuleId(agendaItemDefBuilder1.getRuleId())));
        AgendaItemDefinition.Builder agendaItemDefBuilder2 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        agendaItemDefBuilder1.setAlways(agendaItemDefBuilder2);
        agendaItemDefBuilder2.setRuleId(this.createRuleDefinition2(contextDef, "New Agenda", "KRMS_TEST_1").getId());
        agendaItemDefBuilder2.setRule(RuleDefinition.Builder.create((RuleDefinitionContract)this.ruleBoService.getRuleByRuleId(agendaItemDefBuilder2.getRuleId())));
        AgendaItemDefinition.Builder agendaItemDefBuilder3 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        agendaItemDefBuilder2.setAlways(agendaItemDefBuilder3);
        agendaItemDefBuilder3.setRuleId(this.createRuleDefinition3(contextDef, "New Agenda", "KRMS_TEST_1").getId());
        agendaItemDefBuilder3.setRule(RuleDefinition.Builder.create((RuleDefinitionContract)this.ruleBoService.getRuleByRuleId(agendaItemDefBuilder3.getRuleId())));
        AgendaItemDefinition.Builder agendaItemDefBuilder4 = AgendaItemDefinition.Builder.create(null, (String)agendaDef.getId());
        agendaItemDefBuilder3.setAlways(agendaItemDefBuilder4);
        agendaItemDefBuilder4.setRuleId(this.createRuleDefinition4(contextDef, "New Agenda", "KRMS_TEST_1").getId());
        agendaItemDefBuilder4.setRule(RuleDefinition.Builder.create((RuleDefinitionContract)this.ruleBoService.getRuleByRuleId(agendaItemDefBuilder4.getRuleId())));
        AgendaItemDefinition agendaItemDefNew4 = this.agendaBoService.createAgendaItem(agendaItemDefBuilder4.build());
        agendaItemDefBuilder3.setAlwaysId(agendaItemDefNew4.getId());
        agendaItemDefBuilder3.setAlways(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefNew4));
        AgendaItemDefinition agendaItemDefNew3 = this.agendaBoService.createAgendaItem(agendaItemDefBuilder3.build());
        agendaItemDefBuilder2.setAlwaysId(agendaItemDefNew3.getId());
        agendaItemDefBuilder2.setAlways(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefNew3));
        AgendaItemDefinition agendaItemDefNew2 = this.agendaBoService.createAgendaItem(agendaItemDefBuilder2.build());
        agendaItemDefBuilder1.setAlwaysId(agendaItemDefNew2.getId());
        agendaItemDefBuilder1.setAlways(AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefNew2));
        AgendaItemDefinition agendaItemDefNew1 = this.agendaBoService.createAgendaItem(agendaItemDefBuilder1.build());
        AgendaDefinition.Builder agendaDefBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDef);
        agendaDefBuilder.setFirstItemId(agendaItemDefNew1.getId());
        agendaDef = agendaDefBuilder.build();
        AgendaDefinition agendaDefUpdated = this.agendaBoService.updateAgenda(agendaDef);
        Assert.assertNull((String)"First agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal1.getId()));
        Assert.assertNull((String)"Second agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal2.getId()));
        Assert.assertNull((String)"Third agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal3.getId()));
        Assert.assertNull((String)"Fourth agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal4.getId()));
        Assert.assertNull((String)"First agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef1.getId()));
        Assert.assertNull((String)"Second agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef2.getId()));
        Assert.assertNull((String)"Third agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef3.getId()));
        Assert.assertNull((String)"Fourth agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef4.getId()));
        Assert.assertNull((String)"First rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef1.getId()));
        Assert.assertNull((String)"First rule compound component 0 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef1.getCompoundComponents().get(0)).getId()));
        Assert.assertNull((String)"First rule compound component 1 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef1.getCompoundComponents().get(1)).getId()));
        Assert.assertNull((String)"Second rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef2.getId()));
        Assert.assertNull((String)"Second rule compound component 0 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef2.getCompoundComponents().get(0)).getId()));
        Assert.assertNull((String)"Second rule compound component 1 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef2.getCompoundComponents().get(1)).getId()));
        Assert.assertNull((String)"Second rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef3.getId()));
        Assert.assertNull((String)"Fourth rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef4.getId()));
        Assert.assertNull((String)"Fourth rule compound component 0 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef4.getCompoundComponents().get(0)).getId()));
        Assert.assertNull((String)"Fourth rule compound component 1 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef4.getCompoundComponents().get(1)).getId()));
        Assert.assertNull((String)"First rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs1.get(0)).getId()));
        Assert.assertNull((String)"Second rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs2.get(0)).getId()));
        Assert.assertNull((String)"Third rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs3.get(0)).getId()));
        Assert.assertNull((String)"Fourth rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs4.get(0)).getId()));
        AgendaItemDefinition agendaItemDefVerify1 = this.getAgendaBoService().getAgendaItemById(agendaDefUpdated.getFirstItemId());
        AgendaItemDefinition agendaItemDefVerify2 = agendaItemDefVerify1.getAlways();
        AgendaItemDefinition agendaItemDefVerify3 = agendaItemDefVerify2.getAlways();
        AgendaItemDefinition agendaItemDefVerify4 = agendaItemDefVerify3.getAlways();
        Assert.assertNotNull((String)"First updated agenda item should not be null", (Object)agendaItemDefVerify1);
        Assert.assertNotNull((String)"Second updated agenda item should not be null", (Object)agendaItemDefVerify2);
        Assert.assertNotNull((String)"Third updated agenda item should not be null", (Object)agendaItemDefVerify3);
        Assert.assertNotNull((String)"Fourth updated agenda item should not be null", (Object)agendaItemDefVerify4);
        Assert.assertNotNull((String)"First agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify1.getRuleId()));
        Assert.assertNotNull((String)"Second agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify2.getRuleId()));
        Assert.assertNotNull((String)"Third agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify3.getRuleId()));
        Assert.assertNotNull((String)"Fourth agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify4.getRuleId()));
    }

    @Test
    public void testUpdateAgendaPullLowerTwo() {
        ContextDefinition context = this.getContextRepository().getContextByNameAndNamespace("Context2", "KRMS_TEST_2");
        Assert.assertNotNull((String)"context Context2 not found", (Object)context);
        AgendaDefinition agendaDef = this.getAgendaBoService().getAgendaByNameAndContextId("Agenda3", context.getId());
        Assert.assertNotNull((String)"agenda Agenda3 not found", (Object)agendaDef);
        AgendaItemDefinition agendaItemDefOriginal1 = this.getAgendaBoService().getAgendaItemById(agendaDef.getFirstItemId());
        Assert.assertNotNull((String)("agenda item " + agendaDef.getFirstItemId() + " not found"), (Object)agendaItemDefOriginal1);
        AgendaItemDefinition agendaItemDefOriginal2 = agendaItemDefOriginal1.getAlways();
        AgendaItemDefinition agendaItemDefOriginal3 = agendaItemDefOriginal2.getAlways();
        AgendaItemDefinition agendaItemDefOriginal4 = agendaItemDefOriginal3.getAlways();
        RuleDefinition ruleDef1 = agendaItemDefOriginal1.getRule();
        RuleDefinition ruleDef2 = agendaItemDefOriginal2.getRule();
        RuleDefinition ruleDef3 = agendaItemDefOriginal3.getRule();
        RuleDefinition ruleDef4 = agendaItemDefOriginal4.getRule();
        PropositionDefinition propDef1 = ruleDef1.getProposition();
        PropositionDefinition propDef2 = ruleDef2.getProposition();
        PropositionDefinition propDef3 = ruleDef3.getProposition();
        PropositionDefinition propDef4 = ruleDef4.getProposition();
        List actionDefs1 = ruleDef1.getActions();
        List actionDefs2 = ruleDef2.getActions();
        List actionDefs3 = ruleDef3.getActions();
        List actionDefs4 = ruleDef4.getActions();
        AgendaItemDefinition.Builder agendaItemDefBuilder1 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefOriginal1);
        AgendaItemDefinition.Builder agendaItemDefBuilder2 = AgendaItemDefinition.Builder.create((AgendaItemDefinitionContract)agendaItemDefOriginal2);
        agendaItemDefBuilder2.setAlwaysId(null);
        agendaItemDefBuilder2.setAlways(null);
        AgendaItemDefinition agendaItemDefNew2 = agendaItemDefBuilder2.build();
        AgendaItemDefinition agendaItemDefNew1 = agendaItemDefBuilder1.build();
        this.agendaBoService.updateAgendaItem(agendaItemDefNew2);
        AgendaDefinition.Builder agendaDefBuilder = AgendaDefinition.Builder.create((AgendaDefinitionContract)agendaDef);
        agendaDefBuilder.setFirstItemId(agendaItemDefNew1.getId());
        agendaDef = agendaDefBuilder.build();
        AgendaDefinition agendaDefUpdated = this.agendaBoService.updateAgenda(agendaDef);
        Assert.assertNull((String)"Third agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal3.getId()));
        Assert.assertNull((String)"Fourth agenda item should be deleted", (Object)this.agendaBoService.getAgendaItemById(agendaItemDefOriginal4.getId()));
        RuleDefinition ruleDefCheck = this.ruleBoService.getRuleByRuleId(ruleDef3.getId());
        Assert.assertNull((String)"Third agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef3.getId()));
        Assert.assertNull((String)"Fourth agenda item rule should be deleted", (Object)this.ruleBoService.getRuleByRuleId(ruleDef4.getId()));
        Assert.assertNull((String)"Third rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef3.getId()));
        Assert.assertNull((String)"Fourth rule proposition should be deleted", (Object)this.propositionBoService.getPropositionById(propDef4.getId()));
        Assert.assertNull((String)"Fourth rule compound component 0 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef4.getCompoundComponents().get(0)).getId()));
        Assert.assertNull((String)"Fourth rule compound component 1 should be deleted", (Object)this.propositionBoService.getPropositionById(((PropositionDefinition)propDef4.getCompoundComponents().get(1)).getId()));
        Assert.assertNull((String)"Third rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs3.get(0)).getId()));
        Assert.assertNull((String)"Fourth rule action should be deleted", (Object)this.actionBoService.getActionByActionId(((ActionDefinition)actionDefs4.get(0)).getId()));
        AgendaItemDefinition agendaItemDefVerify1 = this.getAgendaBoService().getAgendaItemById(agendaDefUpdated.getFirstItemId());
        AgendaItemDefinition agendaItemDefVerify2 = agendaItemDefVerify1.getAlways();
        Assert.assertNotNull((String)"First updated agenda item should not be null", (Object)agendaItemDefVerify1);
        Assert.assertNotNull((String)"Second updated agenda item should not be null", (Object)agendaItemDefVerify2);
        Assert.assertNotNull((String)"First agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify1.getRuleId()));
        Assert.assertNotNull((String)"Second agenda item rule should not be null", (Object)this.ruleBoService.getRuleByRuleId(agendaItemDefVerify2.getRuleId()));
    }

    private class AgendaDefinitionDataWrapper {
        private ContextDefinition context;
        private AgendaDefinition agenda;
        private AgendaItemDefinition firstItem;
        private AgendaItemDefinition secondItem;
        private AgendaItemDefinition thirdItem;
        private AgendaItemDefinition fourthItem;
        private RuleDefinition firstItemRule;

        AgendaDefinitionDataWrapper() {
            this.context = AgendaBoServiceTest.this.getContextRepository().getContextByNameAndNamespace("Context1", "KRMS_TEST_1");
            Assert.assertNotNull((String)"context Context1 not found", (Object)this.context);
            this.agenda = AgendaBoServiceTest.this.getAgendaBoService().getAgendaByNameAndContextId("TestAgenda1", this.context.getId());
            Assert.assertNotNull((String)"agenda TestAgenda1 not found", (Object)this.agenda);
            this.firstItem = AgendaBoServiceTest.this.getAgendaBoService().getAgendaItemById(this.agenda.getFirstItemId());
            Assert.assertNotNull((String)("agenda item " + this.agenda.getFirstItemId() + " not found"), (Object)this.firstItem);
            this.secondItem = this.firstItem.getAlways();
            this.thirdItem = this.secondItem.getAlways();
            this.fourthItem = this.thirdItem.getAlways();
            this.firstItemRule = this.firstItem.getRule();
        }
    }
}

