/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementPropositionDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMPDT";
    }

    @Test
    public void testCreateProposition() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        PropositionDefinition propositionDefinition = this.createTestSimpleProposition(t0.namespaceName, t0.proposition_0_Id, "campusCode", "BL", "=", "java.lang.String", t0.rule_0_Id, "Campus Code");
        Assert.assertEquals((String)"created Proposition not found", (Object)t0.rule_0_Id, (Object)propositionDefinition.getRuleId());
        try {
            this.ruleManagementService.createProposition(propositionDefinition);
            Assert.fail((String)"should throw exception if trying to create and already exists");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCompoundCreateProposition() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        PropositionDefinition propS3 = this.createTestSimpleProposition(t1.namespaceName, "S3", "Occasion", "Training", "=", "java.lang.String", t1.rule_0_Id, "Special Event");
        PropositionDefinition.Builder propBuilderS3 = PropositionDefinition.Builder.create((PropositionDefinitionContract)propS3);
        PropositionDefinition propS2 = this.createTestSimpleProposition(t1.namespaceName, "S2", "Occasion", "Conference", "=", "java.lang.String", t1.rule_0_Id, "Special Event");
        PropositionDefinition.Builder propBuilderS2 = PropositionDefinition.Builder.create((PropositionDefinitionContract)propS2);
        PropositionDefinition propS1 = this.createTestSimpleProposition(t1.namespaceName, "S1", "Account", "54321", "=", "java.lang.String", t1.rule_0_Id, "Charged To Account");
        PropositionDefinition.Builder propBuilderS1 = PropositionDefinition.Builder.create((PropositionDefinitionContract)propS1);
        PropositionDefinition.Builder propBuilderC2 = PropositionDefinition.Builder.create(null, (String)PropositionType.COMPOUND.getCode(), (String)t1.rule_0_Id, null, new ArrayList());
        propBuilderC2.compoundOpCode(LogicalOperator.OR.getCode());
        ArrayList<PropositionDefinition.Builder> compoundComponentsC2 = new ArrayList<PropositionDefinition.Builder>();
        compoundComponentsC2.add(propBuilderS2);
        compoundComponentsC2.add(propBuilderS3);
        propBuilderC2.setCompoundComponents(compoundComponentsC2);
        propBuilderC2.setDescription("C2_compound_proposition");
        PropositionDefinition.Builder propBuilderC1 = PropositionDefinition.Builder.create(null, (String)PropositionType.COMPOUND.getCode(), (String)t1.rule_0_Id, null, new ArrayList());
        propBuilderC1.compoundOpCode(LogicalOperator.AND.getCode());
        ArrayList<PropositionDefinition.Builder> compoundComponentsC1 = new ArrayList<PropositionDefinition.Builder>();
        compoundComponentsC1.add(propBuilderS1);
        compoundComponentsC1.add(propBuilderC2);
        propBuilderC1.setCompoundComponents(compoundComponentsC1);
        propBuilderC1.setDescription("C1_compound_proposition");
        PropositionDefinition propC1 = this.ruleManagementService.createProposition(propBuilderC1.build());
        propC1 = this.ruleManagementService.getProposition(propC1.getId());
        Assert.assertEquals((String)"proposition not in database", (Object)"C1_compound_proposition", (Object)propC1.getDescription());
        List<String> propositionDescrs = Arrays.asList("C1_compound_proposition", "C2_compound_proposition", "S1_simple_proposition", "S2_simple_proposition", "S3_simple_proposition");
        Set propsFound = this.ruleManagementService.getPropositionsByRule(t1.rule_0_Id);
        for (PropositionDefinition propTemp : propsFound) {
            Assert.assertTrue((boolean)propositionDescrs.contains(propTemp.getDescription()));
        }
        Assert.assertEquals((String)"invalid number of propositions found for ruleId", (long)5L, (long)propsFound.size());
    }

    @Test
    public void testGetProposition() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(t2.object0);
        PropositionDefinition returnPropositionDefinition = this.ruleManagementService.getProposition(propositionDefinition.getId());
        Assert.assertEquals((String)"", (Object)propositionDefinition.getRuleId(), (Object)returnPropositionDefinition.getRuleId());
        try {
            this.ruleManagementService.getProposition(null);
            Assert.fail((String)"should throw RiceIllegalArgumentException");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetPropositionsByType() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(t3.object0);
        Set propositionDefinitionSet = this.ruleManagementService.getPropositionsByType(propositionDefinition.getTypeId());
        boolean propositionFound = false;
        for (PropositionDefinition pd : propositionDefinitionSet) {
            if (!pd.getId().equals(propositionDefinition.getId())) continue;
            Assert.assertEquals((String)"unexpected PropositionTypeId returned", (Object)propositionDefinition.getTypeId(), (Object)pd.getTypeId());
            propositionFound = true;
        }
        Assert.assertTrue((String)"proposition not found by PropositionTypeId", (boolean)propositionFound);
    }

    @Test
    public void testGetPropositionsByRule() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(t4.object0);
        Set propositionDefinitionSet = this.ruleManagementService.getPropositionsByRule(propositionDefinition.getRuleId());
        boolean propositionFound = false;
        for (PropositionDefinition pd : propositionDefinitionSet) {
            if (!pd.getId().equals(propositionDefinition.getId())) continue;
            propositionFound = true;
        }
        Assert.assertTrue((String)"proposition not found by RuleId", (boolean)propositionFound);
    }

    @Test
    public void testUpdateProposition() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(t5.object0);
        PropositionDefinition.Builder builder = PropositionDefinition.Builder.create((PropositionDefinitionContract)propositionDefinition);
        builder.setDescription("UpdatedDescription");
        builder.setPropositionTypeCode(PropositionType.COMPOUND.getCode());
        this.ruleManagementService.updateProposition(builder.build());
        PropositionDefinition returnPropositionDefinition = this.ruleManagementService.getProposition(propositionDefinition.getId());
        Assert.assertEquals((String)"description was not updated", (Object)"UpdatedDescription", (Object)returnPropositionDefinition.getDescription());
        Assert.assertEquals((String)"propositionType was not updated", (Object)PropositionType.COMPOUND.getCode(), (Object)returnPropositionDefinition.getPropositionTypeCode());
    }

    @Test
    public void testDeleteProposition() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        PropositionDefinition propositionDefinition = this.createTestPropositionForRule(t6.object0);
        this.ruleManagementService.deleteProposition(propositionDefinition.getId());
        Assert.assertTrue((String)"proposition should have been deleted", (boolean)this.ruleManagementService.getPropositionsByRule(propositionDefinition.getRuleId()).isEmpty());
        try {
            this.ruleManagementService.deleteProposition(propositionDefinition.getId());
            Assert.fail((String)"should fail with IllegalStateException: the Proposition to delete does not exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFindPropositionIds() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        List<String> propositionIds = Arrays.asList(this.createTestPropositionForRule(t6.object0).getId(), this.createTestPropositionForRule(t6.object1).getId(), this.createTestPropositionForRule(t6.object2).getId(), this.createTestPropositionForRule(t6.object3).getId());
        for (String propositionId : propositionIds) {
            PropositionDefinition.Builder builder = PropositionDefinition.Builder.create((PropositionDefinitionContract)this.ruleManagementService.getProposition(propositionId));
            builder.setDescription("targetOfQuery");
            this.ruleManagementService.updateProposition(builder.build());
        }
        QueryByCriteria.Builder query = QueryByCriteria.Builder.create();
        query.setPredicates(new Predicate[]{PredicateFactory.equal((String)"description", (Object)"targetOfQuery")});
        List returnedPropositionIds = this.ruleManagementService.findPropositionIds(query.build());
        for (String returnedPropositionId : returnedPropositionIds) {
            Assert.assertTrue((boolean)propositionIds.contains(returnedPropositionId));
        }
        Assert.assertEquals((String)"incorrect number of Propositions found", (long)4L, (long)returnedPropositionIds.size());
    }

    @Test
    public void testPropositionCacheEvict() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        this.verifyEmptyProposition(t7);
        this.buildTestRuleDefinition(t7.namespaceName, t7.object0);
        this.verifyFullProposition(t7);
    }

    private void verifyEmptyProposition(RuleManagementBaseTestObjectNames t) {
        Set propositions = this.ruleManagementService.getPropositionsByRule(t.rule_Id);
        Assert.assertFalse((String)"Proposition is not null", (propositions != null && !propositions.isEmpty() ? 1 : 0) != 0);
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        Assert.assertFalse((String)"Proposition in Rule found", (rule != null ? 1 : 0) != 0);
    }

    private void verifyFullProposition(RuleManagementBaseTestObjectNames t) {
        Set propositions = this.ruleManagementService.getPropositionsByRule(t.rule_Id);
        Assert.assertTrue((String)"Proposition is not null", (propositions != null && !propositions.isEmpty() ? 1 : 0) != 0);
        String propositionId = ((PropositionDefinition)new ArrayList(propositions).get(0)).getId();
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        Assert.assertTrue((String)"Proposition in Rule not found", (rule != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Proposition in Rule not found", (boolean)StringUtils.equals((String)propositionId, (String)rule.getPropId()));
    }
}

