/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaItemDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinitionContract;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.test.RuleManagementBaseTest;
import org.kuali.rice.krms.test.RuleManagementBaseTestObjectNames;

public class RuleManagementRuleDefinitionTest
extends RuleManagementBaseTest {
    @Override
    @Before
    public void setClassDiscriminator() {
        this.CLASS_DISCRIMINATOR = "RMRDT";
    }

    @Test
    public void testGetRuleByNameAndNamespace() {
        RuleManagementBaseTestObjectNames t0 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t0");
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t0.namespaceName, t0.object0);
        RuleDefinition returnRuleDefinition = this.ruleManagementService.getRuleByNameAndNamespace(ruleDefinition.getName(), ruleDefinition.getNamespace());
        Assert.assertEquals((String)"rule not found", (Object)ruleDefinition.getId(), (Object)returnRuleDefinition.getId());
        try {
            this.ruleManagementService.getRuleByNameAndNamespace(null, t0.namespaceName);
            Assert.fail((String)"Should have thrown IllegalArgumentException: name is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getRuleByNameAndNamespace("   ", t0.namespaceName);
            Assert.fail((String)"Should have thrown IllegalArgumentException: name is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getRuleByNameAndNamespace(ruleDefinition.getName(), null);
            Assert.fail((String)"should throw IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.ruleManagementService.getRuleByNameAndNamespace(ruleDefinition.getName(), "    ");
            Assert.fail((String)"should throw IllegalArgumentException: namespace is null or blank");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateRule() {
        RuleManagementBaseTestObjectNames t1 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t1");
        RuleDefinition ruleFirstCreate = this.buildTestRuleDefinition(t1.namespaceName, t1.object0);
        Assert.assertTrue((String)"created Rule not found", (boolean)this.ruleManagementService.getRule(ruleFirstCreate.getId()).getId().contains(t1.rule_0_Id));
        try {
            RuleDefinition ruleSecondCreate = this.ruleManagementService.createRule(ruleFirstCreate);
            Assert.fail((String)"should have thrown RiceIllegalArgumentException");
        }
        catch (RiceIllegalArgumentException ruleSecondCreate) {
            // empty catch block
        }
        RuleDefinition malformedRule = this.buildTestRuleDefinition(t1.namespaceName, t1.object1);
        RuleDefinition.Builder builder = RuleDefinition.Builder.create((RuleDefinitionContract)malformedRule);
        builder.setPropId("invalidValue");
        malformedRule = builder.build();
        try {
            this.ruleManagementService.createRule(malformedRule);
            Assert.fail((String)"should have thrown RiceIllegalArgumentException");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateRule() {
        RuleManagementBaseTestObjectNames t2 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t2");
        RuleDefinition.Builder ruleBuilder0 = RuleDefinition.Builder.create((RuleDefinitionContract)this.buildTestRuleDefinition(t2.namespaceName, t2.object0));
        ruleBuilder0.setName("updatedName");
        this.ruleManagementService.updateRule(ruleBuilder0.build());
        RuleDefinition rule0 = this.ruleManagementService.getRule(t2.rule_0_Id);
        Assert.assertNotEquals((String)"Rule Name Not Updated", (Object)t2.rule_0_Name, (Object)rule0.getName());
        Assert.assertEquals((String)"Rule Name Not Updated", (Object)"updatedName", (Object)rule0.getName());
        RuleDefinition.Builder ruleBuilder1 = RuleDefinition.Builder.create((RuleDefinitionContract)this.buildTestRuleDefinition(t2.namespaceName, t2.object1));
        Assert.assertEquals((String)"Expected Proposition not found in Rule", (Object)t2.proposition_1_Descr, (Object)ruleBuilder1.getProposition().getDescription());
        String newPropId = "PropNewId";
        PropositionDefinition prop = this.createTestSimpleProposition(t2.namespaceName, newPropId, "TSI_" + newPropId, "ABC", "=", "java.lang.String", t2.rule_0_Id, "TSI_" + newPropId + "_Descr");
        PropositionDefinition.Builder propBuilder = PropositionDefinition.Builder.create((PropositionDefinitionContract)prop);
        ruleBuilder1.setPropId(newPropId);
        ruleBuilder1.setProposition(propBuilder);
        this.ruleManagementService.updateRule(ruleBuilder1.build());
        rule0 = this.ruleManagementService.getRule(ruleBuilder1.getId());
        Assert.assertEquals((String)"Expected Proposition not found in Rule", (Object)"PropNewId_simple_proposition", (Object)rule0.getProposition().getDescription());
        RuleDefinition.Builder ruleBuilder2 = RuleDefinition.Builder.create((RuleDefinitionContract)this.buildTestRuleDefinition(t2.namespaceName, t2.object7));
        this.createTestKrmsAttribute(t2.actionAttribute, t2.actionAttribute_Key, t2.namespaceName);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(t2.actionAttribute_Key, t2.actionAttribute_Value);
        ArrayList<ActionDefinition.Builder> actionBuilders = new ArrayList<ActionDefinition.Builder>();
        KrmsTypeDefinition krmsTypeDefinition = this.createKrmsActionTypeDefinition(t2.namespaceName);
        ActionDefinition.Builder actionBuilder = ActionDefinition.Builder.create((String)t2.action_Id, (String)t2.action_Name, (String)t2.namespaceName, (String)krmsTypeDefinition.getId(), (String)rule0.getId(), (Integer)1);
        actionBuilder.setDescription(t2.action_Descr);
        actionBuilder.setAttributes(attributes);
        actionBuilders.add(actionBuilder);
        ruleBuilder2.setActions(actionBuilders);
        this.ruleManagementService.updateRule(ruleBuilder2.build());
        ruleBuilder2 = RuleDefinition.Builder.create((RuleDefinitionContract)this.ruleManagementService.getRule(t2.rule_7_Id));
        HashMap<String, String> newAttributes = new HashMap<String, String>();
        newAttributes.put(t2.actionAttribute_Key, t2.actionAttribute1_Value);
        for (ActionDefinition.Builder ruleActionBuilder : ruleBuilder2.getActions()) {
            ruleActionBuilder.setAttributes(newAttributes);
        }
        this.ruleManagementService.updateRule(ruleBuilder2.build());
        rule0 = this.ruleManagementService.getRule(t2.rule_7_Id);
        Assert.assertEquals((String)"Invalid AgendaItem Rule Actions count", (long)1L, (long)rule0.getActions().size());
        for (ActionDefinition action : rule0.getActions()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("action.id", action.getId());
            List actionAttributes = BusinessObjectServiceMigrationUtils.findMatching((DataObjectService)this.dataObjectService, ActionAttributeBo.class, map);
            Assert.assertEquals((String)"Invalid AgendaItem Rule Actions attribute count", (long)1L, (long)actionAttributes.size());
            for (ActionAttributeBo actionAttribute : actionAttributes) {
                String expectedAttribute = t2.actionAttribute1_Value;
                String actualAttribute = actionAttribute.getValue();
                Assert.assertEquals((String)"Invalid AgendaItem Rule Actions attribute", (Object)expectedAttribute, (Object)actualAttribute);
            }
        }
    }

    @Test
    public void testDeleteRule() {
        RuleManagementBaseTestObjectNames t3 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t3");
        RuleDefinition rule = this.buildTestRuleDefinition(t3.namespaceName, t3.object0);
        Assert.assertTrue((String)"created Rule not found", (boolean)this.ruleManagementService.getRule(rule.getId()).getId().contains(t3.rule_0_Id));
        String propositionId = rule.getPropId();
        Assert.assertEquals((String)"Proposition for Rule not found", (Object)t3.proposition_0_Descr, (Object)this.ruleManagementService.getProposition(propositionId).getDescription());
        this.ruleManagementService.deleteRule(rule.getId());
        Assert.assertNull((String)"Rule was not deleted", (Object)this.ruleManagementService.getRule(rule.getId()));
        try {
            this.ruleManagementService.deleteProposition(propositionId);
            Assert.fail((String)"should fail with IllegalStateException: the Proposition to delete does not exists");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFindRuleIds() {
        RuleManagementBaseTestObjectNames t4 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t4");
        RuleDefinition rule0 = this.buildTestRuleDefinition(t4.namespaceName, t4.object0);
        RuleDefinition rule1 = this.buildTestRuleDefinition(t4.namespaceName, t4.object1);
        RuleDefinition rule2 = this.buildTestRuleDefinition(t4.namespaceName, t4.object2);
        RuleDefinition rule3 = this.buildTestRuleDefinition(t4.namespaceName, t4.object3);
        String ruleNameSpace = rule0.getNamespace();
        ArrayList<String> ruleNames = new ArrayList<String>();
        ruleNames.add(rule0.getName());
        ruleNames.add(rule1.getName());
        ruleNames.add(rule2.getName());
        ruleNames.add(rule3.getName());
        QueryByCriteria.Builder builder = QueryByCriteria.Builder.create();
        builder.setPredicates(new Predicate[]{PredicateFactory.equal((String)"namespace", (Object)ruleNameSpace), PredicateFactory.in((String)"name", (Object[])ruleNames.toArray(new String[0]))});
        List ruleIds = this.ruleManagementService.findRuleIds(builder.build());
        Assert.assertEquals((String)"Wrong number of RuleIds returned", (long)4L, (long)ruleIds.size());
        if (!ruleIds.contains(rule0.getId())) {
            Assert.fail((String)"RuleId not found in results");
        }
    }

    @Test
    public void testGetRule() {
        RuleManagementBaseTestObjectNames t5 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t5");
        RuleDefinition ruleDefinition = this.buildTestRuleDefinition(t5.namespaceName, t5.object0);
        Assert.assertNotNull((Object)this.ruleManagementService.getRule(ruleDefinition.getId()));
        Assert.assertNull((String)"Should have returned null", (Object)this.ruleManagementService.getRule(null));
        Assert.assertNull((String)"Should have returned null", (Object)this.ruleManagementService.getRule("   "));
        Assert.assertNull((String)"Should have returned null", (Object)this.ruleManagementService.getRule("badValueId"));
    }

    @Test
    public void testGetRules() {
        RuleManagementBaseTestObjectNames t6 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t6");
        this.buildTestRuleDefinition(t6.namespaceName, t6.object0);
        this.buildTestRuleDefinition(t6.namespaceName, t6.object1);
        List<String> ruleIds = new ArrayList<String>();
        ruleIds.add(t6.rule_0_Id);
        ruleIds.add(t6.rule_1_Id);
        List ruleDefinitions = this.ruleManagementService.getRules(ruleIds);
        Assert.assertEquals((String)"Two RuleDefintions should have been returned", (long)2L, (long)ruleDefinitions.size());
        for (RuleDefinition ruleDefinition : ruleDefinitions) {
            if (ruleIds.contains(ruleDefinition.getId())) continue;
            Assert.fail((String)"Invalid RuleDefinition returned");
        }
        try {
            this.ruleManagementService.getRules(null);
            Assert.fail((String)"Should have failed with RiceIllegalArgumentException: ruleIds must not be null");
        }
        catch (RiceIllegalArgumentException riceIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"No RuleDefinitions should have been returned", (long)0L, (long)this.ruleManagementService.getRules(new ArrayList()).size());
        ruleIds = Arrays.asList("badValueId");
        Assert.assertEquals((String)"No RuleDefinitions should have been returned", (long)0L, (long)this.ruleManagementService.getRules(ruleIds).size());
    }

    @Test
    public void testRuleCacheEvict() {
        RuleManagementBaseTestObjectNames t7 = new RuleManagementBaseTestObjectNames(this.CLASS_DISCRIMINATOR, "t7");
        this.verifyEmptyRule(t7);
        String ruleId = this.buildTestRuleDefinition(t7.namespaceName, t7.object0).getId();
        this.buildTestActionDefinition(t7.action_Id, t7.action_Name, t7.action_Descr, 1, ruleId, t7.namespaceName);
        String agendaId = this.createTestAgenda(t7.object0).getId();
        this.buildTestAgendaItemDefinition(t7.agendaItem_Id, agendaId, ruleId);
        this.verifyFullRule(t7);
    }

    private void verifyEmptyRule(RuleManagementBaseTestObjectNames t) {
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        Assert.assertNull((String)"Rule is not null", (Object)rule);
        Set propositions = this.ruleManagementService.getPropositionsByRule(t.rule_Id);
        Assert.assertFalse((String)"Rule in Proposition found", (propositions != null && !propositions.isEmpty() ? 1 : 0) != 0);
        ActionDefinition action = this.ruleManagementService.getAction(t.action_Id);
        Assert.assertFalse((String)"Rule in Action found", (action != null ? 1 : 0) != 0);
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertFalse((String)"Rule in AgendaItem found", (agendaItem != null ? 1 : 0) != 0);
    }

    private void verifyFullRule(RuleManagementBaseTestObjectNames t) {
        RuleDefinition rule = this.ruleManagementService.getRule(t.rule_Id);
        Assert.assertNotNull((String)"Rule is null", (Object)rule);
        boolean foundRule = false;
        Set propositions = this.ruleManagementService.getPropositionsByRule(t.rule_Id);
        if (propositions != null) {
            for (PropositionDefinition proposition : propositions) {
                if (!StringUtils.equals((String)t.rule_Id, (String)proposition.getRuleId())) continue;
                foundRule = true;
                break;
            }
        }
        Assert.assertTrue((String)"Rule in Proposition not found", (boolean)foundRule);
        ActionDefinition action = this.ruleManagementService.getAction(t.action_Id);
        Assert.assertTrue((String)"Rule in Action not found", (action != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rule in Action not found", (boolean)StringUtils.equals((String)t.rule_Id, (String)action.getRuleId()));
        AgendaItemDefinition agendaItem = this.ruleManagementService.getAgendaItem(t.agendaItem_Id);
        Assert.assertTrue((String)"Rule in AgendaItem not found", (agendaItem != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Rule in AgendaItem not found", (boolean)StringUtils.equals((String)t.rule_Id, (String)agendaItem.getRuleId()));
    }
}

