/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging;

import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.kuali.rice.ksb.messaging.ClientAppServiceSharedPayloadObj;
import org.kuali.rice.ksb.messaging.MessageFetcher;
import org.kuali.rice.ksb.messaging.PersistedMessageBO;
import org.kuali.rice.ksb.messaging.remotedservices.TestHarnessSharedTopic;
import org.kuali.rice.ksb.messaging.service.KSBJavaService;
import org.kuali.rice.ksb.service.KSBServiceLocator;
import org.kuali.rice.ksb.test.KSBTestCase;

public class MessageFetcherTest
extends KSBTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        ConfigContext.getCurrentContextConfig().putProperty("message.off", "true");
        TestHarnessSharedTopic.CALL_COUNT = 0;
        TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD = 0;
    }

    @After
    public void tearDown() throws Exception {
        TestHarnessSharedTopic.CALL_COUNT = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequeueMessages() throws Exception {
        List messages = KSBServiceLocator.getMessageQueueService().getNextDocuments(null);
        Assert.assertEquals((String)"Should have no messages in the queue.", (long)0L, (long)messages.size());
        TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD = 500;
        for (int i = 0; i < TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD; ++i) {
            this.sendMessage();
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 60000L && (messages = KSBServiceLocator.getMessageQueueService().getNextDocuments(null)).size() < TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD) {
            System.out.println(messages.size() + " messages were found in the database");
            Thread.sleep(1000L);
        }
        messages = KSBServiceLocator.getMessageQueueService().getNextDocuments(null);
        Assert.assertEquals((String)"Should have 500 messages in the queue.", (long)500L, (long)messages.size());
        this.turnOnMessaging();
        new MessageFetcher((Integer)null).run();
        Object object = TestHarnessSharedTopic.LOCK;
        synchronized (object) {
            TestHarnessSharedTopic.LOCK.wait(300000L);
        }
        Thread.sleep(500L);
        Assert.assertEquals((String)"Service not called by message fetcher", (long)TestHarnessSharedTopic.CALL_COUNT, (long)TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD);
        messages = KSBServiceLocator.getMessageQueueService().getNextDocuments(null);
        Assert.assertEquals((String)"Should still have no messages in the queue.", (long)0L, (long)messages.size());
    }

    private void sendMessage() {
        QName serviceName = QName.valueOf("{testAppsSharedTopic}sharedTopic");
        KSBJavaService testJavaAsyncService = (KSBJavaService)KsbApiServiceLocator.getMessageHelper().getServiceAsynchronously(serviceName);
        testJavaAsyncService.invoke((Serializable)new ClientAppServiceSharedPayloadObj("message content", false));
    }

    private void turnOnMessaging() {
        ConfigContext.getCurrentContextConfig().putProperty("message.off", "false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequeueSingleMessage() throws Exception {
        TestHarnessSharedTopic.CALL_COUNT_NOTIFICATION_THRESHOLD = 1;
        this.sendMessage();
        this.sendMessage();
        List messages = KSBServiceLocator.getMessageQueueService().getNextDocuments(null);
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertNotNull((String)"message should have been persisted", messages.get(0));
        this.turnOnMessaging();
        new MessageFetcher(((PersistedMessageBO)messages.get(0)).getRouteQueueId()).run();
        Object object = TestHarnessSharedTopic.LOCK;
        synchronized (object) {
            TestHarnessSharedTopic.LOCK.wait(3000L);
        }
        Thread.sleep(500L);
        Assert.assertEquals((String)"Service not called by message fetcher correct number of times", (long)1L, (long)TestHarnessSharedTopic.CALL_COUNT);
        for (int i = 0; i < 10 && KSBServiceLocator.getMessageQueueService().getNextDocuments(null).size() != 1; ++i) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"Message Queue should have a single remaining message because only single message was resent", (long)1L, (long)KSBServiceLocator.getMessageQueueService().getNextDocuments(null).size());
    }
}

