/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.vc.kew;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.junit.Test;
import org.kuali.rice.vc.test.WsdlCompareTestCase;

public class KewWsdlCompatibilityTest
extends WsdlCompareTestCase {
    private static final Logger LOG = Logger.getLogger(KewWsdlCompatibilityTest.class);
    private static final String MODULE_NAME = "kew";

    public KewWsdlCompatibilityTest() {
        super(MODULE_NAME);
    }

    @Test
    public void compareKewApiWsdls() {
        String wsdlDirectory = "../../" + this.getModuleName() + "/api/target/wsdl";
        File[] files = new File(wsdlDirectory).listFiles();
        if (files == null) {
            throw new RuntimeException("can't find wsdls at " + wsdlDirectory + " from " + new File(".").getAbsolutePath());
        }
        this.compareWsdlFiles(files);
    }

    @Test
    public void compareKewFrameworkWsdls() {
        String wsdlDirectory = "../../" + this.getModuleName() + "/framework/target/wsdl";
        File[] files = new File(wsdlDirectory).listFiles();
        if (files == null) {
            throw new RuntimeException("can't find wsdls at " + wsdlDirectory + " from " + new File(".").getAbsolutePath());
        }
        this.compareWsdlFiles(files);
    }

    @Override
    protected Map<String, List<WsdlCompareTestCase.VersionTransition>> getWsdlVersionTransitionBlacklists() {
        HashMap<String, List<WsdlCompareTestCase.VersionTransition>> blacklist = new HashMap<String, List<WsdlCompareTestCase.VersionTransition>>(super.getWsdlVersionTransitionBlacklists());
        blacklist.put("ImmediateEmailReminderQueue", Arrays.asList(new WsdlCompareTestCase.VersionTransition("2.1.0", "2.1.1"), new WsdlCompareTestCase.VersionTransition("2.0.2", "2.1.1")));
        blacklist.put("ActionListService", Arrays.asList(new WsdlCompareTestCase.VersionTransition("2.1.0", "2.1.1"), new WsdlCompareTestCase.VersionTransition("2.0.2", "2.1.1")));
        blacklist.put("WorkflowDocumentService", Arrays.asList(new WsdlCompareTestCase.VersionTransition("2.1.2", "2.2.0"), new WsdlCompareTestCase.VersionTransition("2.2.0", "2.2.1")));
        return blacklist;
    }
}

