/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.peopleflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegate;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegateContract;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMemberContract;
import org.w3c.dom.Element;

@XmlRootElement(name="peopleFlowMember")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PeopleFlowMemberType", propOrder={"memberId", "memberType", "actionRequestPolicy", "responsibilityId", "priority", "delegates", "_futureElements"})
public final class PeopleFlowMember
extends AbstractDataTransferObject
implements PeopleFlowMemberContract {
    private static final int STARTING_PRIORITY = 1;
    @XmlElement(name="memberId", required=true)
    private final String memberId;
    @XmlElement(name="memberType", required=true)
    private final MemberType memberType;
    @XmlElement(name="actionRequestPolicy", required=false)
    private final ActionRequestPolicy actionRequestPolicy;
    @XmlElement(name="responsibilityId", required=false)
    private final String responsibilityId;
    @XmlElement(name="priority", required=true)
    private final int priority;
    @XmlElementWrapper(name="delegates", required=false)
    @XmlElement(name="delegate", required=false)
    private final List<PeopleFlowDelegate> delegates;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PeopleFlowMember() {
        this.memberId = null;
        this.memberType = null;
        this.actionRequestPolicy = null;
        this.responsibilityId = null;
        this.priority = 1;
        this.delegates = null;
    }

    private PeopleFlowMember(Builder builder) {
        this.memberId = builder.getMemberId();
        this.memberType = builder.getMemberType();
        this.actionRequestPolicy = builder.getActionRequestPolicy();
        this.responsibilityId = builder.getResponsibilityId();
        this.priority = builder.getPriority();
        this.delegates = ModelObjectUtils.buildImmutableCopy(builder.getDelegates());
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public MemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public ActionRequestPolicy getActionRequestPolicy() {
        return this.actionRequestPolicy;
    }

    @Override
    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public List<PeopleFlowDelegate> getDelegates() {
        return this.delegates;
    }

    static class Elements {
        static final String MEMBER_ID = "memberId";
        static final String MEMBER_TYPE = "memberType";
        static final String ACTION_REQUEST_POLICY = "actionRequestPolicy";
        static final String RESPONSIBILITY_ID = "responsibilityId";
        static final String PRIORITY = "priority";
        static final String DELEGATES = "delegates";
        static final String DELEGATE = "delegate";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "peopleFlowMember";
        static final String TYPE_NAME = "PeopleFlowMemberType";

        Constants() {
        }
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    PeopleFlowMemberContract {
        private String memberId;
        private MemberType memberType;
        private ActionRequestPolicy actionRequestPolicy;
        private String responsibilityId;
        private int priority;
        private List<PeopleFlowDelegate.Builder> delegates;

        private Builder(String memberId, MemberType memberType) {
            this.setMemberId(memberId);
            this.setMemberType(memberType);
            this.setPriority(1);
            this.setDelegates(new ArrayList<PeopleFlowDelegate.Builder>());
        }

        public static Builder create(String memberId, MemberType memberType) {
            return new Builder(memberId, memberType);
        }

        public static Builder create(PeopleFlowMemberContract contract) {
            Builder builder = Builder.createCopy(contract);
            builder.setResponsibilityId(contract.getResponsibilityId());
            return builder;
        }

        public static Builder createCopy(PeopleFlowMemberContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getMemberId(), contract.getMemberType());
            builder.setActionRequestPolicy(contract.getActionRequestPolicy());
            builder.setPriority(contract.getPriority());
            if (CollectionUtils.isNotEmpty(contract.getDelegates())) {
                for (PeopleFlowDelegateContract peopleFlowDelegateContract : contract.getDelegates()) {
                    builder.getDelegates().add(PeopleFlowDelegate.Builder.create(peopleFlowDelegateContract));
                }
            }
            return builder;
        }

        public PeopleFlowMember build() {
            return new PeopleFlowMember(this);
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        @Override
        public MemberType getMemberType() {
            return this.memberType;
        }

        @Override
        public ActionRequestPolicy getActionRequestPolicy() {
            return this.actionRequestPolicy;
        }

        @Override
        public String getResponsibilityId() {
            return this.responsibilityId;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public List<PeopleFlowDelegate.Builder> getDelegates() {
            return this.delegates;
        }

        public void setMemberId(String memberId) {
            if (StringUtils.isBlank((String)memberId)) {
                throw new IllegalArgumentException("memberId was null or blank");
            }
            this.memberId = memberId;
        }

        public void setMemberType(MemberType memberType) {
            if (memberType == null) {
                throw new IllegalArgumentException("memberType was null");
            }
            this.memberType = memberType;
        }

        public void setActionRequestPolicy(ActionRequestPolicy actionRequestPolicy) {
            if (this.memberType.equals((Object)MemberType.ROLE)) {
                if (actionRequestPolicy == null) {
                    throw new IllegalArgumentException("actionRequestPolicy was null");
                }
                this.actionRequestPolicy = actionRequestPolicy;
            }
        }

        public void setResponsibilityId(String responsibilityId) {
            this.responsibilityId = responsibilityId;
        }

        public void setPriority(int priority) {
            if (priority < 1) {
                throw new IllegalArgumentException("Given priority was smaller than the minimum prior value of 1");
            }
            this.priority = priority;
        }

        public void setDelegates(List<PeopleFlowDelegate.Builder> delegates) {
            this.delegates = delegates;
        }
    }
}

