/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.action;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

@XmlRootElement(name="adHocRevoke")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="AdHocRevokeType", propOrder={"nodeNames", "principalIds", "groupIds", "_futureElements"})
public final class AdHocRevoke
extends AbstractDataTransferObject {
    private static final long serialVersionUID = 5848714514445793355L;
    @XmlElementWrapper(name="nodeNames", required=false)
    @XmlElement(name="nodeName", required=false)
    private final Set<String> nodeNames;
    @XmlElementWrapper(name="principalIds", required=false)
    @XmlElement(name="principalId", required=false)
    private final Set<String> principalIds;
    @XmlElementWrapper(name="groupIds", required=false)
    @XmlElement(name="groupId", required=false)
    private final Set<String> groupIds;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private AdHocRevoke() {
        this.nodeNames = null;
        this.principalIds = null;
        this.groupIds = null;
    }

    private AdHocRevoke(Set<String> nodeNames, Set<String> principalIds, Set<String> groupIds) {
        this.nodeNames = nodeNames;
        this.principalIds = principalIds;
        this.groupIds = groupIds;
    }

    public static AdHocRevoke create(Set<String> nodeNames, Set<String> principalIds, Set<String> groupIds) {
        return new AdHocRevoke(nodeNames, principalIds, groupIds);
    }

    public static AdHocRevoke createRevokeFromPrincipal(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("principalId was null or blank");
        }
        return AdHocRevoke.create(null, Collections.singleton(principalId), null);
    }

    public static AdHocRevoke createRevokeFromGroup(String groupId) {
        if (StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("groupId was null or blank");
        }
        return AdHocRevoke.create(null, null, Collections.singleton(groupId));
    }

    public static AdHocRevoke createRevokeAtNode(String nodeName) {
        if (StringUtils.isBlank((String)nodeName)) {
            throw new IllegalArgumentException("nodeName was null or blank");
        }
        return AdHocRevoke.create(Collections.singleton(nodeName), null, null);
    }

    public Set<String> getNodeNames() {
        if (this.nodeNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.nodeNames);
    }

    public Set<String> getPrincipalIds() {
        if (this.principalIds == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.principalIds);
    }

    public Set<String> getGroupIds() {
        if (this.groupIds == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.groupIds);
    }

    static class Elements {
        static final String NODE_NAMES = "nodeNames";
        static final String NODE_NAME = "nodeName";
        static final String PRINCIPAL_IDS = "principalIds";
        static final String PRINCIPAL_ID = "principalId";
        static final String GROUP_IDS = "groupIds";
        static final String GROUP_ID = "groupId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "adHocRevoke";
        static final String TYPE_NAME = "AdHocRevokeType";

        Constants() {
        }
    }
}

